/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.h2forms.core;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenAppUiModule;
import org.modellwerkstatt.dataux.runtime.telemetrics.AppJmxRegistration;
import org.modellwerkstatt.dataux.runtime.telemetrics.Dux;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_MainWindow;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.h2forms.core.ContextClient;
import org.modellwerkstatt.h2forms.core.ContextPage;
import org.modellwerkstatt.h2forms.core.ContextStatics;
import org.modellwerkstatt.h2forms.core.H2Dialog;
import org.modellwerkstatt.h2forms.core.IH2Controller;
import org.modellwerkstatt.h2forms.core.IH2FormsTemplateRenderer;
import org.modellwerkstatt.h2forms.core.IH2UiFactory;
import org.modellwerkstatt.h2forms.core.LoadMeUp;
import org.modellwerkstatt.manmap.runtime.IM3DatabaseDescription;
import org.modellwerkstatt.manmap.runtime.MMStaticAccessHelper;
import org.modellwerkstatt.objectflow.runtime.CoreReporterInfo;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXApplicationFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.runtime.OFXLogger;
import org.modellwerkstatt.objectflow.runtime.OFXStringFormatter2;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

@MultipartConfig(fileSizeThreshold=0x100000, maxFileSize=0xA00000L, maxRequestSize=0x1900000L)
public class H2ApplicationLoader
extends HttpServlet {
    public static final boolean H2_INTERNAL_DEBUG = false;
    public static final String DEFAULT_STATIC_DIR = "static";
    private static final String CHARSET = "UTF-8";
    private static final String frameworkVersion = "H2Forms PRO";
    private static final boolean KILL_AND_RELOAD_SESSION_ON_CHANGING_NETWORK = true;
    public static final String URL_PARAM_RT = "rt";
    public static final String URL_PICUPLOAD = "/picupload/";
    private IGenAppUiModule genApplication;
    private AbstractApplicationContext springAppContext;
    private String appBehaviourFqName = "?";
    private IH2UiFactory uiFactory;
    private AppJmxRegistration jmxRegistration;
    private boolean templatesInitializedWihtoutEx;
    private String deployedAsVersion;

    public void init() throws ServletException {
        super.init();
        try {
            Dux.init((String)"/Users/danielstieger/h2hardlog.log");
            String xmlConfigFile = this.getInitParameter("xmlConfigFile");
            this.springAppContext = new ClassPathXmlApplicationContext(xmlConfigFile);
            this.uiFactory = (IH2UiFactory)this.springAppContext.getBean(IH2UiFactory.class);
            String realPath = this.getServletContext().getRealPath("/");
            int startOfVersion = realPath.indexOf("##");
            if (startOfVersion > 0 && realPath.length() > startOfVersion + 2) {
                this.deployedAsVersion = realPath.substring(startOfVersion + 2);
                this.deployedAsVersion = this.deployedAsVersion.substring(0, this.deployedAsVersion.length() - 1);
            }
            ContextStatics statics = this.uiFactory.getContextStatics();
            statics.setMowarePlatform(IOFXCoreReporter.MoWarePlatform.MOWARE_H2);
            statics.setServletPath(this.getServletContext().getContextPath());
            statics.setStaticContentUrlPrefix(this.getInitParameter("staticContentUrlPrefix"));
            if (statics.getStaticContentUrlPrefix() == null) {
                statics.setStaticContentUrlPrefix(statics.getServletPath() + "/static/" + statics.getTemplateName());
            } else if (statics.getStaticContentUrlPrefix().endsWith("/")) {
                statics.setStaticContentUrlPrefix(statics.getStaticContentUrlPrefix().substring(0, statics.getStaticContentUrlPrefix().length() - 1));
            }
            statics.setGuessedServerName(System.getProperty("server.instancename"));
            this.appBehaviourFqName = this.getInitParameter("applicationFqName");
            this.jmxRegistration = new AppJmxRegistration(this.appBehaviourFqName, this.deployedAsVersion, realPath, statics.getServletPath());
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            Class<?> appBehaviorClass = classLoader.loadClass(this.appBehaviourFqName);
            this.genApplication = (IGenAppUiModule)this.springAppContext.getAutowireCapableBeanFactory().createBean(appBehaviorClass);
            this.appBehaviourFqName = this.genApplication.getClass().getName();
            ((IM3DatabaseDescription)this.springAppContext.getBean(IM3DatabaseDescription.class)).setSessionInfo(this.genApplication.getShortAppName() + " " + this.genApplication.getApplicationVersion() + " " + statics.getGuessedServerName());
            this.uiFactory.initCmdUrlDefaults();
            this.uiFactory.initExtAuthProviders();
            statics.setApplicationName(this.genApplication.getShortAppName());
            statics.setAppVersionInfo(this.genApplication.getShortAppName() + " " + this.genApplication.getApplicationVersion());
            if (this.uiFactory.getUploadLocationStore() == null) {
                Dux.hl((String)("NO uploadLocationStore set. setting it to  " + statics.getServletPath() + URL_PICUPLOAD));
                this.uiFactory.setUploadLocationStore(statics.getServletPath() + URL_PICUPLOAD);
            }
            if (this.uiFactory.isCheckDeployedVersion() && !this.genApplication.getApplicationVersion().equals(this.deployedAsVersion)) {
                CoreReporterInfo info = this.createCoreReporterInfo(0, "", "", "", "", IOFXCoreReporter.LogPriority.ERROR, "Application deployed as '" + this.deployedAsVersion + "' does not match app version '" + this.genApplication.getApplicationVersion() + "'");
                this.uiFactory.report(info);
            }
            this.uiFactory.getEventBus().setSysInfo(IOFXCoreReporter.MoWarePlatform.MOWARE_H2 + " " + statics.getGuessedServerName() + ": " + statics.getApplicationName() + " " + this.genApplication.getApplicationVersion());
            this.templatesInitializedWihtoutEx = false;
            this.uiFactory.initRenderer(this.getServletContext());
            this.templatesInitializedWihtoutEx = true;
            this.jmxRegistration.registerAppTelemetrics((IOFXApplicationFactory)this.uiFactory, this.appBehaviourFqName, this.genApplication.getShortAppName(), this.deployedAsVersion, this.uiFactory.getSystemLabel(-1, MoWareTranslations.Key.MOWARE_VERSION) + " / H2Forms PRO", statics.getGuessedServerName());
            if (this.uiFactory.isAutoParDeploymentForwardGracefully()) {
                this.jmxRegistration.enableAutoForwardGracefully();
            }
        }
        catch (Exception e) {
            this.log("Exception in servlet init, setting service as unavailable.", e);
            throw new UnavailableException("Servlet unavailable due to " + e.getClass().getSimpleName() + " " + e.getMessage());
        }
    }

    public HttpSession loginUserCreateApplication(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        String username = request.getParameter("username");
        if (username == null) {
            username = this.uiFactory.getRemoteAddr(request);
        }
        session.setAttribute("userName", (Object)username);
        String remoteAddr = this.uiFactory.getRemoteAddr(request);
        session.setAttribute("remoteAddr", (Object)remoteAddr);
        String requestHostname = this.getCurrentRequestHostName(request);
        ContextClient client = new ContextClient();
        client.setRemoteAddr(remoteAddr);
        client.setRequestHostName(requestHostname);
        session.setAttribute("client", (Object)client);
        IH2Controller crtl = this.uiFactory.createLoginController(this.genApplication, this.jmxRegistration, client);
        session.setAttribute("h2controller", (Object)crtl);
        this.setShortSession(session);
        return session;
    }

    public void setShortSession(HttpSession session) {
        session.setMaxInactiveInterval(3600);
    }

    public void setLongSession(HttpSession session) {
        int secondsOfDay = new LocalTime().getMillisOfDay() / 1000;
        session.setMaxInactiveInterval(86400 - secondsOfDay);
    }

    public String getCurrentRequestHostName(HttpServletRequest request) {
        String hostField = request.getHeader("host");
        String hostName = "?";
        if (hostField != null) {
            if (hostField.contains(":")) {
                hostField = hostField.substring(0, hostField.lastIndexOf(":"));
            }
            if (hostField.contains(".")) {
                hostField = hostField.substring(0, hostField.indexOf("."));
            }
            hostName = hostField;
        }
        return hostName;
    }

    public HttpSession shutdownSession(HttpSession session) {
        IH2Controller app = (IH2Controller)session.getAttribute("h2controller");
        if (app != null) {
            app.externalCloseApplicationWithSessionId(session.getId());
        }
        session.invalidate();
        return null;
    }

    public CoreReporterInfo createCoreReporterInfo(int uId, String uName, String devNameAndSw, String devId, String devRemoteAdr, IOFXCoreReporter.LogPriority prio, String desc) {
        CoreReporterInfo info = new CoreReporterInfo(IOFXCoreReporter.Type.APP_PROBLEM, this.appBehaviourFqName, this.genApplication.getApplicationVersion(), "org.modellwerkstatt.RT", "", "", prio, uId, uName, devNameAndSw, devId, devRemoteAdr, "moware11 2025.24 (dck)", this.uiFactory.getContextStatics().getMowarePlatform(), this.uiFactory.getContextStatics().getGuessedServerName(), desc);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getRequestURI().contains("/static/")) {
            response.sendError(404);
            return;
        }
        Object cookieInfos = "";
        Cookie[] allCookies = request.getCookies();
        if (allCookies != null) {
            for (Cookie co : allCookies) {
                cookieInfos = (String)cookieInfos + co.getName() + ": " + co.getValue() + " ," + co.getDomain() + "," + co.getVersion() + "," + co.getComment() + "," + co.getMaxAge() + "," + co.getPath() + ";  ";
            }
        }
        HttpSession session = request.getSession(false);
        try {
            long thisServedStartOfRequest = System.currentTimeMillis();
            String thisServedUsername = "?";
            Object thisSessionInfo = "?";
            Object thisRequestInfo = "?";
            response.setCharacterEncoding(CHARSET);
            request.setCharacterEncoding(CHARSET);
            if (session != null) {
                String storedIP = (String)session.getAttribute("remoteAddr");
                String currentIP = this.uiFactory.getRemoteAddr(request);
                String currentUserName = (String)session.getAttribute("userName");
                Object deviceAndDeviceSW = "?";
                String clientId = "?";
                int userId = 0;
                String userName = currentUserName;
                ContextClient client = (ContextClient)session.getAttribute("client");
                if (client != null) {
                    deviceAndDeviceSW = client.getDevice() + " " + client.getDeviceSw();
                    clientId = client.getDeviceId();
                    userId = client.getUserid();
                    userName = client.getUsername();
                }
                if (!H2ApplicationLoader.sameNetwork(storedIP, currentIP)) {
                    session = this.shutdownSession(session);
                    this.uiFactory.execLocationRedirect(response, this.uiFactory.getContextStatics().getServletPath());
                    this.jmxRegistration.getAppTelemetrics().servedRequest("-", "-", "ip address changed from " + storedIP + " to " + currentIP + ": shutdown and redirect", -1L);
                    String msg = " $ $ $ $ " + currentUserName + " $ IPCHANGE $ ";
                    this.log(msg + this.dumpSessionAndRequestInfo(session, request));
                    CoreReporterInfo info = this.createCoreReporterInfo(userId, userName, (String)deviceAndDeviceSW, clientId, storedIP, IOFXCoreReporter.LogPriority.INFO, "ip adr changed to " + currentIP);
                    info.addParameter("param", (Object)("changed from " + storedIP + " to " + currentIP));
                    this.uiFactory.report(info);
                    return;
                }
            }
            if (session != null && request.getParameter("username") != null) {
                String storedUsername = (String)session.getAttribute("userName");
                String requestedUsername = request.getParameter("username");
                if (!requestedUsername.equals(storedUsername)) {
                    session = this.shutdownSession(session);
                    this.uiFactory.execLocationRedirect(response, this.uiFactory.getContextStatics().getServletPath() + "?username=" + requestedUsername);
                    this.jmxRegistration.getAppTelemetrics().servedRequest("-", "-", "username changed from " + storedUsername + " to " + requestedUsername + ": shutdown and redirect", -1L);
                    return;
                }
            }
            if (session != null && request.getMethod().equals("GET")) {
                ContextClient client = (ContextClient)session.getAttribute("client");
                if (request.getParameter("appstart") != null) {
                    CoreReporterInfo info = this.createCoreReporterInfo(client.getUserid(), client.getUsername(), client.getDevice() + " " + client.getDeviceSw(), client.getDeviceId(), client.getRemoteAddr(), IOFXCoreReporter.LogPriority.INFO, "browser start");
                    info.addParameter("param", (Object)("appstart=" + request.getParameter("appstart") + " / " + (String)cookieInfos));
                    this.uiFactory.report(info);
                }
            }
            this.jmxRegistration.checkMarkAsForwardGracyFully();
            if (session == null) {
                if (this.jmxRegistration.markedAsOld()) {
                    this.uiFactory.getRenderer().handleSpecialPageResponse(IH2FormsTemplateRenderer.SpecialPage.LANDING_PAGE, response, this.uiFactory.getContextStatics(), new ContextClient(), new ContextPage(0L, false, DeprecatedServerDateProvider.getSqlServerDateTime().getMillis()), new H2Dialog(IToolkit_MainWindow.DlgType.ERROR_SMALL, this.uiFactory.getSystemLabel(-1, MoWareTranslations.Key.INFORMATION), this.uiFactory.getSystemLabel(-1, MoWareTranslations.Key.APPLICATION_REPLACED), null).withReload());
                    return;
                }
                session = this.loginUserCreateApplication(request);
            }
            HttpSession httpSession = session;
            synchronized (httpSession) {
                IH2Controller crtl = (IH2Controller)session.getAttribute("h2controller");
                ContextClient client = (ContextClient)session.getAttribute("client");
                if (crtl == null) {
                    session = this.shutdownSession(session);
                    if (this.jmxRegistration.markedAsOld()) {
                        this.uiFactory.getRenderer().handleSpecialPageResponse(IH2FormsTemplateRenderer.SpecialPage.LANDING_PAGE, response, this.uiFactory.getContextStatics(), new ContextClient(), new ContextPage(0L, false, DeprecatedServerDateProvider.getSqlServerDateTime().getMillis()), new H2Dialog(IToolkit_MainWindow.DlgType.ERROR_SMALL, this.uiFactory.getSystemLabel(-1, MoWareTranslations.Key.INFORMATION), this.uiFactory.getSystemLabel(-1, MoWareTranslations.Key.APPLICATION_REPLACED), null).withReload());
                        return;
                    }
                    session = this.loginUserCreateApplication(request);
                }
                thisSessionInfo = (String)session.getAttribute("remoteAddr") + " / " + (String)session.getAttribute("userName");
                crtl = (IH2Controller)session.getAttribute("h2controller");
                thisServedUsername = crtl.getShortUserInfo();
                try {
                    thisRequestInfo = "" + crtl;
                    crtl.handleRequest(request, (String)cookieInfos);
                    IH2Controller newCrtl = crtl.swapToNextController();
                    if (newCrtl != null) {
                        crtl.externalCloseApplicationWithSessionId(session.getId());
                        crtl = newCrtl;
                        session.setAttribute("h2controller", (Object)crtl);
                        thisRequestInfo = "" + crtl;
                        crtl.handleRequest(request, (String)cookieInfos);
                        crtl.createResponse(response, "POST".equals(request.getMethod()) && request.getParameter("XMLHttpRequest") != null);
                    } else {
                        crtl.createResponse(response, "POST".equals(request.getMethod()) && request.getParameter("XMLHttpRequest") != null);
                    }
                    if (crtl.isRemoveFromSessionAndClose()) {
                        Dux.hl((String)"doing a shutdownSession(session) now");
                        this.shutdownSession(session);
                    } else if (crtl.hasCommitableSessionRunning()) {
                        this.setLongSession(session);
                    } else {
                        this.setShortSession(session);
                    }
                }
                catch (Exception e) {
                    this.resetWrittenData(response);
                    String sessionDump = this.dumpSessionAndRequestInfo(session, request);
                    CoreReporterInfo info = this.createCoreReporterInfo(client.getUserid(), client.getUsername(), client.getDevice() + " " + client.getDeviceSw(), client.getDeviceId(), client.getRemoteAddr(), IOFXCoreReporter.LogPriority.ERROR, "H2Application crashed with ex while request/response handling by controller");
                    info.addParameter("param", (Object)sessionDump);
                    info.setException((Throwable)e);
                    this.uiFactory.report(info);
                    String msg = "H2Application crashed with ex while request/response handling by controller: \n\n " + this.dumpSessionAndRequestInfo(session, request);
                    msg = msg + sessionDump + "\n\n\n" + OFXConsoleHelper.stackTrace2String((Throwable)e);
                    response.getWriter().write(msg);
                    this.shutdownSession(session);
                }
            }
            this.jmxRegistration.getAppTelemetrics().servedRequest("request" + (String)thisSessionInfo, thisServedUsername, (String)thisRequestInfo, thisServedStartOfRequest);
        }
        catch (Exception ex) {
            Object sessionInfo = "(session null)";
            if (session != null) {
                try {
                    sessionInfo = this.dumpSessionAndRequestInfo(session, request);
                }
                catch (Throwable e) {
                    sessionInfo = "(ex " + e.getClass().getSimpleName() + " " + e.getMessage() + " while retrieving session info)";
                }
                finally {
                    session = this.shutdownSession(session);
                }
            }
            CoreReporterInfo info = this.createCoreReporterInfo(0, "", "", "", this.uiFactory.getRemoteAddr(request), IOFXCoreReporter.LogPriority.FATAL, "H2ApplicationLoader framework " + ex.getClass().getSimpleName() + " " + ex.getMessage());
            info.addParameter("param", sessionInfo);
            info.setException((Throwable)ex);
            this.uiFactory.report(info);
            OFXLogger.log(H2ApplicationLoader.class, (IOFXCoreReporter.LogPriority)IOFXCoreReporter.LogPriority.FATAL, (String)("H2ApplicationLoader framework " + ex.getClass().getSimpleName() + " " + ex.getMessage() + "\n" + (String)sessionInfo), (Throwable)ex);
            this.jmxRegistration.getAppTelemetrics().incException();
            String msg = ex.getClass().getSimpleName() + ":" + ex.getMessage();
            response.sendError(500, msg);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String uri = request.getRequestURI();
        if (uri.endsWith(URL_PICUPLOAD) && this.uiFactory.getUploadFsLocationStore() != null) {
            Dux.hl((String)("Upload at url '/picupload/' with UploadFsLocationStore " + this.uiFactory.getUploadFsLocationStore()));
            try {
                Dux.hl((String)Dux.requestToString((HttpServletRequest)request));
                String string = LoadMeUp.handleUpload(this.uiFactory.getUploadFsLocationStore(), request, response);
            }
            catch (Exception ex) {
                String ip = this.uiFactory.getRemoteAddr(request);
                super.log("Problem while uploading a file for " + ip, (Throwable)ex);
                String msg = "Problem while uploading a file for " + ip + ".\n\n" + ex.getClass().getSimpleName() + ": " + ex.getMessage();
                response.getWriter().write(msg);
            }
        } else {
            this.doGet(request, response);
        }
    }

    public void resetWrittenData(HttpServletResponse response) {
        try {
            if (!response.isCommitted()) {
                response.reset();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String dumpSessionAndRequestInfo(HttpSession session, HttpServletRequest request) {
        Object info = "";
        Object tmpInfo = "[REQUEST " + request.getMethod() + " " + request.getRequestURI();
        info = (String)info + (String)tmpInfo + " ] ";
        if (session == null) {
            tmpInfo = " [ SESSION null ";
        } else {
            tmpInfo = " [ SESSION cT: " + new DateTime(session.getCreationTime()) + ", lAT:" + new DateTime(session.getLastAccessedTime()) + ", mIT " + session.getMaxInactiveInterval() + ", ";
            Enumeration attributes = session.getAttributeNames();
            while (attributes.hasMoreElements()) {
                String atrName = (String)attributes.nextElement();
                tmpInfo = (String)tmpInfo + atrName + ": " + session.getAttribute(atrName) + ", ";
            }
        }
        info = (String)info + (String)tmpInfo + "]  ";
        return info;
    }

    public void destroy() {
        this.uiFactory.getEventBus().close();
        this.jmxRegistration.gcClean();
        String msg = OFXConsoleHelper.closeConnectionPoolExplicitly((AbstractApplicationContext)this.springAppContext);
        if (msg != null) {
            super.log(msg);
        }
        this.springAppContext.close();
        this.springAppContext = null;
        DeprecatedServerDateProvider.shutdownAndGcClean();
        MMStaticAccessHelper.shutdownAndGcClean();
        OFXStringFormatter2.GLOBAL_INSTANCE_DEFAULT_LANG = null;
        super.destroy();
    }

    public static boolean sameNetwork(String ip1, String ip2) {
        if (ip1 != null && ip2 != null && ip1.contains(".") && ip2.contains(".")) {
            String[] net1 = ip1.split("\\.");
            String[] net2 = ip2.split("\\.");
            for (int i = 0; i < 3; ++i) {
                if (net1[i].equals(net2[i])) continue;
                return false;
            }
        }
        return true;
    }
}

