/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.h2forms.core;

import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.dataux.runtime.core.FlagOnUiEvent;
import org.modellwerkstatt.dataux.runtime.core.IApplication;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_MainWindow;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;

public class H2Dialog {
    protected String text;
    protected boolean toastMessageOnly;
    protected List<DialogButton> buttons;
    protected String heading;
    protected IApplication.DlgRunnable runnable;
    protected IToolkit_MainWindow.DlgType type;
    protected List<IOFXProblem> listOfProblems;
    protected boolean reloadEnabled;

    public H2Dialog(IToolkit_MainWindow.DlgType t, String head, String msg, IApplication.DlgRunnable run) {
        this.heading = head;
        this.text = msg;
        this.runnable = run;
        this.buttons = ListSequence.fromList(new ArrayList());
        this.toastMessageOnly = false;
        this.type = t;
        this.reloadEnabled = false;
    }

    public H2Dialog(boolean toastMsg, IToolkit_MainWindow.DlgType t, String head, String msg, IApplication.DlgRunnable run) {
        this(t, head, msg, run);
        this.toastMessageOnly = toastMsg;
    }

    public H2Dialog(List<IOFXProblem> problems, IApplication.DlgRunnable run) {
        this(null, null, null, run);
        this.listOfProblems = problems;
    }

    public String getText() {
        return this.text;
    }

    public String getTextBr() {
        return this.text.replace("\n", "<br/>");
    }

    public String getHeading() {
        return this.heading;
    }

    public List<DialogButton> getButtons() {
        return this.buttons;
    }

    public List<IOFXProblem> getProblems() {
        return this.listOfProblems;
    }

    public boolean isModalWithButtons() {
        return ListSequence.fromList(this.buttons).count() > 0;
    }

    public boolean isReloadEnabled() {
        return this.reloadEnabled;
    }

    public IToolkit_MainWindow.DlgType getType() {
        return this.type;
    }

    public IApplication.DlgRunnable getRunnable() {
        return this.runnable;
    }

    public void clearRunnable() {
        this.runnable = null;
    }

    public boolean isCloseQuestion() {
        return IToolkit_MainWindow.DlgType.QUESTIONCLOSE_SMALL.equals((Object)this.type);
    }

    public boolean isErrorLarge() {
        return IToolkit_MainWindow.DlgType.ERROR_LARGE.equals((Object)this.type);
    }

    public boolean isErrorSmall() {
        return IToolkit_MainWindow.DlgType.ERROR_SMALL.equals((Object)this.type);
    }

    public boolean isInfoLargeOrSmall() {
        return IToolkit_MainWindow.DlgType.INFO_LARGE.equals((Object)this.type) || IToolkit_MainWindow.DlgType.INFO_SMALL.equals((Object)this.type);
    }

    public boolean isToast() {
        return IToolkit_MainWindow.DlgType.INFO_SMALL.equals((Object)this.type) && this.toastMessageOnly;
    }

    public boolean isInfoSmall() {
        return IToolkit_MainWindow.DlgType.INFO_SMALL.equals((Object)this.type);
    }

    public boolean isInfoLarge() {
        return IToolkit_MainWindow.DlgType.INFO_LARGE.equals((Object)this.type);
    }

    public boolean isListOfProblems() {
        return this.listOfProblems != null && ListSequence.fromList(this.listOfProblems).count() > 0;
    }

    public void addButton(DialogButton btn) {
        ListSequence.fromList(this.buttons).addElement((Object)btn);
    }

    public H2Dialog withReload() {
        this.reloadEnabled = true;
        return this;
    }

    public String toString() {
        Object result;
        Object object = result = this.text == null ? "" : this.text;
        if (this.listOfProblems != null) {
            result = (String)result + " " + FlagOnUiEvent.asSimpleString(this.listOfProblems);
        }
        result = result == null ? null : ((String)result).trim();
        int maxLength = ((String)result).length() < 30 ? ((String)result).length() : 30;
        String trimmedText = ((String)result).substring(0, maxLength);
        return "[H2Dlg " + this.type + ": " + trimmedText + "....  (rnbl=" + (this.runnable != null) + " modal=" + this.isModalWithButtons() + ")]";
    }

    public static class DialogButton {
        public String label;
        public String buttonCode;

        public DialogButton(String label, String code) {
            this.label = label;
            this.buttonCode = code;
        }
    }
}

