/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.h2forms.pebble;

import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jetbrains.mps.internal.collections.runtime.IMapSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;

public abstract class AbstractEditor {
    public static final String EDITOR_ID = "editorId";
    public static final String EDITOR_INDEX = "editorIndex";
    public static final String LABEL_TEXT = "labelText";
    public static final String ENABLED = "enabled";
    public static final String FOLDED = "folded";
    public static final String WIDE = "wide";
    public static final String TEXT = "text";
    public static final String VALUE = "value";
    public static final String SELECTEDINDEX = "selectedIndex";
    public static final String ITEMS = "items";
    public static final String REQUEST_FOCUS = "requestFocus";
    public static final String ERROR_TEXT = "errorText";
    public static final String USE_NUMERIC_KEYBOARD = "useNumericKeyboard";
    public static final String IS_DATE_DELEGATE = "isDateDelegate";
    public static final String IS_DATE_DELEGATE_WITH_PICKER = "isDateDelegateWithPicker";
    public static final String SCANABLE = "scanable";
    public static final String MULTILINE = "multiline";
    public static final String MULTILINE_LABELS = "multilineLabels";
    public static final String MULTILINE_VALUES = "multilineValues";
    public static final String UPLOADLOCATIONRETRIEVE = "uploadLocationRetrieve";
    public static final String UPLOADLOCATIONSTORE = "uploadLocationStore";
    public static final String MAX_WIDTH = "maxWidth";
    public static final String MAX_HEIGHT = "maxHeight";
    public static final String ALTER = "alter";
    public static final String NUM_OF_LINES = "numOfLines";
    protected String editorId;
    protected int editorIndex;
    protected String labelText;
    protected boolean enabled;
    protected boolean requestFocus;
    protected String errorText;
    protected boolean folded;
    protected boolean wide;
    protected boolean scanable;
    private boolean initBeforeRenderDone;
    protected Writer writerToUse;
    protected PebbleTemplate compiledTextEditorTemplate;

    public AbstractEditor(String id, PebbleTemplate renderer) {
        this.editorId = id + "_" + this.hashCode();
        this.compiledTextEditorTemplate = renderer;
        this.initBeforeRenderDone = false;
        this.labelText = "";
        this.enabled = true;
        this.requestFocus = false;
        this.folded = false;
        this.scanable = false;
        this.errorText = null;
    }

    public void initBeforeRender(Writer writer, int editIndex) {
        this.writerToUse = writer;
        this.editorIndex = editIndex;
        this.initBeforeRenderDone = true;
    }

    public void newObjectBound() {
    }

    public Map<String, Object> initAndGetRenderMap() {
        if (!this.initBeforeRenderDone) {
            throw new IllegalStateException("Programming error - initBeforeRender() not called.");
        }
        IMapSequence renderMap = MapSequence.fromMap(new HashMap());
        MapSequence.fromMap((Map)renderMap).put((Object)EDITOR_ID, (Object)this.editorId);
        MapSequence.fromMap((Map)renderMap).put((Object)EDITOR_INDEX, (Object)this.editorIndex);
        MapSequence.fromMap((Map)renderMap).put((Object)ENABLED, (Object)this.enabled);
        MapSequence.fromMap((Map)renderMap).put((Object)FOLDED, (Object)this.folded);
        MapSequence.fromMap((Map)renderMap).put((Object)WIDE, (Object)this.wide);
        MapSequence.fromMap((Map)renderMap).put((Object)SCANABLE, (Object)this.scanable);
        MapSequence.fromMap((Map)renderMap).put((Object)LABEL_TEXT, (Object)this.labelText);
        MapSequence.fromMap((Map)renderMap).put((Object)REQUEST_FOCUS, (Object)this.requestFocus);
        MapSequence.fromMap((Map)renderMap).put((Object)ERROR_TEXT, (Object)this.errorText);
        this.initBeforeRenderDone = false;
        return renderMap;
    }

    public void setValidationErrorText(String text) {
        if ("".equals(text)) {
            text = null;
        }
        this.errorText = text;
    }

    public boolean isValidationErrorText() {
        return this.errorText != null;
    }

    public void setLabel(String text) {
        this.labelText = text;
    }

    public void setEnabled(boolean enbl) {
        this.enabled = enbl;
    }

    public void requestFocus(boolean doit) {
        this.requestFocus = doit;
    }

    public abstract void toHtml() throws IOException;

    public abstract void handleRequest(HttpServletRequest var1);

    public void enableKeyReleaseEvents() {
    }

    public void setForcedNumericalEditor() {
    }

    public void setIssuesUpdateConclusion() {
    }

    public void setPreviousIssuesUpadetConclusion() {
    }

    public void setReadOnlyModeNotDisabled() {
    }

    public void setEditorPrompt(String promptText) {
    }

    public void gcClear() {
    }

    public void setLabelTooltip(String text) {
    }

    public Object getEditor() {
        return this;
    }

    public Object getLabel() {
        return this;
    }

    public Object getRightPartComponent() {
        return this.getEditor();
    }

    public void setOption(IToolkit_TextEditor.Option ... option) {
        if (IToolkit_TextEditor.has((IToolkit_TextEditor.Option)IToolkit_TextEditor.Option.FOLDED, (IToolkit_TextEditor.Option[])option)) {
            this.folded = true;
        }
        if (IToolkit_TextEditor.has((IToolkit_TextEditor.Option)IToolkit_TextEditor.Option.WIDE, (IToolkit_TextEditor.Option[])option)) {
            this.wide = true;
        }
    }

    public static class PebItem {
        public String label;
        public boolean enabled;
        public int itemId;
        public boolean selected;

        public PebItem(String label, boolean enbld, int code, boolean sel) {
            this.label = label;
            this.itemId = code;
            this.enabled = enbld;
            this.selected = sel;
        }

        public String toString() {
            return String.format("[%s %d]", this.label, this.itemId);
        }
    }
}

