/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.h2forms.pebble;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.loader.Loader;
import com.mitchellbosecke.pebble.loader.ServletLoader;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_CommandContainerUi;
import org.modellwerkstatt.h2forms.core.ContextClient;
import org.modellwerkstatt.h2forms.core.ContextPage;
import org.modellwerkstatt.h2forms.core.ContextStatics;
import org.modellwerkstatt.h2forms.core.H2Dialog;
import org.modellwerkstatt.h2forms.core.IH2FormsTemplateRenderer;
import org.modellwerkstatt.h2forms.pebble.AbstractForm;
import org.modellwerkstatt.h2forms.pebble.CommandContainerUi;

public class PebbleTemplateRenderer
implements IH2FormsTemplateRenderer {
    public static final String TEMPLATE_ENDING = "peb";
    private PebbleEngine engine;
    private PebbleTemplate compiledHomeTemplate;
    private PebbleTemplate compiledLoginTemplate;

    public void initTemplates(ServletContext context, String templateName, String homeTemplate, String loginTemplate) {
        this.engine = new PebbleEngine.Builder().loader((Loader)new ServletLoader(context)).strictVariables(true).build();
        this.compiledHomeTemplate = this.compileTemplateFor(templateName, homeTemplate);
        this.compiledLoginTemplate = this.compileTemplateFor(templateName, loginTemplate);
    }

    public PebbleTemplate compileTemplateFor(String templateName, String template) {
        return this.engine.getTemplate("/static/" + templateName + "/" + template + ".peb");
    }

    @Override
    public void handleRequest(HttpServletRequest request, String naviCrtl, IToolkit_CommandContainerUi currentContainerUI) {
        if (currentContainerUI != null) {
            ((CommandContainerUi)currentContainerUI).handleRequest(request, naviCrtl);
        }
    }

    @Override
    public void handleResponse(HttpServletResponse response, ContextStatics statics, ContextClient client, ContextPage page, H2Dialog infoMessage, IToolkit_CommandContainerUi currentContainerUI) throws IOException {
        if (currentContainerUI == null) {
            throw new RuntimeException("This can not happen - internal H2Forms error.");
        }
        ((CommandContainerUi)currentContainerUI).handleResponse(response, statics, client, page, infoMessage);
    }

    @Override
    public void handleSpecialPageResponse(IH2FormsTemplateRenderer.SpecialPage typeOfPage, HttpServletResponse response, ContextStatics statics, ContextClient client, ContextPage page, H2Dialog infoMessage) throws IOException {
        page.setScrollPosition(-1);
        Map<String, Object> renderMap = CommandContainerUi.createDefaultMapForCommandUI(statics, client, page, infoMessage);
        if (typeOfPage == IH2FormsTemplateRenderer.SpecialPage.LOGIN_PAGE) {
            AbstractForm.PebAction someAction = new AbstractForm.PebAction("Ok", false, null, null, 0, 0, null);
            someAction.adjustEnabled(true);
            MapSequence.fromMap(renderMap).put((Object)"keyboard", (Object)true);
            this.compiledLoginTemplate.evaluate((Writer)response.getWriter(), renderMap);
        } else if (typeOfPage == IH2FormsTemplateRenderer.SpecialPage.LANDING_PAGE) {
            this.compiledHomeTemplate.evaluate((Writer)response.getWriter(), renderMap);
        } else {
            throw new IllegalStateException("Unknonwn page type to render: " + typeOfPage);
        }
    }
}

