/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.h2forms.pebble;

import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.h2forms.pebble.AbstractColumnDivider;
import org.modellwerkstatt.h2forms.pebble.IntListHelper;
import org.modellwerkstatt.h2forms.pebble.TableForm;

public class TwelveWeightDivider
extends AbstractColumnDivider {
    private List<Integer> singleLineWeights;
    private List<Boolean> closingRow;

    @Override
    public void init(List<TableForm.Column> cols) {
        super.init(cols);
        if (ListSequence.fromList(cols).count() > 12) {
            throw new RuntimeException("This table column-divider only supports only up to 12 cols. You are using " + ListSequence.fromList(cols).count() + " cols.");
        }
        this.singleLineWeights = ListSequence.fromList(new ArrayList());
        this.closingRow = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(cols).visitAll(it -> {
            ListSequence.fromList(this.singleLineWeights).addElement((Object)((int)Math.round((double)it.width / 8.33)));
            ListSequence.fromList(this.closingRow).addElement((Object)false);
        });
        int total = IntListHelper.sum(this.singleLineWeights);
        if (total != 12) {
            if (total > 12) {
                int indexOfMax = IntListHelper.maxAsIndex(this.singleLineWeights);
                ListSequence.fromList(this.singleLineWeights).setElement(indexOfMax, (Object)((Integer)ListSequence.fromList(this.singleLineWeights).getElement(indexOfMax) - (total - 12)));
            } else if (total < 12) {
                int indexOfMin = IntListHelper.minAsIndex(this.singleLineWeights);
                ListSequence.fromList(this.singleLineWeights).setElement(indexOfMin, (Object)((Integer)ListSequence.fromList(this.singleLineWeights).getElement(indexOfMin) + (12 - total)));
            }
        }
        if (ListSequence.fromList(this.singleLineWeights).any(it -> it <= 0)) {
            throw new RuntimeException("After calculating weights for columns, we ended up with 0 weights for some cols. This should not happen (cols weights " + this.singleLineWeights + ")!");
        }
        int sum = 0;
        for (int i = 0; i < ListSequence.fromList(this.singleLineWeights).count(); ++i) {
            if ((sum += ((Integer)ListSequence.fromList(this.singleLineWeights).getElement(i)).intValue()) % 6 == 0) {
                ListSequence.fromList(this.closingRow).setElement(i, (Object)true);
                continue;
            }
            if (sum <= 6 || !ListSequence.fromList(this.closingRow).all(it -> it == false) || i <= 0) continue;
            ListSequence.fromList(this.closingRow).setElement(i - 1, (Object)true);
        }
    }

    @Override
    public boolean needsCloseRow(int colIndex) {
        return (Boolean)ListSequence.fromList(this.closingRow).getElement(colIndex);
    }

    @Override
    public boolean needsOpenRow(int colIndex) {
        return false;
    }

    @Override
    public int getSizeS(int colIndex) {
        return this.getSizeM(colIndex) * 2;
    }

    @Override
    public int getSizeM(int colIndex) {
        return (Integer)ListSequence.fromList(this.singleLineWeights).getElement(colIndex);
    }

    @Override
    public int numOfEmptyCellToAdd() {
        return 0;
    }

    public static void main(String[] args) {
        TableForm.Column single8 = new TableForm.Column("prop", "lab", null, 8, false);
        TwelveWeightDivider d1 = new TwelveWeightDivider();
        d1.init((List<TableForm.Column>)ListSequence.fromListAndArray(new ArrayList(), (Object[])new TableForm.Column[]{single8, single8, single8, single8, single8, single8, single8, single8, single8, single8, single8, single8}));
        TwelveWeightDivider d2 = new TwelveWeightDivider();
        d2.init((List<TableForm.Column>)ListSequence.fromListAndArray(new ArrayList(), (Object[])new TableForm.Column[]{single8, single8}));
        TwelveWeightDivider d3 = new TwelveWeightDivider();
        d3.init((List<TableForm.Column>)ListSequence.fromListAndArray(new ArrayList(), (Object[])new TableForm.Column[]{single8, single8, single8}));
        TwelveWeightDivider d4 = new TwelveWeightDivider();
        d4.init((List<TableForm.Column>)ListSequence.fromListAndArray(new ArrayList(), (Object[])new TableForm.Column[]{single8, single8, single8, single8}));
        TwelveWeightDivider d5 = new TwelveWeightDivider();
        d5.init((List<TableForm.Column>)ListSequence.fromListAndArray(new ArrayList(), (Object[])new TableForm.Column[]{single8, single8, single8, single8, single8}));
        TwelveWeightDivider d6 = new TwelveWeightDivider();
        d6.init((List<TableForm.Column>)ListSequence.fromListAndArray(new ArrayList(), (Object[])new TableForm.Column[]{single8, single8, single8, single8, single8, single8}));
        System.err.println("\n\n\n--------------------------------\n" + AbstractColumnDivider.printDiv(d1));
        System.err.println("\n\n\n--------------------------------\n" + AbstractColumnDivider.printDiv(d2));
        System.err.println("\n\n\n--------------------------------\n" + AbstractColumnDivider.printDiv(d3));
        System.err.println("\n\n\n--------------------------------\n" + AbstractColumnDivider.printDiv(d4));
        System.err.println("\n\n\n--------------------------------\n" + AbstractColumnDivider.printDiv(d5));
        System.err.println("\n\n\n--------------------------------\n" + AbstractColumnDivider.printDiv(d6));
    }
}

