package org.modellwerkstatt.dataux.tests.dynlock;

/*Generated by MPS */

import org.springframework.stereotype.Component;
import org.springframework.beans.factory.annotation.Autowired;
import org.modellwerkstatt.objectflow.runtime.IOFXApplicationFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.dataux.runtime.services.DynLockStateHolder;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.services.ImplDynLockQuery;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import java.util.HashMap;
import org.modellwerkstatt.objectflow.runtime.OFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.OFXAbortedException;

@Component(value = "org.modellwerkstatt.dataux.tests.dynlock.DynLockService")
public class DynLockService {
  @Autowired
  private IOFXApplicationFactory uiFactory;

  @Autowired
  private IOFXPlatform __runtimeIOFXPlatform;
  @Autowired
  private IOFXTranslationProvider __runtimeIOFXTranslationProvider;

  private DynLockService __dynlockDynLockService = this;


  public DynLockStateHolder getADynLockInstance(final IOFXSession __manMapSession) {
    if (uiFactory instanceof IToolkit_UiFactory) {
      return new ImplDynLockQuery(((IToolkit_UiFactory) uiFactory), __manMapSession);
    }

    throw new RuntimeException("In order to get a dynLockInstance, connection to EventBus via IToolkit_UiFactory is needed. But we have a " + uiFactory + " instead.");
  }
  public void usageExampleFor(final IOFXSession __manMapSession) {

    String finanzberichtLockName = "finanzbericht_" + 4711;
    DynLockStateHolder state = __dynlockDynLockService.getADynLockInstance(__manMapSession);

    try {
      state.requestLocks(ListSequence.fromListAndArray(new ArrayList<String>(), finanzberichtLockName));

      // slow running DB code here..
      // #SomeRepo.findAllRelevantBelege()
      // for () .... wire up domain model with some refs etc. etc.

      // before doing a done, check locks ...

      state.ensureLocksReceived(800);

      if (state.anyLockNotGranted()) {
        {
          HashMap<String, Object> parameterMap = null;
          __manMapSession.addProblem(new OFXProblem(__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "Lock %s not granted, it is locked by user %s", finanzberichtLockName, state.firstUserHoldingALock()), null, parameterMap, new IOFXProblem.Opt[]{}));
          throw new OFXAbortedException();
        }
      }

    } finally {
      state.close();
    }
    //  else do a done.
  }




}
