package org.modellwerkstatt.objectflow.tests.ConvSerdes;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import org.modellwerkstatt.objectflow.serdes.ConvFormatOptions;
import org.modellwerkstatt.objectflow.serdes.IConvFormatOptions;
import org.modellwerkstatt.objectflow.serdes.IConvSerdes;
import org.modellwerkstatt.objectflow.serdes.CONV;
import org.modellwerkstatt.objectflow.serdes.ConvStdFormatters;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;
import java.math.BigDecimal;
import org.joda.time.LocalDate;
import org.joda.time.DateTime;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;

public class JSonDeserialization extends OFXTestSuit {

  @Autowired
  private IOFXPlatform __runtimeIOFXPlatform;
  @Autowired
  private IOFXTranslationProvider __runtimeIOFXTranslationProvider;

  private String jSonTxt = "{\n\t\"intValue\": 4711,\n\t\"stringValue\": \"Test String\",\n\t\"bdValue\": 12.45,\n\t\"localDateValue\": \"27.01.1980\",\n\t\"dateTimeValue\": \"04:7:28 27.01.80\", \n\t\"statusValue\": \"S2\",\n\t\n\t\"textChild\": {\n\t\"intValue\": 0,\n\t\"stringValue\": \"Test String in Text Child\",\n\t\"bdValue\": 47.11,\n\t\"localDateValue\": \"27.01.1980\",\n\t\"dateTimeValue\": \"04:7:28 27.01.80\", \n\t\"statusValue\": \"S3\" \t\n\t},\n\t\"multipleChilds\": [{\n\t\"intValue\": 10,\n\t\"stringValue\": \"Child in List 1\",\n\t\"bdValue\": 47.12,\n\t\"localDateValue\": \"27.01.1980\",\n\t\"dateTimeValue\": \"04:7:28 27.01.80\", \n\t\"statusValue\": \"S1\" \t\n\t}, { \n\t\"intValue\": 20,\n\t\"stringValue\": \"Child in List 2\",\n\t\"bdValue\": 47.13,\n\t\"localDateValue\": \"27.01.1980\",\n\t\"dateTimeValue\": \"04:7:28 27.01.80\", \n\t\"statusValue\": \"\" \t\n\t} ]\n}    \n";
  private String entityJsonTxt = "{\"id\":4711,\"vo1\":{\"myIntVal\":4712,\"myStringVal\":\"4712\"},\"vo2\":{\"myIntVal\":4713,\"myStringVal\":\"4713\"},\"childs\":[{\"id\":7,\"name\":\"Entity Child\",\"parentKEY\":4711}]}";
  @Autowired
  private IOFXUserEnvironment userEnv;



  public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  @OFXTestMethod(id = 0, name = "Deserialize and check various types here..", debug = false, enabled = true, runAt = "")
  public void __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY);
    IConvSerdes<Text> myDeser = CONV.<Text>jsonSerDes(Text.class, new ConvStdFormatters(opts));

    Text newObj = myDeser.deser(jSonTxt);

    {
      int leftSide = newObj.getIntValue();
      int rightSide = 4711;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .intValue == 4711          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String operand = newObj.getStringValue();
      String param0 = "Test String";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .stringValue.equals(\"Test String\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      BigDecimal leftSide = newObj.getBdValue();
      BigDecimal rightSide = new BigDecimal("12.45");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .bdValue == 12.45bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      LocalDate operand = newObj.getLocalDateValue();
      LocalDate param0 = new LocalDate(1980, 1, 27);
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .localDateValue.equals( new_LocalDateFromServer )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      DateTime operand = newObj.getDateTimeValue();
      DateTime param0 = new DateTime(1980, 1, 27, 4, 7, 28, 0);
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .dateTimeValue.equals( new_DateTimeFromServer )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    {
      IOFXMetaStatus.IOFXStatusElement operand = newObj.getStatusValue();
      if (!(SaveObjectComperator.equalsStatus(operand, Text_MySatus.S2))) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .statusValue of S2           ==>>" + operand + "\n");
      }
    }

    {
      int leftSide = newObj.getTextChild().getIntValue();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .textChild.intValue == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      BigDecimal leftSide = newObj.getTextChild().getBdValue();
      BigDecimal rightSide = new BigDecimal("47.11");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .textChild.bdValue == 47.11bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      IOFXMetaStatus.IOFXStatusElement operand = newObj.getTextChild().getStatusValue();
      if (!(SaveObjectComperator.equalsStatus(operand, Text_MySatus.S3))) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .textChild.statusValue of S3           ==>>" + operand + "\n");
      }
    }

    {
      int leftSide = ListSequence.fromList(newObj.getMultipleChilds()).count();
      int rightSide = 2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .multipleChilds.size == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      int leftSide = ListSequence.fromList(newObj.getMultipleChilds()).getElement(0).getIntValue();
      int rightSide = 10;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .multipleChilds.get.intValue == 10          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      BigDecimal leftSide = ListSequence.fromList(newObj.getMultipleChilds()).getElement(0).getBdValue();
      BigDecimal rightSide = new BigDecimal("47.12");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .multipleChilds.get.bdValue == 47.12bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      IOFXMetaStatus.IOFXStatusElement operand = ListSequence.fromList(newObj.getMultipleChilds()).getElement(0).getStatusValue();
      if (!(SaveObjectComperator.equalsStatus(operand, Text_MySatus.S1))) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .multipleChilds.get.statusValue of S1           ==>>" + operand + "\n");
      }
    }

    {
      int leftSide = ListSequence.fromList(newObj.getMultipleChilds()).getElement(1).getIntValue();
      int rightSide = 20;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .multipleChilds.get.intValue == 20          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      BigDecimal leftSide = ListSequence.fromList(newObj.getMultipleChilds()).getElement(1).getBdValue();
      BigDecimal rightSide = new BigDecimal("47.13");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .multipleChilds.get.bdValue == 47.13bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      IOFXMetaStatus.IOFXStatusElement operand = ListSequence.fromList(newObj.getMultipleChilds()).getElement(1).getStatusValue();
      if (!(SaveObjectComperator.equalsStatus(operand, Text_MySatus.S3))) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .multipleChilds.get.statusValue of S3           ==>>" + operand + "\n");
      }
    }

  }
  @OFXTestMethod(id = 1, name = "Deserialize and check various types here that might be null, when null in json", debug = false, enabled = true, runAt = "")
  public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY);
    IConvSerdes<Text> myDeser = CONV.<Text>jsonSerDes(Text.class, new ConvStdFormatters(opts));

    String nullText = "{\n\t\"intValue\": null,\n\t\"stringValue\": null,\n\t\"bdValue\": null,\n\t\"localDateValue\": null,\n\t\"dateTimeValue\": null, \n\t\"statusValue\": null,\n\t\n\t\"textChild\": null,\n\t\"multipleChilds\": null\n}";
    Text newObj = myDeser.deser(nullText);

    {
      int leftSide = newObj.getIntValue();
      int rightSide = -1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here that might be null, when null in json':  newObj .intValue == -1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String leftSide = newObj.getStringValue();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here that might be null, when null in json':  newObj .stringValue ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      BigDecimal leftSide = newObj.getBdValue();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here that might be null, when null in json':  newObj .bdValue ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      LocalDate leftSide = newObj.getLocalDateValue();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here that might be null, when null in json':  newObj .localDateValue ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      DateTime leftSide = newObj.getDateTimeValue();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here that might be null, when null in json':  newObj .dateTimeValue ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      IOFXMetaStatus.IOFXStatusElement operand = newObj.getStatusValue();
      if (!(SaveObjectComperator.equalsStatus(operand, Text_MySatus.S3))) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here that might be null, when null in json':  newObj .statusValue of S3           ==>>" + operand + "\n");
      }
    }

    {
      TextChild leftSide = newObj.getTextChild();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here that might be null, when null in json':  newObj .textChild ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      List<TextChild> leftSide = newObj.getMultipleChilds();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here that might be null, when null in json':  newObj .multipleChilds ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 2, name = "Deserialize and provok an error.", debug = false, enabled = true, runAt = "")
  public void __testmethod_2(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {



    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY);

    IConvSerdes<Text> myDeser = CONV.<Text>jsonSerDes(Text.class, new ConvStdFormatters(opts));

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        Text newObj = myDeser.deser(jSonTxt.replace("stringValue", "stringValue2"));

      } catch (RuntimeException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("Text.stringValue")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("Text.stringValue")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'JSonDeserialization.Deserialize and provok an error.': Fail In Exception RuntimeException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'JSonDeserialization.Deserialize and provok an error.': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'JSonDeserialization.Deserialize and provok an error.': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }
  }
  @OFXTestMethod(id = 3, name = "Using Key Substitutioner for json to obj graph", debug = false, enabled = true, runAt = "")
  public void __testmethod_3(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY);

    String json_Adopted = jSonTxt.replace("intValue", "int-Value").replace("textChild", "text-Child");

    IConvSerdes<Text> myDeser = CONV.<Text>jsonSerDes(Text.class, new ConvStdFormatters(opts, JsonKeySubsitutes.KEY_SUB));

    Text newObj = myDeser.deser(json_Adopted);

    {
      int leftSide = newObj.getIntValue();
      int rightSide = 4711;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Using Key Substitutioner for json to obj graph':  newObj .intValue == 4711          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = newObj.getTextChild().getIntValue();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Using Key Substitutioner for json to obj graph':  newObj .textChild.intValue == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(newObj.getMultipleChilds()).count();
      int rightSide = 2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Using Key Substitutioner for json to obj graph':  newObj .multipleChilds.size == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(newObj.getMultipleChilds()).getElement(0).getIntValue();
      int rightSide = 10;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Using Key Substitutioner for json to obj graph':  newObj .multipleChilds.get.intValue == 10          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(newObj.getMultipleChilds()).getElement(1).getIntValue();
      int rightSide = 20;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Using Key Substitutioner for json to obj graph':  newObj .multipleChilds.get.intValue == 20          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 4, name = "Field Missing in json should lead to error when using complete_excact.", debug = false, enabled = true, runAt = "")
  public void __testmethod_4(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY);

    String json_Adopted = jSonTxt.replace("\"intValue\": 4711,", "");

    IConvSerdes<Text> myDeser = CONV.<Text>jsonSerDes(Text.class, new ConvStdFormatters(opts));

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        Text newObj = myDeser.deser(json_Adopted);

      } catch (RuntimeException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("do not match")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("do not match")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'JSonDeserialization.Field Missing in json should lead to error when using complete_excact.': Fail In Exception RuntimeException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'JSonDeserialization.Field Missing in json should lead to error when using complete_excact.': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'JSonDeserialization.Field Missing in json should lead to error when using complete_excact.': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }


  }
  @OFXTestMethod(id = 5, name = "Field to much leads to error when using complete_exact", debug = false, enabled = true, runAt = "")
  public void __testmethod_5(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY);

    String json_Adopted = jSonTxt.replace("\"intValue\": 4711,", "\"intValue\": 4711, \"intValue2\": 4722,");

    IConvSerdes<Text> myDeser = CONV.<Text>jsonSerDes(Text.class, new ConvStdFormatters(opts));

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        Text newObj = myDeser.deser(json_Adopted);

      } catch (RuntimeException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("do not match")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("do not match")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'JSonDeserialization.Field to much leads to error when using complete_exact': Fail In Exception RuntimeException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'JSonDeserialization.Field to much leads to error when using complete_exact': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'JSonDeserialization.Field to much leads to error when using complete_exact': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }


  }
  @OFXTestMethod(id = 6, name = "Field to much leads to NO ERROR when not using complete_exact", debug = false, enabled = true, runAt = "")
  public void __testmethod_6(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en");

    String json_Adopted = jSonTxt.replace("\"intValue\": 4711,", "\"intValue\": 4711, \"intValue2\": 4722,");

    IConvSerdes<Text> myDeser = CONV.<Text>jsonSerDes(Text.class, new ConvStdFormatters(opts));

    Text newObj = myDeser.deser(json_Adopted);

  }
  @OFXTestMethod(id = 7, name = "Field Missing in json should set Field to null / 0 when field not present", debug = false, enabled = true, runAt = "")
  public void __testmethod_7(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.SET_MISSING_PROPERTIES_NULL);

    String json_Adopted = "{ }";

    IConvSerdes<Text> myDeser = CONV.<Text>jsonSerDes(Text.class, new ConvStdFormatters(opts));

    Text newObj = myDeser.deser(json_Adopted);

    {
      int leftSide = newObj.getIntValue();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Field Missing in json should set Field to null / 0 when field not present':  newObj .intValue == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String leftSide = newObj.getStringValue();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Field Missing in json should set Field to null / 0 when field not present':  newObj .stringValue ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      BigDecimal leftSide = newObj.getBdValue();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Field Missing in json should set Field to null / 0 when field not present':  newObj .bdValue ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      LocalDate leftSide = newObj.getLocalDateValue();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Field Missing in json should set Field to null / 0 when field not present':  newObj .localDateValue ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      DateTime leftSide = newObj.getDateTimeValue();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Field Missing in json should set Field to null / 0 when field not present':  newObj .dateTimeValue ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    // S3 = null while loading
    {
      IOFXMetaStatus.IOFXStatusElement operand = newObj.getStatusValue();
      if (!(SaveObjectComperator.equalsStatus(operand, Text_MySatus.S3))) {
        throw new OFXTestSuitException("'JSonDeserialization.Field Missing in json should set Field to null / 0 when field not present':  newObj .statusValue of S3           ==>>" + operand + "\n");
      }
    }

    {
      TextChild leftSide = newObj.getTextChild();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Field Missing in json should set Field to null / 0 when field not present':  newObj .textChild ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(newObj.getMultipleChilds()).count();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Field Missing in json should set Field to null / 0 when field not present':  newObj .multipleChilds.size == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }



  }
  @OFXTestMethod(id = 8, name = "Null array should set list property to null", debug = false, enabled = true, runAt = "")
  public void __testmethod_8(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.SET_MISSING_PROPERTIES_NULL);

    String json_Adopted = "{\"multipleChilds\": null}";

    IConvSerdes<Text> myDeser = CONV.<Text>jsonSerDes(Text.class, new ConvStdFormatters(opts));

    Text newObj = myDeser.deser(json_Adopted);

    {
      List<TextChild> leftSide = newObj.getMultipleChilds();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Null array should set list property to null':  newObj .multipleChilds ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 9, name = "Null array should set list property to empty in case of NULL_ARRAY_TO_EMPTY", debug = false, enabled = true, runAt = "")
  public void __testmethod_9(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.SET_MISSING_PROPERTIES_NULL, IConvFormatOptions.Mode.NULL_ARRAY_TO_EMPTY);

    String json_Adopted = "{\"multipleChilds\": null}";

    IConvSerdes<Text> myDeser = CONV.<Text>jsonSerDes(Text.class, new ConvStdFormatters(opts));

    Text newObj = myDeser.deser(json_Adopted);

    {
      int leftSide = ListSequence.fromList(newObj.getMultipleChilds()).count();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Null array should set list property to empty in case of NULL_ARRAY_TO_EMPTY':  newObj .multipleChilds.size == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 10, name = "Deserialize a list of object straight on - using array and class.", debug = false, enabled = true, runAt = "")
  public void __testmethod_10(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.SET_MISSING_PROPERTIES_NULL);
    String json_adopted = "[" + jSonTxt + ", " + jSonTxt + "]";

    IConvSerdes<Text[]> myDeser = CONV.<Text[]>jsonSerDes(Text[].class, new ConvStdFormatters(opts));

    Text[] newObjList = myDeser.deser(json_adopted);

    {
      int leftSide = newObjList.length;
      int rightSide = 2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of object straight on - using array and class.':  newObjList .length == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    for (Text newObj : newObjList) {
      {
        int leftSide = newObj.getIntValue();
        int rightSide = 4711;
        if (leftSide != rightSide) {
          throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of object straight on - using array and class.':  newObj .intValue == 4711          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
      }
      {
        String operand = newObj.getStringValue();
        String param0 = "Test String";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append("" + param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!(operand.equals(param0))) {
          throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of object straight on - using array and class.':  newObj .stringValue.equals(\"Test String\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
        }
      }
      {
        BigDecimal leftSide = newObj.getBdValue();
        BigDecimal rightSide = new BigDecimal("12.45");
        if (leftSide.compareTo(rightSide) != 0) {
          throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of object straight on - using array and class.':  newObj .bdValue == 12.45bd          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
      }

      {
        LocalDate operand = newObj.getLocalDateValue();
        LocalDate param0 = new LocalDate(1980, 1, 27);
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append("" + param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!(operand.equals(param0))) {
          throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of object straight on - using array and class.':  newObj .localDateValue.equals( new_LocalDateFromServer )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
        }
      }
      {
        DateTime operand = newObj.getDateTimeValue();
        DateTime param0 = new DateTime(1980, 1, 27, 4, 7, 28, 0);
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append("" + param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!(operand.equals(param0))) {
          throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of object straight on - using array and class.':  newObj .dateTimeValue.equals( new_DateTimeFromServer )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
        }
      }

      {
        IOFXMetaStatus.IOFXStatusElement operand = newObj.getStatusValue();
        if (!(SaveObjectComperator.equalsStatus(operand, Text_MySatus.S2))) {
          throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of object straight on - using array and class.':  newObj .statusValue of S2           ==>>" + operand + "\n");
        }
      }

      {
        int leftSide = newObj.getTextChild().getIntValue();
        int rightSide = 0;
        if (leftSide != rightSide) {
          throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of object straight on - using array and class.':  newObj .textChild.intValue == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
      }
      {
        BigDecimal leftSide = newObj.getTextChild().getBdValue();
        BigDecimal rightSide = new BigDecimal("47.11");
        if (leftSide.compareTo(rightSide) != 0) {
          throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of object straight on - using array and class.':  newObj .textChild.bdValue == 47.11bd          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
      }
      {
        IOFXMetaStatus.IOFXStatusElement operand = newObj.getTextChild().getStatusValue();
        if (!(SaveObjectComperator.equalsStatus(operand, Text_MySatus.S3))) {
          throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of object straight on - using array and class.':  newObj .textChild.statusValue of S3           ==>>" + operand + "\n");
        }
      }

      {
        int leftSide = ListSequence.fromList(newObj.getMultipleChilds()).count();
        int rightSide = 2;
        if (leftSide != rightSide) {
          throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of object straight on - using array and class.':  newObj .multipleChilds.size == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
      }
    }

  }
  @OFXTestMethod(id = 11, name = "Deserialize with null object field . . . ", debug = false, enabled = true, runAt = "")
  public void __testmethod_11(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    String json = "{\n\t\"intValue\": 4711,\n\t\"stringValue\": \"Test String\",\n\t\"bdValue\": 12.45,\n\t\"localDateValue\": \"27.01.1980\",\n\t\"dateTimeValue\": \"04:7:28 27.01.80\", \n\t\"statusValue\": \"S2\",\n\t\n\t\"textChild\": null,\n\t\"multipleChilds\": []\n}    \n";

    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY);
    IConvSerdes<Text> myDeser = CONV.<Text>jsonSerDes(Text.class, new ConvStdFormatters(opts));

    Text newObj = myDeser.deser(json);

    {
      int leftSide = newObj.getIntValue();
      int rightSide = 4711;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize with null object field . . . ':  newObj .intValue == 4711          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String operand = newObj.getStringValue();
      String param0 = "Test String";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize with null object field . . . ':  newObj .stringValue.equals(\"Test String\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      BigDecimal leftSide = newObj.getBdValue();
      BigDecimal rightSide = new BigDecimal("12.45");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize with null object field . . . ':  newObj .bdValue == 12.45bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      LocalDate operand = newObj.getLocalDateValue();
      LocalDate param0 = new LocalDate(1980, 1, 27);
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize with null object field . . . ':  newObj .localDateValue.equals( new_LocalDateFromServer )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      DateTime operand = newObj.getDateTimeValue();
      DateTime param0 = new DateTime(1980, 1, 27, 4, 7, 28, 0);
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize with null object field . . . ':  newObj .dateTimeValue.equals( new_DateTimeFromServer )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    {
      IOFXMetaStatus.IOFXStatusElement operand = newObj.getStatusValue();
      if (!(SaveObjectComperator.equalsStatus(operand, Text_MySatus.S2))) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize with null object field . . . ':  newObj .statusValue of S2           ==>>" + operand + "\n");
      }
    }

    {
      TextChild leftSide = newObj.getTextChild();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize with null object field . . . ':  newObj .textChild ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      int leftSide = ListSequence.fromList(newObj.getMultipleChilds()).count();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize with null object field . . . ':  newObj .multipleChilds.size == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }


  }
  @OFXTestMethod(id = 12, name = "Deserialize Entity Graph with Opposite Keyword.", debug = false, enabled = true, runAt = "")
  public void __testmethod_12(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IConvSerdes<MyE> myDeser = CONV.<MyE>jsonSerDes(MyE.class, CONV.CONV_DEFAULT_EN);
    MyE origObj = myDeser.deser(entityJsonTxt);

    {
      int leftSide = ListSequence.fromList(origObj.getChilds()).count();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize Entity Graph with Opposite Keyword.':  origObj .childs.size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(origObj.getChilds()).first().getParentKEY();
      int rightSide = 4711;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize Entity Graph with Opposite Keyword.':  origObj .childs.first.parent#KEY == 4711          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 13, name = "Deserialize a cycling graph here.", debug = false, enabled = true, runAt = "")
  public void __testmethod_13(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    String JSON_INPUT = "{\"id\":1,\"rootName\":\"Root\",\"listOfChilds\":[{\"id\":2,\"childName\":\"Child 2\",\"listOfChilds\":[]},{\"id\":3,\"childName\":\"Child 3\",\"listOfChilds\":[]},{\"id\":4,\"childName\":\"Child 4\",\"listOfChilds\":[{\"id\":5,\"childName\":\"Child 5\",\"listOfChilds\":[]}]}]}";

    IConvSerdes<RootEntity> myDeser = CONV.<RootEntity>jsonSerDes(RootEntity.class, CONV.CONV_DEFAULT_EN);
    RootEntity root = myDeser.deser(JSON_INPUT);

    {
      int leftSide = ListSequence.fromList(root.getListOfChilds()).count();
      int rightSide = 3;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize a cycling graph here.':  root .listOfChilds.size == 3          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(ListSequence.fromList(root.getListOfChilds()).getElement(0).getListOfChilds()).count();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize a cycling graph here.':  root .listOfChilds.get.listOfChilds.size == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(root.getListOfChilds()).getElement(0).getId();
      int rightSide = 2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize a cycling graph here.':  root .listOfChilds.get.id == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      int leftSide = ListSequence.fromList(ListSequence.fromList(root.getListOfChilds()).getElement(1).getListOfChilds()).count();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize a cycling graph here.':  root .listOfChilds.get.listOfChilds.size == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(root.getListOfChilds()).getElement(1).getId();
      int rightSide = 3;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize a cycling graph here.':  root .listOfChilds.get.id == 3          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      int leftSide = ListSequence.fromList(ListSequence.fromList(root.getListOfChilds()).getElement(2).getListOfChilds()).count();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize a cycling graph here.':  root .listOfChilds.get.listOfChilds.size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(root.getListOfChilds()).getElement(2).getId();
      int rightSide = 4;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize a cycling graph here.':  root .listOfChilds.get.id == 4          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      int leftSide = ListSequence.fromList(ListSequence.fromList(root.getListOfChilds()).getElement(2).getListOfChilds()).getElement(0).getId();
      int rightSide = 5;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize a cycling graph here.':  root .listOfChilds.get.listOfChilds.get.id == 5          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }


  }
  @OFXTestMethod(id = 14, name = "Deserialize a simple array of value", debug = false, enabled = true, runAt = "")
  public void __testmethod_14(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {



    String json_codes = "[500, 501, 502]";

    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.SIMPLE_ARRAYS_TO_DTO);
    IConvSerdes<ErrCodes[]> myDeser = CONV.<ErrCodes[]>jsonSerDes(ErrCodes[].class, new ConvStdFormatters(opts));

    ErrCodes[] newObj = myDeser.deser(json_codes);

    {
      int leftSide = newObj.length;
      int rightSide = 3;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize a simple array of value':  newObj .length == 3          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = newObj[0].getValue();
      int rightSide = 500;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize a simple array of value':  [ .value == 500          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = newObj[1].getValue();
      int rightSide = 501;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize a simple array of value':  [ .value == 501          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = newObj[2].getValue();
      int rightSide = 502;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize a simple array of value':  [ .value == 502          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }


  }
  @OFXTestMethod(id = 15, name = "Deserialize an object with an array", debug = false, enabled = true, runAt = "")
  public void __testmethod_15(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {



    String json_codes = "{\"name\": \"test object\", \"errorCodes\": [500, 501, 502], \"coordinates\": [12.12, 13.13]}";

    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.SIMPLE_ARRAYS_TO_DTO);
    IConvSerdes<ComplexArr> myDeser = CONV.<ComplexArr>jsonSerDes(ComplexArr.class, new ConvStdFormatters(opts));

    ComplexArr newObj = myDeser.deser(json_codes);

    {
      String operand = newObj.getName();
      String param0 = "test object";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize an object with an array':  newObj .name.equals(\"test object\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    {
      int leftSide = ListSequence.fromList(newObj.getErrorCodes()).count();
      int rightSide = 3;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize an object with an array':  newObj .errorCodes.size == 3          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(newObj.getErrorCodes()).getElement(0).getValue();
      int rightSide = 500;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize an object with an array':  newObj .errorCodes.get.value == 500          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(newObj.getErrorCodes()).getElement(1).getValue();
      int rightSide = 501;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize an object with an array':  newObj .errorCodes.get.value == 501          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(newObj.getErrorCodes()).getElement(2).getValue();
      int rightSide = 502;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize an object with an array':  newObj .errorCodes.get.value == 502          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      BigDecimal leftSide = ListSequence.fromList(newObj.getCoordinates()).getElement(0).getValue();
      BigDecimal rightSide = new BigDecimal("12.12");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize an object with an array':  newObj .coordinates.get.value == 12.12bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      BigDecimal leftSide = ListSequence.fromList(newObj.getCoordinates()).getElement(1).getValue();
      BigDecimal rightSide = new BigDecimal("13.13");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize an object with an array':  newObj .coordinates.get.value == 13.13bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 16, name = "Deserialize complex ROOT - also checking for boolean.", debug = false, enabled = true, runAt = "")
  public void __testmethod_16(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {



    String json_codes = "{  \"web-app\": {    \"servlet\": [      {        \"servlet-name\": \"cofaxCDS\",        \"servlet-class\": \"org.cofax.cds.CDSServlet\",        \"init-param\": {          \"configGlossary:installationAt\": \"Philadelphia, PA\",          \"useJSP\": false,          \"jspListTemplate\": \"listTemplate.jsp\",          \"jspFileTemplate\": \"articleTemplate.jsp\",          \"cachePackageTagsTrack\": 200,          \"cachePackageTagsStore\": 200,          \"useDataStore\": true,          \"betaServer\": true        }      }    ]  }}";

    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.SET_MISSING_PROPERTIES_NULL);
    IConvSerdes<ROOT> myDeser = CONV.<ROOT>jsonSerDes(ROOT.class, new ConvStdFormatters(opts, JsonKeySubsitutes.KEY_SUB_COMPLEX));

    ROOT newObj = myDeser.deser(json_codes);

    {
      IOFXMetaStatus.IOFXStatusElement operand = ListSequence.fromList(newObj.getWeb_app().getServlet()).first().getInit_param().getUseJSP();
      if (!(SaveObjectComperator.equalsStatus(operand, ROOT_BoolStatus.FALSE))) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize complex ROOT - also checking for boolean.':  newObj .web_app.servlet.first.init_param.useJSP of false           ==>>" + operand + "\n");
      }
    }
    {
      IOFXMetaStatus.IOFXStatusElement operand = ListSequence.fromList(newObj.getWeb_app().getServlet()).first().getInit_param().getBetaServer();
      if (!(SaveObjectComperator.equalsStatus(operand, ROOT_BoolStatus.TRUE))) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize complex ROOT - also checking for boolean.':  newObj .web_app.servlet.first.init_param.betaServer of true           ==>>" + operand + "\n");
      }
    }


  }
  @OFXTestMethod(id = 17, name = "Deserialize a list of 1000 object for performance checks.", debug = false, enabled = true, runAt = "")
  public void __testmethod_17(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.SET_MISSING_PROPERTIES_NULL);


    long startTime2 = System.currentTimeMillis();
    String json_adopted = "[";
    for (int i = 0; i < 1000; i++) {
      json_adopted += jSonTxt + ", ";
    }
    json_adopted += jSonTxt + "]";
    long diffMsCreation = System.currentTimeMillis() - startTime2;

    long startTime3 = System.currentTimeMillis();
    IConvSerdes<Text[]> myDeser = CONV.<Text[]>jsonSerDes(Text[].class, new ConvStdFormatters(opts));
    long diffMsSerializer = System.currentTimeMillis() - startTime3;

    long startTime = System.currentTimeMillis();
    Text[] newObjList = myDeser.deser(json_adopted);
    {
      int leftSide = newObjList.length;
      int rightSide = 1001;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of 1000 object for performance checks.':  newObjList .length == 1001          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    long diffMs = System.currentTimeMillis() - startTime;



    {
      long leftSide = diffMs;
      int rightSide = 400;
      if (!(leftSide < rightSide)) {
        throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of 1000 object for performance checks.':  diffMs  < 400          ==>>" + leftSide + " <" + rightSide + "\n");
      }
    }
  }


  public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  public static void main(String[] args) {
    String[] allIncludedTest = new String[]{};
    String[] includedTestToRun = new String[]{};

    OFXTestSuit.runAsMain("org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", JSonDeserialization.class, allIncludedTest, includedTestToRun);
  }
}
