package org.modellwerkstatt.objectflow.tests.ConvSerdes;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import org.modellwerkstatt.objectflow.serdes.ConvFormatOptions;
import org.modellwerkstatt.objectflow.serdes.IConvFormatOptions;
import org.modellwerkstatt.objectflow.serdes.IConvSerdes;
import org.modellwerkstatt.objectflow.serdes.CONV;
import org.modellwerkstatt.objectflow.serdes.ConvStdFormatters;
import jetbrains.mps.references.BLOperations;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;
import java.math.BigDecimal;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.joda.time.LocalDate;
import org.joda.time.DateTime;

public class XmlSerDeserialization extends OFXTestSuit {

  @Autowired
  private JsonRootFactory __ConvSerdesJsonRootFactory;
  @Autowired
  private IOFXPlatform __runtimeIOFXPlatform;
  @Autowired
  private IOFXTranslationProvider __runtimeIOFXTranslationProvider;




  public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  @OFXTestMethod(id = 0, name = "Serialize and check various types here..", debug = false, enabled = true, runAt = "")
  public void __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY);
    IConvSerdes<Text> myDeser = CONV.<Text>xmlSerDes(Text.class, new ConvStdFormatters(opts));

    Text origObj = __ConvSerdesJsonRootFactory.create(__manMapSession);
    BLOperations.plusAssign(origObj.refToStringValue(), " & <Dan>");

    String st = myDeser.ser(origObj);

    Text reconstructed = myDeser.deser(st);
    {
      int leftSide = reconstructed.getIntValue();
      int rightSide = origObj.getIntValue();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize and check various types here..':  reconstructed .intValue ==  origObj .intValue          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      BigDecimal leftSide = reconstructed.getBdValue();
      BigDecimal rightSide = origObj.getBdValue();
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize and check various types here..':  reconstructed .bdValue ==  origObj .bdValue          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String leftSide = reconstructed.getStringValue();
      String rightSide = origObj.getStringValue();
      if (!(SaveObjectComperator.equals(leftSide, rightSide))) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize and check various types here..':  reconstructed .stringValue ==  origObj .stringValue          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = reconstructed.getLocalDateValue().compareTo(origObj.getLocalDateValue());
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize and check various types here..':  reconstructed .localDateValue.compareTo( origObj .localDateValue) == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = reconstructed.getDateTimeValue().compareTo(origObj.getDateTimeValue());
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize and check various types here..':  reconstructed .dateTimeValue.compareTo( origObj .dateTimeValue) == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      Text_MySatus leftSide = reconstructed.getStatusValue();
      Text_MySatus rightSide = origObj.getStatusValue();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize and check various types here..':  reconstructed .statusValue ==  origObj .statusValue          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      int leftSide = reconstructed.getTextChild().getIntValue();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize and check various types here..':  reconstructed .textChild.intValue == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      BigDecimal leftSide = reconstructed.getTextChild().getBdValue();
      BigDecimal rightSide = new BigDecimal("47.11");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize and check various types here..':  reconstructed .textChild.bdValue == 47.11bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      IOFXMetaStatus.IOFXStatusElement operand = reconstructed.getTextChild().getStatusValue();
      if (!(SaveObjectComperator.equalsStatus(operand, Text_MySatus.S1))) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize and check various types here..':  reconstructed .textChild.statusValue of S1           ==>>" + operand + "\n");
      }
    }

    {
      int leftSide = ListSequence.fromList(reconstructed.getMultipleChilds()).count();
      int rightSide = ListSequence.fromList(reconstructed.getMultipleChilds()).count();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize and check various types here..':  reconstructed .multipleChilds.size ==  reconstructed .multipleChilds.size          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }



  }
  @OFXTestMethod(id = 1, name = "Serialize null fields to xml correctly ......", debug = false, enabled = true, runAt = "")
  public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY);
    IConvSerdes<Text> myDeser = CONV.<Text>xmlSerDes(Text.class, new ConvStdFormatters(opts));
    Text obj = new Text();
    obj.setIntValue(0);
    obj.setStringValue(null);
    obj.setBdValue(null);
    obj.setLocalDateValue(null);
    obj.setDateTimeValue(null);
    obj.setStatusValue(null);

    obj.setTextChild(null);
    obj.setMultipleChilds(null);

    String xml = myDeser.ser(obj);

    String st = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><Text><intValue>0</intValue><stringValue/><bdValue/><localDateValue/><dateTimeValue/><statusValue/><textChild/><multipleChilds/></Text>";

    {
      String operand = xml.replace("\n", "");
      String param0 = st.replace("\n", "");
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize null fields to xml correctly ......':  xml .replace(\"\n\", \"\").equals( st .replace(\"\n\", \"\"))          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    Text reconstructed = myDeser.deser(st);
    {
      int leftSide = reconstructed.getIntValue();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize null fields to xml correctly ......':  reconstructed .intValue == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String operand = reconstructed.getStringValue();
      String param0 = "";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize null fields to xml correctly ......':  reconstructed .stringValue.equals(\"\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      BigDecimal leftSide = reconstructed.getBdValue();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize null fields to xml correctly ......':  reconstructed .bdValue ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      LocalDate leftSide = reconstructed.getLocalDateValue();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize null fields to xml correctly ......':  reconstructed .localDateValue ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      DateTime leftSide = reconstructed.getDateTimeValue();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize null fields to xml correctly ......':  reconstructed .dateTimeValue ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      IOFXMetaStatus.IOFXStatusElement operand = reconstructed.getStatusValue();
      if (!(SaveObjectComperator.equalsStatus(operand, Text_MySatus.S3))) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize null fields to xml correctly ......':  reconstructed .statusValue of S3           ==>>" + operand + "\n");
      }
    }
    {
      TextChild leftSide = reconstructed.getTextChild();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize null fields to xml correctly ......':  reconstructed .textChild ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(reconstructed.getMultipleChilds()).count();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize null fields to xml correctly ......':  reconstructed .multipleChilds.size == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 2, name = "Just trying to serialize an entity with valueObject", debug = false, enabled = true, runAt = "")
  public void __testmethod_2(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY);
    IConvSerdes<MyE> myDeser = CONV.<MyE>xmlSerDes(MyE.class, new ConvStdFormatters(opts));
    MyE origObj = __ConvSerdesJsonRootFactory.createEntity(__manMapSession);

    String st = myDeser.ser(origObj);

    String result = "<vo2><MyVO><myIntVal>4713</myIntVal><myStringVal>4713</myStringVal></MyVO></vo2><childs><MyEChild><id>7</id><name>Entity Child</name><parentKEY>4711</parentKEY></MyEChild></childs>";

    {
      String operand = st.replace("\n", "");
      String param0 = result;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Just trying to serialize an entity with valueObject':  st .replace(\"\n\", \"\").contains( result )          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    MyE reconstructed = myDeser.deser(st);

    {
      int leftSide = reconstructed.getVo1().getMyIntVal();
      int rightSide = 4712;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Just trying to serialize an entity with valueObject':  reconstructed .vo1.myIntVal == 4712          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = reconstructed.getVo2().getMyIntVal();
      int rightSide = 4713;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Just trying to serialize an entity with valueObject':  reconstructed .vo2.myIntVal == 4713          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      String operand = reconstructed.getVo1().getMyStringVal();
      String param0 = "4712";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Just trying to serialize an entity with valueObject':  reconstructed .vo1.myStringVal.equals(\"4712\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = reconstructed.getVo2().getMyStringVal();
      String param0 = "4713";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Just trying to serialize an entity with valueObject':  reconstructed .vo2.myStringVal.equals(\"4713\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    {
      int leftSide = ListSequence.fromList(reconstructed.getChilds()).count();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Just trying to serialize an entity with valueObject':  reconstructed .childs.size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String operand = ListSequence.fromList(reconstructed.getChilds()).getElement(0).getName();
      String param0 = "Entity Child";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Just trying to serialize an entity with valueObject':  reconstructed .childs.get.name.equals(\"Entity Child\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }



  }
  @OFXTestMethod(id = 3, name = "Serialize a list of DTOs into a string.", debug = false, enabled = true, runAt = "")
  public void __testmethod_3(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY);

    IConvSerdes<Text[]> myDeser = CONV.<Text[]>xmlSerDes(Text[].class, new ConvStdFormatters(opts));

    Text textObj = __ConvSerdesJsonRootFactory.create(__manMapSession);
    Text textObj2 = __ConvSerdesJsonRootFactory.create(__manMapSession);
    Text[] textArray = new Text[]{textObj, textObj2};

    String st = myDeser.ser(textArray);
    {
      String operand = st.replace("\n", "");
      String param0 = "</Text></TextList>";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.endsWith(param0))) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize a list of DTOs into a string.':  st .replace(\"\n\", \"null\").endsWith(\"</Text></TextList>\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") " + "\n");
      }
    }

    Text[] reconstructed = myDeser.deser(st);
    {
      int leftSide = reconstructed.length;
      int rightSide = 2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize a list of DTOs into a string.':  reconstructed .length == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      String operand = reconstructed[0].getStringValue();
      String param0 = "Test String";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize a list of DTOs into a string.':  [ .stringValue.equals(\"Test String\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = reconstructed[1].getStringValue();
      String param0 = "Test String";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize a list of DTOs into a string.':  [ .stringValue.equals(\"Test String\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    {
      String operand = reconstructed[0].getTextChild().getStringValue();
      String param0 = "Test String in Text Child";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize a list of DTOs into a string.':  [ .textChild.stringValue.equals(\"Test String in Text Child\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = reconstructed[1].getTextChild().getStringValue();
      String param0 = "Test String in Text Child";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize a list of DTOs into a string.':  [ .textChild.stringValue.equals(\"Test String in Text Child\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    {
      int leftSide = ListSequence.fromList(reconstructed[0].getMultipleChilds()).count();
      int rightSide = 2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize a list of DTOs into a string.':  [ .multipleChilds.size == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(reconstructed[1].getMultipleChilds()).count();
      int rightSide = 2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize a list of DTOs into a string.':  [ .multipleChilds.size == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 4, name = "Deserialize some oracle xml export ... ", debug = false, enabled = true, runAt = "")
  public void __testmethod_4(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    String st = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><artikel NUM_ARTIKEL=\"\">   <num_artikel>109076</num_artikel>   <bezeichnung>Red Bull Silver Edition 250 ml</bezeichnung>   <inhalt>1</inhalt>   <preise>      <preis>         <prz_steuer>20</prz_steuer>         <cod_whrg>EUR</cod_whrg>         <vk>            <brutto>1,59</brutto>            <netto>1,325</netto>            <typ>V1NO</typ>            <referenz>3361762</referenz>         </vk>         <ek>            <netto>,9554</netto>            <typ>E1NO</typ>            <referenz>4616371</referenz>         </ek>      </preis>   </preise>   <gebinde_liste>      <gebinde NUM_GEBINDE=\"0\">         <num_geb_inh>0</num_geb_inh>         <typ_einheit>9</typ_einheit>         <mge_inh>0</mge_inh>         <num_art_lg>0</num_art_lg>         <ean_bestellung>9002490218225</ean_bestellung>      </gebinde>      <gebinde NUM_GEBINDE=\"1\">         <num_geb_inh>0</num_geb_inh>         <typ_einheit>5</typ_einheit>         <mge_inh>24</mge_inh>         <num_art_lg>0</num_art_lg>         <ean_bestellung>9002490218379</ean_bestellung>      </gebinde>   </gebinde_liste></artikel>";

    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "de", IConvFormatOptions.Mode.SET_MISSING_PROPERTIES_NULL);

    IConvSerdes<Artikel> myDeser = CONV.<Artikel>xmlSerDes(Artikel.class, new ConvStdFormatters(opts));

    Artikel wolfiXmlExp = myDeser.deser(st);

    {
      BigDecimal leftSide = ListSequence.fromList(wolfiXmlExp.getPreise()).getElement(0).getVk().getBrutto();
      BigDecimal rightSide = new BigDecimal("1.59");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Deserialize some oracle xml export ... ':  wolfiXmlExp .preise.get.vk.brutto == 1.59bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      BigDecimal leftSide = ListSequence.fromList(wolfiXmlExp.getPreise()).getElement(0).getEk().getBrutto();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Deserialize some oracle xml export ... ':  wolfiXmlExp .preise.get.ek.brutto ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(wolfiXmlExp.getGebinde_liste()).count();
      int rightSide = 2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Deserialize some oracle xml export ... ':  wolfiXmlExp .gebinde_liste.size == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String operand = ListSequence.fromList(wolfiXmlExp.getGebinde_liste()).getElement(1).getEan_bestellung();
      String param0 = "9002490218379";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Deserialize some oracle xml export ... ':  wolfiXmlExp .gebinde_liste.get.ean_bestellung.equals(\"9002490218379\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 5, name = "Custom serialization, using an attribute for ids", debug = false, enabled = true, runAt = "")
  public void __testmethod_5(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    String st = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><artikel NUM_ARTIKEL=\"109076\">   <bezeichnung>Red Bull Silver Edition 250 ml</bezeichnung>   <inhalt>1</inhalt>   <preise>      <preis>         <prz_steuer>20</prz_steuer>         <cod_whrg>EUR</cod_whrg>         <vk>            <brutto>1,59</brutto>            <netto>1,325</netto>            <typ>V1NO</typ>            <referenz>3361762</referenz>         </vk>         <ek>            <netto>,9554</netto>            <typ>E1NO</typ>            <referenz>4616371</referenz>         </ek>      </preis>   </preise>   <gebinde_liste>      <gebinde NUM_GEBINDE=\"0\">         <num_geb_inh>0</num_geb_inh>         <typ_einheit>9</typ_einheit>         <mge_inh>0</mge_inh>         <num_art_lg>0</num_art_lg>         <ean_bestellung>9002490218225</ean_bestellung>      </gebinde>      <gebinde NUM_GEBINDE=\"1\">         <num_geb_inh>0</num_geb_inh>         <typ_einheit>5</typ_einheit>         <mge_inh>24</mge_inh>         <num_art_lg>0</num_art_lg>         <ean_bestellung>9002490218379</ean_bestellung>      </gebinde>   </gebinde_liste></artikel>";

    ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "de", IConvFormatOptions.Mode.SET_MISSING_PROPERTIES_NULL);

    IConvSerdes<Artikel> myDeser = new MyArtikelSerdes(new ConvStdFormatters(opts));

    Artikel wolfiXmlExp = myDeser.deser(st);

    {
      int leftSide = wolfiXmlExp.getNum_artikel();
      int rightSide = 109076;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Custom serialization, using an attribute for ids':  wolfiXmlExp .num_artikel == 109076          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      BigDecimal leftSide = ListSequence.fromList(wolfiXmlExp.getPreise()).getElement(0).getVk().getBrutto();
      BigDecimal rightSide = new BigDecimal("1.59");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Custom serialization, using an attribute for ids':  wolfiXmlExp .preise.get.vk.brutto == 1.59bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      BigDecimal leftSide = ListSequence.fromList(wolfiXmlExp.getPreise()).getElement(0).getEk().getBrutto();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Custom serialization, using an attribute for ids':  wolfiXmlExp .preise.get.ek.brutto ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(wolfiXmlExp.getGebinde_liste()).count();
      int rightSide = 2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Custom serialization, using an attribute for ids':  wolfiXmlExp .gebinde_liste.size == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String operand = ListSequence.fromList(wolfiXmlExp.getGebinde_liste()).getElement(1).getEan_bestellung();
      String param0 = "9002490218379";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Custom serialization, using an attribute for ids':  wolfiXmlExp .gebinde_liste.get.ean_bestellung.equals(\"9002490218379\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 6, name = "Serialize / Deserialive single field value object", debug = false, enabled = true, runAt = "")
  public void __testmethod_6(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    SingleMyE entity = new SingleMyE();
    entity.setText("textcontent");
    entity.setVo1(new SingleMyVO().withMyVal("4711"));
    entity.setVo2(null);

    IConvSerdes<SingleMyE> serdes = CONV.xmlSerDes(SingleMyE.class, CONV.CONV_DEFAULT_EN);

    String st = serdes.ser(entity);
    SingleMyE reloaded = serdes.deser(st);
    {
      String operand = reloaded.getVo1().getMyVal();
      String param0 = "4711";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'XmlSerDeserialization.Serialize / Deserialive single field value object':  reloaded .vo1.myVal.equals(\"4711\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }


  public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  public static void main(String[] args) {
    String[] allIncludedTest = new String[]{};
    String[] includedTestToRun = new String[]{};

    OFXTestSuit.runAsMain("org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", XmlSerDeserialization.class, allIncludedTest, includedTestToRun);
  }
}
