package org.modellwerkstatt.objectflow.tests.ObjectFlowInfra;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.CreatorsFactory;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoInvoice;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Invoice;
import org.modellwerkstatt.objectflow.runtime.IOFXEntity;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.NewInvoice;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.MoRevertibleMerger;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import java.util.ArrayList;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.InvoicePosition;
import org.modellwerkstatt.objectflow.runtime.OFXIllegalAccessException;
import jetbrains.mps.references.BLOperations;

public class SessionAndMerge extends OFXTestSuit {

  @Autowired
  private CreatorsFactory __DomainCreatorsFactory;
  @Autowired
  private RepoInvoice __DomainRepoInvoice;
  @Autowired
  private IOFXPlatform __runtimeIOFXPlatform;
  @Autowired
  private IOFXTranslationProvider __runtimeIOFXTranslationProvider;




  public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  @OFXTestMethod(id = 0, name = "SessionEntities Test Checkout / RO marked", debug = false, enabled = true, runAt = "")
  public void __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    for (int i = 1; i < 100000; i++) {
      Invoice inv = new Invoice();
      inv.setId(i);
      inv.setText("Invoice " + i);
      ((IOFXEntity) inv).setReadOnly(true);
      __manMapSession.ensureInSession(inv);
    }

    for (int i = 1; i < 100000; i++) {
      NewInvoice ni = new NewInvoice();
      ni.setId(i);
      ni.setText("NewInvoice " + i);
      __manMapSession.ensureInSession(ni);
    }

    {
      int leftSide = ListSequence.fromList(__manMapSession.<Invoice>getEntitiesCheckedOut(Invoice.entitySessionUID)).count();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.SessionEntities Test Checkout / RO marked':  session entities .size == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(__manMapSession.<Integer>getEntitiesCheckedOutKey(Invoice.entitySessionUID)).count();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.SessionEntities Test Checkout / RO marked':  session entities .size == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      int leftSide = ListSequence.fromList(__manMapSession.<Invoice>getEntitiesAll(Invoice.entitySessionUID)).count();
      int rightSide = 99999;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.SessionEntities Test Checkout / RO marked':  session entities .size == 99999          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(__manMapSession.<Integer>getEntitiesAllKey(Invoice.entitySessionUID)).count();
      int rightSide = 99999;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.SessionEntities Test Checkout / RO marked':  session entities .size == 99999          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      int leftSide = ListSequence.fromList(__manMapSession.<NewInvoice>getEntitiesCheckedOut(NewInvoice.entitySessionUID)).count();
      int rightSide = 99999;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.SessionEntities Test Checkout / RO marked':  session entities .size == 99999          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(__manMapSession.<Integer>getEntitiesCheckedOutKey(NewInvoice.entitySessionUID)).count();
      int rightSide = 99999;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.SessionEntities Test Checkout / RO marked':  session entities .size == 99999          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }


    long t = System.currentTimeMillis();
    Invoice lookingFor = ListSequence.fromList(__manMapSession.<Invoice>getEntitiesAll(Invoice.entitySessionUID)).findFirst((it) -> it.getId() == 99997);
    {
      Invoice leftSide = lookingFor;
      Object rightSide = null;
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.SessionEntities Test Checkout / RO marked':  lookingFor  !=  null           ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }


  }
  @OFXTestMethod(id = 1, name = "Use of concept sessionEntities", debug = false, enabled = true, runAt = "")
  public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXSession sess = __DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
    Invoice invoice1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("sesEnt-1", sess);
    Invoice invoice2 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("sesEnt-2", sess);

    final Invoice reloaded_inv1 = __DomainRepoInvoice.checkoutInvoiceByIdWithRefs(invoice1.getId(), __manMapSession);
    final Invoice reloaded_inv2 = __DomainRepoInvoice.checkoutInvoiceByIdWithRefs(invoice2.getId(), __manMapSession);


    List<Invoice> invoicesCheckedOut = __manMapSession.<Invoice>getEntitiesCheckedOut(Invoice.entitySessionUID);
    {
      int leftSide = ListSequence.fromList(invoicesCheckedOut).count();
      int rightSide = 2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.Use of concept sessionEntities':  invoicesCheckedOut .size == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(ListSequence.fromList(invoicesCheckedOut).any((it) -> it.getId() == reloaded_inv1.getId()))) {
      throw new OFXTestSuitException("'SessionAndMerge.Use of concept sessionEntities':  invoicesCheckedOut .any          ==>> FALSE !" + "\n");
    }
    if (!(ListSequence.fromList(invoicesCheckedOut).any((it) -> it.getId() == reloaded_inv2.getId()))) {
      throw new OFXTestSuitException("'SessionAndMerge.Use of concept sessionEntities':  invoicesCheckedOut .any          ==>> FALSE !" + "\n");
    }

    List<Integer> keysOfInv = __manMapSession.<Integer>getEntitiesCheckedOutKey(Invoice.entitySessionUID);
    {
      int leftSide = ListSequence.fromList(keysOfInv).count();
      int rightSide = 2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.Use of concept sessionEntities':  keysOfInv .size == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(ListSequence.fromList(keysOfInv).any((it) -> it == reloaded_inv1.getId()))) {
      throw new OFXTestSuitException("'SessionAndMerge.Use of concept sessionEntities':  keysOfInv .any          ==>> FALSE !" + "\n");
    }
    if (!(ListSequence.fromList(keysOfInv).any((it) -> it == reloaded_inv2.getId()))) {
      throw new OFXTestSuitException("'SessionAndMerge.Use of concept sessionEntities':  keysOfInv .any          ==>> FALSE !" + "\n");
    }

  }
  @OFXTestMethod(id = 2, name = "Using Merge - entity into entity merged into session", debug = false, enabled = true, runAt = "")
  public void __testmethod_2(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXSession sess = __DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
    Invoice orig = __DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("ee-merge-1", sess);



    Invoice mergedInvoice = MoRevertibleMerger.<Integer,Invoice>mergeEntityIntoEntity(Invoice.class, orig, new Invoice(), __manMapSession, false);

    {
      boolean leftSide = mergedInvoice.getName().equals("ee-merge-1");
      boolean rightSide = mergedInvoice != orig;
    }
    {
      boolean leftSide = ListSequence.fromList(__manMapSession.<Invoice>getEntitiesAll(Invoice.entitySessionUID)).count() == 1;
      boolean rightSide = ListSequence.fromList(__manMapSession.<Invoice>getEntitiesAll(Invoice.entitySessionUID)).first() == mergedInvoice;
    }

  }
  @OFXTestMethod(id = 3, name = "Using Merge - entity into entity merged into session - [Read Only Error]", debug = false, enabled = true, runAt = "")
  public void __testmethod_3(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXSession sess = __DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
    Invoice orig = __DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("ee-merge-1", sess);



    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        Invoice mergedInvoice = MoRevertibleMerger.<Integer,Invoice>mergeEntityIntoEntity(Invoice.class, orig, new Invoice(), __manMapSession, true);

      } catch (IllegalStateException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("checkedout")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("checkedout")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'SessionAndMerge.Using Merge - entity into entity merged into session - [Read Only Error]': Fail In Exception IllegalStateException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'SessionAndMerge.Using Merge - entity into entity merged into session - [Read Only Error]': Fail In Exception IllegalStateException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'SessionAndMerge.Using Merge - entity into entity merged into session - [Read Only Error]': Fail In Exception 'IllegalStateException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

  }
  @OFXTestMethod(id = 4, name = "Using Merge - situation in a search command.. ", debug = false, enabled = true, runAt = "")
  public void __testmethod_4(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXSession sess = __DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
    Invoice invoice1 = __DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("srchmerge-1", sess);
    Invoice invoice2 = __DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("srchmerge-2", sess);

    Invoice reloaded_inv1 = __DomainRepoInvoice.getInvoiceByIdWithRefs(invoice1.getId(), __manMapSession);
    Invoice reloaded_inv2 = __DomainRepoInvoice.getInvoiceByIdWithRefs(invoice2.getId(), __manMapSession);

    List<Invoice> resultList = ListSequence.fromListAndArray(new ArrayList<Invoice>(), reloaded_inv1, reloaded_inv2);
    {
      boolean leftSide = reloaded_inv1.getMainPosRef() != null;
      boolean rightSide = reloaded_inv1.getMainPosRef().getId() == invoice1.getMainPosRef().getId();
    }



    // invoice1 and ref is from another session
    invoice1.setText("head_changed");
    invoice1.getMainPosRef().setPosText("pos_changed");

    Invoice mergedInvoice = MoRevertibleMerger.<Integer,Invoice>mergeEntityIntoList(Invoice.class, invoice1, resultList, __manMapSession, true);

    MoRevertibleMerger.<Integer,InvoicePosition>mergeRefOnRef(InvoicePosition.class, invoice1.getMainPosRef(), __manMapSession, true, new MoRevertibleMerger.RefChange<Invoice, InvoicePosition>() {
      public void doChange(Invoice destEntity, InvoicePosition destRef) {
        boolean isDestReadOnly = destEntity.getReadOnly();
        destEntity.setReadOnly(false);
        destEntity.setMainPosRef(destRef);
        destEntity.setReadOnly(isDestReadOnly);
      }
    }, mergedInvoice);

    {
      InvoicePosition leftSide = mergedInvoice.getMainPosRef();
      Object rightSide = null;
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command.. ':  mergedInvoice .mainPosRef !=  null           ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }

    // manually set backref, does not work on read only entities
    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        mergedInvoice.getMainPosRef().setInvoice(mergedInvoice);

      } catch (OFXIllegalAccessException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();


      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command.. ': Fail In Exception OFXIllegalAccessException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command.. ': Fail In Exception OFXIllegalAccessException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command.. ': Fail In Exception 'OFXIllegalAccessException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }


    {
      IOFXEntity operand = ((IOFXEntity) mergedInvoice);
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.getReadOnly())) {
        throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command.. ': ((IOFXEntity) mergedInvoice ).getReadOnly()          ==>> '" + operand + "'.getReadOnly(" + textRepresentation + ") " + "\n");
      }
    }
    {
      IOFXEntity operand = ((IOFXEntity) mergedInvoice.getMainPosRef());
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.getReadOnly())) {
        throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command.. ': ((IOFXEntity) mergedInvoice .mainPosRef).getReadOnly()          ==>> '" + operand + "'.getReadOnly(" + textRepresentation + ") " + "\n");
      }
    }
    {
      boolean leftSide = mergedInvoice.getText().equals("head_changed");
      boolean rightSide = mergedInvoice != invoice1;
    }
    {
      boolean leftSide = mergedInvoice.getMainPosRef().getPosText().equals("pos_changed");
      boolean rightSide = mergedInvoice.getMainPosRef() != invoice1.getMainPosRef();
    }

    {
      Invoice leftSide = mergedInvoice;
      Invoice rightSide = ListSequence.fromList(resultList).getElement(0);
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command.. ':  mergedInvoice  ==  resultList .get          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      InvoicePosition leftSide = mergedInvoice.getMainPosRef();
      InvoicePosition rightSide = ListSequence.fromList(resultList).getElement(0).getMainPosRef();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command.. ':  mergedInvoice .mainPosRef ==  resultList .get.mainPosRef          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 5, name = "Using Merge - integrate ref into session", debug = false, enabled = true, runAt = "")
  public void __testmethod_5(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXSession sess = __DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
    Invoice invoice1 = __DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("refferr-1", sess);

    Invoice mergedInvoice = MoRevertibleMerger.<Integer,Invoice>mergeEntityIntoEntity(Invoice.class, invoice1, new Invoice(), __manMapSession, false);

    // ref in session is NULL
    MoRevertibleMerger.<Integer,InvoicePosition>mergeRefOnRef(InvoicePosition.class, invoice1.getMainPosRef(), __manMapSession, false, new MoRevertibleMerger.RefChange<Invoice, InvoicePosition>() {
      public void doChange(Invoice destEntity, InvoicePosition destRef) {
        boolean isDestReadOnly = destEntity.getReadOnly();
        destEntity.setReadOnly(false);
        destEntity.setMainPosRef(destRef);
        destEntity.setReadOnly(isDestReadOnly);
      }
    }, mergedInvoice);

    {
      Invoice leftSide = mergedInvoice.getMainPosRef().getInvoice();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.Using Merge - integrate ref into session':  mergedInvoice .mainPosRef.invoice ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    if (!(!(((IOFXEntity) mergedInvoice.getMainPosRef()).getReadOnly()))) {
      throw new OFXTestSuitException("'SessionAndMerge.Using Merge - integrate ref into session': !(((IOFXEntity) mergedInvoice .mainPosRef).getReadOnly())          ==>> FALSE !" + "\n");
    }
    {
      int leftSide = ListSequence.fromList(__manMapSession.<InvoicePosition>getEntitiesCheckedOut(InvoicePosition.entitySessionUID)).count();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.Using Merge - integrate ref into session':  session entities .size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      InvoicePosition leftSide = ListSequence.fromList(__manMapSession.<InvoicePosition>getEntitiesCheckedOut(InvoicePosition.entitySessionUID)).first();
      InvoicePosition rightSide = mergedInvoice.getMainPosRef();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.Using Merge - integrate ref into session':  session entities .first ==  mergedInvoice .mainPosRef          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      InvoicePosition leftSide = mergedInvoice.getMainPosRef();
      InvoicePosition rightSide = invoice1.getMainPosRef();
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.Using Merge - integrate ref into session':  mergedInvoice .mainPosRef !=  invoice1 .mainPosRef          ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 6, name = "Using Merge - integrate ref into session [Read Only Error]", debug = false, enabled = true, runAt = "")
  public void __testmethod_6(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXSession sess = __DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
    Invoice invoice1 = __DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("refferr-1", sess);

    Invoice mergedInvoice = MoRevertibleMerger.<Integer,Invoice>mergeEntityIntoEntity(Invoice.class, invoice1, new Invoice(), __manMapSession, false);

    InvoicePosition pos = MoRevertibleMerger.<Integer,InvoicePosition>mergeEntityIntoEntity(InvoicePosition.class, invoice1.getMainPosRef(), new InvoicePosition(), __manMapSession, false);

    MoRevertibleMerger.<Integer,InvoicePosition>mergeRefOnRef(InvoicePosition.class, invoice1.getMainPosRef(), __manMapSession, false, new MoRevertibleMerger.RefChange<Invoice, InvoicePosition>() {
      public void doChange(Invoice destEntity, InvoicePosition destRef) {
        boolean isDestReadOnly = destEntity.getReadOnly();
        destEntity.setReadOnly(false);
        destEntity.setMainPosRef(destRef);
        destEntity.setReadOnly(isDestReadOnly);
      }
    }, mergedInvoice);

    {
      InvoicePosition leftSide = mergedInvoice.getMainPosRef();
      InvoicePosition rightSide = pos;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.Using Merge - integrate ref into session [Read Only Error]':  mergedInvoice .mainPosRef ==  pos           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }


    // ref in session is NULL
    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        MoRevertibleMerger.<Integer,InvoicePosition>mergeRefOnRef(InvoicePosition.class, invoice1.getMainPosRef(), __manMapSession, true, new MoRevertibleMerger.RefChange<Invoice, InvoicePosition>() {
          public void doChange(Invoice destEntity, InvoicePosition destRef) {
            boolean isDestReadOnly = destEntity.getReadOnly();
            destEntity.setReadOnly(false);
            destEntity.setMainPosRef(destRef);
            destEntity.setReadOnly(isDestReadOnly);
          }
        }, mergedInvoice);

      } catch (IllegalStateException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("checkedout")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("checkedout")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'SessionAndMerge.Using Merge - integrate ref into session [Read Only Error]': Fail In Exception IllegalStateException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'SessionAndMerge.Using Merge - integrate ref into session [Read Only Error]': Fail In Exception IllegalStateException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'SessionAndMerge.Using Merge - integrate ref into session [Read Only Error]': Fail In Exception 'IllegalStateException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }
  }
  @OFXTestMethod(id = 7, name = "Using Merge - situation in a search command (article ref changes)", debug = false, enabled = true, runAt = "")
  public void __testmethod_7(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXSession sess = __DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
    Invoice invoice1 = __DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("srchmerge-1", sess);
    Invoice invoice2 = __DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("srchmerge-2", sess);

    Invoice reloaded_inv1 = __DomainRepoInvoice.getInvoiceByIdWithRefs(invoice1.getId(), __manMapSession);
    Invoice reloaded_inv2 = __DomainRepoInvoice.getInvoiceByIdWithRefs(invoice2.getId(), __manMapSession);

    List<Invoice> resultList = ListSequence.fromListAndArray(new ArrayList<Invoice>(), reloaded_inv1, reloaded_inv2);
    {
      boolean leftSide = reloaded_inv1.getMainPosRef() != null;
      boolean rightSide = reloaded_inv1.getMainPosRef().getId() == invoice1.getMainPosRef().getId();
    }

    // invoice1 and ref is from another session
    invoice1.setText("head_changed");
    invoice1.setMainPosRef(ListSequence.fromList(invoice1.getPositions()).last());
    {
      int leftSide = invoice1.getMainPosRef().getId();
      int rightSide = reloaded_inv1.getMainPosRef().getId();
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command (article ref changes)':  invoice1 .mainPosRef.id !=  reloaded_inv1 .mainPosRef.id          ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }

    Invoice mergedInvoice = MoRevertibleMerger.<Integer,Invoice>mergeEntityIntoList(Invoice.class, invoice1, resultList, __manMapSession, true);


    // TODO: unrealistisch - muss mainPosRef haben! Aber was, wenn neues Objekt in List gemerged?

    // invoice1.setReadOnly(false)
    // newRef sessionEntities getOrCreate(invoice1.mainPosRef)
    // merge invoice1.mainPosRef into newRef
    // invoice1.mainPosRef = newRef
    // invoice1.setReadOnly(true)



    MoRevertibleMerger.<Integer,InvoicePosition>mergeRefOnRef(InvoicePosition.class, invoice1.getMainPosRef(), __manMapSession, true, new MoRevertibleMerger.RefChange<Invoice, InvoicePosition>() {
      public void doChange(Invoice destEntity, InvoicePosition destRef) {
        boolean isDestReadOnly = destEntity.getReadOnly();
        destEntity.setReadOnly(false);
        destEntity.setMainPosRef(destRef);
        destEntity.setReadOnly(isDestReadOnly);
      }
    }, mergedInvoice);


    {
      IOFXEntity operand = ((IOFXEntity) mergedInvoice);
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.getReadOnly())) {
        throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command (article ref changes)': ((IOFXEntity) mergedInvoice ).getReadOnly()          ==>> '" + operand + "'.getReadOnly(" + textRepresentation + ") " + "\n");
      }
    }
    {
      IOFXEntity operand = ((IOFXEntity) mergedInvoice.getMainPosRef());
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.getReadOnly())) {
        throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command (article ref changes)': ((IOFXEntity) mergedInvoice .mainPosRef).getReadOnly()          ==>> '" + operand + "'.getReadOnly(" + textRepresentation + ") " + "\n");
      }
    }
    {
      boolean leftSide = mergedInvoice.getText().equals("head_changed");
      boolean rightSide = mergedInvoice != invoice1;
    }
    {
      boolean leftSide = mergedInvoice.getMainPosRef().getPosText().equals("pos_changed");
      boolean rightSide = mergedInvoice.getMainPosRef() != invoice1.getMainPosRef();
    }

    {
      InvoicePosition leftSide = mergedInvoice.getMainPosRef();
      InvoicePosition rightSide = ListSequence.fromList(resultList).getElement(0).getMainPosRef();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command (article ref changes)':  mergedInvoice .mainPosRef ==  resultList .get.mainPosRef          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 8, name = "Using Merge - situation in a search command (merge positions also)", debug = false, enabled = true, runAt = "")
  public void __testmethod_8(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXSession sess = __DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
    Invoice invoice1 = __DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("srchmerge-1", sess);
    Invoice invoice2 = __DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("srchmerge-2", sess);

    Invoice reloaded_inv1 = __DomainRepoInvoice.getInvoiceByIdWithRefs(invoice1.getId(), __manMapSession);
    Invoice reloaded_inv2 = __DomainRepoInvoice.getInvoiceByIdWithRefs(invoice2.getId(), __manMapSession);

    List<Invoice> resultList = ListSequence.fromListAndArray(new ArrayList<Invoice>(), reloaded_inv1, reloaded_inv2);
    {
      boolean leftSide = reloaded_inv1.getMainPosRef() != null;
      boolean rightSide = reloaded_inv1.getMainPosRef().getId() == invoice1.getMainPosRef().getId();
    }

    // invoice1 and ref is from another session
    invoice1.setText("head_changed");
    ListSequence.fromList(invoice1.getPositions()).getElement(0).setPosText("poschange0");
    ListSequence.fromList(invoice1.getPositions()).getElement(1).setPosText("poschange1");
    ListSequence.fromList(invoice1.getPositions()).getElement(2).setPosText("poschange2");
    ListSequence.fromList(invoice1.getPositions()).getElement(3).setPosText("poschange3");

    Invoice mergedInvoice = MoRevertibleMerger.<Integer,Invoice>mergeEntityIntoList(Invoice.class, invoice1, resultList, __manMapSession, true);

    MoRevertibleMerger.<Integer,InvoicePosition>mergeListIntoList(InvoicePosition.class, invoice1.getPositions(), mergedInvoice.getPositions(), __manMapSession, true);


    {
      IOFXEntity operand = ((IOFXEntity) mergedInvoice);
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.getReadOnly())) {
        throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command (merge positions also)': ((IOFXEntity) mergedInvoice ).getReadOnly()          ==>> '" + operand + "'.getReadOnly(" + textRepresentation + ") " + "\n");
      }
    }

    {
      boolean leftSide = ListSequence.fromList(mergedInvoice.getPositions()).getElement(1).equals("poschange1");
      boolean rightSide = ListSequence.fromList(mergedInvoice.getPositions()).getElement(1) != ListSequence.fromList(invoice1.getPositions()).getElement(1);
    }

    {
      InvoicePosition leftSide = mergedInvoice.getMainPosRef();
      InvoicePosition rightSide = ListSequence.fromList(resultList).getElement(0).getMainPosRef();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command (merge positions also)':  mergedInvoice .mainPosRef ==  resultList .get.mainPosRef          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 9, name = "Using Merge - situation in a search command (merge positions also - adding a new one!)", debug = false, enabled = true, runAt = "")
  public void __testmethod_9(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXSession sess = __DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
    Invoice invoice1 = __DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("srchmerge-1", sess);
    Invoice invoice2 = __DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("srchmerge-2", sess);

    Invoice reloaded_inv1 = __DomainRepoInvoice.getInvoiceByIdWithRefs(invoice1.getId(), __manMapSession);
    Invoice reloaded_inv2 = __DomainRepoInvoice.getInvoiceByIdWithRefs(invoice2.getId(), __manMapSession);

    List<Invoice> resultList = ListSequence.fromListAndArray(new ArrayList<Invoice>(), reloaded_inv1, reloaded_inv2);
    {
      boolean leftSide = reloaded_inv1.getMainPosRef() != null;
      boolean rightSide = reloaded_inv1.getMainPosRef().getId() == invoice1.getMainPosRef().getId();
    }

    ListSequence.fromList(reloaded_inv1.getPositions()).removeLastElement();

    // invoice1 and ref is from another session
    invoice1.setText("head_changed");
    ListSequence.fromList(invoice1.getPositions()).getElement(0).setPosText("poschange0");
    ListSequence.fromList(invoice1.getPositions()).getElement(1).setPosText("poschange1");
    ListSequence.fromList(invoice1.getPositions()).getElement(2).setPosText("poschange2");
    ListSequence.fromList(invoice1.getPositions()).getElement(3).setPosText("poschange3");



    Invoice mergedInvoice = MoRevertibleMerger.<Integer,Invoice>mergeEntityIntoList(Invoice.class, invoice1, resultList, __manMapSession, true);

    MoRevertibleMerger.<Integer,InvoicePosition>mergeListIntoList(InvoicePosition.class, invoice1.getPositions(), mergedInvoice.getPositions(), __manMapSession, true);


    {
      IOFXEntity operand = ((IOFXEntity) mergedInvoice);
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.getReadOnly())) {
        throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command (merge positions also - adding a new one!)': ((IOFXEntity) mergedInvoice ).getReadOnly()          ==>> '" + operand + "'.getReadOnly(" + textRepresentation + ") " + "\n");
      }
    }

    {
      int leftSide = ListSequence.fromList(mergedInvoice.getPositions()).count();
      int rightSide = 4;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command (merge positions also - adding a new one!)':  mergedInvoice .positions.size == 4          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      boolean leftSide = ListSequence.fromList(mergedInvoice.getPositions()).getElement(3).equals("poschange3");
      boolean rightSide = ListSequence.fromList(mergedInvoice.getPositions()).getElement(3) != ListSequence.fromList(invoice1.getPositions()).getElement(3);
    }

    {
      InvoicePosition leftSide = mergedInvoice.getMainPosRef();
      InvoicePosition rightSide = ListSequence.fromList(resultList).getElement(0).getMainPosRef();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command (merge positions also - adding a new one!)':  mergedInvoice .mainPosRef ==  resultList .get.mainPosRef          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 10, name = "Merging Invoices multiple times ... ", debug = false, enabled = true, runAt = "")
  public void __testmethod_10(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXSession sess = __DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
    Invoice invoice1 = __DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("dtomrg-1", sess);

    Invoice inv = MoRevertibleMerger.<Integer,Invoice>mergeEntityIntoEntity(Invoice.class, invoice1, null, __manMapSession, false);

    {
      Invoice leftSide = inv;
      Invoice rightSide = invoice1;
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.Merging Invoices multiple times ... ':  inv  !=  invoice1           ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }

    Invoice inv2 = MoRevertibleMerger.<Integer,Invoice>mergeEntityIntoEntity(Invoice.class, invoice1, null, __manMapSession, false);

    {
      Invoice leftSide = inv;
      Invoice rightSide = inv2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.Merging Invoices multiple times ... ':  inv  ==  inv2           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        Invoice inv3 = MoRevertibleMerger.<Integer,Invoice>mergeEntityIntoEntity(Invoice.class, invoice1, new Invoice(), __manMapSession, false);

      } catch (IllegalStateException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("not the one in the session")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("not the one in the session")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'SessionAndMerge.Merging Invoices multiple times ... ': Fail In Exception IllegalStateException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'SessionAndMerge.Merging Invoices multiple times ... ': Fail In Exception IllegalStateException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'SessionAndMerge.Merging Invoices multiple times ... ': Fail In Exception 'IllegalStateException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

    Invoice inv5 = MoRevertibleMerger.<Integer,Invoice>mergeEntityIntoEntity(Invoice.class, invoice1, new Invoice(), null, false);

    {
      Invoice leftSide = inv5;
      Invoice rightSide = inv;
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.Merging Invoices multiple times ... ':  inv5  !=  inv           ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 11, name = "DTO Style merging; not considerung current session.", debug = false, enabled = true, runAt = "")
  public void __testmethod_11(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXSession sess = __DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
    Invoice invoice1 = __DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("dtomrg-1", sess);

    Invoice inv = MoRevertibleMerger.<Integer,Invoice>mergeEntityIntoEntity(Invoice.class, invoice1, null, null, false);

    InvoicePosition mainPos = MoRevertibleMerger.<Integer,InvoicePosition>mergeRefOnRef(InvoicePosition.class, invoice1.getMainPosRef(), null, false, new MoRevertibleMerger.RefChange<Invoice, InvoicePosition>() {
      public void doChange(Invoice destEntity, InvoicePosition destRef) {
        boolean isDestReadOnly = destEntity.getReadOnly();
        destEntity.setReadOnly(false);
        destEntity.setMainPosRef(destRef);
        destEntity.setReadOnly(isDestReadOnly);
      }
    }, inv);

    {
      int leftSide = ListSequence.fromList(__manMapSession.<InvoicePosition>getEntitiesAll(InvoicePosition.entitySessionUID)).count();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.DTO Style merging; not considerung current session.':  session entities .size == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      InvoicePosition leftSide = mainPos;
      InvoicePosition rightSide = invoice1.getMainPosRef();
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.DTO Style merging; not considerung current session.':  mainPos  !=  invoice1 .mainPosRef          ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }
    {
      String operand = mainPos.getPosText();
      String param0 = invoice1.getMainPosRef().getPosText();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'SessionAndMerge.DTO Style merging; not considerung current session.':  mainPos .posText.equals( invoice1 .mainPosRef.posText)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 12, name = "Merging positions in existing aggregate", debug = false, enabled = true, runAt = "")
  public void __testmethod_12(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXSession sess = __DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
    Invoice invoice1 = __DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("postst-1", sess);

    Invoice reloaded = __DomainRepoInvoice.getInvoiceByIdWithRefs(invoice1.getId(), __manMapSession);

    InvoicePosition pos = new InvoicePosition();
    pos.setInvoice(reloaded);
    pos.setPosText("created pos");
    ListSequence.fromList(reloaded.getPositions()).addElement(pos);
    {
      int leftSide = ListSequence.fromList(reloaded.getPositions()).count();
      int rightSide = 5;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.Merging positions in existing aggregate':  reloaded .positions.size == 5          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    ListSequence.fromList(invoice1.getPositions()).visitAll((it) -> BLOperations.plusAssign(it.refToPosText(), " *"));

    Invoice integrated = MoRevertibleMerger.<Integer,Invoice>mergeEntityIntoEntity(Invoice.class, invoice1, reloaded, __manMapSession, true);

    List<InvoicePosition> integrated_pos = MoRevertibleMerger.<Integer,InvoicePosition>mergeListIntoList(InvoicePosition.class, invoice1.getPositions(), integrated.getPositions(), __manMapSession, true);

    {
      int leftSide = ListSequence.fromList(__manMapSession.<InvoicePosition>getEntitiesAll(InvoicePosition.entitySessionUID)).count();
      int rightSide = 4;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.Merging positions in existing aggregate':  session entities .size == 4          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(integrated_pos).count();
      int rightSide = 4;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.Merging positions in existing aggregate':  integrated_pos .size == 4          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(reloaded.getPositions()).count();
      int rightSide = 4;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'SessionAndMerge.Merging positions in existing aggregate':  reloaded .positions.size == 4          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(ListSequence.fromList(reloaded.getPositions()).all((it) -> it.getPosText().endsWith("*")))) {
      throw new OFXTestSuitException("'SessionAndMerge.Merging positions in existing aggregate':  reloaded .positions.all          ==>> FALSE !" + "\n");
    }

  }


  public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  public static void main(String[] args) {
    String[] allIncludedTest = new String[]{};
    String[] includedTestToRun = new String[]{};

    OFXTestSuit.runAsMain("org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", SessionAndMerge.class, allIncludedTest, includedTestToRun);
  }
}
