package org.modellwerkstatt.objectflow.tests.OrderDocument;

/*Generated by MPS */

import org.springframework.stereotype.Component;
import org.springframework.beans.factory.annotation.Autowired;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import java.math.BigDecimal;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import jetbrains.mps.internal.collections.runtime.ListSequence;

@Component(value = "org.modellwerkstatt.objectflow.tests.OrderDocument.ODF")
public class ODF {

  @Autowired
  private IOFXPlatform __runtimeIOFXPlatform;
  @Autowired
  private IOFXTranslationProvider __runtimeIOFXTranslationProvider;

  private ODF __OrderDocumentODF = this;


  public OrderDocument createOrderDocument(String withRemark, String forPerson, final IOFXSession __manMapSession) {

    OrderDocument od = new OrderDocument();
    od.setRemark(withRemark);
    od.setPersonName(forPerson);
    od.setTotalValue(new MonetaryValue(new BigDecimal("0.0")));
    od.setExpectedDate(DeprecatedServerDateProvider.getSqlServerLocalDate().plusMonths(1));
    od.setStatus(OrderDocument_OrderDocStatus.DRAFT);
    return od;

  }
  public OrderDocumentPos createOrderDocPos(OrderDocument forDocument, String withTitle, int forArtikelKey, BigDecimal withValue, final IOFXSession __manMapSession) {
    OrderDocumentPos ods = new OrderDocumentPos();

    // might be not persisted (id=0)
    ods.setOrderDocKey(forDocument.getId());
    ods.setTitle(withTitle);
    ods.setVal(new MonetaryValue());
    ods.setArticelKey(forArtikelKey);
    ods.setVal(new MonetaryValue(withValue));

    // add it to aggreagte but also return it to caller for changes
    ListSequence.fromList(forDocument.getPositions()).addElement(ods);
    return ods;
  }




}
