package org.modellwerkstatt.objectflow.tests.ProdConsJob;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.batchjob.OFXPCPairController;
import org.modellwerkstatt.objectflow.batchjob.IOFXTimerMasterController;
import org.modellwerkstatt.objectflow.batchjob.OFXExceptionStrategy;
import org.modellwerkstatt.objectflow.runtime.OFXSimpleAppFactory;
import org.modellwerkstatt.objectflow.batchjob.IOFXCommandImplProducer;
import java.util.ArrayList;
import org.modellwerkstatt.objectflow.runtime.IOFXUserServices;
import org.modellwerkstatt.objectflow.batchjob.IOFXCommandImplConsumer;
import org.modellwerkstatt.objectflow.batchjob.OFXConsumerRunnable;

public class TestPairController extends OFXPCPairController<Integer> {
  protected int inboxOffset = 0;
  protected int[][] inboxItems;
  protected int[] config;
  protected int called = 0;

  public TestPairController(int id, String name, IOFXTimerMasterController masterController, OFXExceptionStrategy strat) {
    super(id, name, masterController, strat, null, new OFXSimpleAppFactory());
  }

  public void setup(int o, int[][] itemsForInbox, int[] configuration) {
    inboxOffset = o;
    inboxItems = itemsForInbox;
    config = configuration;
  }

  public IOFXCommandImplProducer<Integer> createNewProducerImplementation() {
    return new IOFXCommandImplProducer<Integer>() {
      public ArrayList<Integer> process(IOFXUserServices __userServices) throws Exception {
        ArrayList<Integer> aList = new ArrayList<Integer>();
        boolean numberTwoFound = false;

        for (int i = 0; i < inboxItems[called % inboxItems.length].length; i++) {
          int item = inboxItems[called % inboxItems.length][i] + inboxOffset;
          aList.add(item);
          if (item == 2) {
            numberTwoFound = true;
          }
        }
        called++;

        if (TestUtil.configVal(config, TestUtil.PRODUCER_RTEX_ON_KEY_2) && numberTwoFound) {
          throw new RuntimeException("Producer RT EX");
        }

        return aList;
      }
      public String getLastAction() {
        return "-";
      }
    };
  }

  public IOFXCommandImplConsumer<Integer>[] createNewConsumerImplementations() {
    return new IOFXCommandImplConsumer[]{new IOFXCommandImplConsumer<Integer>() {

      public boolean toExecute(Integer key) {
        return true;
      }
      public String getLastAction() {
        return "Testsuit Waiting Consumer";
      }
      public void process(IOFXUserServices __userServices, Integer key) {

        if (TestUtil.configVal(config, TestUtil.ON_KEY_2_EXITCONSUMER) && key == 2) {
          throw new RuntimeException(OFXConsumerRunnable.TEST_STOP_EVENT_LOOP_EX_MSG);
        }
        if (TestUtil.configVal(config, TestUtil.ON_KEY_3_EXITCONSUMER) && key == 3) {
          throw new IllegalStateException(OFXConsumerRunnable.TEST_STOP_EVENT_LOOP_EX_MSG);
        }

        if (TestUtil.configVal(config, TestUtil.ON_KEY_2_RTEX) && key == 2) {
          throw new RuntimeException("Key 2 and config ex on 2");
        }
        if (TestUtil.configVal(config, TestUtil.ON_KEY_3_ILSTATEEX) && key == 3) {
          throw new IllegalStateException("Key 3 and config ex on 3");
        }

        TestUtil.wait(50);
      }
    }};
  }


}
