package org.modellwerkstatt.objectflow.tests.manmap.Domain;

/*Generated by MPS */

import org.springframework.stereotype.Component;
import org.springframework.beans.factory.annotation.Autowired;
import org.modellwerkstatt.objectflow.runtime.IOFXApplicationFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import java.math.BigDecimal;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.IOFXSessionOperation;

@Component(value = "org.modellwerkstatt.objectflow.tests.manmap.Domain.CreatorsFactory")
public class CreatorsFactory {
  @Autowired
  private IOFXApplicationFactory appFactory;

  @Autowired
  private SessionLess __DomainSessionLess;
  @Autowired
  private RepoInvoice __DomainRepoInvoice;
  @Autowired
  private RepoAuditEntity __DomainRepoAuditEntity;
  @Autowired
  private RepoAccountAudit __DomainRepoAccountAudit;
  @Autowired
  private IOFXPlatform __runtimeIOFXPlatform;
  @Autowired
  private IOFXTranslationProvider __runtimeIOFXTranslationProvider;

  private CreatorsFactory __DomainCreatorsFactory = this;


  public IOFXSession CREATE_SESSION(final IOFXSession __manMapSession) {
    IOFXSession customSession = appFactory.createNewSession(__manMapSession.getUserEnvironment(), __manMapSession.getUserServices());
    return customSession;
  }
  private Invoice createInvoicePlain(String name, int posNum, boolean withFirstPosAsMainRef, final IOFXSession __manMapSession) {
    final Invoice invoice = new Invoice();
    invoice.setDateTime(DeprecatedServerDateProvider.getSqlServerDateTime());
    invoice.setLocalDate(DeprecatedServerDateProvider.getSqlServerLocalDate());
    invoice.setHeadState(Invoice_HeadState.STAT1);
    invoice.setNameLen(name.length());
    invoice.setMoneyAmount(new MoneyAmount(100, "EUR"));
    invoice.setNameLen2(new BigDecimal(name.length()));
    invoice.setText("Invoice");
    invoice.setName(name);

    for (int i = 0; i < posNum; i++) {
      InvoicePosition pos = new InvoicePosition();
      pos.setPosText(name + "_" + i);
      pos.setDate(DeprecatedServerDateProvider.getSqlServerLocalDate());
      pos.setPosAvalue(new BigDecimal("10.0").multiply(new BigDecimal(i)));
      pos.setInvoice(invoice);
      ListSequence.fromList(invoice.getPositions()).addElement(pos);
    }
    if (withFirstPosAsMainRef) {
      invoice.setMainPosRef(ListSequence.fromList(invoice.getPositions()).getElement(0));
    }

    invoice.complete();
    return invoice;
  }
  public Invoice createInvoiceGraphWith4Positions_onDB(String name, final IOFXSession __manMapSession) {
    Invoice invoice = createInvoicePlain(name, 4, false, __manMapSession);
    __DomainSessionLess.checkinInvoiceImmediatelly(invoice, CREATE_SESSION(__manMapSession), __manMapSession);
    return invoice;
  }
  public Invoice createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB(String name, final IOFXSession __manMapSession) {
    Invoice invoice = createInvoicePlain(name, 4, true, __manMapSession);
    __DomainSessionLess.checkinInvoiceImmediatelly(invoice, CREATE_SESSION(__manMapSession), __manMapSession);
    return invoice;
  }
  public Invoice createInvoiceGraphWith4Positions_NOTonDB(String name, final IOFXSession __manMapSession) {
    return createInvoiceGraphWithNPositions_NOTonDB(name, 4, __manMapSession);
  }
  public Invoice createInvoiceGraphWithNPositions_NOTonDB(String name, int posNum, final IOFXSession __manMapSession) {
    Invoice inv = createInvoicePlain(name, posNum, false, __manMapSession);
    return inv;
  }
  public NewInvoicePos createNewInvoicePosition(NewInvoice invoice, String name, final IOFXSession __manMapSession) {

    NewInvoicePos pos = new NewInvoicePos();
    pos.setPosText(name);
    pos.setDate(DeprecatedServerDateProvider.getSqlServerLocalDate());
    pos.setPosAvalue(new BigDecimal("10.0"));
    ListSequence.fromList(invoice.getPositions()).addElement(pos);

    invoice.complete();
    return pos;
  }
  public NewInvoice createNewInvoiceGraphWithNPositions_NOTonDB(String name, int posNum, final IOFXSession __manMapSession) {
    NewInvoice invoice = new NewInvoice();
    invoice.setDateTime(DeprecatedServerDateProvider.getSqlServerDateTime());
    invoice.setLocalDate(DeprecatedServerDateProvider.getSqlServerLocalDate());
    invoice.setHeadState(Invoice_HeadState.STAT1);
    invoice.setTotalAmount(new BigDecimal("100.0"));
    invoice.setNameLen2(new BigDecimal(name.length()));
    invoice.setText("Invoice");
    invoice.setName(name);

    for (int i = 0; i < posNum; i++) {
      NewInvoicePos pos = createNewInvoicePosition(invoice, name + "_" + i, __manMapSession);
      pos.setPosAvalue(new BigDecimal("10.0").multiply(new BigDecimal(i)));
    }

    invoice.complete();
    return invoice;
  }
  public Invoice createExtendedInvoiceGraphWith2Positions_onDB(String name, final IOFXSession __manMapSession) {
    ExtendedInvoice extendedInvoice = new ExtendedInvoice();
    extendedInvoice.setDateTime(DeprecatedServerDateProvider.getSqlServerDateTime());
    extendedInvoice.setLocalDate(DeprecatedServerDateProvider.getSqlServerLocalDate());
    extendedInvoice.setHeadState(Invoice_HeadState.STAT1);
    extendedInvoice.setNameLen(name.length());
    extendedInvoice.setMoneyAmount(new MoneyAmount(100, "EUR"));
    extendedInvoice.setNameLen2(new BigDecimal(name.length()));
    extendedInvoice.setText("Extended Invoice");
    extendedInvoice.setName(name);
    extendedInvoice.setExtendedInt(10);
    extendedInvoice.setExtendedString("EXT");

    for (int i = 0; i < 2; i++) {
      InvoicePosition pos = new InvoicePosition();
      pos.setPosText(name + "_" + i);
      pos.setDate(DeprecatedServerDateProvider.getSqlServerLocalDate());
      pos.setPosAvalue(new BigDecimal("10.0").multiply(new BigDecimal(i)));
      pos.setInvoice(extendedInvoice);
      ListSequence.fromList(extendedInvoice.getPositions()).addElement(pos);
    }

    extendedInvoice.complete();

    __DomainSessionLess.checkinExtendedInvoice(extendedInvoice, CREATE_SESSION(__manMapSession), __manMapSession);


    return extendedInvoice;
  }
  private void deleteInvoice(Invoice inv, final IOFXSession __manMapSession) {
    __DomainRepoInvoice.deleteInovice(inv, null);
  }
  public Referer createRefererEntityWithStringKey(String keyString, final IOFXSession __manMapSession) {
    Referer ref = new Referer();
    ref.setKey(keyString);
    ref.setName(keyString);
    ref.setTotalValue(new BigDecimal("0.0"));
    // Is that explicitly needed -> no longer with MRS 18 plugin
    ref.setAccount(null);
    ref.setAccountKey(new AccountKey());
    return ref;
  }
  public Account createAccountWithNumAndMandant(int num, String mandant, final IOFXSession __manMapSession) {
    AccountKey key = new AccountKey(num, mandant, AccountKey_Active.ON);
    Account account = new Account();
    account.setKey(key);
    account.setTotalValue(new BigDecimal("0.0"));
    // Is that explicitly needed -> no longer with MRS 18 plugin
    account.setRelatedAccountAudit(null);
    return account;


  }
  public AuditEntity createAuditEntity_onDB(String name, final IOFXSession __manMapSession) {
    final AuditEntity obj = new AuditEntity();
    obj.setAmount(new MoneyAmount(10, "EUR"));
    obj.setOnOff(AuditEntity_OnOff.ON);
    obj.setText(name);
    obj.setTotalAmount(new BigDecimal("10.0"));

    final IOFXSession session = CREATE_SESSION(__manMapSession);
    session.addOperation(new IOFXSessionOperation() {
      public void execute() {
        __DomainRepoAuditEntity.checkinAuditEntity(obj, session);
      }
      public String getInformation() {
        return "checkin AuditEntity";
      }
    });

    try {
      session.startTransactionAndFlush();
    } catch (Exception ex) {
      throw new RuntimeException(ex);
    }

    return obj;
  }
  public Account createAccount_onDB(String name, Account ref, final IOFXSession __manMapSession) {
    final Account obj = new Account();
    obj.setKey(new AccountKey(10, name, AccountKey_Active.ON));
    obj.setTotalValue(new BigDecimal("10.0"));
    obj.setADateDirtyIrrelevant(null);
    obj.setRelatedAccountAudit(ref);

    final IOFXSession session = CREATE_SESSION(__manMapSession);
    session.addOperation(new IOFXSessionOperation() {
      public void execute() {
        __DomainRepoAccountAudit.insertAccount(obj, session);
      }
      public String getInformation() {
        return "checkin Account";
      }
    });

    try {
      session.startTransactionAndFlush();
    } catch (Exception ex) {
      throw new RuntimeException(ex);
    }

    return obj;
  }
  public AuditEntity createAuditEntity_NOTonDB(String name, final IOFXSession __manMapSession) {
    final AuditEntity obj = new AuditEntity();
    obj.setAmount(new MoneyAmount(10, "EUR"));
    obj.setOnOff(AuditEntity_OnOff.ON);
    obj.setText(name);
    obj.setTotalAmount(new BigDecimal("10.0"));
    return obj;
  }
  public Invoice createInvoiceGraphWith2PositionsAnd2SubPos_onDB(String name, final IOFXSession __manMapSession) {
    Invoice invoice = new Invoice();
    invoice.setDateTime(DeprecatedServerDateProvider.getSqlServerDateTime());
    invoice.setLocalDate(DeprecatedServerDateProvider.getSqlServerLocalDate());
    invoice.setHeadState(Invoice_HeadState.STAT1);
    invoice.setNameLen(name.length());
    invoice.setMoneyAmount(new MoneyAmount(100, "EUR"));
    invoice.setNameLen2(new BigDecimal(name.length()));
    invoice.setText("Invoice");
    invoice.setName(name);

    for (int i = 0; i < 2; i++) {
      InvoicePosition pos = new InvoicePosition();
      pos.setPosText(name + "_" + i);
      pos.setDate(DeprecatedServerDateProvider.getSqlServerLocalDate());
      pos.setPosAvalue(new BigDecimal("10.0").multiply(new BigDecimal(i)));
      pos.setInvoice(invoice);
      ListSequence.fromList(invoice.getPositions()).addElement(pos);

      for (int j = 0; j < 2; j++) {
        SubInvoicePosition sub = new SubInvoicePosition();
        sub.setText(name + "_sub_" + j);
        sub.setInvpos(pos);
        ListSequence.fromList(pos.getSubposition()).addElement(sub);
      }
    }

    invoice.complete();

    __DomainSessionLess.checkinInvoiceWithSub(invoice, CREATE_SESSION(__manMapSession), null);

    return invoice;
  }




}
