package org.modellwerkstatt.objectflow.tests.manmap.Domain;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.runtime.OFXEntity;
import org.modellwerkstatt.objectflow.runtime.OFXInteger;
import org.modellwerkstatt.objectflow.runtime.OFXBigDecimal;
import java.math.BigDecimal;
import org.modellwerkstatt.objectflow.runtime.OFXString;
import org.modellwerkstatt.objectflow.runtime.OFXLocalDate;
import org.modellwerkstatt.objectflow.runtime.OFXDateTime;
import org.modellwerkstatt.objectflow.runtime.OFXStatus;
import org.modellwerkstatt.objectflow.runtime.OFXList;
import org.modellwerkstatt.objectflow.runtime.OFXKeyReference;
import org.modellwerkstatt.objectflow.runtime.OFXValueObject;
import org.modellwerkstatt.objectflow.runtime.OFXIllegalAccessException;
import jetbrains.mps.references.Reference;
import org.joda.time.LocalDate;
import org.joda.time.DateTime;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.MU;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaRange;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaRangeScale;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaLength;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaBasis;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaReferences;
import org.modellwerkstatt.objectflow.runtime.IOFXRevertableObject;

public class Invoice extends OFXEntity<Integer> {
  public static final int entitySessionUID = Invoice.class.hashCode();

  public Invoice() {
    this.setMoneyAmount(new MoneyAmount(0, "EUR"));
  }
  public Invoice(int i) {
  }

  public int getSessionObjectKeyStoreID() {
    return entitySessionUID;
  }
  public Integer getIM3Key() {
    return this.id.getValue();
  }
  public Object getKeyProperty() {
    return this.id;
  }


  protected OFXInteger id = new OFXInteger();
  protected OFXInteger nameLen = new OFXInteger();
  protected OFXBigDecimal totalAmount = new OFXBigDecimal();
  protected OFXBigDecimal nameLen2 = new OFXBigDecimal(new BigDecimal("50.0"), new BigDecimal("50.1"), 2);
  protected OFXString text = new OFXString(0, 20);
  protected OFXString name = new OFXString(0, 20);
  protected OFXLocalDate localDate = new OFXLocalDate();
  protected OFXDateTime dateTime = new OFXDateTime();
  protected OFXStatus<Invoice_HeadState> headState = new OFXStatus<Invoice_HeadState>(Invoice_HeadState.ON_CREATE);
  protected OFXList<InvoicePosition> positions = new OFXList<InvoicePosition>();
  protected OFXKeyReference<Integer, InvoicePosition> mainPosRef = new OFXKeyReference<Integer, InvoicePosition>(false, Integer.class);
  protected OFXValueObject<MoneyAmount> moneyAmount = new OFXValueObject<MoneyAmount>();
  public int getId() {
    return this.id.getValue();
  }
  private void _setId(int value) {
    if ((_dirty |= this.id.setValue(value)) && this._readOnly) {
      throw new OFXIllegalAccessException("Changing values in read only Invoice (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
    }
  }
  public int setId(int value) {
    _setId(value);
    return value;
  }
  public Reference<Integer> refToId() {
    return new Reference<Integer>() {
      public Integer get() {
        return getId();
      }
      public void set(Integer value) {
        _setId(value);
      }
    };
  }
  public int getNameLen() {
    return this.nameLen.getValue();
  }
  private void _setNameLen(int value) {
    if ((_dirty |= this.nameLen.setValue(value)) && this._readOnly) {
      throw new OFXIllegalAccessException("Changing values in read only Invoice (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
    }
  }
  public int setNameLen(int value) {
    _setNameLen(value);
    return value;
  }
  public Reference<Integer> refToNameLen() {
    return new Reference<Integer>() {
      public Integer get() {
        return getNameLen();
      }
      public void set(Integer value) {
        _setNameLen(value);
      }
    };
  }
  public BigDecimal getTotalAmount() {
    return this.totalAmount.getValue();
  }
  private void _setTotalAmount(BigDecimal value) {
    if ((_dirty |= this.totalAmount.setValue(value)) && this._readOnly) {
      throw new OFXIllegalAccessException("Changing values in read only Invoice (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
    }
  }
  public BigDecimal setTotalAmount(BigDecimal value) {
    _setTotalAmount(value);
    return value;
  }
  public Reference<BigDecimal> refToTotalAmount() {
    return new Reference<BigDecimal>() {
      public BigDecimal get() {
        return getTotalAmount();
      }
      public void set(BigDecimal value) {
        _setTotalAmount(value);
      }
    };
  }
  public BigDecimal getNameLen2() {
    return this.nameLen2.getValue();
  }
  private void _setNameLen2(BigDecimal value) {
    if ((_dirty |= this.nameLen2.setValue(value)) && this._readOnly) {
      throw new OFXIllegalAccessException("Changing values in read only Invoice (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
    }
  }
  public BigDecimal setNameLen2(BigDecimal value) {
    _setNameLen2(value);
    return value;
  }
  public Reference<BigDecimal> refToNameLen2() {
    return new Reference<BigDecimal>() {
      public BigDecimal get() {
        return getNameLen2();
      }
      public void set(BigDecimal value) {
        _setNameLen2(value);
      }
    };
  }
  public String getText() {
    return this.text.getValue();
  }
  private void _setText(String value) {
    if ((_dirty |= this.text.setValue(value)) && this._readOnly) {
      throw new OFXIllegalAccessException("Changing values in read only Invoice (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
    }
  }
  public String setText(String value) {
    _setText(value);
    return value;
  }
  public Reference<String> refToText() {
    return new Reference<String>() {
      public String get() {
        return getText();
      }
      public void set(String value) {
        _setText(value);
      }
    };
  }
  public String getName() {
    return this.name.getValue();
  }
  private void _setName(String value) {
    if ((_dirty |= this.name.setValue(value)) && this._readOnly) {
      throw new OFXIllegalAccessException("Changing values in read only Invoice (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
    }
  }
  public String setName(String value) {
    _setName(value);
    return value;
  }
  public Reference<String> refToName() {
    return new Reference<String>() {
      public String get() {
        return getName();
      }
      public void set(String value) {
        _setName(value);
      }
    };
  }
  public LocalDate getLocalDate() {
    return this.localDate.getValue();
  }
  private void _setLocalDate(LocalDate value) {
    if ((_dirty |= this.localDate.setValue(value)) && this._readOnly) {
      throw new OFXIllegalAccessException("Changing values in read only Invoice (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
    }
  }
  public LocalDate setLocalDate(LocalDate value) {
    _setLocalDate(value);
    return value;
  }
  public Reference<LocalDate> refToLocalDate() {
    return new Reference<LocalDate>() {
      public LocalDate get() {
        return getLocalDate();
      }
      public void set(LocalDate value) {
        _setLocalDate(value);
      }
    };
  }
  public DateTime getDateTime() {
    return this.dateTime.getValue();
  }
  private void _setDateTime(DateTime value) {
    if ((_dirty |= this.dateTime.setValue(value)) && this._readOnly) {
      throw new OFXIllegalAccessException("Changing values in read only Invoice (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
    }
  }
  public DateTime setDateTime(DateTime value) {
    _setDateTime(value);
    return value;
  }
  public Reference<DateTime> refToDateTime() {
    return new Reference<DateTime>() {
      public DateTime get() {
        return getDateTime();
      }
      public void set(DateTime value) {
        _setDateTime(value);
      }
    };
  }
  public Invoice_HeadState getHeadState() {
    return this.headState.getValue();
  }
  private void _setHeadState(Invoice_HeadState value) {
    if ((_dirty |= this.headState.setValue(value)) && this._readOnly) {
      throw new OFXIllegalAccessException("Changing values in read only Invoice (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
    }
  }
  public Invoice_HeadState setHeadState(Invoice_HeadState value) {
    _setHeadState(value);
    return value;
  }
  public Reference<Invoice_HeadState> refToHeadState() {
    return new Reference<Invoice_HeadState>() {
      public Invoice_HeadState get() {
        return getHeadState();
      }
      public void set(Invoice_HeadState value) {
        _setHeadState(value);
      }
    };
  }
  public List<InvoicePosition> getPositions() {
    return this.positions.getValue();
  }
  private void _setPositions(List<InvoicePosition> value) {
    if ((_dirty |= this.positions.setValue(value)) && this._readOnly) {
      throw new OFXIllegalAccessException("Changing values in read only Invoice (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
    }
  }
  public List<InvoicePosition> setPositions(List<InvoicePosition> value) {
    _setPositions(value);
    return value;
  }
  public Reference<List<InvoicePosition>> refToPositions() {
    return new Reference<List<InvoicePosition>>() {
      public List<InvoicePosition> get() {
        return getPositions();
      }
      public void set(List<InvoicePosition> value) {
        _setPositions(value);
      }
    };
  }
  public InvoicePosition getMainPosRef() {
    return this.mainPosRef.getValue();
  }
  private void _setMainPosRef(InvoicePosition value) {
    if ((_dirty |= this.mainPosRef.setValue(value)) && this._readOnly) {
      throw new OFXIllegalAccessException("Changing values in read only Invoice (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
    }
  }
  public InvoicePosition setMainPosRef(InvoicePosition value) {
    _setMainPosRef(value);
    return value;
  }
  public Reference<InvoicePosition> refToMainPosRef() {
    return new Reference<InvoicePosition>() {
      public InvoicePosition get() {
        return getMainPosRef();
      }
      public void set(InvoicePosition value) {
        _setMainPosRef(value);
      }
    };
  }
  public MoneyAmount getMoneyAmount() {
    return this.moneyAmount.getValue();
  }
  private void _setMoneyAmount(MoneyAmount value) {
    if ((_dirty |= this.moneyAmount.setValue(value)) && this._readOnly) {
      throw new OFXIllegalAccessException("Changing values in read only Invoice (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
    }
  }
  public MoneyAmount setMoneyAmount(MoneyAmount value) {
    _setMoneyAmount(value);
    return value;
  }
  public Reference<MoneyAmount> refToMoneyAmount() {
    return new Reference<MoneyAmount>() {
      public MoneyAmount get() {
        return getMoneyAmount();
      }
      public void set(MoneyAmount value) {
        _setMoneyAmount(value);
      }
    };
  }


  public void complete() {
    setTotalAmount(MU.sum(ListSequence.fromList(this.getPositions()).select((it) -> it.getPosAvalue())));
  }
  public void ensurePosSortOrder() {
    this.setPositions(ListSequence.fromList(this.getPositions()).sort((it) -> it.getId(), true).toList());
  }

  public int getMainPosRefKEY() {
    return mainPosRef.getKey();
  }
  public void setMainPosRefKEY(Integer key) {
    mainPosRef.setKey(key);
  }
  public IOFXMetaRange<Integer> getId_META() {
    return this.id;
  }
  public IOFXMetaRange<Integer> getNameLen_META() {
    return this.nameLen;
  }
  public IOFXMetaRangeScale<BigDecimal> getTotalAmount_META() {
    return this.totalAmount;
  }
  public IOFXMetaRangeScale<BigDecimal> getNameLen2_META() {
    return this.nameLen2;
  }
  public IOFXMetaLength<String> getText_META() {
    return this.text;
  }
  public IOFXMetaLength<String> getName_META() {
    return this.name;
  }
  public IOFXMetaRange<LocalDate> getLocalDate_META() {
    return this.localDate;
  }
  public IOFXMetaRange<DateTime> getDateTime_META() {
    return this.dateTime;
  }
  public IOFXMetaStatus<Invoice_HeadState> getHeadState_META() {
    return this.headState;
  }
  public IOFXMetaBasis getPositions_META() {
    return this.positions;
  }
  public IOFXMetaReferences<InvoicePosition> getMainPosRef_META() {
    return this.mainPosRef;
  }
  public IOFXMetaBasis getMoneyAmount_META() {
    return this.moneyAmount;
  }



  public void beforeSave() {
    super.beforeSave();
    mainPosRef.checkReferenceBeforeSave();
  }

  @Override
  public void rollback() {
    super.rollback();
    this.id.setValue(_BEFORESAVE_KEY);
  }
  public boolean anyOfListDirty() {
    boolean dirty = super.anyOfListDirty();
    dirty |= positions.wasListChanged();
    return dirty;
  }
  public void clearDirtyOnLists() {
    super.clearDirtyOnLists();
    positions.setHashForDirtyChecking();
  }
  @Override
  public String toString() {
    return "Invoice " + getKeyProperty();
  }

  public void load(IOFXRevertableObject param, boolean fullRevertNotMerge) {
    Invoice entity = ((Invoice) param);
    this.id.load(entity.id, fullRevertNotMerge);
    this.nameLen.load(entity.nameLen, fullRevertNotMerge);
    this.totalAmount.load(entity.totalAmount, fullRevertNotMerge);
    this.nameLen2.load(entity.nameLen2, fullRevertNotMerge);
    this.text.load(entity.text, fullRevertNotMerge);
    this.name.load(entity.name, fullRevertNotMerge);
    this.localDate.load(entity.localDate, fullRevertNotMerge);
    this.dateTime.load(entity.dateTime, fullRevertNotMerge);
    this.headState.load(entity.headState, fullRevertNotMerge);
    this.positions.load(entity.positions, fullRevertNotMerge);
    this.mainPosRef.load(entity.mainPosRef, fullRevertNotMerge);
    this.moneyAmount.load(entity.moneyAmount, fullRevertNotMerge);
    super.load(param, fullRevertNotMerge);
  }
  public IOFXRevertableObject copy() {
    Invoice entity = new Invoice();
    entity.id = this.id.copy();
    entity.nameLen = this.nameLen.copy();
    entity.totalAmount = this.totalAmount.copy();
    entity.nameLen2 = this.nameLen2.copy();
    entity.text = this.text.copy();
    entity.name = this.name.copy();
    entity.localDate = this.localDate.copy();
    entity.dateTime = this.dateTime.copy();
    entity.headState = this.headState.copy();
    entity.positions = this.positions.copy();
    entity.mainPosRef = this.mainPosRef.copy();
    entity.moneyAmount = this.moneyAmount.copy();
    super.entityInfraInto(entity);
    return entity;
  }
}
