package org.modellwerkstatt.objectflow.tests.manmap.Domain;

/*Generated by MPS */

import org.springframework.stereotype.Component;
import org.modellwerkstatt.manmap.runtime.MMClassMapper;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.modellwerkstatt.manmap.runtime.IM3CompoundKey;
import java.sql.PreparedStatement;
import org.modellwerkstatt.manmap.runtime.IM3Session;
import org.modellwerkstatt.manmap.runtime.IM3DynamicTableEvaluator;
import org.springframework.dao.DataAccessException;
import java.util.List;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;

@Component(value = "org.modellwerkstatt.objectflow.tests.manmap.Domain.MapAccount")
public class MapAccount extends MMClassMapper<AccountKey, Account> {
  public static final int entitySessionUID = Account.entitySessionUID;
  private final int[] keysIndex = new int[]{0, 1, 2};

  public MapAccount() {
    super("org.modellwerkstatt.objectflow.tests.manmap.Domain.MapAccount", "org.modellwerkstatt.objectflow.tests.manmap.Domain.Account", "MMT_KONTOAUDIT");
  }

  @Override
  public int getEntitySessionUID() {
    return entitySessionUID;
  }

  public Account map(ResultSet resultSet, int curCol, Account existingEntity) throws SQLException {
    Account account_10 = existingEntity;

    {
      AccountKey accountkey_0 = new AccountKey();
      accountkey_0.setNumber(__intTypeHandler.getResult(resultSet, curCol++));
      accountkey_0.setMandant(__stringTypeHandler.getResult(resultSet, curCol++));
      accountkey_0.setActive(AccountKey_Active.fromString(__stringTypeHandler.getResult(resultSet, curCol++)));
      account_10.setKey(accountkey_0);
    }
    account_10.setTotalValue(__bigDecimalTypeHandler.getResult(resultSet, curCol++));
    {
      AccountKey accountkey_0 = new AccountKey();
      accountkey_0.setNumber(__intTypeHandler.getResult(resultSet, curCol++));
      accountkey_0.setMandant(__stringTypeHandler.getResult(resultSet, curCol++));
      accountkey_0.setActive(AccountKey_Active.fromString(__stringTypeHandler.getResult(resultSet, curCol++)));
      account_10.setRelatedAccountAuditKEY(accountkey_0);
    }
    account_10.setParentKEY(__stringTypeHandler.getResult(resultSet, curCol++));

    return account_10;
  }

  public AccountKey getKeyByIndex(ResultSet resultSet, int startRow) throws SQLException {
    AccountKey key;

    // returns null, if key is not set, e.g. key is 0 or string is ""
    {
      key = new AccountKey();
      int i = 0;
      key.setNumber(__intTypeHandler.getResult(resultSet, startRow + keysIndex[i++]));
      key.setMandant(__stringTypeHandler.getResult(resultSet, startRow + keysIndex[i++]));
      key.setActive(AccountKey_Active.fromString(__stringTypeHandler.getResult(resultSet, startRow + keysIndex[i++])));
      if (((IM3CompoundKey) key).isNullKey()) {
        return null;
      }
    }
    return key;
  }

  protected void setParametersInsert(Account account_10, PreparedStatement preparedStatement, StringBuilder debugSb) throws SQLException {
    int curCol = 1;
    {
      AccountKey accountkey_0 = account_10.getKey();
      __intTypeHandler.setParameter(preparedStatement, curCol++, accountkey_0.getNumber(), debugSb);
      __stringTypeHandler.setParameter(preparedStatement, curCol++, accountkey_0.getMandant(), debugSb);
      __stringTypeHandler.setParameter(preparedStatement, curCol++, AccountKey_Active.asStringForManmap(accountkey_0.getActive()), debugSb);
    }
    __bigDecimalTypeHandler.setParameter(preparedStatement, curCol++, account_10.getTotalValue(), debugSb);
    {
      AccountKey accountkey_0 = account_10.getRelatedAccountAuditKEY();
      __intTypeHandler.setParameter(preparedStatement, curCol++, accountkey_0.getNumber(), debugSb);
      __stringTypeHandler.setParameter(preparedStatement, curCol++, accountkey_0.getMandant(), debugSb);
      __stringTypeHandler.setParameter(preparedStatement, curCol++, AccountKey_Active.asStringForManmap(accountkey_0.getActive()), debugSb);
    }
    __stringTypeHandler.setParameter(preparedStatement, curCol++, account_10.getParentKEY(), debugSb);
  }
  protected void setParametersUpdate(Account account_10, PreparedStatement preparedStatement, StringBuilder debugSb) throws SQLException {
    int curCol = 1;
    // skipped in prepared statement dispatch
    __bigDecimalTypeHandler.setParameter(preparedStatement, curCol++, account_10.getTotalValue(), debugSb);
    {
      AccountKey accountkey_0 = account_10.getRelatedAccountAuditKEY();
      __intTypeHandler.setParameter(preparedStatement, curCol++, accountkey_0.getNumber(), debugSb);
      __stringTypeHandler.setParameter(preparedStatement, curCol++, accountkey_0.getMandant(), debugSb);
      __stringTypeHandler.setParameter(preparedStatement, curCol++, AccountKey_Active.asStringForManmap(accountkey_0.getActive()), debugSb);
    }
    __stringTypeHandler.setParameter(preparedStatement, curCol++, account_10.getParentKEY(), debugSb);
    {
      AccountKey accountkey_0 = account_10.getKey();
      __intTypeHandler.setParameter(preparedStatement, curCol++, accountkey_0.getNumber(), debugSb);
      __stringTypeHandler.setParameter(preparedStatement, curCol++, accountkey_0.getMandant(), debugSb);
      __stringTypeHandler.setParameter(preparedStatement, curCol++, AccountKey_Active.asStringForManmap(accountkey_0.getActive()), debugSb);
    }
  }

  public String fieldsForSelect(boolean rootTable) {
    if (rootTable) {
      return "iRoot.KEY_NUMBER, iRoot.KEY_MANDANT, iRoot.KEY_STATUS, iRoot.NUM_TOTALVAL, iRoot.REF_NUMBER, iRoot.REF_MANDANT, iRoot.REF_STATUS, iRoot.REF_REFERER";
    } else {
      return "iRoot.KEY_NUMBER, iRoot.KEY_MANDANT, iRoot.KEY_STATUS, iRoot.NUM_TOTALVAL, iRoot.REF_NUMBER, iRoot.REF_MANDANT, iRoot.REF_STATUS, iRoot.REF_REFERER";
    }
  }

  protected String getTableNameFromRef(String refName) {

    throw new IllegalArgumentException("Table reference Name " + refName + " no found. Maybe you have to rebuild all.");
  }

  protected void doInsertAuditForEntity(Account entity, IM3Session session) {
  }
  protected void doUpdateAuditForEntity(Account entity, IM3Session session) {
  }

  public void update(Account entity, IM3DynamicTableEvaluator[] evaluators, IM3Session session, boolean audit, Object debugTextOrNull) throws DataAccessException {

    String sql = String.format("UPDATE %s SET NUM_TOTALVAL=?, REF_NUMBER=?, REF_MANDANT=?, REF_STATUS=?, REF_REFERER=? WHERE KEY_NUMBER=? AND KEY_MANDANT=? AND KEY_STATUS=?", getCurrentTableName(evaluators));
    super.__update(entity, audit, sql, session, debugTextOrNull);
  }

  public void insert(Account entity, IM3DynamicTableEvaluator[] evaluators, IM3Session session, boolean audit, Object debugTextOrNull) throws DataAccessException {

    MMClassMapper.SequenceSetter sequenceSetter = new MMClassMapper.SequenceSetter<Account>() {
      @Override
      public void setValues(Account ent) {
      }
    };
    String sql = String.format("INSERT INTO %s (KEY_NUMBER, KEY_MANDANT, KEY_STATUS, NUM_TOTALVAL, REF_NUMBER, REF_MANDANT, REF_STATUS, REF_REFERER) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", getCurrentTableName(evaluators));
    super.__insert(entity, audit, sql, sequenceSetter, session, debugTextOrNull);

  }

  public void batchInsert(List<Account> listOfEntities, IM3DynamicTableEvaluator[] evaluators, IM3Session session, boolean audit, Object debugTextOrNull) throws DataAccessException {

    int numOfEntities = listOfEntities.size();
    String sql = String.format("INSERT INTO %s (KEY_NUMBER, KEY_MANDANT, KEY_STATUS, NUM_TOTALVAL, REF_NUMBER, REF_MANDANT, REF_STATUS, REF_REFERER) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", getCurrentTableName(evaluators));


    int entityNumIndex = 0;
    for (Account entity : listOfEntities) {

      if (entity.getReadOnly()) {
        throw new IllegalStateException("Batch insert called on entity which was marked as readonly. (key " + entity.getIM3Key() + ", tcn " + entity.getTCN() + ")");
      }

      if (!(entity.getDirty())) {
        throw new IllegalStateException("Batch insert called on entity which was not marked as dirty. (key " + entity.getIM3Key() + ", tcn " + entity.getTCN() + ")");
      }

      // before changing anything in entity, like tcn, audit etc.
      entity.beforeSave();
      if (audit) {
        doInsertAuditForEntity(entity, session);
      }
      entityNumIndex++;
    }

    super.__batchInsert(listOfEntities, numOfEntities, sql, session, debugTextOrNull);
  }

  public void batchUpdate(List<Account> listOfEntities, IM3DynamicTableEvaluator[] evaluators, IM3Session session, boolean audit, Object debugTextOrNull) throws DataAccessException {

    String sql = String.format("UPDATE %s SET NUM_TOTALVAL=?, REF_NUMBER=?, REF_MANDANT=?, REF_STATUS=?, REF_REFERER=? WHERE KEY_NUMBER=? AND KEY_MANDANT=? AND KEY_STATUS=?", getCurrentTableName(evaluators));
    super.__batchUpdate(listOfEntities, audit, sql, session, debugTextOrNull);
  }

  public void delete(final Account entity, IM3DynamicTableEvaluator[] evaluators, IM3Session session, Object debugTextOrNull) throws DataAccessException {

    String sql = String.format("DELETE FROM %s WHERE KEY_NUMBER = ? AND KEY_MANDANT = ? AND KEY_STATUS = ?", getCurrentTableName(evaluators));

    final StringBuilder debugSb = new StringBuilder("Parameters:\n");
    PreparedStatementSetter setter = new PreparedStatementSetter() {
      public void setValues(PreparedStatement preparedStatement) throws SQLException {
        Account account_10 = entity;
        int curCol = 1;
        {
          AccountKey accountkey_0 = account_10.getKey();
          __intTypeHandler.setParameter(preparedStatement, curCol++, accountkey_0.getNumber(), debugSb);
          __stringTypeHandler.setParameter(preparedStatement, curCol++, accountkey_0.getMandant(), debugSb);
          __stringTypeHandler.setParameter(preparedStatement, curCol++, AccountKey_Active.asStringForManmap(accountkey_0.getActive()), debugSb);
        }
      }
    };

    super.__delete(entity, sql, setter, session, debugTextOrNull, debugSb);
  }

  public void reload(final Account entity, IM3DynamicTableEvaluator[] evaluators, final IM3Session session, Object debugTextOrNull) throws DataAccessException {

    String sql = String.format("SELECT iRoot.KEY_NUMBER, iRoot.KEY_MANDANT, iRoot.KEY_STATUS, iRoot.NUM_TOTALVAL, iRoot.REF_NUMBER, iRoot.REF_MANDANT, iRoot.REF_STATUS, iRoot.REF_REFERER FROM %s iRoot WHERE iRoot.KEY_NUMBER =? AND iRoot.KEY_MANDANT =? AND iRoot.KEY_STATUS =? ", getCurrentTableName(evaluators));

    final StringBuilder debugSb = new StringBuilder("Parameters:\n");
    PreparedStatementSetter setter = new PreparedStatementSetter() {
      public void setValues(PreparedStatement preparedStatement) throws SQLException {
        Account account_10 = entity;
        int curCol = 1;
        {
          AccountKey accountkey_0 = account_10.getKey();
          __intTypeHandler.setParameter(preparedStatement, curCol++, accountkey_0.getNumber(), debugSb);
          __stringTypeHandler.setParameter(preparedStatement, curCol++, accountkey_0.getMandant(), debugSb);
          __stringTypeHandler.setParameter(preparedStatement, curCol++, AccountKey_Active.asStringForManmap(accountkey_0.getActive()), debugSb);
        }
      }
    };
    RowMapper mapper = new RowMapper<Account>() {
      public Account mapRow(ResultSet p0, int p1) throws SQLException {
        return MapAccount.this.map(p0, 1, entity);
      }
    };
    super.__reload(entity, sql, setter, mapper, session, debugTextOrNull, debugSb);
  }

  public Account get(final AccountKey outerKey, final boolean readOnly, IM3DynamicTableEvaluator[] evaluators, final IM3Session session, Object debugTextOrNull) {

    // check for null key
    if (((IM3CompoundKey) outerKey).isNullKey()) {
      return null;
    }

    String sql = String.format("SELECT iRoot.KEY_NUMBER, iRoot.KEY_MANDANT, iRoot.KEY_STATUS, iRoot.NUM_TOTALVAL, iRoot.REF_NUMBER, iRoot.REF_MANDANT, iRoot.REF_STATUS, iRoot.REF_REFERER FROM %s iRoot WHERE iRoot.KEY_NUMBER =? AND iRoot.KEY_MANDANT =? AND iRoot.KEY_STATUS =? ", getCurrentTableName(evaluators));

    final StringBuilder debugSb = new StringBuilder("Parameters:\n");
    PreparedStatementSetter setter = new PreparedStatementSetter() {
      public void setValues(PreparedStatement preparedStatement) throws SQLException {
        AccountKey key = outerKey;
        int curCol = 1;
        __intTypeHandler.setParameter(preparedStatement, curCol++, key.getNumber(), debugSb);
        __stringTypeHandler.setParameter(preparedStatement, curCol++, key.getMandant(), debugSb);
        __stringTypeHandler.setParameter(preparedStatement, curCol++, AccountKey_Active.asStringForManmap(key.getActive()), debugSb);
      }
    };
    RowMapper mapper = new RowMapper<Account>() {
      public Account mapRow(ResultSet p0, int p1) throws SQLException {
        return MapAccount.this.map(p0, 1, new Account());
      }
    };

    return super.__get(outerKey, readOnly, sql, setter, mapper, session, debugTextOrNull, debugSb);
  }
}
