package org.modellwerkstatt.objectflow.tests.manmap.Tests;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.CreatorsFactory;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoAuditEntity;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.joda.time.DateTime;
import org.modellwerkstatt.objectflow.runtime.OFXIncludedSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.AuditEntity;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;
import org.joda.time.LocalDate;
import org.modellwerkstatt.objectflow.runtime.IOFXSessionOperation;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;

public class Audit extends OFXTestSuit {

  @Autowired
  private CreatorsFactory __DomainCreatorsFactory;
  @Autowired
  private RepoAuditEntity __DomainRepoAuditEntity;
  @Autowired
  private IOFXPlatform __runtimeIOFXPlatform;
  @Autowired
  private IOFXTranslationProvider __runtimeIOFXTranslationProvider;

  private IOFXUserEnvironment userEnv;
  private int origUserId;
  private DateTime defaultDateTime = new DateTime(1980, 1, 27, 4, 30, 0, 0);
  private DateTime secondModification = new DateTime(1985, 1, 7, 12, 0, 0, 0);

  @OFXIncludedSuit(name = "org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit")
  private DBinit ___inst_DBinit;


  public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
    userEnv = __localApplicationFactory.createNewSession(__userEnvironment, __userServices).getUserEnvironment();
    origUserId = userEnv.getUserId();
  }


  @OFXTestMethod(id = 0, name = "Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    final AuditEntity entity = __DomainCreatorsFactory.createAuditEntity_NOTonDB("audit", __manMapSession);


    {
      DateTime leftSide = entity.getZzCreatedAt();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Audit.Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.':  entity .zzCreatedAt ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      DateTime leftSide = entity.getZzModifiedAt();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Audit.Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.':  entity .zzModifiedAt ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      LocalDate leftSide = entity.getZzCreatedAtLDate();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Audit.Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.':  entity .zzCreatedAtLDate ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      LocalDate leftSide = entity.getZzModifiedAtLDate();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Audit.Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.':  entity .zzModifiedAtLDate ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = entity.getZzCreatedAtUid();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Audit.Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.':  entity .zzCreatedAtUid == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = entity.getZzModifiedAtUid();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Audit.Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.':  entity .zzModifiedAtUid == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    final IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);

    session.addOperation(new IOFXSessionOperation() {
      public void execute() {
        __DomainRepoAuditEntity.checkinAuditEntity(entity, session);
      }
      public String getInformation() {
        return "checking AuditEntity";
      }
    });

    try {
      session.startTransactionAndFlush();
    } catch (Exception ex) {
      throw new RuntimeException(ex);
    }

    AuditEntity reload = __DomainRepoAuditEntity.checkoutAuditEntity(entity.getId(), null);
    {
      DateTime operand = reload.getZzCreatedAt();
      DateTime param0 = defaultDateTime;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Audit.Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.':  reload .zzCreatedAt.equals( defaultDateTime )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      DateTime operand = reload.getZzModifiedAt();
      DateTime param0 = defaultDateTime;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Audit.Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.':  reload .zzModifiedAt.equals( defaultDateTime )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    {
      LocalDate operand = reload.getZzCreatedAtLDate();
      LocalDate param0 = defaultDateTime.toLocalDate();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Audit.Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.':  reload .zzCreatedAtLDate.equals( defaultDateTime .toLocalDate())          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      LocalDate operand = reload.getZzModifiedAtLDate();
      LocalDate param0 = defaultDateTime.toLocalDate();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Audit.Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.':  reload .zzModifiedAtLDate.equals( defaultDateTime .toLocalDate())          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    {
      int leftSide = reload.getZzCreatedAtUid();
      int rightSide = userEnv.getUserId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Audit.Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.':  reload .zzCreatedAtUid ==  userEnv .getUserId()          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = reload.getZzModifiedAtUid();
      int rightSide = userEnv.getUserId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Audit.Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.':  reload .zzModifiedAtUid ==  userEnv .getUserId()          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 1, name = "Update the AuditEntity should change modified Stamps. - LocalDate and DateTime.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    AuditEntity created = __DomainCreatorsFactory.createAuditEntity_onDB("update", __manMapSession);


    DeprecatedServerDateProvider.fixServerDatetimeToConstant(secondModification);
    userEnv.setUserId(4711);

    final IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    final AuditEntity reloaded = __DomainRepoAuditEntity.checkoutAuditEntity(created.getId(), session);

    // mark as dirty
    reloaded.setText("*changed*");

    session.addOperation(new IOFXSessionOperation() {
      public void execute() {
        __DomainRepoAuditEntity.checkinAuditEntity(reloaded, session);
      }
      public String getInformation() {
        return "checking AuditEntity";
      }
    });

    try {
      session.startTransactionAndFlush();
    } catch (Exception ex) {
      throw new RuntimeException(ex);
    } finally {
      // at least set back user ID
      userEnv.setUserId(origUserId);
    }

    AuditEntity reload2 = __DomainRepoAuditEntity.checkoutAuditEntity(reloaded.getId(), null);
    {
      DateTime operand = reload2.getZzCreatedAt();
      DateTime param0 = defaultDateTime;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Audit.Update the AuditEntity should change modified Stamps. - LocalDate and DateTime.':  reload2 .zzCreatedAt.equals( defaultDateTime )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      LocalDate operand = reload2.getZzCreatedAtLDate();
      LocalDate param0 = defaultDateTime.toLocalDate();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Audit.Update the AuditEntity should change modified Stamps. - LocalDate and DateTime.':  reload2 .zzCreatedAtLDate.equals( defaultDateTime .toLocalDate())          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    {
      DateTime operand = reload2.getZzModifiedAt();
      DateTime param0 = secondModification;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Audit.Update the AuditEntity should change modified Stamps. - LocalDate and DateTime.':  reload2 .zzModifiedAt.equals( secondModification )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      LocalDate operand = reload2.getZzModifiedAtLDate();
      LocalDate param0 = secondModification.toLocalDate();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Audit.Update the AuditEntity should change modified Stamps. - LocalDate and DateTime.':  reload2 .zzModifiedAtLDate.equals( secondModification .toLocalDate())          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    {
      int leftSide = reload2.getZzCreatedAtUid();
      int rightSide = origUserId;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Audit.Update the AuditEntity should change modified Stamps. - LocalDate and DateTime.':  reload2 .zzCreatedAtUid ==  origUserId           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = reload2.getZzModifiedAtUid();
      int rightSide = 4711;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Audit.Update the AuditEntity should change modified Stamps. - LocalDate and DateTime.':  reload2 .zzModifiedAtUid == 4711          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 2, name = "Update the AuditEntity should NOT change modified Stamps when not dirty. - LocalDate and DateTime.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_2(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    AuditEntity created = __DomainCreatorsFactory.createAuditEntity_onDB("update", __manMapSession);


    DateTime modifiedAt = new DateTime(1985, 1, 7, 12, 0, 0, 0);
    DeprecatedServerDateProvider.fixServerDatetimeToConstant(modifiedAt);
    userEnv.setUserId(4711);

    final IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    final AuditEntity reloaded = __DomainRepoAuditEntity.checkoutAuditEntity(created.getId(), session);

    session.addOperation(new IOFXSessionOperation() {
      public void execute() {
        __DomainRepoAuditEntity.checkinAuditEntity(reloaded, session);
      }
      public String getInformation() {
        return "checking AuditEntity";
      }
    });

    try {
      session.startTransactionAndFlush();
    } catch (Exception ex) {
      throw new RuntimeException(ex);
    } finally {
      // TODO: at least set back user ID
      // TODO: but at end of test?
      userEnv.setUserId(origUserId);
    }

    AuditEntity reload2 = __DomainRepoAuditEntity.checkoutAuditEntity(reloaded.getId(), null);
    {
      DateTime operand = reload2.getZzCreatedAt();
      DateTime param0 = defaultDateTime;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Audit.Update the AuditEntity should NOT change modified Stamps when not dirty. - LocalDate and DateTime.':  reload2 .zzCreatedAt.equals( defaultDateTime )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      DateTime operand = reload2.getZzModifiedAt();
      DateTime param0 = defaultDateTime;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Audit.Update the AuditEntity should NOT change modified Stamps when not dirty. - LocalDate and DateTime.':  reload2 .zzModifiedAt.equals( defaultDateTime )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    {
      LocalDate operand = reload2.getZzCreatedAtLDate();
      LocalDate param0 = defaultDateTime.toLocalDate();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Audit.Update the AuditEntity should NOT change modified Stamps when not dirty. - LocalDate and DateTime.':  reload2 .zzCreatedAtLDate.equals( defaultDateTime .toLocalDate())          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      LocalDate operand = reload2.getZzModifiedAtLDate();
      LocalDate param0 = defaultDateTime.toLocalDate();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Audit.Update the AuditEntity should NOT change modified Stamps when not dirty. - LocalDate and DateTime.':  reload2 .zzModifiedAtLDate.equals( defaultDateTime .toLocalDate())          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    {
      int leftSide = reload2.getZzCreatedAtUid();
      int rightSide = origUserId;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Audit.Update the AuditEntity should NOT change modified Stamps when not dirty. - LocalDate and DateTime.':  reload2 .zzCreatedAtUid ==  origUserId           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = reload2.getZzModifiedAtUid();
      int rightSide = origUserId;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Audit.Update the AuditEntity should NOT change modified Stamps when not dirty. - LocalDate and DateTime.':  reload2 .zzModifiedAtUid ==  origUserId           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 3, name = "Update the AuditEntity should change modified Stamps when not dirty (forced) - LocalDate and DateTime.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_3(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    AuditEntity created = __DomainCreatorsFactory.createAuditEntity_onDB("update", __manMapSession);


    DateTime modifiedAt = new DateTime(1985, 1, 7, 12, 0, 0, 0);
    DeprecatedServerDateProvider.fixServerDatetimeToConstant(modifiedAt);
    userEnv.setUserId(4711);

    final IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    final AuditEntity reloaded = __DomainRepoAuditEntity.checkoutAuditEntity(created.getId(), session);

    session.addOperation(new IOFXSessionOperation() {
      public void execute() {
        __DomainRepoAuditEntity.checkinAuditEntityForceAudit(reloaded, session);
      }
      public String getInformation() {
        return "checking AuditEntity";
      }
    });

    try {
      session.startTransactionAndFlush();
    } catch (Exception ex) {
      throw new RuntimeException(ex);
    } finally {
      // TODO: at least set back user ID
      // TODO: but at end of test?
      userEnv.setUserId(origUserId);
    }

    AuditEntity reload2 = __DomainRepoAuditEntity.checkoutAuditEntity(reloaded.getId(), null);
    {
      DateTime operand = reload2.getZzCreatedAt();
      DateTime param0 = defaultDateTime;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Audit.Update the AuditEntity should change modified Stamps when not dirty (forced) - LocalDate and DateTime.':  reload2 .zzCreatedAt.equals( defaultDateTime )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      DateTime operand = reload2.getZzModifiedAt();
      DateTime param0 = modifiedAt;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Audit.Update the AuditEntity should change modified Stamps when not dirty (forced) - LocalDate and DateTime.':  reload2 .zzModifiedAt.equals( modifiedAt )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    {
      LocalDate operand = reload2.getZzCreatedAtLDate();
      LocalDate param0 = defaultDateTime.toLocalDate();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Audit.Update the AuditEntity should change modified Stamps when not dirty (forced) - LocalDate and DateTime.':  reload2 .zzCreatedAtLDate.equals( defaultDateTime .toLocalDate())          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      LocalDate operand = reload2.getZzModifiedAtLDate();
      LocalDate param0 = modifiedAt.toLocalDate();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Audit.Update the AuditEntity should change modified Stamps when not dirty (forced) - LocalDate and DateTime.':  reload2 .zzModifiedAtLDate.equals( modifiedAt .toLocalDate())          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    {
      int leftSide = reload2.getZzCreatedAtUid();
      int rightSide = origUserId;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Audit.Update the AuditEntity should change modified Stamps when not dirty (forced) - LocalDate and DateTime.':  reload2 .zzCreatedAtUid ==  origUserId           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = reload2.getZzModifiedAtUid();
      int rightSide = 4711;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Audit.Update the AuditEntity should change modified Stamps when not dirty (forced) - LocalDate and DateTime.':  reload2 .zzModifiedAtUid == 4711          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 4, name = "Update the AuditEntity should NOT change modified Stamps (skiped) - LocalDate and DateTime.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_4(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    AuditEntity created = __DomainCreatorsFactory.createAuditEntity_onDB("update", __manMapSession);


    DateTime modifiedAt = new DateTime(1985, 1, 7, 12, 0, 0, 0);
    DeprecatedServerDateProvider.fixServerDatetimeToConstant(modifiedAt);
    userEnv.setUserId(4711);

    final IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    final AuditEntity reloaded = __DomainRepoAuditEntity.checkoutAuditEntity(created.getId(), session);

    reloaded.setText("*changed*");

    session.addOperation(new IOFXSessionOperation() {
      public void execute() {
        __DomainRepoAuditEntity.checkinAuditEntitySkipAudit(reloaded, session);
      }
      public String getInformation() {
        return "checking AuditEntity";
      }
    });

    try {
      session.startTransactionAndFlush();
    } catch (Exception ex) {
      throw new RuntimeException(ex);
    } finally {
      // TODO: at least set back user ID
      // TODO: but at end of test?
      userEnv.setUserId(origUserId);
    }

    AuditEntity reload2 = __DomainRepoAuditEntity.checkoutAuditEntity(reloaded.getId(), null);
    {
      DateTime operand = reload2.getZzCreatedAt();
      DateTime param0 = defaultDateTime;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Audit.Update the AuditEntity should NOT change modified Stamps (skiped) - LocalDate and DateTime.':  reload2 .zzCreatedAt.equals( defaultDateTime )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      DateTime operand = reload2.getZzModifiedAt();
      DateTime param0 = defaultDateTime;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Audit.Update the AuditEntity should NOT change modified Stamps (skiped) - LocalDate and DateTime.':  reload2 .zzModifiedAt.equals( defaultDateTime )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    {
      LocalDate operand = reload2.getZzCreatedAtLDate();
      LocalDate param0 = defaultDateTime.toLocalDate();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Audit.Update the AuditEntity should NOT change modified Stamps (skiped) - LocalDate and DateTime.':  reload2 .zzCreatedAtLDate.equals( defaultDateTime .toLocalDate())          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      LocalDate operand = reload2.getZzModifiedAtLDate();
      LocalDate param0 = defaultDateTime.toLocalDate();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Audit.Update the AuditEntity should NOT change modified Stamps (skiped) - LocalDate and DateTime.':  reload2 .zzModifiedAtLDate.equals( defaultDateTime .toLocalDate())          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    {
      int leftSide = reload2.getZzCreatedAtUid();
      int rightSide = origUserId;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Audit.Update the AuditEntity should NOT change modified Stamps (skiped) - LocalDate and DateTime.':  reload2 .zzCreatedAtUid ==  origUserId           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = reload2.getZzModifiedAtUid();
      int rightSide = origUserId;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Audit.Update the AuditEntity should NOT change modified Stamps (skiped) - LocalDate and DateTime.':  reload2 .zzModifiedAtUid ==  origUserId           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 5, name = "newDateTimeFromServer(): Get a DB Hit - assuming it is not in Sync with local time. ", debug = false, enabled = true, runAt = "")
  public void __testmethod_5(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    DateTime dt = DeprecatedServerDateProvider.getSqlServerDateTime();
    long localMillis = System.currentTimeMillis();

    {
      long leftSide = Math.abs(dt.getMillis() - localMillis);
      int rightSide = 30;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'Audit.newDateTimeFromServer(): Get a DB Hit - assuming it is not in Sync with local time. ': Math.abs( dt .getMillis() -  localMillis ) > 30          ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }

    // but not more then approx 5 Minutes?
    {
      long leftSide = Math.abs(dt.getMillis() - localMillis);
      int rightSide = 60000 * 5;
      if (!(leftSide < rightSide)) {
        throw new OFXTestSuitException("'Audit.newDateTimeFromServer(): Get a DB Hit - assuming it is not in Sync with local time. ': Math.abs( dt .getMillis() -  localMillis ) < 60000 * 5          ==>>" + leftSide + " <" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 6, name = "newDateTimeFromServer(): Hitting it 1000 times is quite fast. ", debug = false, enabled = true, runAt = "")
  public void __testmethod_6(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    DateTime dt = DeprecatedServerDateProvider.getSqlServerDateTime();
    long currentMillis = System.currentTimeMillis();

    for (int i = 1; i < 100000; i++) {
      DateTime tmpDateTime = DeprecatedServerDateProvider.getSqlServerDateTime();
      if (tmpDateTime.getMinuteOfHour() > 100) {
        throw new RuntimeException("This can not happen. Prevent optimization.");
      }

    }
    {
      long leftSide = currentMillis - System.currentTimeMillis();
      int rightSide = 5;
      if (!(leftSide < rightSide)) {
        throw new OFXTestSuitException("'Audit.newDateTimeFromServer(): Hitting it 1000 times is quite fast. ':  currentMillis  - System.currentTimeMillis() < 5          ==>>" + leftSide + " <" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 7, name = "newDateTimeFromServer(): Hitting continiously the db. ", debug = false, enabled = true, runAt = "")
  public void __testmethod_7(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    long was = DeprecatedServerDateProvider.REORGANIZE_TIMESTAMP_FROM_DB_INTERVALL;
    try {
      DeprecatedServerDateProvider.REORGANIZE_TIMESTAMP_FROM_DB_INTERVALL = 0;

      long startTime = System.currentTimeMillis();

      for (int i = 1; i < 1000; i++) {

        DateTime tmpDateTime = DeprecatedServerDateProvider.getSqlServerDateTime();

        if (tmpDateTime.getMinuteOfHour() > 100) {
          throw new RuntimeException("This can not happen. Prevent optimization.");
        }

      }
      {
        long leftSide = System.currentTimeMillis() - startTime;
        int rightSide = 100;
        if (!(leftSide > rightSide)) {
          throw new OFXTestSuitException("'Audit.newDateTimeFromServer(): Hitting continiously the db. ': System.currentTimeMillis() -  startTime  > 100          ==>>" + leftSide + " >" + rightSide + "\n");
        }
      }

    } finally {
      DeprecatedServerDateProvider.REORGANIZE_TIMESTAMP_FROM_DB_INTERVALL = was;

    }

  }


  public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  public static void main(String[] args) {
    String[] allIncludedTest = new String[]{"org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit"};
    String[] includedTestToRun = new String[]{};

    OFXTestSuit.runAsMain("org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", Audit.class, allIncludedTest, includedTestToRun);
  }
}
