package org.modellwerkstatt.objectflow.tests.manmap.Tests;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;
import org.modellwerkstatt.objectflow.tests.manmap.ZMixedNewer.BlobEntityFactory;
import org.modellwerkstatt.objectflow.tests.manmap.ZMixedNewer.BlobEntityRepo;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.OFXIncludedSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import org.modellwerkstatt.objectflow.tests.manmap.ZMixedNewer.BlobEntity;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;

public class Blob_Support extends OFXTestSuit {

  @Autowired
  private BlobEntityFactory __ZMixedNewerBlobEntityFactory;
  @Autowired
  private BlobEntityRepo __ZMixedNewerBlobEntityRepo;
  @Autowired
  private IOFXPlatform __runtimeIOFXPlatform;
  @Autowired
  private IOFXTranslationProvider __runtimeIOFXTranslationProvider;


  @OFXIncludedSuit(name = "org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit")
  private DBinit ___inst_DBinit;


  public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  @OFXTestMethod(id = 0, name = "Store and retrieve Blob Entity", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    BlobEntity blob = __ZMixedNewerBlobEntityFactory.createBlobWith2Pos_onDB("store", __manMapSession);

    BlobEntity reloaded = __ZMixedNewerBlobEntityRepo.checkoutBlobEntity(blob.getId(), __manMapSession);
    {
      int leftSide = ListSequence.fromList(reloaded.getPositions()).count();
      int rightSide = 2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Blob Support.Store and retrieve Blob Entity':  reloaded .positions.size == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String operand = blob.getText();
      String param0 = "store";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Blob Support.Store and retrieve Blob Entity':  blob .text.equals(\"store\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    String st = new String(blob.getBlob());
    {
      String operand = st;
      String param0 = "the BLOB field for";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.contains(param0))) {
        throw new OFXTestSuitException("'Blob Support.Store and retrieve Blob Entity':  st .contains(\"the BLOB field for\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
      }
    }
    if (!(ListSequence.fromList(reloaded.getPositions()).all((it) -> (new String(it.getPosBlob())).contains("some BLOB for pos")))) {
      throw new OFXTestSuitException("'Blob Support.Store and retrieve Blob Entity':  reloaded .positions.all          ==>> FALSE !" + "\n");
    }

  }
  @OFXTestMethod(id = 1, name = "Store and retrieve Blob Entity - Take 2", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    BlobEntity blob = __ZMixedNewerBlobEntityFactory.createBlobWith2Pos_onDB("retrieve", __manMapSession);

    BlobEntity reloaded = __ZMixedNewerBlobEntityRepo.checkoutBlobEntity(blob.getId(), __manMapSession);
    {
      int leftSide = ListSequence.fromList(reloaded.getPositions()).count();
      int rightSide = 2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Blob Support.Store and retrieve Blob Entity - Take 2':  reloaded .positions.size == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String operand = blob.getText();
      String param0 = "retrieve";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Blob Support.Store and retrieve Blob Entity - Take 2':  blob .text.equals(\"retrieve\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    String st = new String(blob.getBlob());
    {
      boolean leftSide = st.contains("the BLOB field for");
      boolean rightSide = st.contains("retrieve");
    }
    if (!(ListSequence.fromList(reloaded.getPositions()).all((it) -> {
      String posSt = new String(it.getPosBlob());
      return posSt.contains("some BLOB for pos") && posSt.contains("retrieve");
    }))) {
      throw new OFXTestSuitException("'Blob Support.Store and retrieve Blob Entity - Take 2':  reloaded .positions.all          ==>> FALSE !" + "\n");
    }

    {
      boolean leftSide = __ZMixedNewerBlobEntityRepo.countBlobEntities(__manMapSession) == 2;
      boolean rightSide = __ZMixedNewerBlobEntityRepo.countBlobPos(__manMapSession) == 4;
    }
  }
  @OFXTestMethod(id = 2, name = "Retrieve Blob Entity with = comparison", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_2(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {



    BlobEntity blob = __ZMixedNewerBlobEntityFactory.createBlobWith2Pos_onDB("query", __manMapSession);

    // NOT Supported by oracle !
  }


  public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  public static void main(String[] args) {
    String[] allIncludedTest = new String[]{"org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit"};
    String[] includedTestToRun = new String[]{};

    OFXTestSuit.runAsMain("org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", Blob_Support.class, allIncludedTest, includedTestToRun);
  }
}
