package org.modellwerkstatt.objectflow.tests.manmap.Tests;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.CreatorsFactory;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoCustomSql;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoCustomSqlNP;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoInvoice;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.manmap.runtime.IM3DatabaseDescription;
import org.modellwerkstatt.objectflow.runtime.OFXIncludedSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.AuditEntity;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import java.math.BigDecimal;
import org.joda.time.LocalDate;
import org.joda.time.DateTime;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Invoice_HeadState;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Invoice;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;

public class CustomSQL extends OFXTestSuit {

  @Autowired
  private CreatorsFactory __DomainCreatorsFactory;
  @Autowired
  private RepoCustomSql __DomainRepoCustomSql;
  @Autowired
  private RepoCustomSqlNP __DomainRepoCustomSqlNP;
  @Autowired
  private RepoInvoice __DomainRepoInvoice;
  @Autowired
  private IOFXPlatform __runtimeIOFXPlatform;
  @Autowired
  private IOFXTranslationProvider __runtimeIOFXTranslationProvider;

  @Autowired
  private IM3DatabaseDescription dbDesc;

  @OFXIncludedSuit(name = "org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit")
  private DBinit ___inst_DBinit;


  public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  @OFXTestMethod(id = 0, name = "Simply query for int with plain sql.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    AuditEntity obj = __DomainCreatorsFactory.createAuditEntity_onDB("simple", __manMapSession);


    int numOfRecords;
    numOfRecords = __DomainRepoCustomSql.getCountOfAuditEntities(null);

    {
      int leftSide = numOfRecords;
      int rightSide = 0;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'CustomSQL.Simply query for int with plain sql.':  numOfRecords  > 0          ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 1, name = "Using Custom SQL to load an AuditEntity.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    AuditEntity obj = __DomainCreatorsFactory.createAuditEntity_onDB("numeric", __manMapSession);


    AuditEntity reload = __DomainRepoCustomSql.findAuditEntityById_numericInterface(obj.getId(), null);
    {
      String operand = reload.getText();
      String param0 = "numeric";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'CustomSQL.Using Custom SQL to load an AuditEntity.':  reload .text.equals(\"numeric\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 2, name = "Use new mapper interface to load entity.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_2(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    AuditEntity obj = __DomainCreatorsFactory.createAuditEntity_onDB("newstyle", __manMapSession);


    AuditEntity reloaded = __DomainRepoCustomSql.findAuditEntitybyId_combinedSQL(obj.getId(), null);

    {
      String operand = reloaded.getText();
      String param0 = "newstyle";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'CustomSQL.Use new mapper interface to load entity.':  reloaded .text.equals(\"newstyle\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 3, name = "Use new mapper interface to load entity - combined sql.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_3(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    AuditEntity obj = __DomainCreatorsFactory.createAuditEntity_onDB("newstyle", __manMapSession);


    AuditEntity reloaded = __DomainRepoCustomSql.findIntkeyObjectById_combinedsqlAlternative(obj.getId(), null);

    {
      String operand = reloaded.getText();
      String param0 = "newstyle";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'CustomSQL.Use new mapper interface to load entity - combined sql.':  reloaded .text.equals(\"newstyle\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 4, name = "Use numeric interface to load a list of AuditEntities", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_4(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    final AuditEntity obj = __DomainCreatorsFactory.createAuditEntity_onDB("oldstyle1", __manMapSession);
    final AuditEntity obj1 = __DomainCreatorsFactory.createAuditEntity_onDB("oldstyle2", __manMapSession);
    final AuditEntity obj2 = __DomainCreatorsFactory.createAuditEntity_onDB("oldstyle3", __manMapSession);


    List<AuditEntity> objects = __DomainRepoCustomSql.findAllAuditEntities_numericInterface(null);
    {
      int leftSide = ListSequence.fromList(objects).where((it) -> it.getId() == obj.getId() || it.getId() == obj1.getId() || it.getId() == obj2.getId()).count();
      int rightSide = 3;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'CustomSQL.Use numeric interface to load a list of AuditEntities':  objects .where.size == 3          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 5, name = "Issue an update call in plain sql.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_5(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    AuditEntity obj = __DomainCreatorsFactory.createAuditEntity_onDB("inserted", __manMapSession);


    {
      boolean leftSide = obj.getId() > 0;
      boolean rightSide = obj.getText().equals("inserted");
    }

    obj.setText("plainsql");
    __DomainRepoCustomSql.updateTextInAuditEntityPlainSQL(obj, null);

    AuditEntity reloded = __DomainRepoCustomSql.findAuditEntitybyId_combinedSQL(obj.getId(), null);
    {
      String operand = reloded.getText();
      String param0 = "plainsql";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'CustomSQL.Issue an update call in plain sql.':  reloded .text.equals(\"plainsql\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 6, name = "Find AuditEntity plain sql with some params.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_6(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    AuditEntity obj = __DomainCreatorsFactory.createAuditEntity_onDB("params", __manMapSession);


    List<AuditEntity> reloaded = __DomainRepoCustomSql.findAuditEntitiesWithSomeParams(obj.getId(), obj.getZzCreatedAt(), obj.getOnOff(), null);
    {
      int leftSide = ListSequence.fromList(reloaded).count();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'CustomSQL.Find AuditEntity plain sql with some params.':  reloaded .size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String operand = ListSequence.fromList(reloaded).getElement(0).getText();
      String param0 = "params";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'CustomSQL.Find AuditEntity plain sql with some params.':  reloaded .get.text.equals(\"params\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 7, name = "MapSELECT should report nice messages on errors.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_7(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    if (dbDesc.needsIdSelectPost()) {
      // MySQL Case
      {
        boolean __FailIn_catched = false;
        boolean __FailIn_text = true;
        Throwable __FailIn_origThrowable = null;
        String messagesInProblems = "";

        try {
          __DomainRepoCustomSql.mapSelectError("DAN", null);

        } catch (RuntimeException ex) {
          __FailIn_origThrowable = ex;
          __FailIn_catched = true;
          messagesInProblems = ex.getMessage();

          __FailIn_text = false;
          if (messagesInProblems == null) {
            messagesInProblems = "";
          }
          if (messagesInProblems.contains("bad SQL grammar")) {
            __FailIn_text = true;

          } else {
            // down ward compatibility for OFXAbortException
            messagesInProblems += "\n";
            List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
            for (IOFXProblem problem : allProblems) {
              messagesInProblems += problem.getSimpleUserText() + "\n";
              if (problem.getSimpleUserText().contains("bad SQL grammar")) {
                __FailIn_text = true;
                break;
              }
            }
          }

        } catch (Throwable t) {
          throw new RuntimeException(t);

        } finally {
          // check also loop in map_OFXTestSuit

          if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
            throw new OFXTestSuitException("'CustomSQL.MapSELECT should report nice messages on errors.': Fail In Exception RuntimeException was NOT catched!");

          } else if (__FailIn_catched && !(__FailIn_text)) {
            throw new OFXTestSuitException("'CustomSQL.MapSELECT should report nice messages on errors.': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

          } else if (!(__FailIn_catched)) {
            throw new OFXTestSuitException("'CustomSQL.MapSELECT should report nice messages on errors.': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
          }

        }

      }

    } else {
      // Oracle Case
      {
        boolean __FailIn_catched = false;
        boolean __FailIn_text = true;
        Throwable __FailIn_origThrowable = null;
        String messagesInProblems = "";

        try {
          __DomainRepoCustomSql.mapSelectError("DAN", null);

        } catch (RuntimeException ex) {
          __FailIn_origThrowable = ex;
          __FailIn_catched = true;
          messagesInProblems = ex.getMessage();

          __FailIn_text = false;
          if (messagesInProblems == null) {
            messagesInProblems = "";
          }
          if (messagesInProblems.contains("ORA-00936")) {
            __FailIn_text = true;

          } else {
            // down ward compatibility for OFXAbortException
            messagesInProblems += "\n";
            List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
            for (IOFXProblem problem : allProblems) {
              messagesInProblems += problem.getSimpleUserText() + "\n";
              if (problem.getSimpleUserText().contains("ORA-00936")) {
                __FailIn_text = true;
                break;
              }
            }
          }

        } catch (Throwable t) {
          throw new RuntimeException(t);

        } finally {
          // check also loop in map_OFXTestSuit

          if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
            throw new OFXTestSuitException("'CustomSQL.MapSELECT should report nice messages on errors.': Fail In Exception RuntimeException was NOT catched!");

          } else if (__FailIn_catched && !(__FailIn_text)) {
            throw new OFXTestSuitException("'CustomSQL.MapSELECT should report nice messages on errors.': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

          } else if (!(__FailIn_catched)) {
            throw new OFXTestSuitException("'CustomSQL.MapSELECT should report nice messages on errors.': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
          }

        }

      }
    }

  }
  @OFXTestMethod(id = 8, name = "MapUPDATE should report nice messages on errors.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_8(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    if (dbDesc.needsIdSelectPost()) {
      {
        boolean __FailIn_catched = false;
        boolean __FailIn_text = true;
        Throwable __FailIn_origThrowable = null;
        String messagesInProblems = "";

        try {
          __DomainRepoCustomSql.mapUpdateError("DAN", null);

        } catch (RuntimeException ex) {
          __FailIn_origThrowable = ex;
          __FailIn_catched = true;
          messagesInProblems = ex.getMessage();

          __FailIn_text = false;
          if (messagesInProblems == null) {
            messagesInProblems = "";
          }
          if (messagesInProblems.contains("bad SQL grammar")) {
            __FailIn_text = true;

          } else {
            // down ward compatibility for OFXAbortException
            messagesInProblems += "\n";
            List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
            for (IOFXProblem problem : allProblems) {
              messagesInProblems += problem.getSimpleUserText() + "\n";
              if (problem.getSimpleUserText().contains("bad SQL grammar")) {
                __FailIn_text = true;
                break;
              }
            }
          }

        } catch (Throwable t) {
          throw new RuntimeException(t);

        } finally {
          // check also loop in map_OFXTestSuit

          if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
            throw new OFXTestSuitException("'CustomSQL.MapUPDATE should report nice messages on errors.': Fail In Exception RuntimeException was NOT catched!");

          } else if (__FailIn_catched && !(__FailIn_text)) {
            throw new OFXTestSuitException("'CustomSQL.MapUPDATE should report nice messages on errors.': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

          } else if (!(__FailIn_catched)) {
            throw new OFXTestSuitException("'CustomSQL.MapUPDATE should report nice messages on errors.': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
          }

        }

      }

    } else {
      {
        boolean __FailIn_catched = false;
        boolean __FailIn_text = true;
        Throwable __FailIn_origThrowable = null;
        String messagesInProblems = "";

        try {
          __DomainRepoCustomSql.mapUpdateError("DAN", null);

        } catch (RuntimeException ex) {
          __FailIn_origThrowable = ex;
          __FailIn_catched = true;
          messagesInProblems = ex.getMessage();

          __FailIn_text = false;
          if (messagesInProblems == null) {
            messagesInProblems = "";
          }
          if (messagesInProblems.contains("ORA-00971")) {
            __FailIn_text = true;

          } else {
            // down ward compatibility for OFXAbortException
            messagesInProblems += "\n";
            List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
            for (IOFXProblem problem : allProblems) {
              messagesInProblems += problem.getSimpleUserText() + "\n";
              if (problem.getSimpleUserText().contains("ORA-00971")) {
                __FailIn_text = true;
                break;
              }
            }
          }

        } catch (Throwable t) {
          throw new RuntimeException(t);

        } finally {
          // check also loop in map_OFXTestSuit

          if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
            throw new OFXTestSuitException("'CustomSQL.MapUPDATE should report nice messages on errors.': Fail In Exception RuntimeException was NOT catched!");

          } else if (__FailIn_catched && !(__FailIn_text)) {
            throw new OFXTestSuitException("'CustomSQL.MapUPDATE should report nice messages on errors.': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

          } else if (!(__FailIn_catched)) {
            throw new OFXTestSuitException("'CustomSQL.MapUPDATE should report nice messages on errors.': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
          }

        }

      }

    }


  }
  @OFXTestMethod(id = 9, name = "MapUPDATE can be used also without return value.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_9(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    __DomainRepoCustomSql.mapUpdateWithoutReturnValue(null);
  }
  @OFXTestMethod(id = 10, name = "Query by all types for the 47000000 invoice", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_10(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    {
      int leftSide = __DomainRepoCustomSqlNP.queryByAllTypes(47000000, "Invoice", new BigDecimal("60.0"), new LocalDate(2016, 9, 21), new DateTime(2016, 9, 21, 0, 0, 0, 0), Invoice_HeadState.STAT1, __manMapSession);
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'CustomSQL.Query by all types for the 47000000 invoice': #RepoCustomSqlNP.queryByAllTypes(47000000, \"Invoice\", 60.0bd,  new_LocalDateFromServer ,  new_DateTimeFromServer , \"HeadState.stat1\") == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 11, name = "Named Parameter Test - multiple named params used in query", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_11(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    {
      int leftSide = __DomainRepoCustomSqlNP.namedParamTest(47000001, 8, __manMapSession);
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - multiple named params used in query': #RepoCustomSqlNP.namedParamTest(47000001, 8) == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 12, name = "Named Parameter Test - Query by all types for the 47000000 invoice", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_12(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    {
      int leftSide = __DomainRepoCustomSqlNP.queryByAllTypes(47000000, "Invoice", new BigDecimal("60.0"), new LocalDate(2016, 9, 21), new DateTime(2016, 9, 21, 0, 0, 0, 0), Invoice_HeadState.STAT1, __manMapSession);
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - Query by all types for the 47000000 invoice': #RepoCustomSqlNP.queryByAllTypes(47000000, \"Invoice\", 60.0bd,  new_LocalDateFromServer ,  new_DateTimeFromServer , \"HeadState.stat1\") == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 13, name = "Named Parameter Test - INSERT invoice with MapUPDATE", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_13(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    int key = __DomainRepoCustomSqlNP.insertInvoice(__manMapSession);
    {
      int leftSide = key;
      int rightSide = 0;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - INSERT invoice with MapUPDATE':  key  > 0          ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }

    Invoice inv = __DomainRepoInvoice.checkoutInvoiceByIdWithoutRefs(key, __manMapSession);
    {
      IOFXMetaStatus.IOFXStatusElement operand = inv.getHeadState();
      if (!(SaveObjectComperator.equalsStatus(operand, Invoice_HeadState.STAT2))) {
        throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - INSERT invoice with MapUPDATE':  inv .headState of stat2           ==>>" + operand + "\n");
      }
    }
  }
  @OFXTestMethod(id = 14, name = "Named Parameter Test - UPDATE invoice with MapUPDATE", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_14(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    int key2 = __DomainRepoCustomSqlNP.insertInvoice(__manMapSession);
    __DomainRepoCustomSqlNP.updateInvoice(key2, __manMapSession);

    Invoice inv = __DomainRepoInvoice.checkoutInvoiceByIdWithoutRefs(key2, __manMapSession);
    {
      IOFXMetaStatus.IOFXStatusElement operand = inv.getHeadState();
      if (!(SaveObjectComperator.equalsStatus(operand, Invoice_HeadState.STAT2))) {
        throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - UPDATE invoice with MapUPDATE':  inv .headState of stat2           ==>>" + operand + "\n");
      }
    }
    {
      String operand = inv.getText();
      String param0 = "some text";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - UPDATE invoice with MapUPDATE':  inv .text.equals(\"some text\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = inv.getName();
      String param0 = "some text 2";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - UPDATE invoice with MapUPDATE':  inv .name.equals(\"some text 2\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      BigDecimal leftSide = inv.getTotalAmount();
      BigDecimal rightSide = new BigDecimal("11.11");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - UPDATE invoice with MapUPDATE':  inv .totalAmount == 11.11bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 15, name = "Named Parameter Test - Check for escape of : when used in ''", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_15(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    DateTime t = __DomainRepoCustomSqlNP.checkForEscapeFeature(__manMapSession);
    {
      int leftSide = t.compareTo(new DateTime(2015, 5, 15, 8, 30, 25, 0));
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - Check for escape of : when used in ''':  t .compareTo( new_DateTimeFromServer ) == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 16, name = "NPE from 22. Apr. 24''", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_16(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    __DomainRepoCustomSqlNP.checkForNPParameterNull(null, __manMapSession);
  }
  @OFXTestMethod(id = 17, name = "Named Parameter Test - with dynamic named parameters.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_17(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    int key2 = __DomainRepoCustomSqlNP.insertInvoice(__manMapSession);
    __DomainRepoCustomSqlNP.updateInvoiceWithDynParams(key2, __manMapSession);

    Invoice inv = __DomainRepoInvoice.checkoutInvoiceByIdWithoutRefs(key2, __manMapSession);
    {
      IOFXMetaStatus.IOFXStatusElement operand = inv.getHeadState();
      if (!(SaveObjectComperator.equalsStatus(operand, Invoice_HeadState.STAT2))) {
        throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - with dynamic named parameters.':  inv .headState of stat2           ==>>" + operand + "\n");
      }
    }
    {
      String operand = inv.getText();
      String param0 = "dyn params";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - with dynamic named parameters.':  inv .text.equals(\"dyn params\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = inv.getName();
      String param0 = "dyn params 2";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - with dynamic named parameters.':  inv .name.equals(\"dyn params 2\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      BigDecimal leftSide = inv.getTotalAmount();
      BigDecimal rightSide = new BigDecimal("27.80");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - with dynamic named parameters.':  inv .totalAmount == 27.80bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }


  public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  public static void main(String[] args) {
    String[] allIncludedTest = new String[]{"org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit"};
    String[] includedTestToRun = new String[]{};

    OFXTestSuit.runAsMain("org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", CustomSQL.class, allIncludedTest, includedTestToRun);
  }
}
