package org.modellwerkstatt.objectflow.tests.manmap.Tests;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.CreatorsFactory;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoInvoice;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.SessionLess;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoReferer;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoAccountAudit;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.NewInvRepo;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.manmap.runtime.IM3DatabaseDescription;
import org.modellwerkstatt.objectflow.runtime.OFXIncludedSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Invoice;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Invoice_HeadState;
import org.joda.time.DateTime;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import org.joda.time.LocalDate;
import java.math.BigDecimal;
import org.modellwerkstatt.manmap.runtime.IM3Entity;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.InvoicePosition;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.ExtendedInvoice;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.runtime.OFXIllegalAccessException;
import org.springframework.jdbc.IncorrectResultSetColumnCountException;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Referer;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Account;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.AccountKey_Active;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import org.springframework.jdbc.BadSqlGrammarException;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.NewInvoice;
import org.springframework.jdbc.UncategorizedSQLException;
import jetbrains.mps.references.BLOperations;
import org.springframework.dao.DuplicateKeyException;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.NewInvoicePos;
import org.modellwerkstatt.objectflow.runtime.IOFXEntity;

public class Graph_load_save__no_session_ extends OFXTestSuit {

  @Autowired
  private CreatorsFactory __DomainCreatorsFactory;
  @Autowired
  private RepoInvoice __DomainRepoInvoice;
  @Autowired
  private SessionLess __DomainSessionLess;
  @Autowired
  private RepoReferer __DomainRepoReferer;
  @Autowired
  private RepoAccountAudit __DomainRepoAccountAudit;
  @Autowired
  private NewInvRepo __DomainNewInvRepo;
  @Autowired
  private IOFXPlatform __runtimeIOFXPlatform;
  @Autowired
  private IOFXTranslationProvider __runtimeIOFXTranslationProvider;

  @Autowired
  private IM3DatabaseDescription dpDesc;

  @OFXIncludedSuit(name = "org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit")
  private DBinit ___inst_DBinit;


  public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  @OFXTestMethod(id = 0, name = "Store and Load Invoices by Graph get/where", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("first", __manMapSession);
    Invoice inv2 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("second", __manMapSession);
    Invoice inv3 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("third", __manMapSession);




    // load 3 invoices and compare them with standard graph.
    Invoice reloaded1 = __DomainRepoInvoice.checkoutInvoiceByIdWithoutRefs(inv1.getId(), null);
    {
      String operand = reloaded1.getName();
      String param0 = "first";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Invoices by Graph get/where':  reloaded1 .name.equals(\"first\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      IOFXMetaStatus.IOFXStatusElement operand = reloaded1.getHeadState();
      if (!(SaveObjectComperator.equalsStatus(operand, Invoice_HeadState.STAT1))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Invoices by Graph get/where':  reloaded1 .headState of stat1           ==>>" + operand + "\n");
      }
    }
    {
      int leftSide = reloaded1.getNameLen();
      int rightSide = "first".length();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Invoices by Graph get/where':  reloaded1 .nameLen == \"first\".length()          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = reloaded1.getMoneyAmount().getVal();
      int rightSide = 100;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Invoices by Graph get/where':  reloaded1 .moneyAmount.val == 100          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      DateTime operand = reloaded1.getDateTime();
      DateTime param0 = DeprecatedServerDateProvider.getSqlServerDateTime();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Invoices by Graph get/where':  reloaded1 .dateTime.equals( new_DateTimeFromServer )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      LocalDate operand = reloaded1.getLocalDate();
      LocalDate param0 = DeprecatedServerDateProvider.getSqlServerLocalDate();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Invoices by Graph get/where':  reloaded1 .localDate.equals( new_LocalDateFromServer )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    reloaded1.complete();
    {
      BigDecimal leftSide = reloaded1.getTotalAmount();
      BigDecimal rightSide = new BigDecimal("60.0");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Invoices by Graph get/where':  reloaded1 .totalAmount == 60.0bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    Invoice reloaded2 = __DomainRepoInvoice.checkoutInvoiceByIdWithoutRefs(inv2.getId(), null);
    {
      String operand = reloaded2.getName();
      String param0 = "second";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Invoices by Graph get/where':  reloaded2 .name.equals(\"second\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      IOFXMetaStatus.IOFXStatusElement operand = reloaded2.getHeadState();
      if (!(SaveObjectComperator.equalsStatus(operand, Invoice_HeadState.STAT1))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Invoices by Graph get/where':  reloaded2 .headState of stat1           ==>>" + operand + "\n");
      }
    }
    {
      int leftSide = reloaded2.getNameLen();
      int rightSide = "second".length();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Invoices by Graph get/where':  reloaded2 .nameLen == \"second\".length()          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = reloaded2.getMoneyAmount().getVal();
      int rightSide = 100;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Invoices by Graph get/where':  reloaded2 .moneyAmount.val == 100          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      DateTime operand = reloaded2.getDateTime();
      DateTime param0 = DeprecatedServerDateProvider.getSqlServerDateTime();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Invoices by Graph get/where':  reloaded2 .dateTime.equals( new_DateTimeFromServer )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      LocalDate operand = reloaded2.getLocalDate();
      LocalDate param0 = DeprecatedServerDateProvider.getSqlServerLocalDate();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Invoices by Graph get/where':  reloaded2 .localDate.equals( new_LocalDateFromServer )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    reloaded2.complete();
    {
      BigDecimal leftSide = reloaded2.getTotalAmount();
      BigDecimal rightSide = new BigDecimal("60.0");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Invoices by Graph get/where':  reloaded2 .totalAmount == 60.0bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    Invoice reloaded3 = __DomainRepoInvoice.checkoutInvoiceByIdWithoutRefs(inv3.getId(), null);
    {
      String operand = reloaded3.getName();
      String param0 = "third";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Invoices by Graph get/where':  reloaded3 .name.equals(\"third\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      IOFXMetaStatus.IOFXStatusElement operand = reloaded3.getHeadState();
      if (!(SaveObjectComperator.equalsStatus(operand, Invoice_HeadState.STAT1))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Invoices by Graph get/where':  reloaded3 .headState of stat1           ==>>" + operand + "\n");
      }
    }
    {
      int leftSide = reloaded3.getNameLen();
      int rightSide = "third".length();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Invoices by Graph get/where':  reloaded3 .nameLen == \"third\".length()          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = reloaded3.getMoneyAmount().getVal();
      int rightSide = 100;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Invoices by Graph get/where':  reloaded3 .moneyAmount.val == 100          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      DateTime operand = reloaded3.getDateTime();
      DateTime param0 = DeprecatedServerDateProvider.getSqlServerDateTime();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Invoices by Graph get/where':  reloaded3 .dateTime.equals( new_DateTimeFromServer )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      LocalDate operand = reloaded3.getLocalDate();
      LocalDate param0 = DeprecatedServerDateProvider.getSqlServerLocalDate();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Invoices by Graph get/where':  reloaded3 .localDate.equals( new_LocalDateFromServer )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    reloaded3.complete();
    {
      BigDecimal leftSide = reloaded3.getTotalAmount();
      BigDecimal rightSide = new BigDecimal("60.0");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Invoices by Graph get/where':  reloaded3 .totalAmount == 60.0bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 1, name = "Update an Invoice and reload it again.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("first", __manMapSession);

    inv1.setText("changed");
    inv1.setNameLen(4711);
    inv1.setTotalAmount(new BigDecimal("4711.11"));
    inv1.setHeadState(Invoice_HeadState.STAT2);
    __DomainRepoInvoice.checkinInvoice(inv1, null);

    Invoice changedInvoice = __DomainRepoInvoice.checkoutInvoiceByIdWithoutRefs(inv1.getId(), null);
    {
      String leftSide = changedInvoice.getText();
      String rightSide = "changed";
      if (!(SaveObjectComperator.equals(leftSide, rightSide))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Update an Invoice and reload it again.':  changedInvoice .text == \"changed\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = changedInvoice.getNameLen();
      int rightSide = 4711;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Update an Invoice and reload it again.':  changedInvoice .nameLen == 4711          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      BigDecimal leftSide = changedInvoice.getTotalAmount();
      BigDecimal rightSide = new BigDecimal("4711.11");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'Graph load/save (no session).Update an Invoice and reload it again.':  changedInvoice .totalAmount == 4711.11bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      Invoice_HeadState leftSide = changedInvoice.getHeadState();
      Invoice_HeadState rightSide = Invoice_HeadState.STAT2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Update an Invoice and reload it again.':  changedInvoice .headState == \"HeadState.stat2\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 2, name = "Use join to load two different invoice graphs", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_2(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("first", __manMapSession);
    Invoice inv2 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("second", __manMapSession);



    Invoice reloaded1 = __DomainRepoInvoice.checkoutInvoiceJoinPositions(inv1.getId(), null);
    {
      String operand = reloaded1.getName();
      String param0 = "first";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs':  reloaded1 .name.equals(\"first\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      IOFXMetaStatus.IOFXStatusElement operand = reloaded1.getHeadState();
      if (!(SaveObjectComperator.equalsStatus(operand, Invoice_HeadState.STAT1))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs':  reloaded1 .headState of stat1           ==>>" + operand + "\n");
      }
    }
    {
      int leftSide = reloaded1.getNameLen();
      int rightSide = "first".length();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs':  reloaded1 .nameLen == \"first\".length()          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = reloaded1.getMoneyAmount().getVal();
      int rightSide = 100;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs':  reloaded1 .moneyAmount.val == 100          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      DateTime operand = reloaded1.getDateTime();
      DateTime param0 = DeprecatedServerDateProvider.getSqlServerDateTime();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs':  reloaded1 .dateTime.equals( new_DateTimeFromServer )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      LocalDate operand = reloaded1.getLocalDate();
      LocalDate param0 = DeprecatedServerDateProvider.getSqlServerLocalDate();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs':  reloaded1 .localDate.equals( new_LocalDateFromServer )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    reloaded1.complete();
    {
      BigDecimal leftSide = reloaded1.getTotalAmount();
      BigDecimal rightSide = new BigDecimal("60.0");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs':  reloaded1 .totalAmount == 60.0bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }


    Invoice reloaded2 = __DomainRepoInvoice.checkoutInvoiceJoinPositions(inv2.getId(), null);
    {
      String operand = reloaded2.getName();
      String param0 = "second";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs':  reloaded2 .name.equals(\"second\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      IOFXMetaStatus.IOFXStatusElement operand = reloaded2.getHeadState();
      if (!(SaveObjectComperator.equalsStatus(operand, Invoice_HeadState.STAT1))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs':  reloaded2 .headState of stat1           ==>>" + operand + "\n");
      }
    }
    {
      int leftSide = reloaded2.getNameLen();
      int rightSide = "second".length();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs':  reloaded2 .nameLen == \"second\".length()          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = reloaded2.getMoneyAmount().getVal();
      int rightSide = 100;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs':  reloaded2 .moneyAmount.val == 100          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      DateTime operand = reloaded2.getDateTime();
      DateTime param0 = DeprecatedServerDateProvider.getSqlServerDateTime();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs':  reloaded2 .dateTime.equals( new_DateTimeFromServer )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      LocalDate operand = reloaded2.getLocalDate();
      LocalDate param0 = DeprecatedServerDateProvider.getSqlServerLocalDate();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs':  reloaded2 .localDate.equals( new_LocalDateFromServer )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    reloaded2.complete();
    {
      BigDecimal leftSide = reloaded2.getTotalAmount();
      BigDecimal rightSide = new BigDecimal("60.0");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs':  reloaded2 .totalAmount == 60.0bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 3, name = "Use join to load two different invoice graphs, REVERSE", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_3(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("first", __manMapSession);
    Invoice inv2 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("second", __manMapSession);



    Invoice reloaded1 = __DomainRepoInvoice.checkoutInvoiceJoinPositionsReverse(inv1.getId(), null);
    {
      String operand = reloaded1.getName();
      String param0 = "first";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs, REVERSE':  reloaded1 .name.equals(\"first\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      IOFXMetaStatus.IOFXStatusElement operand = reloaded1.getHeadState();
      if (!(SaveObjectComperator.equalsStatus(operand, Invoice_HeadState.STAT1))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs, REVERSE':  reloaded1 .headState of stat1           ==>>" + operand + "\n");
      }
    }
    {
      int leftSide = reloaded1.getNameLen();
      int rightSide = "first".length();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs, REVERSE':  reloaded1 .nameLen == \"first\".length()          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = reloaded1.getMoneyAmount().getVal();
      int rightSide = 100;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs, REVERSE':  reloaded1 .moneyAmount.val == 100          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      DateTime operand = reloaded1.getDateTime();
      DateTime param0 = DeprecatedServerDateProvider.getSqlServerDateTime();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs, REVERSE':  reloaded1 .dateTime.equals( new_DateTimeFromServer )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      LocalDate operand = reloaded1.getLocalDate();
      LocalDate param0 = DeprecatedServerDateProvider.getSqlServerLocalDate();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs, REVERSE':  reloaded1 .localDate.equals( new_LocalDateFromServer )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    reloaded1.complete();
    {
      BigDecimal leftSide = reloaded1.getTotalAmount();
      BigDecimal rightSide = new BigDecimal("60.0");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs, REVERSE':  reloaded1 .totalAmount == 60.0bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }


    Invoice reload2 = __DomainRepoInvoice.checkoutInvoiceJoinPositionsReverse(inv2.getId(), null);
    {
      String operand = reload2.getName();
      String param0 = "second";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs, REVERSE':  reload2 .name.equals(\"second\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      IOFXMetaStatus.IOFXStatusElement operand = reload2.getHeadState();
      if (!(SaveObjectComperator.equalsStatus(operand, Invoice_HeadState.STAT1))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs, REVERSE':  reload2 .headState of stat1           ==>>" + operand + "\n");
      }
    }
    {
      int leftSide = reload2.getNameLen();
      int rightSide = "second".length();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs, REVERSE':  reload2 .nameLen == \"second\".length()          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = reload2.getMoneyAmount().getVal();
      int rightSide = 100;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs, REVERSE':  reload2 .moneyAmount.val == 100          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      DateTime operand = reload2.getDateTime();
      DateTime param0 = DeprecatedServerDateProvider.getSqlServerDateTime();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs, REVERSE':  reload2 .dateTime.equals( new_DateTimeFromServer )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      LocalDate operand = reload2.getLocalDate();
      LocalDate param0 = DeprecatedServerDateProvider.getSqlServerLocalDate();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs, REVERSE':  reload2 .localDate.equals( new_LocalDateFromServer )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    reload2.complete();
    {
      BigDecimal leftSide = reload2.getTotalAmount();
      BigDecimal rightSide = new BigDecimal("60.0");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use join to load two different invoice graphs, REVERSE':  reload2 .totalAmount == 60.0bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }


  }
  @OFXTestMethod(id = 4, name = "Dirty flag should not be set when loading a graph", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_4(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("first", __manMapSession);


    Invoice reload1 = __DomainRepoInvoice.checkoutInvoiceByIdWithoutRefs(inv1.getId(), null);
    {
      boolean leftSide = ((IM3Entity) reload1).getDirty();
      boolean rightSide = false;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Dirty flag should not be set when loading a graph': ((IM3Entity) reload1 ).getDirty() == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    reload1.setText("CHANGED");
    {
      boolean leftSide = ((IM3Entity) reload1).getDirty();
      boolean rightSide = true;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Dirty flag should not be set when loading a graph': ((IM3Entity) reload1 ).getDirty() == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 5, name = "Dirty flag should not be set when loading a graph, REVERSE", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_5(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("first", __manMapSession);


    Invoice reload1 = __DomainRepoInvoice.checkoutInvoiceJoinPositionsReverse(inv1.getId(), null);
    {
      boolean leftSide = ((IM3Entity) reload1).getDirty();
      boolean rightSide = false;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Dirty flag should not be set when loading a graph, REVERSE': ((IM3Entity) reload1 ).getDirty() == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    for (InvoicePosition pos : reload1.getPositions()) {
      {
        boolean leftSide = ((IM3Entity) pos).getDirty();
        boolean rightSide = false;
        if (leftSide != rightSide) {
          throw new OFXTestSuitException("'Graph load/save (no session).Dirty flag should not be set when loading a graph, REVERSE': ((IM3Entity) pos ).getDirty() == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
      }
    }

    reload1.setText("CHANGED");
    {
      boolean leftSide = ((IM3Entity) reload1).getDirty();
      boolean rightSide = true;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Dirty flag should not be set when loading a graph, REVERSE': ((IM3Entity) reload1 ).getDirty() == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    for (InvoicePosition pos : reload1.getPositions()) {
      pos.setPosText("CHANGED");
      {
        boolean leftSide = ((IM3Entity) pos).getDirty();
        boolean rightSide = true;
        if (leftSide != rightSide) {
          throw new OFXTestSuitException("'Graph load/save (no session).Dirty flag should not be set when loading a graph, REVERSE': ((IM3Entity) pos ).getDirty() == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
      }
    }
  }
  @OFXTestMethod(id = 6, name = "Multiple saves should be easily possible (legacy?)", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_6(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice invoice = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("doublesave", __manMapSession);


    Invoice reload1 = __DomainRepoInvoice.checkoutInvoiceJoinPositions(invoice.getId(), null);
    __DomainRepoInvoice.checkinInvoice(reload1, null);
    __DomainRepoInvoice.checkinInvoice(reload1, null);
    reload1.setName("CHANGED");
    __DomainRepoInvoice.checkinInvoice(reload1, null);
    Invoice reload2Invoice = __DomainRepoInvoice.checkoutInvoiceJoinPositions(invoice.getId(), null);
    {
      String operand = reload2Invoice.getName();
      String param0 = "CHANGED";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Multiple saves should be easily possible (legacy?)':  reload2Invoice .name.equals(\"CHANGED\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 7, name = "Delete and Insert changes object count by one.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_7(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("first", __manMapSession);


    int numOfInvoicesInTable = ListSequence.fromList(__DomainRepoInvoice.findAllInvoices(null)).count();
    int numOfInvoicesPositionsInTable = ListSequence.fromList(__DomainRepoInvoice.findAllInvoicePositions(null)).count();
    {
      int leftSide = numOfInvoicesInTable;
      int rightSide = 0;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'Graph load/save (no session).Delete and Insert changes object count by one.':  numOfInvoicesInTable  > 0          ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }
    {
      int leftSide = numOfInvoicesPositionsInTable;
      int rightSide = 0;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'Graph load/save (no session).Delete and Insert changes object count by one.':  numOfInvoicesPositionsInTable  > 0          ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }

    __DomainRepoInvoice.deleteInovice(inv1, null);
    int afterDeleteNumOfInvoicesInTable = ListSequence.fromList(__DomainRepoInvoice.findAllInvoices(null)).count();
    int afterDeleteNumOfInvoicesPositionsInTable = ListSequence.fromList(__DomainRepoInvoice.findAllInvoicePositions(null)).count();
    {
      int leftSide = afterDeleteNumOfInvoicesInTable - numOfInvoicesInTable;
      int rightSide = -1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Delete and Insert changes object count by one.':  afterDeleteNumOfInvoicesInTable  -  numOfInvoicesInTable  == -1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = afterDeleteNumOfInvoicesPositionsInTable - numOfInvoicesPositionsInTable;
      int rightSide = -4;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Delete and Insert changes object count by one.':  afterDeleteNumOfInvoicesPositionsInTable  -  numOfInvoicesPositionsInTable  == -4          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    // mark it as a not saved object : )
    inv1.setId(0);
    ((IM3Entity) inv1).setTCN(0);
    ListSequence.fromList(inv1.getPositions()).visitAll((it) -> {
      it.setId(0);
      ((IM3Entity) it).setTCN(0);
    });

    __DomainSessionLess.checkinInvoiceImmediatelly(inv1, __localApplicationFactory.createNewSession(__userEnvironment, __userServices), null);

    int afterInsertOfInvoicesInTable = ListSequence.fromList(__DomainRepoInvoice.findAllInvoices(null)).count();
    int afterInsertOfInvoicesPositionsInTable = ListSequence.fromList(__DomainRepoInvoice.findAllInvoicePositions(null)).count();
    {
      int leftSide = afterInsertOfInvoicesInTable;
      int rightSide = numOfInvoicesInTable;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Delete and Insert changes object count by one.':  afterInsertOfInvoicesInTable  ==  numOfInvoicesInTable           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = afterInsertOfInvoicesPositionsInTable;
      int rightSide = numOfInvoicesPositionsInTable;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Delete and Insert changes object count by one.':  afterInsertOfInvoicesPositionsInTable  ==  numOfInvoicesPositionsInTable           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 8, name = "Store and Load Extended Invoices by Graph get/where (legacy)", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_8(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice extInv1 = __DomainCreatorsFactory.createExtendedInvoiceGraphWith2Positions_onDB("ext1", __manMapSession);
    Invoice extInv2 = __DomainCreatorsFactory.createExtendedInvoiceGraphWith2Positions_onDB("ext2", __manMapSession);
    Invoice extInv3 = __DomainCreatorsFactory.createExtendedInvoiceGraphWith2Positions_onDB("ext3", __manMapSession);


    ExtendedInvoice reloaded1;
    ExtendedInvoice reloaded2;
    ExtendedInvoice reloaded3;

    reloaded1 = __DomainRepoInvoice.checkoutExtendedInvoiceById(extInv1.getId(), null);
    reloaded2 = __DomainRepoInvoice.checkoutExtendedInvoiceById(extInv2.getId(), null);
    reloaded3 = __DomainRepoInvoice.checkoutExtendedInvoiceById(extInv3.getId(), null);

    {
      String operand = reloaded1.getText();
      String param0 = reloaded1.getText();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Extended Invoices by Graph get/where (legacy)':  reloaded1 .text.equals( reloaded1 .text)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = reloaded1.getExtendedString();
      String param0 = reloaded1.getExtendedString();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Extended Invoices by Graph get/where (legacy)':  reloaded1 .extendedString.equals( reloaded1 .extendedString)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    {
      int leftSide = ListSequence.fromList(reloaded1.getPositions()).count();
      int rightSide = 0;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Extended Invoices by Graph get/where (legacy)':  reloaded1 .positions.size > 0          ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(reloaded2.getPositions()).count();
      int rightSide = 0;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Extended Invoices by Graph get/where (legacy)':  reloaded2 .positions.size > 0          ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(reloaded3.getPositions()).count();
      int rightSide = 0;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and Load Extended Invoices by Graph get/where (legacy)':  reloaded3 .positions.size > 0          ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }


  }
  @OFXTestMethod(id = 9, name = "Use Extended Invoice to load from Invoice table", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_9(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    String NAME = "ext1_tblinv";
    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("ext1_tblinv", __manMapSession);


    ExtendedInvoice extInf = __DomainRepoInvoice.findExtInvoicesTblInvoiceById(inv1.getId(), null);
    {
      String operand = extInf.getName();
      String param0 = NAME;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use Extended Invoice to load from Invoice table':  extInf .name.equals( NAME )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      IOFXMetaStatus.IOFXStatusElement operand = extInf.getHeadState();
      if (!(SaveObjectComperator.equalsStatus(operand, Invoice_HeadState.STAT1))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use Extended Invoice to load from Invoice table':  extInf .headState of stat1           ==>>" + operand + "\n");
      }
    }
    {
      int leftSide = extInf.getNameLen();
      int rightSide = NAME.length();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use Extended Invoice to load from Invoice table':  extInf .nameLen ==  NAME .length()          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = extInf.getMoneyAmount().getVal();
      int rightSide = 100;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use Extended Invoice to load from Invoice table':  extInf .moneyAmount.val == 100          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      DateTime operand = extInf.getDateTime();
      DateTime param0 = DeprecatedServerDateProvider.getSqlServerDateTime();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use Extended Invoice to load from Invoice table':  extInf .dateTime.equals( new_DateTimeFromServer )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      LocalDate operand = extInf.getLocalDate();
      LocalDate param0 = DeprecatedServerDateProvider.getSqlServerLocalDate();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use Extended Invoice to load from Invoice table':  extInf .localDate.equals( new_LocalDateFromServer )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    {
      int leftSide = ListSequence.fromList(extInf.getPositions()).count();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use Extended Invoice to load from Invoice table':  extInf .positions.size == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      BigDecimal leftSide = extInf.getTotalAmount();
      BigDecimal rightSide = new BigDecimal("60.0");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'Graph load/save (no session).Use Extended Invoice to load from Invoice table':  extInf .totalAmount == 60.0bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 10, name = "Reload Invoice again changes object.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_10(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("first", __manMapSession);


    BigDecimal origAmount = inv1.getTotalAmount();
    inv1.setName("*CHANGED*");
    inv1.setTotalAmount(new BigDecimal("4711.0"));

    __DomainRepoInvoice.reloadInvoiceAgain(inv1, null);
    {
      String operand = inv1.getName();
      String param0 = "first";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Reload Invoice again changes object.':  inv1 .name.equals(\"first\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      BigDecimal leftSide = inv1.getTotalAmount();
      BigDecimal rightSide = origAmount;
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'Graph load/save (no session).Reload Invoice again changes object.':  inv1 .totalAmount ==  origAmount           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 11, name = "Deleting a readonly object results in an exception", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_11(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("first", __manMapSession);


    List<Invoice> reloaded = __DomainRepoInvoice.findInvoiceByIdOrByName(inv1.getId(), null, null);
    {
      int leftSide = ListSequence.fromList(reloaded).count();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Deleting a readonly object results in an exception':  reloaded .size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        __DomainRepoInvoice.deleteInovice(ListSequence.fromList(reloaded).first(), null);

      } catch (IllegalStateException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("readonly")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("readonly")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Graph load/save (no session).Deleting a readonly object results in an exception': Fail In Exception IllegalStateException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Graph load/save (no session).Deleting a readonly object results in an exception': Fail In Exception IllegalStateException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Graph load/save (no session).Deleting a readonly object results in an exception': Fail In Exception 'IllegalStateException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

  }
  @OFXTestMethod(id = 12, name = "Changing a readonly object results in an exception", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_12(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("first", __manMapSession);


    List<Invoice> reloaded = __DomainRepoInvoice.findInvoiceByIdOrByName(inv1.getId(), null, null);
    {
      int leftSide = ListSequence.fromList(reloaded).count();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Changing a readonly object results in an exception':  reloaded .size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        ListSequence.fromList(reloaded).first().setText("CHANGED");

      } catch (OFXIllegalAccessException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("not allowed")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("not allowed")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Graph load/save (no session).Changing a readonly object results in an exception': Fail In Exception OFXIllegalAccessException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Graph load/save (no session).Changing a readonly object results in an exception': Fail In Exception OFXIllegalAccessException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Graph load/save (no session).Changing a readonly object results in an exception': Fail In Exception 'OFXIllegalAccessException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }
  }
  @OFXTestMethod(id = 13, name = "Reloading an Invoice read only object results not in an exception", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_13(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("first", __manMapSession);


    List<Invoice> reloaded = __DomainRepoInvoice.findInvoiceByIdOrByName(inv1.getId(), null, null);
    __DomainRepoInvoice.reloadInvoiceAgain(ListSequence.fromList(reloaded).first(), null);
  }
  @OFXTestMethod(id = 14, name = "Deleting an non existing object should result in an exception", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_14(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv = new Invoice();

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        __DomainRepoInvoice.deleteInovice(inv, null);

      } catch (IncorrectResultSetColumnCountException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();


      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Graph load/save (no session).Deleting an non existing object should result in an exception': Fail In Exception IncorrectResultSetColumnCountException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Graph load/save (no session).Deleting an non existing object should result in an exception': Fail In Exception IncorrectResultSetColumnCountException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Graph load/save (no session).Deleting an non existing object should result in an exception': Fail In Exception 'IncorrectResultSetColumnCountException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }
  }
  @OFXTestMethod(id = 15, name = "Get() an object with unknown id should result in an exception", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_15(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        __DomainRepoInvoice.checkoutInvoiceByIdWithoutRefs(123456789, null);

      } catch (IncorrectResultSetColumnCountException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();


      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Graph load/save (no session).Get() an object with unknown id should result in an exception': Fail In Exception IncorrectResultSetColumnCountException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Graph load/save (no session).Get() an object with unknown id should result in an exception': Fail In Exception IncorrectResultSetColumnCountException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Graph load/save (no session).Get() an object with unknown id should result in an exception': Fail In Exception 'IncorrectResultSetColumnCountException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }
  }
  @OFXTestMethod(id = 16, name = "Double write with optimistic locking should result in an exception", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_16(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("first", __manMapSession);


    // inv1, save, check it out for longer
    Invoice inv = __DomainRepoInvoice.checkoutInvoiceByIdWithoutRefs(inv1.getId(), null);

    // stored changed invoice increasing tcn
    inv1.setText("CHANGED");
    __DomainRepoInvoice.checkinInvoice(inv1, null);

    // now storing the old object leads to no error... since not dirty!
    __DomainRepoInvoice.checkinInvoice(inv, null);

    // but forcing dirty
    inv.setText("CHANGED2");


    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        __DomainRepoInvoice.checkinInvoice(inv, null);

      } catch (IncorrectResultSetColumnCountException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();


      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Graph load/save (no session).Double write with optimistic locking should result in an exception': Fail In Exception IncorrectResultSetColumnCountException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Graph load/save (no session).Double write with optimistic locking should result in an exception': Fail In Exception IncorrectResultSetColumnCountException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Graph load/save (no session).Double write with optimistic locking should result in an exception': Fail In Exception 'IncorrectResultSetColumnCountException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

    // UPDATE() org.modellwerkstatt.objectflow.tests.manmap.Domain.Invoice - key 1 ,tcn-1 0 (0 rows affected).

  }
  @OFXTestMethod(id = 17, name = "Store and reload a string key object.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_17(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    String NAME = "simpleStringKeyReload";
    Referer ref1 = __DomainCreatorsFactory.createRefererEntityWithStringKey(NAME, __manMapSession);

    __DomainRepoReferer.insertReferer(ref1, null);
    Referer reloaded1 = __DomainRepoReferer.checkoutReferer(ref1.getKey(), null);
    {
      String operand = reloaded1.getKey();
      String param0 = NAME;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and reload a string key object.':  reloaded1 .key.equals( NAME )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = reloaded1.getName();
      String param0 = NAME;
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and reload a string key object.':  reloaded1 .name.equals( NAME )          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      Account leftSide = reloaded1.getAccount();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and reload a string key object.':  reloaded1 .account ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      IOFXMetaStatus.IOFXStatusElement operand = reloaded1.getAccountKey().getActive();
      if (!(SaveObjectComperator.equalsStatus(operand, AccountKey_Active.ON))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Store and reload a string key object.':  reloaded1 .accountKey.active of on           ==>>" + operand + "\n");
      }
    }
  }
  @OFXTestMethod(id = 18, name = "Create, load save an entity with ValueObject Key.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_18(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Account account1 = __DomainCreatorsFactory.createAccountWithNumAndMandant(1, "graph1", __manMapSession);


    __DomainRepoAccountAudit.insertAccount(account1, null);

    // should not lead to any exception due to skip audit...
    Account reloaded = __DomainRepoAccountAudit.checkoutAccountAudit(account1.getKey(), null);
    {
      int leftSide = reloaded.getKey().getNumber();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Create, load save an entity with ValueObject Key.':  reloaded .key.number == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String operand = reloaded.getKey().getMandant();
      String param0 = "graph1";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Create, load save an entity with ValueObject Key.':  reloaded .key.mandant.equals(\"graph1\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      IOFXMetaStatus.IOFXStatusElement operand = reloaded.getKey().getActive();
      if (!(SaveObjectComperator.equalsStatus(operand, AccountKey_Active.ON))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Create, load save an entity with ValueObject Key.':  reloaded .key.active of on           ==>>" + operand + "\n");
      }
    }
    {
      BigDecimal leftSide = reloaded.getTotalValue();
      BigDecimal rightSide = new BigDecimal("0.0");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'Graph load/save (no session).Create, load save an entity with ValueObject Key.':  reloaded .totalValue == 0.0bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 19, name = "Delete an entity with ValueObject Key.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_19(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Account account1 = __DomainCreatorsFactory.createAccountWithNumAndMandant(2, "graph2", __manMapSession);


    __DomainRepoAccountAudit.insertAccount(account1, null);
    int auditCount = ListSequence.fromList(__DomainRepoAccountAudit.findAllAccountAudits(null)).count();
    {
      int leftSide = auditCount;
      int rightSide = 0;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'Graph load/save (no session).Delete an entity with ValueObject Key.':  auditCount  > 0          ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }

    __DomainRepoAccountAudit.deleteAccountAudit(account1, null);
    int auditCountAfterDelete = ListSequence.fromList(__DomainRepoAccountAudit.findAllAccountAudits(null)).count();
    {
      int leftSide = auditCountAfterDelete;
      int rightSide = auditCount - 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Delete an entity with ValueObject Key.':  auditCountAfterDelete  ==  auditCount  - 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 20, name = "Create multiple account objects with same key and checkaut as list.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_20(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Account account1 = __DomainCreatorsFactory.createAccountWithNumAndMandant(10, "graph10", __manMapSession);
    Account account2 = __DomainCreatorsFactory.createAccountWithNumAndMandant(10, "graph10", __manMapSession);


    __DomainRepoAccountAudit.insertAccount(account1, null);
    __DomainRepoAccountAudit.insertAccount(account2, null);

    // that can not work, since mapper aligns same objects  (by key)
    List<Account> accounts = __DomainRepoAccountAudit.checkoutAccountAuditOnKeysDirectly(account1.getKey().getNumber(), account1.getKey().getMandant(), account1.getKey().getActive(), null);
    // same key - only one object.
    {
      int leftSide = ListSequence.fromList(accounts).count();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Create multiple account objects with same key and checkaut as list.':  accounts .size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        __DomainRepoAccountAudit.deleteAccountAudit(account1, null);

      } catch (IncorrectResultSetColumnCountException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("2 rows affected")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("2 rows affected")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Graph load/save (no session).Create multiple account objects with same key and checkaut as list.': Fail In Exception IncorrectResultSetColumnCountException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Graph load/save (no session).Create multiple account objects with same key and checkaut as list.': Fail In Exception IncorrectResultSetColumnCountException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Graph load/save (no session).Create multiple account objects with same key and checkaut as list.': Fail In Exception 'IncorrectResultSetColumnCountException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }
  }
  @OFXTestMethod(id = 21, name = "Setting a BigDecimal Number to null should not lead to an exception.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_21(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice invoice = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("big0", __manMapSession);


    // assignment not problem.
    invoice.setTotalAmount(null);
    // checking also
    __DomainRepoInvoice.checkinInvoice(invoice, null);
    // but when reloading, typehandler sets value to 0.0
    Invoice reloaded = __DomainRepoInvoice.checkoutInvoiceByIdWithRefs(invoice.getId(), null);
    {
      BigDecimal leftSide = reloaded.getTotalAmount();
      BigDecimal rightSide = new BigDecimal("0.0");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'Graph load/save (no session).Setting a BigDecimal Number to null should not lead to an exception.':  reloaded .totalAmount == 0.0bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 22, name = "Setting a string to null should not lead to an exception.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_22(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice invoice = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("string null", __manMapSession);


    // assignment not problem.
    invoice.setText(null);
    // checking also
    __DomainRepoInvoice.checkinInvoice(invoice, null);
    // but when reloading, typehandler sets value to ""
    Invoice reloaded = __DomainRepoInvoice.checkoutInvoiceByIdWithRefs(invoice.getId(), null);
    {
      String operand = reloaded.getText();
      String param0 = "";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Setting a string to null should not lead to an exception.':  reloaded .text.equals(\"\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 23, name = "Saving an entity refering to unseaved entity leads to an exception", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_23(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Referer main = __DomainCreatorsFactory.createRefererEntityWithStringKey("", __manMapSession);
    Referer child1 = __DomainCreatorsFactory.createRefererEntityWithStringKey("child1", __manMapSession);



    // main has a null key = ""
    child1.setParent(main);

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        __DomainRepoReferer.insertReferer(child1, null);

      } catch (IllegalStateException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("without saving the referred")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("without saving the referred")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Graph load/save (no session).Saving an entity refering to unseaved entity leads to an exception': Fail In Exception IllegalStateException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Graph load/save (no session).Saving an entity refering to unseaved entity leads to an exception': Fail In Exception IllegalStateException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Graph load/save (no session).Saving an entity refering to unseaved entity leads to an exception': Fail In Exception 'IllegalStateException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

  }
  @OFXTestMethod(id = 24, name = "Dirty on Reference if object not saved.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_24(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("first", __manMapSession);


    // load 3 invoices and compare them with standard graph.
    Invoice reloaded1 = __DomainRepoInvoice.checkoutInvoiceByIdWithoutRefs(inv1.getId(), null);
    {
      boolean leftSide = ((IM3Entity) reloaded1).getDirty();
      boolean rightSide = false;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Dirty on Reference if object not saved.': ((IM3Entity) reloaded1 ).getDirty() == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      boolean leftSide = ((IM3Entity) ListSequence.fromList(reloaded1.getPositions()).first()).getDirty();
      boolean rightSide = false;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Dirty on Reference if object not saved.': ((IM3Entity) reloaded1 .positions.first).getDirty() == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    ListSequence.fromList(reloaded1.getPositions()).first().setInvoice(new Invoice());
    {
      boolean leftSide = ((IM3Entity) ListSequence.fromList(reloaded1.getPositions()).first()).getDirty();
      boolean rightSide = true;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Dirty on Reference if object not saved.': ((IM3Entity) reloaded1 .positions.first).getDirty() == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 25, name = "Use Overwrite auto_id, that will gen an errer, since seq won t exist.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_25(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {




    final ExtendedInvoice e = new ExtendedInvoice();
    e.setDateTime(DeprecatedServerDateProvider.getSqlServerDateTime());
    e.setExtendedString("ExtendedInvoice Seq.");


    if (dpDesc.needsIdSelectPost()) {
      // works in mysql, since no sequences are used.
      final IOFXSession sess = __DomainSessionLess.CREATE_SESSION(__manMapSession);
      __DomainSessionLess.opInTrans(((_FunctionTypes._void_P0_E0) () -> __DomainRepoInvoice.checkinInvoiceOverwrittenSeq(e, sess)), sess, __manMapSession);

    } else {
      //   java.sql.SQLException: ORA-02289: Sequence ist nicht vorhanden.
      {
        boolean __FailIn_catched = false;
        boolean __FailIn_text = true;
        Throwable __FailIn_origThrowable = null;
        String messagesInProblems = "";

        try {
          __DomainRepoInvoice.checkinInvoiceOverwrittenSeq(e, null);

        } catch (BadSqlGrammarException ex) {
          __FailIn_origThrowable = ex;
          __FailIn_catched = true;
          messagesInProblems = ex.getMessage();

          __FailIn_text = false;
          if (messagesInProblems == null) {
            messagesInProblems = "";
          }
          if (messagesInProblems.contains("ORA-02289")) {
            __FailIn_text = true;

          } else {
            // down ward compatibility for OFXAbortException
            messagesInProblems += "\n";
            List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
            for (IOFXProblem problem : allProblems) {
              messagesInProblems += problem.getSimpleUserText() + "\n";
              if (problem.getSimpleUserText().contains("ORA-02289")) {
                __FailIn_text = true;
                break;
              }
            }
          }

        } catch (Throwable t) {
          throw new RuntimeException(t);

        } finally {
          // check also loop in map_OFXTestSuit

          if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
            throw new OFXTestSuitException("'Graph load/save (no session).Use Overwrite auto_id, that will gen an errer, since seq won t exist.': Fail In Exception BadSqlGrammarException was NOT catched!");

          } else if (__FailIn_catched && !(__FailIn_text)) {
            throw new OFXTestSuitException("'Graph load/save (no session).Use Overwrite auto_id, that will gen an errer, since seq won t exist.': Fail In Exception BadSqlGrammarException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

          } else if (!(__FailIn_catched)) {
            throw new OFXTestSuitException("'Graph load/save (no session).Use Overwrite auto_id, that will gen an errer, since seq won t exist.': Fail In Exception 'BadSqlGrammarException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
          }

        }

      }
    }

  }
  @OFXTestMethod(id = 26, name = "Load NewInvoice Aggregate with key only backref", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_26(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv = __DomainCreatorsFactory.createInvoiceGraphWith2PositionsAnd2SubPos_onDB("no key test", __manMapSession);


    IOFXSession sess = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    final NewInvoice agg = __DomainNewInvRepo.checkOutInvoiceById(inv.getId(), sess);

    {
      int leftSide = ListSequence.fromList(agg.getPositions()).count();
      int rightSide = 0;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'Graph load/save (no session).Load NewInvoice Aggregate with key only backref':  agg .positions.size > 0          ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(agg.getPositions()).count();
      int rightSide = ListSequence.fromList(inv.getPositions()).count();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Load NewInvoice Aggregate with key only backref':  agg .positions.size ==  inv .positions.size          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      boolean leftSide = ListSequence.fromList(agg.getPositions()).any((it) -> it.getBackRef() != agg.getId());
      boolean rightSide = false;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Load NewInvoice Aggregate with key only backref':  agg .positions.any == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 27, name = "Load all invoices with new Aggregate mapping (keyonly backref)", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_27(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXSession sess = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    List<NewInvoice> allInvoices = __DomainNewInvRepo.findAllNewInvoices(sess);


    for (final NewInvoice inv : allInvoices) {
      {
        boolean leftSide = ListSequence.fromList(inv.getPositions()).any((it) -> it.getBackRef() != inv.getId());
        boolean rightSide = false;
        if (leftSide != rightSide) {
          throw new OFXTestSuitException("'Graph load/save (no session).Load all invoices with new Aggregate mapping (keyonly backref)':  inv .positions.any == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
      }
    }

  }
  @OFXTestMethod(id = 28, name = "Batch Insert: Save positions with list save command - simple insert", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_28(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    // not implemented for mysql
    if (dpDesc.needsIdSelectPost()) {
      return;
    }

    Invoice newInvoice = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_NOTonDB("listsave", __manMapSession);

    __DomainRepoInvoice.saveInvoicePosListBatch(newInvoice, false, __manMapSession);

    if (!(!(ListSequence.fromList(newInvoice.getPositions()).any((it) -> it.getId() == 0)))) {
      throw new OFXTestSuitException("'Graph load/save (no session).Batch Insert: Save positions with list save command - simple insert': !( newInvoice .positions.any)          ==>> FALSE !" + "\n");
    }

    Invoice reloaded = __DomainRepoInvoice.checkoutInvoiceJoinPositions(newInvoice.getId(), null);
    {
      int leftSide = ListSequence.fromList(reloaded.getPositions()).count();
      int rightSide = ListSequence.fromList(newInvoice.getPositions()).count();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Batch Insert: Save positions with list save command - simple insert':  reloaded .positions.size ==  newInvoice .positions.size          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String operand = ListSequence.fromList(reloaded.getPositions()).getElement(0).getPosText();
      String param0 = ListSequence.fromList(newInvoice.getPositions()).getElement(0).getPosText();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Batch Insert: Save positions with list save command - simple insert':  reloaded .positions.get.posText.equals( newInvoice .positions.get.posText)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = ListSequence.fromList(reloaded.getPositions()).getElement(1).getPosText();
      String param0 = ListSequence.fromList(newInvoice.getPositions()).getElement(1).getPosText();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Batch Insert: Save positions with list save command - simple insert':  reloaded .positions.get.posText.equals( newInvoice .positions.get.posText)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = ListSequence.fromList(reloaded.getPositions()).getElement(2).getPosText();
      String param0 = ListSequence.fromList(newInvoice.getPositions()).getElement(2).getPosText();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Batch Insert: Save positions with list save command - simple insert':  reloaded .positions.get.posText.equals( newInvoice .positions.get.posText)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = ListSequence.fromList(reloaded.getPositions()).getElement(3).getPosText();
      String param0 = ListSequence.fromList(newInvoice.getPositions()).getElement(3).getPosText();
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Graph load/save (no session).Batch Insert: Save positions with list save command - simple insert':  reloaded .positions.get.posText.equals( newInvoice .positions.get.posText)          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 29, name = "Batch Insert: Save positions with list save command - check performance)", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_29(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    // not implemented for mysql
    if (dpDesc.needsIdSelectPost()) {
      return;
    }


    int NUM_OF_POS = 20;
    long start;
    Invoice newInvoice = __DomainCreatorsFactory.createInvoiceGraphWithNPositions_NOTonDB("perflistsv", NUM_OF_POS, __manMapSession);

    start = System.currentTimeMillis();
    __DomainRepoInvoice.saveInvoicePosListBatch(newInvoice, false, __manMapSession);
    long batchInsertTime = (System.currentTimeMillis() - start);
    System.err.println("Batch insert took " + batchInsertTime);
    if (!(!(ListSequence.fromList(newInvoice.getPositions()).any((it) -> it.getId() == 0)))) {
      throw new OFXTestSuitException("'Graph load/save (no session).Batch Insert: Save positions with list save command - check performance)': !( newInvoice .positions.any)          ==>> FALSE !" + "\n");
    }


    newInvoice = __DomainCreatorsFactory.createInvoiceGraphWithNPositions_NOTonDB("listsv", NUM_OF_POS, __manMapSession);
    start = System.currentTimeMillis();
    __DomainRepoInvoice.checkinInvoice(newInvoice, __manMapSession);
    long normalInsertTime = (System.currentTimeMillis() - start);
    System.err.println("Normal insert took " + normalInsertTime);
    if (!(!(ListSequence.fromList(newInvoice.getPositions()).any((it) -> it.getId() == 0)))) {
      throw new OFXTestSuitException("'Graph load/save (no session).Batch Insert: Save positions with list save command - check performance)': !( newInvoice .positions.any)          ==>> FALSE !" + "\n");
    }

    {
      long leftSide = normalInsertTime;
      long rightSide = batchInsertTime;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'Graph load/save (no session).Batch Insert: Save positions with list save command - check performance)':  normalInsertTime  >  batchInsertTime           ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 30, name = "Batch Insert: Save positions with list save command - check dirty mechanism", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_30(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    // not implemented for mysql
    if (dpDesc.needsIdSelectPost()) {
      return;
    }

    Invoice newInvoice = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_NOTonDB("listdirty", __manMapSession);

    __DomainRepoInvoice.saveInvoicePosListBatch(newInvoice, true, __manMapSession);
    {
      int leftSide = ListSequence.fromList(newInvoice.getPositions()).where((it) -> it.getId() != 0).count();
      int rightSide = 3;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Batch Insert: Save positions with list save command - check dirty mechanism':  newInvoice .positions.where.size == 3          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    Invoice reloaded = __DomainRepoInvoice.checkoutInvoiceJoinPositions(newInvoice.getId(), null);
    {
      int leftSide = ListSequence.fromList(reloaded.getPositions()).count() + 1;
      int rightSide = ListSequence.fromList(newInvoice.getPositions()).count();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Batch Insert: Save positions with list save command - check dirty mechanism':  reloaded .positions.size + 1 ==  newInvoice .positions.size          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 31, name = "Batch Insert: Provoke exception, field to long - check batchUpdateException", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_31(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    // not implemented for mysql
    if (dpDesc.needsIdSelectPost()) {
      return;
    }

    Invoice newInvoice = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_NOTonDB("toolong", __manMapSession);

    String RANDOM = "1234567890";
    String RANDOM_60 = RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM;
    ListSequence.fromList(newInvoice.getPositions()).first().setPosText(RANDOM_60);
    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        __DomainRepoInvoice.saveInvoicePosListBatch(newInvoice, false, __manMapSession);

      } catch (UncategorizedSQLException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();


      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Graph load/save (no session).Batch Insert: Provoke exception, field to long - check batchUpdateException': Fail In Exception UncategorizedSQLException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Graph load/save (no session).Batch Insert: Provoke exception, field to long - check batchUpdateException': Fail In Exception UncategorizedSQLException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Graph load/save (no session).Batch Insert: Provoke exception, field to long - check batchUpdateException': Fail In Exception 'UncategorizedSQLException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

  }
  @OFXTestMethod(id = 32, name = "Batch Insert: Provoke exception, unique constraint failure - check batchUpdateException", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_32(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    // not implemented for mysql
    if (dpDesc.needsIdSelectPost()) {
      return;
    }

    NewInvoice newInvoice = __DomainCreatorsFactory.createNewInvoiceGraphWithNPositions_NOTonDB("unique", 4, __manMapSession);

    __DomainNewInvRepo.checkinBatch(newInvoice, __manMapSession);

    if (!(ListSequence.fromList(newInvoice.getPositions()).all((it) -> it.getId() > 0))) {
      throw new OFXTestSuitException("'Graph load/save (no session).Batch Insert: Provoke exception, unique constraint failure - check batchUpdateException':  newInvoice .positions.all          ==>> FALSE !" + "\n");
    }
    ListSequence.fromList(newInvoice.getPositions()).visitAll((it) -> BLOperations.plusAssign(it.refToPosText(), "_chg"));
    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        __DomainNewInvRepo.checkinPosForceInsertKeyGiven(newInvoice.getPositions(), __manMapSession);

      } catch (DuplicateKeyException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();


      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Graph load/save (no session).Batch Insert: Provoke exception, unique constraint failure - check batchUpdateException': Fail In Exception DuplicateKeyException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Graph load/save (no session).Batch Insert: Provoke exception, unique constraint failure - check batchUpdateException': Fail In Exception DuplicateKeyException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Graph load/save (no session).Batch Insert: Provoke exception, unique constraint failure - check batchUpdateException': Fail In Exception 'DuplicateKeyException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

  }
  @OFXTestMethod(id = 33, name = "Batch Update: simple update the changed newinvoice - simple update", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_33(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    // not implemented for mysql
    if (dpDesc.needsIdSelectPost()) {
      return;
    }

    Invoice newInvoice = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_NOTonDB("listdirty", __manMapSession);

    __DomainRepoInvoice.saveInvoicePosListBatch(newInvoice, false, __manMapSession);
    {
      int leftSide = ListSequence.fromList(newInvoice.getPositions()).where((it) -> it.getId() != 0).count();
      int rightSide = 4;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Batch Update: simple update the changed newinvoice - simple update':  newInvoice .positions.where.size == 4          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    ListSequence.fromList(newInvoice.getPositions()).visitAll((it) -> BLOperations.plusAssign(it.refToPosText(), "-chg"));
    __DomainRepoInvoice.saveInvoicePosListBatch(newInvoice, false, __manMapSession);

    Invoice reloaded = __DomainRepoInvoice.checkoutInvoiceJoinPositions(newInvoice.getId(), null);
    {
      int leftSide = ListSequence.fromList(reloaded.getPositions()).count();
      int rightSide = ListSequence.fromList(newInvoice.getPositions()).count();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Batch Update: simple update the changed newinvoice - simple update':  reloaded .positions.size ==  newInvoice .positions.size          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(reloaded.getPositions()).where((it) -> it.getPosText().endsWith("-chg")).count();
      int rightSide = 4;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Batch Update: simple update the changed newinvoice - simple update':  reloaded .positions.where.size == 4          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 34, name = "Batch Insert: provoke an error using forced update - forced update", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_34(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    // not implemented for mysql
    if (dpDesc.needsIdSelectPost()) {
      return;
    }

    NewInvoice newInvoice = __DomainCreatorsFactory.createNewInvoiceGraphWithNPositions_NOTonDB("forceupdt", 4, __manMapSession);

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        __DomainNewInvRepo.forcedUpdateBatch(newInvoice, __manMapSession);

      } catch (IncorrectResultSetColumnCountException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();


      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Graph load/save (no session).Batch Insert: provoke an error using forced update - forced update': Fail In Exception IncorrectResultSetColumnCountException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Graph load/save (no session).Batch Insert: provoke an error using forced update - forced update': Fail In Exception IncorrectResultSetColumnCountException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Graph load/save (no session).Batch Insert: provoke an error using forced update - forced update': Fail In Exception 'IncorrectResultSetColumnCountException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

  }
  @OFXTestMethod(id = 35, name = "Batch Handling: Auto insert/update, depending on key.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_35(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    // not implemented for mysql
    if (dpDesc.needsIdSelectPost()) {
      return;
    }

    NewInvoice newInvoice = __DomainCreatorsFactory.createNewInvoiceGraphWithNPositions_NOTonDB("autoinsup", 4, __manMapSession);
    __DomainNewInvRepo.checkinBatch(newInvoice, __manMapSession);

    final Wrappers._T<NewInvoice> reloadedInv1 = new Wrappers._T<NewInvoice>(__DomainNewInvRepo.checkOutInvoiceById(newInvoice.getId(), null));
    {
      int leftSide = ListSequence.fromList(reloadedInv1.value.getPositions()).count();
      int rightSide = 4;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Batch Handling: Auto insert/update, depending on key.':  reloadedInv1 .positions.size == 4          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(reloadedInv1.value.getPositions()).where((it) -> it.getId() == ListSequence.fromList(reloadedInv1.value.getPositions()).getElement(3).getId()).count();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Batch Handling: Auto insert/update, depending on key.':  reloadedInv1 .positions.where.size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }


    NewInvoicePos newPos = __DomainCreatorsFactory.createNewInvoicePosition(newInvoice, "updt 1", __manMapSession);
    NewInvoicePos newPos2 = __DomainCreatorsFactory.createNewInvoicePosition(newInvoice, "updt 2", __manMapSession);
    __DomainNewInvRepo.checkinBatch(newInvoice, __manMapSession);


    reloadedInv1.value = __DomainNewInvRepo.checkOutInvoiceById(newInvoice.getId(), null);
    {
      int leftSide = ListSequence.fromList(reloadedInv1.value.getPositions()).count();
      int rightSide = 6;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Batch Handling: Auto insert/update, depending on key.':  reloadedInv1 .positions.size == 6          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(reloadedInv1.value.getPositions()).where((it) -> it.getId() == ListSequence.fromList(reloadedInv1.value.getPositions()).getElement(3).getId()).count();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Batch Handling: Auto insert/update, depending on key.':  reloadedInv1 .positions.where.size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(reloadedInv1.value.getPositions()).where((it) -> it.getPosText().contains("updt 1")).count();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Batch Handling: Auto insert/update, depending on key.':  reloadedInv1 .positions.where.size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(reloadedInv1.value.getPositions()).where((it) -> it.getPosText().contains("updt 2")).count();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Graph load/save (no session).Batch Handling: Auto insert/update, depending on key.':  reloadedInv1 .positions.where.size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 36, name = "Batch Handling: Auto insert/update, force audit - skip dirty handling. ", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_36(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    // not implemented for mysql
    if (dpDesc.needsIdSelectPost()) {
      return;
    }

    NewInvoice newInvoice = __DomainCreatorsFactory.createNewInvoiceGraphWithNPositions_NOTonDB("autoinsup", 4, __manMapSession);

    ((IOFXEntity) newInvoice).setDirty(false);
    ((IOFXEntity) ListSequence.fromList(newInvoice.getPositions()).getElement(0)).setDirty(false);
    ((IOFXEntity) ListSequence.fromList(newInvoice.getPositions()).getElement(1)).setDirty(false);
    ((IOFXEntity) ListSequence.fromList(newInvoice.getPositions()).getElement(2)).setDirty(false);
    ((IOFXEntity) ListSequence.fromList(newInvoice.getPositions()).getElement(3)).setDirty(false);

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        __DomainNewInvRepo.forcedAuditBatch(newInvoice, __manMapSession);

      } catch (IllegalStateException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();


      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Graph load/save (no session).Batch Handling: Auto insert/update, force audit - skip dirty handling. ': Fail In Exception IllegalStateException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Graph load/save (no session).Batch Handling: Auto insert/update, force audit - skip dirty handling. ': Fail In Exception IllegalStateException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Graph load/save (no session).Batch Handling: Auto insert/update, force audit - skip dirty handling. ': Fail In Exception 'IllegalStateException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }
    // dirty checking preventen, ISE comes from mapper. 

  }
  @OFXTestMethod(id = 37, name = "Batch Handling: force insert, force audit - skip dirty handling. ", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_37(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    // not implemented for mysql
    if (dpDesc.needsIdSelectPost()) {
      return;
    }

    NewInvoice newInvoice = __DomainCreatorsFactory.createNewInvoiceGraphWithNPositions_NOTonDB("autoinsup", 4, __manMapSession);

    ((IOFXEntity) newInvoice).setDirty(false);
    ((IOFXEntity) ListSequence.fromList(newInvoice.getPositions()).getElement(0)).setDirty(false);
    ((IOFXEntity) ListSequence.fromList(newInvoice.getPositions()).getElement(1)).setDirty(false);
    ((IOFXEntity) ListSequence.fromList(newInvoice.getPositions()).getElement(2)).setDirty(false);
    ((IOFXEntity) ListSequence.fromList(newInvoice.getPositions()).getElement(3)).setDirty(false);

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        __DomainNewInvRepo.forcedAuditBatchInsert(newInvoice, __manMapSession);

      } catch (IllegalStateException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();


      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Graph load/save (no session).Batch Handling: force insert, force audit - skip dirty handling. ': Fail In Exception IllegalStateException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Graph load/save (no session).Batch Handling: force insert, force audit - skip dirty handling. ': Fail In Exception IllegalStateException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Graph load/save (no session).Batch Handling: force insert, force audit - skip dirty handling. ': Fail In Exception 'IllegalStateException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }
    // dirty checking preventen, ISE comes from mapper. 

  }


  public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  public static void main(String[] args) {
    String[] allIncludedTest = new String[]{"org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit"};
    String[] includedTestToRun = new String[]{};

    OFXTestSuit.runAsMain("org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", Graph_load_save__no_session_.class, allIncludedTest, includedTestToRun);
  }
}
