package org.modellwerkstatt.objectflow.tests.manmap.Tests;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;
import org.modellwerkstatt.objectflow.tests.manmap.XNokeys.NKRepository;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.OFXIncludedSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import java.util.List;
import org.modellwerkstatt.objectflow.tests.manmap.XNokeys.NkDTO;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;
import org.modellwerkstatt.objectflow.runtime.IOFXEntity;
import org.modellwerkstatt.objectflow.tests.manmap.XNokeys.NKKey;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;
import org.modellwerkstatt.manmap.runtime.MMStaticAccessHelper;
import org.modellwerkstatt.objectflow.tests.manmap.XNokeys.NKArticle;
import org.modellwerkstatt.objectflow.runtime.OFXNotInitializedException;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import java.math.BigDecimal;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;
import org.modellwerkstatt.objectflow.tests.manmap.XNokeys.NkDTO_ActiveStat;

public class NoKey_Tests extends OFXTestSuit {

  @Autowired
  private NKRepository __XNokeysNKRepository;
  @Autowired
  private IOFXPlatform __runtimeIOFXPlatform;
  @Autowired
  private IOFXTranslationProvider __runtimeIOFXTranslationProvider;


  @OFXIncludedSuit(name = "org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit")
  private DBinit ___inst_DBinit;


  public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  @OFXTestMethod(id = 0, name = "Use NoKeyMap to query in custom repo - 4 Datasets should be there.", debug = false, enabled = true, runAt = "")
  public void __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {



    List<NkDTO> dv = __XNokeysNKRepository.findAllDTOs(null);

    {
      int leftSide = ListSequence.fromList(dv).count();
      int rightSide = 4;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Use NoKeyMap to query in custom repo - 4 Datasets should be there.':  dv .size == 4          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 1, name = "All objects retrieved with noKeyMap are read-only.", debug = false, enabled = true, runAt = "")
  public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {



    List<NkDTO> dv = __XNokeysNKRepository.findAllDTOs(null);

    {
      boolean leftSide = ListSequence.fromList(dv).getElement(0)._META().isNewInSession();
      boolean rightSide = false;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.All objects retrieved with noKeyMap are read-only.':  dv .get.#Meta.isNewInSession() == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      boolean leftSide = ListSequence.fromList(dv).getElement(0)._META().getDirty();
      boolean rightSide = false;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.All objects retrieved with noKeyMap are read-only.':  dv .get.#Meta.getDirty() == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      boolean leftSide = ((IOFXEntity) ListSequence.fromList(dv).getElement(0)).getReadOnly();
      boolean rightSide = true;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.All objects retrieved with noKeyMap are read-only.': ((IOFXEntity) dv .get).getReadOnly() == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    // Hashcode is always key when using no key map. unique in session.
    {
      Integer leftSide = ((Integer) ((IOFXEntity) ListSequence.fromList(dv).getElement(0)).getIM3Key());
      int rightSide = ListSequence.fromList(dv).getElement(0).hashCode();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.All objects retrieved with noKeyMap are read-only.': ((Integer)((IOFXEntity) dv .get).getIM3Key()) ==  dv .get.hashCode()          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 2, name = "Use NoKeyMap to find by name.", debug = false, enabled = true, runAt = "")
  public void __testmethod_2(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {



    List<NkDTO> dv = __XNokeysNKRepository.findAllDTOsWithName("DAN", null);

    {
      int leftSide = ListSequence.fromList(dv).count();
      int rightSide = 2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Use NoKeyMap to find by name.':  dv .size == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    NkDTO first = ListSequence.fromList(dv).first();
    {
      NKKey leftSide = first.getDemoKey();
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Use NoKeyMap to find by name.':  first .demoKey ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String operand = first.getName();
      String param0 = "DAN";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'NoKey Tests.Use NoKeyMap to find by name.':  first .name.equals(\"DAN\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

  }
  @OFXTestMethod(id = 3, name = "Use complex NoKeyMap to load valueobject embedded.", debug = false, enabled = true, runAt = "")
  public void __testmethod_3(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {



    List<NkDTO> dv = __XNokeysNKRepository.findAllDTOWithValAndRef(null);
    NkDTO first = ListSequence.fromList(dv).first();

    {
      boolean leftSide = first.getName() != null;
      boolean rightSide = !("".equals(first.getName()));
    }
    {
      NKKey leftSide = first.getDemoKey();
      Object rightSide = null;
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Use complex NoKeyMap to load valueobject embedded.':  first .demoKey !=  null           ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }
    {
      int leftSide = first.getDemoKey().getCount();
      int rightSide = first.getCount();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Use complex NoKeyMap to load valueobject embedded.':  first .demoKey.count ==  first .count          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String leftSide = first.getDemoKey().getName();
      String rightSide = first.getName();
      if (!(SaveObjectComperator.equals(leftSide, rightSide))) {
        throw new OFXTestSuitException("'NoKey Tests.Use complex NoKeyMap to load valueobject embedded.':  first .demoKey.name ==  first .name          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }



  }
  @OFXTestMethod(id = 4, name = "Use complex NoKeyMap to load article reference.", debug = false, enabled = true, runAt = "")
  public void __testmethod_4(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {



    List<NkDTO> dv = __XNokeysNKRepository.findAllDTOWithValAndRef(null);

    NkDTO first = ListSequence.fromList(dv).first();

    if (!(!(MMStaticAccessHelper.isNullKeyStaticHelper(first.getRefArticleKEY())))) {
      throw new OFXTestSuitException("'NoKey Tests.Use complex NoKeyMap to load article reference.': !( first .refArticle#KEY.isNullKey)          ==>> FALSE !" + "\n");
    }
    {
      int leftSide = first.getRefArticleKEY();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Use complex NoKeyMap to load article reference.':  first .refArticle#KEY == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    first.setRefArticle(__XNokeysNKRepository.getArticleById(first.getRefArticleKEY(), null));
    {
      NKArticle leftSide = first.getRefArticle();
      Object rightSide = null;
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Use complex NoKeyMap to load article reference.':  first .refArticle !=  null           ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 5, name = "Use complex NoKeyMap to load article reference - Not Initialized Exception.", debug = false, enabled = true, runAt = "")
  public void __testmethod_5(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {



    List<NkDTO> dv = __XNokeysNKRepository.findAllDTOWithValAndRef(null);

    NkDTO first = ListSequence.fromList(dv).first();

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        {
          String leftSide = first.getRefArticle().getName();
          Object rightSide = null;
          if (leftSide == rightSide) {
            throw new OFXTestSuitException("'NoKey Tests.Use complex NoKeyMap to load article reference - Not Initialized Exception.':  first .refArticle.name !=  null           ==>>" + leftSide + " !=" + rightSide + "\n");
          }
        }

      } catch (OFXNotInitializedException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();


      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("null: Fail In Exception OFXNotInitializedException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("null: Fail In Exception OFXNotInitializedException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("null: Fail In Exception 'OFXNotInitializedException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

  }
  @OFXTestMethod(id = 6, name = "Load Articles joined with NkDTO sets articles to readonly.", debug = false, enabled = true, runAt = "")
  public void __testmethod_6(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    List<NkDTO> dv = __XNokeysNKRepository.findAllDTOWithSameArticleJoined(1, null);
    {
      int leftSide = ListSequence.fromList(dv).count();
      int rightSide = 2;
      if (!(leftSide >= rightSide)) {
        throw new OFXTestSuitException("'NoKey Tests.Load Articles joined with NkDTO sets articles to readonly.':  dv .size >= 2          ==>>" + leftSide + " >=" + rightSide + "\n");
      }
    }

    NkDTO first = ListSequence.fromList(dv).first();
    {
      NKArticle leftSide = first.getRefArticle();
      Object rightSide = null;
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load Articles joined with NkDTO sets articles to readonly.':  first .refArticle !=  null           ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }
    {
      int leftSide = first.getRefArticle().getId();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load Articles joined with NkDTO sets articles to readonly.':  first .refArticle.id == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(!("".equals(first.getRefArticle().getName())))) {
      throw new OFXTestSuitException("'NoKey Tests.Load Articles joined with NkDTO sets articles to readonly.': !(\"\".equals( first .refArticle.name))          ==>> FALSE !" + "\n");
    }

    // but readonly of course !
    {
      boolean leftSide = ((IOFXEntity) ListSequence.fromList(dv).getElement(0).getRefArticle()).getReadOnly();
      boolean rightSide = true;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load Articles joined with NkDTO sets articles to readonly.': ((IOFXEntity) dv .get.refArticle).getReadOnly() == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      boolean leftSide = ((IOFXEntity) ListSequence.fromList(dv).getElement(1).getRefArticle()).getReadOnly();
      boolean rightSide = true;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load Articles joined with NkDTO sets articles to readonly.': ((IOFXEntity) dv .get.refArticle).getReadOnly() == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }


  }
  @OFXTestMethod(id = 7, name = "Load Article with NO manmap session should result in different articles.", debug = false, enabled = true, runAt = "")
  public void __testmethod_7(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    List<NkDTO> dv = __XNokeysNKRepository.findAllDTOWithSameArticleJoined(1, null);
    {
      int leftSide = ListSequence.fromList(dv).count();
      int rightSide = 2;
      if (!(leftSide >= rightSide)) {
        throw new OFXTestSuitException("'NoKey Tests.Load Article with NO manmap session should result in different articles.':  dv .size >= 2          ==>>" + leftSide + " >=" + rightSide + "\n");
      }
    }

    NkDTO first = ListSequence.fromList(dv).first();
    {
      NKArticle leftSide = first.getRefArticle();
      Object rightSide = null;
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load Article with NO manmap session should result in different articles.':  first .refArticle !=  null           ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }
    {
      int leftSide = first.getRefArticle().getId();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load Article with NO manmap session should result in different articles.':  first .refArticle.id == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(!("".equals(first.getRefArticle().getName())))) {
      throw new OFXTestSuitException("'NoKey Tests.Load Article with NO manmap session should result in different articles.': !(\"\".equals( first .refArticle.name))          ==>> FALSE !" + "\n");
    }

    // this is no good, althought key matches, Article objects do not :(
    {
      int leftSide = ListSequence.fromList(dv).getElement(0).getRefArticleKEY();
      int rightSide = ListSequence.fromList(dv).getElement(1).getRefArticleKEY();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load Article with NO manmap session should result in different articles.':  dv .get.refArticle#KEY ==  dv .get.refArticle#KEY          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(dv).getElement(0).getRefArticle().getId();
      int rightSide = ListSequence.fromList(dv).getElement(1).getRefArticle().getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load Article with NO manmap session should result in different articles.':  dv .get.refArticle.id ==  dv .get.refArticle.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      NKArticle leftSide = ListSequence.fromList(dv).getElement(0).getRefArticle();
      NKArticle rightSide = ListSequence.fromList(dv).getElement(1).getRefArticle();
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load Article with NO manmap session should result in different articles.':  dv .get.refArticle !=  dv .get.refArticle          ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 8, name = "Load Article WITH manmap session should result in same articles.", debug = false, enabled = true, runAt = "")
  public void __testmethod_8(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {



    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);

    List<NkDTO> dv = __XNokeysNKRepository.findAllDTOWithSameArticleJoined(1, session);
    {
      int leftSide = ListSequence.fromList(dv).count();
      int rightSide = 2;
      if (!(leftSide >= rightSide)) {
        throw new OFXTestSuitException("'NoKey Tests.Load Article WITH manmap session should result in same articles.':  dv .size >= 2          ==>>" + leftSide + " >=" + rightSide + "\n");
      }
    }

    NkDTO first = ListSequence.fromList(dv).first();
    {
      NKArticle leftSide = first.getRefArticle();
      Object rightSide = null;
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load Article WITH manmap session should result in same articles.':  first .refArticle !=  null           ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }
    {
      int leftSide = first.getRefArticle().getId();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load Article WITH manmap session should result in same articles.':  first .refArticle.id == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(!("".equals(first.getRefArticle().getName())))) {
      throw new OFXTestSuitException("'NoKey Tests.Load Article WITH manmap session should result in same articles.': !(\"\".equals( first .refArticle.name))          ==>> FALSE !" + "\n");
    }

    // this is no good, althought key matches, Article objects do not :(
    {
      int leftSide = ListSequence.fromList(dv).getElement(0).getRefArticleKEY();
      int rightSide = ListSequence.fromList(dv).getElement(1).getRefArticleKEY();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load Article WITH manmap session should result in same articles.':  dv .get.refArticle#KEY ==  dv .get.refArticle#KEY          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(dv).getElement(0).getRefArticle().getId();
      int rightSide = ListSequence.fromList(dv).getElement(1).getRefArticle().getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load Article WITH manmap session should result in same articles.':  dv .get.refArticle.id ==  dv .get.refArticle.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      NKArticle leftSide = ListSequence.fromList(dv).getElement(0).getRefArticle();
      NKArticle rightSide = ListSequence.fromList(dv).getElement(1).getRefArticle();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load Article WITH manmap session should result in same articles.':  dv .get.refArticle ==  dv .get.refArticle          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 9, name = "Load Article with existing Articles in manmap session should use those.", debug = false, enabled = true, runAt = "")
  public void __testmethod_9(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    NKArticle article1 = __XNokeysNKRepository.getArticleById(1, session);
    NKArticle article2 = __XNokeysNKRepository.getArticleById(2, session);


    List<NkDTO> dv = __XNokeysNKRepository.findAllDTOWithSameArticleJoined(1, session);
    {
      int leftSide = ListSequence.fromList(dv).count();
      int rightSide = 2;
      if (!(leftSide >= rightSide)) {
        throw new OFXTestSuitException("'NoKey Tests.Load Article with existing Articles in manmap session should use those.':  dv .size >= 2          ==>>" + leftSide + " >=" + rightSide + "\n");
      }
    }

    {
      int leftSide = ListSequence.fromList(dv).getElement(0).getRefArticleKEY();
      int rightSide = article1.getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load Article with existing Articles in manmap session should use those.':  dv .get.refArticle#KEY ==  article1 .id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(dv).getElement(0).getRefArticle().getId();
      int rightSide = article1.getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load Article with existing Articles in manmap session should use those.':  dv .get.refArticle.id ==  article1 .id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      NKArticle leftSide = ListSequence.fromList(dv).getElement(0).getRefArticle();
      NKArticle rightSide = article1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load Article with existing Articles in manmap session should use those.':  dv .get.refArticle ==  article1           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      NKArticle leftSide = ListSequence.fromList(dv).getElement(1).getRefArticle();
      NKArticle rightSide = article1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load Article with existing Articles in manmap session should use those.':  dv .get.refArticle ==  article1           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 10, name = "Load Article with existing Articles CHECKED-OUT, results in EX", debug = false, enabled = true, runAt = "")
  public void __testmethod_10(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    NKArticle article1 = __XNokeysNKRepository.checkOutArticleById(1, session);
    NKArticle article2 = __XNokeysNKRepository.checkOutArticleById(2, session);


    List<NkDTO> dv;

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        dv = __XNokeysNKRepository.findAllDTOWithSameArticleJoined(1, session);

      } catch (IllegalStateException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("already checked out")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("already checked out")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'NoKey Tests.Load Article with existing Articles CHECKED-OUT, results in EX': Fail In Exception IllegalStateException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'NoKey Tests.Load Article with existing Articles CHECKED-OUT, results in EX': Fail In Exception IllegalStateException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'NoKey Tests.Load Article with existing Articles CHECKED-OUT, results in EX': Fail In Exception 'IllegalStateException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

  }
  @OFXTestMethod(id = 11, name = "Use Inner DTO in DTOs mapped via embedded mapping.", debug = false, enabled = true, runAt = "")
  public void __testmethod_11(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    List<NkDTO> dv = __XNokeysNKRepository.findAllObjUserStackedComplexMapping(null);

    {
      NkDTO leftSide = ListSequence.fromList(dv).getElement(0).getRefToObject();
      Object rightSide = null;
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Use Inner DTO in DTOs mapped via embedded mapping.':  dv .get.refToObject !=  null           ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }
    {
      NKKey leftSide = ListSequence.fromList(dv).getElement(0).getRefToObject().getDemoKey();
      Object rightSide = null;
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Use Inner DTO in DTOs mapped via embedded mapping.':  dv .get.refToObject.demoKey !=  null           ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }
    {
      NkDTO leftSide = ListSequence.fromList(dv).getElement(0);
      NkDTO rightSide = ListSequence.fromList(dv).getElement(0).getRefToObject();
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Use Inner DTO in DTOs mapped via embedded mapping.':  dv .get !=  dv .get.refToObject          ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }

    {
      String leftSide = ListSequence.fromList(dv).getElement(0).getName();
      String rightSide = ListSequence.fromList(dv).getElement(0).getRefToObject().getName();
      if (!(SaveObjectComperator.equals(leftSide, rightSide))) {
        throw new OFXTestSuitException("'NoKey Tests.Use Inner DTO in DTOs mapped via embedded mapping.':  dv .get.name ==  dv .get.refToObject.name          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String leftSide = ListSequence.fromList(dv).getElement(0).getName();
      String rightSide = ListSequence.fromList(dv).getElement(0).getRefToObject().getDemoKey().getName();
      if (!(SaveObjectComperator.equals(leftSide, rightSide))) {
        throw new OFXTestSuitException("'NoKey Tests.Use Inner DTO in DTOs mapped via embedded mapping.':  dv .get.name ==  dv .get.refToObject.demoKey.name          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      NkDTO leftSide = ListSequence.fromList(dv).getElement(1).getRefToObject();
      Object rightSide = null;
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Use Inner DTO in DTOs mapped via embedded mapping.':  dv .get.refToObject !=  null           ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }
    {
      NKKey leftSide = ListSequence.fromList(dv).getElement(1).getRefToObject().getDemoKey();
      Object rightSide = null;
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Use Inner DTO in DTOs mapped via embedded mapping.':  dv .get.refToObject.demoKey !=  null           ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }
    {
      NkDTO leftSide = ListSequence.fromList(dv).getElement(1);
      NkDTO rightSide = ListSequence.fromList(dv).getElement(1).getRefToObject();
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Use Inner DTO in DTOs mapped via embedded mapping.':  dv .get !=  dv .get.refToObject          ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }

    {
      String leftSide = ListSequence.fromList(dv).getElement(1).getName();
      String rightSide = ListSequence.fromList(dv).getElement(1).getRefToObject().getName();
      if (!(SaveObjectComperator.equals(leftSide, rightSide))) {
        throw new OFXTestSuitException("'NoKey Tests.Use Inner DTO in DTOs mapped via embedded mapping.':  dv .get.name ==  dv .get.refToObject.name          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String leftSide = ListSequence.fromList(dv).getElement(1).getName();
      String rightSide = ListSequence.fromList(dv).getElement(1).getRefToObject().getDemoKey().getName();
      if (!(SaveObjectComperator.equals(leftSide, rightSide))) {
        throw new OFXTestSuitException("'NoKey Tests.Use Inner DTO in DTOs mapped via embedded mapping.':  dv .get.name ==  dv .get.refToObject.demoKey.name          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }


  }
  @OFXTestMethod(id = 12, name = "Use INCLUDED complex NoKeyMap to load valueobject embedded.", debug = false, enabled = true, runAt = "")
  public void __testmethod_12(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {



    List<NkDTO> dv = __XNokeysNKRepository.findAllDTOWithValAndRefIncluded(null);
    NkDTO first = ListSequence.fromList(dv).first();

    {
      boolean leftSide = first.getName() != null;
      boolean rightSide = !("".equals(first.getName()));
    }
    {
      NKKey leftSide = first.getDemoKey();
      Object rightSide = null;
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Use INCLUDED complex NoKeyMap to load valueobject embedded.':  first .demoKey !=  null           ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }
    {
      int leftSide = first.getDemoKey().getCount();
      int rightSide = first.getCount();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Use INCLUDED complex NoKeyMap to load valueobject embedded.':  first .demoKey.count ==  first .count          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String leftSide = first.getDemoKey().getName();
      String rightSide = first.getName();
      if (!(SaveObjectComperator.equals(leftSide, rightSide))) {
        throw new OFXTestSuitException("'NoKey Tests.Use INCLUDED complex NoKeyMap to load valueobject embedded.':  first .demoKey.name ==  first .name          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 13, name = "Load Value Object with mapper streight.", debug = false, enabled = true, runAt = "")
  public void __testmethod_13(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    List<NKKey> allVos = __XNokeysNKRepository.findAllKeys("DAN", __manMapSession);
    {
      int leftSide = ListSequence.fromList(allVos).count();
      int rightSide = 2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load Value Object with mapper streight.':  allVos .size == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(ListSequence.fromList(allVos).all((it) -> it.getName().equals("DAN")))) {
      throw new OFXTestSuitException("'NoKey Tests.Load Value Object with mapper streight.':  allVos .all          ==>> FALSE !" + "\n");
    }
  }
  @OFXTestMethod(id = 14, name = "Load DTO with mapper - check count", debug = false, enabled = true, runAt = "")
  public void __testmethod_14(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    {
      int leftSide = __XNokeysNKRepository.countNkDtoS_MAPPER(__manMapSession);
      int rightSide = 4;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - check count': #NKRepository.countNkDtoS_MAPPER() == 4          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 15, name = "Load DTO with mapper - load DTOs", debug = false, enabled = true, runAt = "")
  public void __testmethod_15(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    List<NkDTO> obj = __XNokeysNKRepository.findAllNkDtoS_MAPPER(__manMapSession);
    {
      int leftSide = ListSequence.fromList(obj).count();
      int rightSide = 4;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs':  obj .size == 4          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      String operand = ListSequence.fromList(obj).getElement(0).getName();
      String param0 = "DAN";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs':  obj .get.name.equals(\"DAN\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = ListSequence.fromList(obj).getElement(1).getName();
      String param0 = "WOLFG";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs':  obj .get.name.equals(\"WOLFG\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = ListSequence.fromList(obj).getElement(2).getName();
      String param0 = "DAN";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs':  obj .get.name.equals(\"DAN\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = ListSequence.fromList(obj).getElement(3).getName();
      String param0 = "DAN2";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs':  obj .get.name.equals(\"DAN2\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    {
      String operand = ListSequence.fromList(obj).getElement(0).getDemoKey().getName();
      String param0 = "DAN";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs':  obj .get.demoKey.name.equals(\"DAN\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = ListSequence.fromList(obj).getElement(1).getDemoKey().getName();
      String param0 = "WOLFG";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs':  obj .get.demoKey.name.equals(\"WOLFG\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = ListSequence.fromList(obj).getElement(2).getDemoKey().getName();
      String param0 = "DAN";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs':  obj .get.demoKey.name.equals(\"DAN\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = ListSequence.fromList(obj).getElement(3).getDemoKey().getName();
      String param0 = "DAN2";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs':  obj .get.demoKey.name.equals(\"DAN2\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    {
      BigDecimal leftSide = ListSequence.fromList(obj).getElement(0).getBigDeci();
      BigDecimal rightSide = new BigDecimal("12.2");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs':  obj .get.bigDeci == 12.2bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      BigDecimal leftSide = ListSequence.fromList(obj).getElement(1).getBigDeci();
      BigDecimal rightSide = new BigDecimal("24.4");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs':  obj .get.bigDeci == 24.4bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      BigDecimal leftSide = ListSequence.fromList(obj).getElement(2).getBigDeci();
      BigDecimal rightSide = new BigDecimal("13.2");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs':  obj .get.bigDeci == 13.2bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      BigDecimal leftSide = ListSequence.fromList(obj).getElement(3).getBigDeci();
      BigDecimal rightSide = new BigDecimal("13.3");
      if (leftSide.compareTo(rightSide) != 0) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs':  obj .get.bigDeci == 13.3bd          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      IOFXMetaStatus.IOFXStatusElement operand = ListSequence.fromList(obj).getElement(0).getStatus();
      if (!(SaveObjectComperator.equalsStatus(operand, NkDTO_ActiveStat.ON))) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs':  obj .get.status of on           ==>>" + operand + "\n");
      }
    }
    {
      IOFXMetaStatus.IOFXStatusElement operand = ListSequence.fromList(obj).getElement(1).getStatus();
      if (!(SaveObjectComperator.equalsStatus(operand, NkDTO_ActiveStat.OFF))) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs':  obj .get.status of off           ==>>" + operand + "\n");
      }
    }
    {
      IOFXMetaStatus.IOFXStatusElement operand = ListSequence.fromList(obj).getElement(2).getStatus();
      if (!(SaveObjectComperator.equalsStatus(operand, NkDTO_ActiveStat.OFF))) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs':  obj .get.status of off           ==>>" + operand + "\n");
      }
    }
    {
      IOFXMetaStatus.IOFXStatusElement operand = ListSequence.fromList(obj).getElement(3).getStatus();
      if (!(SaveObjectComperator.equalsStatus(operand, NkDTO_ActiveStat.OFF))) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs':  obj .get.status of off           ==>>" + operand + "\n");
      }
    }
  }
  @OFXTestMethod(id = 16, name = "Load DTO with mapper - load DTOs with condition", debug = false, enabled = true, runAt = "")
  public void __testmethod_16(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    List<NkDTO> obj = __XNokeysNKRepository.findAllNkDtoSByCondition_MAPPER("DAN", __manMapSession);
    {
      int leftSide = ListSequence.fromList(obj).count();
      int rightSide = 2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs with condition':  obj .size == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    if (!(ListSequence.fromList(obj).all((it) -> it.getName().equals("DAN")))) {
      throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs with condition':  obj .all          ==>> FALSE !" + "\n");
    }
  }
  @OFXTestMethod(id = 17, name = "Load DTO with mapper - load DTOs and Article joined.", debug = false, enabled = true, runAt = "")
  public void __testmethod_17(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    List<NkDTO> obj = __XNokeysNKRepository.findAllNkDtoSWithArticle_MAPPER(__manMapSession);
    {
      int leftSide = ListSequence.fromList(obj).count();
      int rightSide = 4;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs and Article joined.':  obj .size == 4          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      String operand = ListSequence.fromList(obj).getElement(0).getName();
      String param0 = "DAN";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs and Article joined.':  obj .get.name.equals(\"DAN\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = ListSequence.fromList(obj).getElement(1).getName();
      String param0 = "WOLFG";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs and Article joined.':  obj .get.name.equals(\"WOLFG\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = ListSequence.fromList(obj).getElement(2).getName();
      String param0 = "DAN";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs and Article joined.':  obj .get.name.equals(\"DAN\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = ListSequence.fromList(obj).getElement(3).getName();
      String param0 = "DAN2";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs and Article joined.':  obj .get.name.equals(\"DAN2\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    {
      String operand = ListSequence.fromList(obj).getElement(0).getRefArticle().getName();
      String param0 = "Articel 1";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs and Article joined.':  obj .get.refArticle.name.equals(\"Articel 1\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = ListSequence.fromList(obj).getElement(1).getRefArticle().getName();
      String param0 = "Articel 2";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs and Article joined.':  obj .get.refArticle.name.equals(\"Articel 2\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = ListSequence.fromList(obj).getElement(2).getRefArticle().getName();
      String param0 = "Articel 1";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs and Article joined.':  obj .get.refArticle.name.equals(\"Articel 1\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
    {
      String operand = ListSequence.fromList(obj).getElement(3).getRefArticle().getName();
      String param0 = "Articel 2";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs and Article joined.':  obj .get.refArticle.name.equals(\"Articel 2\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    {
      NKArticle leftSide = ListSequence.fromList(obj).getElement(0).getRefArticle();
      NKArticle rightSide = ListSequence.fromList(obj).getElement(2).getRefArticle();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs and Article joined.':  obj .get.refArticle ==  obj .get.refArticle          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      NKArticle leftSide = ListSequence.fromList(obj).getElement(1).getRefArticle();
      NKArticle rightSide = ListSequence.fromList(obj).getElement(3).getRefArticle();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'NoKey Tests.Load DTO with mapper - load DTOs and Article joined.':  obj .get.refArticle ==  obj .get.refArticle          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }


  public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  public static void main(String[] args) {
    String[] allIncludedTest = new String[]{"org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit"};
    String[] includedTestToRun = new String[]{};

    OFXTestSuit.runAsMain("org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", NoKey_Tests.class, allIncludedTest, includedTestToRun);
  }
}
