package org.modellwerkstatt.objectflow.tests.manmap.Tests;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.CreatorsFactory;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoInvoice;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.OFXIncludedSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Invoice;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;
import org.modellwerkstatt.objectflow.runtime.IOFXSessionOperation;
import org.springframework.jdbc.IncorrectResultSetColumnCountException;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXEntity;
import org.modellwerkstatt.manmap.runtime.IM3Entity;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.InvoicePosition;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import org.modellwerkstatt.objectflow.runtime.IOFXMeta4Entity;

public class Session_tests extends OFXTestSuit {

  @Autowired
  private CreatorsFactory __DomainCreatorsFactory;
  @Autowired
  private RepoInvoice __DomainRepoInvoice;
  @Autowired
  private IOFXPlatform __runtimeIOFXPlatform;
  @Autowired
  private IOFXTranslationProvider __runtimeIOFXTranslationProvider;


  @OFXIncludedSuit(name = "org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit")
  private DBinit ___inst_DBinit;


  public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  @OFXTestMethod(id = 0, name = "Load same object read-only twice (with get).", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("ses", __manMapSession);


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);

    Invoice same = __DomainRepoInvoice.getInvoiceByIdRO(inv1.getId(), session);
    Invoice same2 = __DomainRepoInvoice.getInvoiceByIdRO(inv1.getId(), session);
    Invoice reloaded3 = __DomainRepoInvoice.getInvoiceByIdRO(inv1.getId(), null);

    {
      Invoice leftSide = same;
      Invoice rightSide = same2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Load same object read-only twice (with get).':  same  ==  same2           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      Invoice leftSide = same;
      Invoice rightSide = reloaded3;
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'Session tests.Load same object read-only twice (with get).':  same  !=  reloaded3           ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 1, name = "Load same object read-only twice (with where).", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("ses", __manMapSession);


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);

    Invoice invGraph = __DomainRepoInvoice.findInvoiceByIdWitoutRefs(inv1.getId(), session);
    Invoice invGraph2 = __DomainRepoInvoice.findInvoiceByIdWitoutRefs(inv1.getId(), session);
    Invoice invWithoutSession = __DomainRepoInvoice.findInvoiceByIdWitoutRefs(inv1.getId(), null);

    {
      Invoice leftSide = invGraph;
      Invoice rightSide = invGraph2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Load same object read-only twice (with where).':  invGraph  ==  invGraph2           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      Invoice leftSide = invGraph;
      Invoice rightSide = invWithoutSession;
      if (leftSide == rightSide) {
        throw new OFXTestSuitException("'Session tests.Load same object read-only twice (with where).':  invGraph  !=  invWithoutSession           ==>>" + leftSide + " !=" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 2, name = "Queue an checkin operation and commit", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_2(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    final Invoice invoice = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_NOTonDB("ses", __manMapSession);


    final IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    {
      int leftSide = invoice.getId();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Queue an checkin operation and commit':  invoice .id == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    session.addOperation(new IOFXSessionOperation() {
      public void execute() {
        __DomainRepoInvoice.checkinInvoice(invoice, session);
      }
      public String getInformation() {
        return "checkin invoice";
      }
    });

    try {
      session.startTransactionAndFlush();
    } catch (Exception e) {
      throw new RuntimeException(e);
    }

    {
      int leftSide = invoice.getId();
      int rightSide = 0;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'Session tests.Queue an checkin operation and commit':  invoice .id > 0          ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }

    Invoice withOutSession = __DomainRepoInvoice.checkoutInvoiceByIdWithoutRefs(invoice.getId(), null);
    {
      int leftSide = withOutSession.getId();
      int rightSide = invoice.getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Queue an checkin operation and commit':  withOutSession .id ==  invoice .id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 3, name = "Queue a checkin operation and rollback.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_3(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    final Invoice invoice = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_NOTonDB("ses", __manMapSession);

    final IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    {
      int leftSide = invoice.getId();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Queue a checkin operation and rollback.':  invoice .id == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    session.addOperation(new IOFXSessionOperation() {
      public void execute() {
        __DomainRepoInvoice.checkinInvoice(invoice, session);
      }
      public String getInformation() {
        return "checkin invoice";
      }
    });

    session.addOperation(new IOFXSessionOperation() {
      public void execute() {
        throw new RuntimeException("catch me");
      }
      public String getInformation() {
        return "catch me exception";
      }
    });

    boolean catched = false;
    try {
      session.startTransactionAndFlush();
    } catch (Exception ex) {
      if (!(catched = true)) {
        throw new OFXTestSuitException("'Session tests.Queue a checkin operation and rollback.':  =           ==>> FALSE !" + "\n");
      }
      {
        String operand = ex.getMessage();
        String param0 = "catch me";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append("" + param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!(operand.contains(param0))) {
          throw new OFXTestSuitException("'Session tests.Queue a checkin operation and rollback.':  ex .getMessage().contains(\"catch me\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
        }
      }
    }
    {
      boolean leftSide = catched;
      boolean rightSide = true;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Queue a checkin operation and rollback.':  catched  == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    // entities state (tcn, id) get also rolled back, summer 25 
    {
      int leftSide = invoice.getId();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Queue a checkin operation and rollback.':  invoice .id == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    //  entity not saved due to rollback, invoice.id == 0, checkout is null
    Invoice checkedOutInvoice = __DomainRepoInvoice.getInvoiceByIdRO(invoice.getId(), null);
    {
      Invoice leftSide = checkedOutInvoice;
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Queue a checkin operation and rollback.':  checkedOutInvoice  ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 4, name = "Checkin and delete in same transaction.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_4(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    final Invoice invoice = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_NOTonDB("ses", __manMapSession);


    final IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    {
      int leftSide = invoice.getId();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Checkin and delete in same transaction.':  invoice .id == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    session.addOperation(new IOFXSessionOperation() {
      public void execute() {
        __DomainRepoInvoice.checkinInvoice(invoice, session);
      }
      public String getInformation() {
        return "checkin invoice";
      }
    });

    session.addOperation(new IOFXSessionOperation() {
      public void execute() {
        __DomainRepoInvoice.deleteInovice(invoice, session);
      }
      public String getInformation() {
        return "delete invoice";
      }
    });

    try {
      session.startTransactionAndFlush();
    } catch (Exception ex) {
      throw new RuntimeException(ex);
    }
    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        Invoice checkedOutInvoice = __DomainRepoInvoice.getInvoiceByIdRO(invoice.getId(), null);

      } catch (IncorrectResultSetColumnCountException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();


      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Session tests.Checkin and delete in same transaction.': Fail In Exception IncorrectResultSetColumnCountException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Session tests.Checkin and delete in same transaction.': Fail In Exception IncorrectResultSetColumnCountException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Session tests.Checkin and delete in same transaction.': Fail In Exception 'IncorrectResultSetColumnCountException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

  }
  @OFXTestMethod(id = 5, name = "Session marked dirty when changing checked out entity.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_5(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice invoice = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("ses", __manMapSession);


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);

    Invoice reloaded = __DomainRepoInvoice.checkoutInvoiceByIdWithoutRefs(invoice.getId(), session);
    {
      boolean leftSide = session.isDirty();
      boolean rightSide = false;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Session marked dirty when changing checked out entity.':  session .isDirty() == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    reloaded.setText("* change *");
    {
      boolean leftSide = session.isDirty();
      boolean rightSide = true;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Session marked dirty when changing checked out entity.':  session .isDirty() == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 6, name = "Checkout of entity already checked out leads to exception (with get).", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_6(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("ses", __manMapSession);


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);

    Invoice reloaded = __DomainRepoInvoice.checkoutInvoiceHeadGet(inv.getId(), session);

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        Invoice reloaded2 = __DomainRepoInvoice.checkoutInvoiceHeadGet(inv.getId(), session);

      } catch (IllegalStateException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("already checked out")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("already checked out")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Session tests.Checkout of entity already checked out leads to exception (with get).': Fail In Exception IllegalStateException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Session tests.Checkout of entity already checked out leads to exception (with get).': Fail In Exception IllegalStateException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Session tests.Checkout of entity already checked out leads to exception (with get).': Fail In Exception 'IllegalStateException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

  }
  @OFXTestMethod(id = 7, name = "Checkout of entity already checked out leads to exception (with where).", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_7(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("ses", __manMapSession);


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);

    Invoice reloaded = __DomainRepoInvoice.checkoutInvoiceHeadWhere(inv.getId(), session);

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        Invoice reloaded2 = __DomainRepoInvoice.checkoutInvoiceHeadWhere(inv.getId(), session);

      } catch (IllegalStateException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("already checked out")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("already checked out")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Session tests.Checkout of entity already checked out leads to exception (with where).': Fail In Exception IllegalStateException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Session tests.Checkout of entity already checked out leads to exception (with where).': Fail In Exception IllegalStateException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Session tests.Checkout of entity already checked out leads to exception (with where).': Fail In Exception 'IllegalStateException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

  }
  @OFXTestMethod(id = 8, name = "Checkout of entity already loaded in ReadOnly leads to an exception (with get).", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_8(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("ses", __manMapSession);


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);

    Invoice roLoaded = __DomainRepoInvoice.findInvoiceByIdWitoutRefs(inv.getId(), session);

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        Invoice checkout = __DomainRepoInvoice.checkoutInvoiceHeadGet(inv.getId(), session);

      } catch (IllegalStateException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("already checked out")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("already checked out")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Session tests.Checkout of entity already loaded in ReadOnly leads to an exception (with get).': Fail In Exception IllegalStateException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Session tests.Checkout of entity already loaded in ReadOnly leads to an exception (with get).': Fail In Exception IllegalStateException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Session tests.Checkout of entity already loaded in ReadOnly leads to an exception (with get).': Fail In Exception 'IllegalStateException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

  }
  @OFXTestMethod(id = 9, name = "Checkout of entity already loaded in ReadOnly leads to an exception (with where).", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_9(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("ses", __manMapSession);


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);

    Invoice roLoaded = __DomainRepoInvoice.findInvoiceByIdWitoutRefs(inv.getId(), session);

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        Invoice checkout = __DomainRepoInvoice.checkoutInvoiceHeadWhere(inv.getId(), session);

      } catch (IllegalStateException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("already checked out")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("already checked out")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Session tests.Checkout of entity already loaded in ReadOnly leads to an exception (with where).': Fail In Exception IllegalStateException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Session tests.Checkout of entity already loaded in ReadOnly leads to an exception (with where).': Fail In Exception IllegalStateException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Session tests.Checkout of entity already loaded in ReadOnly leads to an exception (with where).': Fail In Exception 'IllegalStateException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

  }
  @OFXTestMethod(id = 10, name = "Query entity ready only when already checked out leads to an exception (wtih get).", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_10(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("ses", __manMapSession);


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);

    Invoice roLoaded = __DomainRepoInvoice.checkoutInvoiceByIdWithoutRefs(inv.getId(), session);

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        Invoice invoice = __DomainRepoInvoice.getInvoiceByIdRO(inv.getId(), session);

      } catch (IllegalStateException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("already checked out")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("already checked out")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Session tests.Query entity ready only when already checked out leads to an exception (wtih get).': Fail In Exception IllegalStateException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Session tests.Query entity ready only when already checked out leads to an exception (wtih get).': Fail In Exception IllegalStateException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Session tests.Query entity ready only when already checked out leads to an exception (wtih get).': Fail In Exception 'IllegalStateException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

  }
  @OFXTestMethod(id = 11, name = "Query entity ready only when already checked out leads to an exception (with where).", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_11(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("ses", __manMapSession);


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);

    Invoice roLoaded = __DomainRepoInvoice.checkoutInvoiceByIdWithoutRefs(inv.getId(), session);

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        List<Invoice> invoices = __DomainRepoInvoice.findAllInvoices(session);

      } catch (IllegalStateException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("already checked out")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("already checked out")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Session tests.Query entity ready only when already checked out leads to an exception (with where).': Fail In Exception IllegalStateException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Session tests.Query entity ready only when already checked out leads to an exception (with where).': Fail In Exception IllegalStateException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Session tests.Query entity ready only when already checked out leads to an exception (with where).': Fail In Exception 'IllegalStateException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }

  }
  @OFXTestMethod(id = 12, name = "Deleting a readonly entity leads to an exception.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_12(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("ses", __manMapSession);


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);

    Invoice reloaded = __DomainRepoInvoice.findInvoiceByIdWitoutRefs(inv.getId(), session);

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        __DomainRepoInvoice.deleteInovice(reloaded, session);

      } catch (IllegalStateException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("marked as readonly")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("marked as readonly")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Session tests.Deleting a readonly entity leads to an exception.': Fail In Exception IllegalStateException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Session tests.Deleting a readonly entity leads to an exception.': Fail In Exception IllegalStateException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Session tests.Deleting a readonly entity leads to an exception.': Fail In Exception 'IllegalStateException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }
  }
  @OFXTestMethod(id = 13, name = "Saving a new entity adds entity to session, checkout leads to error.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_13(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    final Invoice invoice = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_NOTonDB("ses", __manMapSession);


    final IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    {
      int leftSide = invoice.getId();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Saving a new entity adds entity to session, checkout leads to error.':  invoice .id == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    session.addOperation(new IOFXSessionOperation() {
      public void execute() {
        __DomainRepoInvoice.checkinInvoice(invoice, session);
      }
      public String getInformation() {
        return "checkin invoice";
      }
    });

    try {
      session.startTransactionAndFlush();
    } catch (Exception e) {
      throw new RuntimeException(e);
    }

    {
      int leftSide = invoice.getId();
      int rightSide = 0;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'Session tests.Saving a new entity adds entity to session, checkout leads to error.':  invoice .id > 0          ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        Invoice withOutSession = __DomainRepoInvoice.checkoutInvoiceByIdWithoutRefs(invoice.getId(), session);

      } catch (IllegalStateException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("already checked out")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("already checked out")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Session tests.Saving a new entity adds entity to session, checkout leads to error.': Fail In Exception IllegalStateException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Session tests.Saving a new entity adds entity to session, checkout leads to error.': Fail In Exception IllegalStateException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Session tests.Saving a new entity adds entity to session, checkout leads to error.': Fail In Exception 'IllegalStateException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }
  }
  @OFXTestMethod(id = 14, name = "Saving a new entity adds entity to session, radonly find leads to error.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_14(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    final Invoice invoice = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_NOTonDB("ses", __manMapSession);


    final IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    {
      int leftSide = invoice.getId();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Saving a new entity adds entity to session, radonly find leads to error.':  invoice .id == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    session.addOperation(new IOFXSessionOperation() {
      public void execute() {
        __DomainRepoInvoice.checkinInvoice(invoice, session);
      }
      public String getInformation() {
        return "checkin invoice";
      }
    });

    try {
      session.startTransactionAndFlush();
    } catch (Exception e) {
      throw new RuntimeException(e);
    }

    {
      int leftSide = invoice.getId();
      int rightSide = 0;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'Session tests.Saving a new entity adds entity to session, radonly find leads to error.':  invoice .id > 0          ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }

    {
      boolean __FailIn_catched = false;
      boolean __FailIn_text = true;
      Throwable __FailIn_origThrowable = null;
      String messagesInProblems = "";

      try {
        Invoice withOutSession = __DomainRepoInvoice.findInvoiceByIdWitoutRefs(invoice.getId(), session);

      } catch (IllegalStateException ex) {
        __FailIn_origThrowable = ex;
        __FailIn_catched = true;
        messagesInProblems = ex.getMessage();

        __FailIn_text = false;
        if (messagesInProblems == null) {
          messagesInProblems = "";
        }
        if (messagesInProblems.contains("already checked out")) {
          __FailIn_text = true;

        } else {
          // down ward compatibility for OFXAbortException
          messagesInProblems += "\n";
          List<IOFXProblem> allProblems = __manMapSession.getAndclearProblemState();
          for (IOFXProblem problem : allProblems) {
            messagesInProblems += problem.getSimpleUserText() + "\n";
            if (problem.getSimpleUserText().contains("already checked out")) {
              __FailIn_text = true;
              break;
            }
          }
        }

      } catch (Throwable t) {
        throw new RuntimeException(t);

      } finally {
        // check also loop in map_OFXTestSuit

        if (!(__FailIn_catched) && __FailIn_origThrowable == null) {
          throw new OFXTestSuitException("'Session tests.Saving a new entity adds entity to session, radonly find leads to error.': Fail In Exception IllegalStateException was NOT catched!");

        } else if (__FailIn_catched && !(__FailIn_text)) {
          throw new OFXTestSuitException("'Session tests.Saving a new entity adds entity to session, radonly find leads to error.': Fail In Exception IllegalStateException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");

        } else if (!(__FailIn_catched)) {
          throw new OFXTestSuitException("'Session tests.Saving a new entity adds entity to session, radonly find leads to error.': Fail In Exception 'IllegalStateException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String(__FailIn_origThrowable));
        }

      }

    }
  }
  @OFXTestMethod(id = 15, name = "Deleting an entity removes entity from session.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_15(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice invoice = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("ses", __manMapSession);


    final IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);

    final Invoice reloaded = __DomainRepoInvoice.checkoutInvoiceByIdWithoutRefs(invoice.getId(), session);

    session.addOperation(new IOFXSessionOperation() {
      public void execute() {
        __DomainRepoInvoice.deleteInovice(reloaded, session);
      }
      public String getInformation() {
        return "delete invoice";
      }
    });

    try {
      session.startTransactionAndFlush();
    } catch (Exception e) {
      throw new RuntimeException(e);
    }

    {
      boolean leftSide = session.getOrCreateKeyStore(((IOFXEntity) invoice).getSessionObjectKeyStoreID()).has(invoice.getId());
      boolean rightSide = false;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Deleting an entity removes entity from session.':  session .getOrCreateKeyStore(((IOFXEntity) invoice ).getSessionObjectKeyStoreID()).has( invoice .id) == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      IM3Entity<Object> leftSide = session.getOrCreateKeyStore(((IOFXEntity) invoice).getSessionObjectKeyStoreID()).get(invoice.getId());
      Object rightSide = null;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Deleting an entity removes entity from session.':  session .getOrCreateKeyStore(((IOFXEntity) invoice ).getSessionObjectKeyStoreID()).get( invoice .id) ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 16, name = "Using Session multiple times to store an entity.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_16(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    final Invoice invoice = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_NOTonDB("ses", __manMapSession);


    final IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    {
      int leftSide = invoice.getId();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Using Session multiple times to store an entity.':  invoice .id == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    try {
      session.addOperation(new IOFXSessionOperation() {
        public void execute() {
          invoice.setText("v1");
          __DomainRepoInvoice.checkinInvoice(invoice, session);
        }
        public String getInformation() {
          return "Checkin Invoice";
        }
      });

      session.startTransactionAndFlush();
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
    {
      int leftSide = invoice.getId();
      int rightSide = 0;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'Session tests.Using Session multiple times to store an entity.':  invoice .id > 0          ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }

    Invoice reloaded = __DomainRepoInvoice.findInvoiceByIdWitoutRefs(invoice.getId(), null);
    {
      String operand = reloaded.getText();
      String param0 = "v1";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Session tests.Using Session multiple times to store an entity.':  reloaded .text.equals(\"v1\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }


    try {
      session.addOperation(new IOFXSessionOperation() {
        public void execute() {
          invoice.setText("v2");
          __DomainRepoInvoice.checkinInvoice(invoice, session);
        }
        public String getInformation() {
          return "Checkin Invoice";
        }
      });

      session.startTransactionAndFlush();
    } catch (Exception e) {
      throw new RuntimeException(e);
    }

    Invoice reloaded2 = __DomainRepoInvoice.findInvoiceByIdWitoutRefs(invoice.getId(), null);
    {
      String operand = reloaded2.getText();
      String param0 = "v2";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Session tests.Using Session multiple times to store an entity.':  reloaded2 .text.equals(\"v2\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 17, name = "Load same list twice (readonly where)", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_17(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("ses", __manMapSession);
    __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("ses", __manMapSession);


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);

    List<InvoicePosition> positions = __DomainRepoInvoice.findAllInvoicePositions(session);
    List<InvoicePosition> positions2 = __DomainRepoInvoice.findAllInvoicePositions(session);

    {
      int leftSide = ListSequence.fromList(positions).count();
      int rightSide = ListSequence.fromList(positions2).count();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Load same list twice (readonly where)':  positions .size ==  positions2 .size          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    for (int i = 0; i < ListSequence.fromList(positions).count(); i++) {
      {
        InvoicePosition leftSide = ListSequence.fromList(positions).getElement(i);
        InvoicePosition rightSide = ListSequence.fromList(positions2).getElement(i);
        if (leftSide != rightSide) {
          throw new OFXTestSuitException("'Session tests.Load same list twice (readonly where)':  positions .get ==  positions2 .get          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
      }
    }
  }
  @OFXTestMethod(id = 18, name = "Load two graphs in session with join on childs", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_18(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("g1", __manMapSession);
    Invoice inv2 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("g2", __manMapSession);


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);

    Invoice reload1 = __DomainRepoInvoice.checkoutInvoiceJoinPositions(inv1.getId(), session);
    Invoice reload2 = __DomainRepoInvoice.checkoutInvoiceJoinPositions(inv2.getId(), session);


    {
      int leftSide = ListSequence.fromList(reload1.getPositions()).getElement(0).getId();
      int rightSide = ListSequence.fromList(inv1.getPositions()).getElement(0).getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Load two graphs in session with join on childs':  reload1 .positions.get.id ==  inv1 .positions.get.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(reload1.getPositions()).getElement(3).getId();
      int rightSide = ListSequence.fromList(inv1.getPositions()).getElement(3).getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Load two graphs in session with join on childs':  reload1 .positions.get.id ==  inv1 .positions.get.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      int leftSide = ListSequence.fromList(reload2.getPositions()).getElement(0).getId();
      int rightSide = ListSequence.fromList(inv2.getPositions()).getElement(0).getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Load two graphs in session with join on childs':  reload2 .positions.get.id ==  inv2 .positions.get.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(reload2.getPositions()).getElement(3).getId();
      int rightSide = ListSequence.fromList(inv2.getPositions()).getElement(3).getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Load two graphs in session with join on childs':  reload2 .positions.get.id ==  inv2 .positions.get.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 19, name = "Load two graphs in session with join on childs reverse", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_19(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("g1", __manMapSession);
    Invoice inv2 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("g2", __manMapSession);


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);

    Invoice reload1 = __DomainRepoInvoice.checkoutInvoiceJoinPositionsReverse(inv1.getId(), session);
    Invoice reload2 = __DomainRepoInvoice.checkoutInvoiceJoinPositionsReverse(inv2.getId(), session);


    {
      int leftSide = ListSequence.fromList(reload1.getPositions()).getElement(0).getId();
      int rightSide = ListSequence.fromList(inv1.getPositions()).getElement(0).getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Load two graphs in session with join on childs reverse':  reload1 .positions.get.id ==  inv1 .positions.get.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(reload1.getPositions()).getElement(3).getId();
      int rightSide = ListSequence.fromList(inv1.getPositions()).getElement(3).getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Load two graphs in session with join on childs reverse':  reload1 .positions.get.id ==  inv1 .positions.get.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      int leftSide = ListSequence.fromList(reload2.getPositions()).getElement(0).getId();
      int rightSide = ListSequence.fromList(inv2.getPositions()).getElement(0).getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Load two graphs in session with join on childs reverse':  reload2 .positions.get.id ==  inv2 .positions.get.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(reload2.getPositions()).getElement(3).getId();
      int rightSide = ListSequence.fromList(inv2.getPositions()).getElement(3).getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Load two graphs in session with join on childs reverse':  reload2 .positions.get.id ==  inv2 .positions.get.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 20, name = "One query - Load two graphs in session with join on childs", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_20(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("g1", __manMapSession);
    Invoice inv2 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("g2", __manMapSession);


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);

    List<Invoice> reloaded = __DomainRepoInvoice.checkoutInvoiceJoinPositionsByIds(ListSequence.fromListAndArray(new ArrayList<Integer>(), inv1.getId(), inv2.getId()), session);

    Invoice reload1 = ListSequence.fromList(reloaded).first();
    {
      int leftSide = ListSequence.fromList(reload1.getPositions()).getElement(0).getId();
      int rightSide = ListSequence.fromList(inv1.getPositions()).getElement(0).getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.One query - Load two graphs in session with join on childs':  reload1 .positions.get.id ==  inv1 .positions.get.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(reload1.getPositions()).getElement(3).getId();
      int rightSide = ListSequence.fromList(inv1.getPositions()).getElement(3).getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.One query - Load two graphs in session with join on childs':  reload1 .positions.get.id ==  inv1 .positions.get.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    Invoice reload2 = ListSequence.fromList(reloaded).getElement(1);
    {
      int leftSide = ListSequence.fromList(reload2.getPositions()).getElement(0).getId();
      int rightSide = ListSequence.fromList(inv2.getPositions()).getElement(0).getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.One query - Load two graphs in session with join on childs':  reload2 .positions.get.id ==  inv2 .positions.get.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(reload2.getPositions()).getElement(3).getId();
      int rightSide = ListSequence.fromList(inv2.getPositions()).getElement(3).getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.One query - Load two graphs in session with join on childs':  reload2 .positions.get.id ==  inv2 .positions.get.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }


  }
  @OFXTestMethod(id = 21, name = "One query - Load two graphs in session with join on childs reverse", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_21(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("g1", __manMapSession);
    Invoice inv2 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("g2", __manMapSession);


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);

    List<Invoice> reloaded = __DomainRepoInvoice.checkoutInvoiceJoinPositionsReverseByIds(ListSequence.fromListAndArray(new ArrayList<Integer>(), inv1.getId(), inv2.getId()), session);

    Invoice reload1 = ListSequence.fromList(reloaded).first();
    {
      int leftSide = ListSequence.fromList(reload1.getPositions()).getElement(0).getId();
      int rightSide = ListSequence.fromList(inv1.getPositions()).getElement(0).getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.One query - Load two graphs in session with join on childs reverse':  reload1 .positions.get.id ==  inv1 .positions.get.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(reload1.getPositions()).getElement(3).getId();
      int rightSide = ListSequence.fromList(inv1.getPositions()).getElement(3).getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.One query - Load two graphs in session with join on childs reverse':  reload1 .positions.get.id ==  inv1 .positions.get.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    Invoice reload2 = ListSequence.fromList(reloaded).getElement(1);
    {
      int leftSide = ListSequence.fromList(reload2.getPositions()).getElement(0).getId();
      int rightSide = ListSequence.fromList(inv2.getPositions()).getElement(0).getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.One query - Load two graphs in session with join on childs reverse':  reload2 .positions.get.id ==  inv2 .positions.get.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(reload2.getPositions()).getElement(3).getId();
      int rightSide = ListSequence.fromList(inv2.getPositions()).getElement(3).getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.One query - Load two graphs in session with join on childs reverse':  reload2 .positions.get.id ==  inv2 .positions.get.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 22, name = "One query - Load two graphs in session with join on childs, pos readonly", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_22(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("g1", __manMapSession);
    Invoice inv2 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("g2", __manMapSession);


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);

    List<Invoice> reloaded = __DomainRepoInvoice.checkoutInvoiceJoinPositions_posRO(ListSequence.fromListAndArray(new ArrayList<Integer>(), inv1.getId(), inv2.getId()), session);
    Invoice i1 = ListSequence.fromList(reloaded).getElement(0);
    {
      boolean leftSide = ((IOFXEntity) i1).getReadOnly();
      boolean rightSide = false;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.One query - Load two graphs in session with join on childs, pos readonly': ((IOFXEntity) i1 ).getReadOnly() == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      boolean leftSide = ListSequence.fromList(i1.getPositions()).any((it) -> ((IOFXEntity) it).getReadOnly() == false);
      boolean rightSide = false;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.One query - Load two graphs in session with join on childs, pos readonly':  i1 .positions.any == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    Invoice i2 = ListSequence.fromList(reloaded).getElement(1);
    {
      boolean leftSide = ((IOFXEntity) i2).getReadOnly();
      boolean rightSide = false;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.One query - Load two graphs in session with join on childs, pos readonly': ((IOFXEntity) i2 ).getReadOnly() == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      boolean leftSide = ListSequence.fromList(i2.getPositions()).any((it) -> ((IOFXEntity) it).getReadOnly() == false);
      boolean rightSide = false;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.One query - Load two graphs in session with join on childs, pos readonly':  i2 .positions.any == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

  }
  @OFXTestMethod(id = 23, name = "One query - Load two graphs in session with join on childs, pos readonly reverse", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_23(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("g1", __manMapSession);
    Invoice inv2 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("g2", __manMapSession);


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);

    List<Invoice> reloaded = __DomainRepoInvoice.checkoutInvoiceJoinPositionsReverse_posRO(ListSequence.fromListAndArray(new ArrayList<Integer>(), inv1.getId(), inv2.getId()), session);
    Invoice i1 = ListSequence.fromList(reloaded).getElement(0);
    {
      boolean leftSide = ((IOFXEntity) i1).getReadOnly();
      boolean rightSide = false;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.One query - Load two graphs in session with join on childs, pos readonly reverse': ((IOFXEntity) i1 ).getReadOnly() == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      boolean leftSide = ListSequence.fromList(i1.getPositions()).any((it) -> ((IOFXEntity) it).getReadOnly() == false);
      boolean rightSide = false;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.One query - Load two graphs in session with join on childs, pos readonly reverse':  i1 .positions.any == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    Invoice i2 = ListSequence.fromList(reloaded).getElement(1);
    {
      boolean leftSide = ((IOFXEntity) i2).getReadOnly();
      boolean rightSide = false;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.One query - Load two graphs in session with join on childs, pos readonly reverse': ((IOFXEntity) i2 ).getReadOnly() == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      boolean leftSide = ListSequence.fromList(i2.getPositions()).any((it) -> ((IOFXEntity) it).getReadOnly() == false);
      boolean rightSide = false;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.One query - Load two graphs in session with join on childs, pos readonly reverse':  i2 .positions.any == \"false\"          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }


  }
  @OFXTestMethod(id = 24, name = "One query - load 2 invoices, joins pos and join reference", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_24(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    final Invoice inv1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_NOTonDB("g1-ref", __manMapSession);
    final Invoice inv2 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_NOTonDB("g2-ref", __manMapSession);


    final IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    inv1.setMainPosRef(new InvoicePosition());
    inv1.getMainPosRef().setPosText("ref1");

    inv2.setMainPosRef(new InvoicePosition());
    inv2.getMainPosRef().setPosText("ref2");




    session.addOperation(new IOFXSessionOperation() {

      public void execute() {
        __DomainRepoInvoice.checkinInvoicePosition(inv1.getMainPosRef(), session);
        __DomainRepoInvoice.checkinInvoicePosition(inv2.getMainPosRef(), session);
        __DomainRepoInvoice.checkinInvoice(inv1, session);
        __DomainRepoInvoice.checkinInvoice(inv2, session);
      }

      public String getInformation() {
        return "";
      }
    });
    try {
      session.startTransactionAndFlush();

    } catch (Exception e) {
      throw new RuntimeException(e);
    }

    IOFXSession session2 = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    List<Invoice> invoices = __DomainRepoInvoice.checkoutInvoiceJoinPositions_AndRefJoin(ListSequence.fromListAndArray(new ArrayList<Integer>(), inv1.getId(), inv2.getId()), session2);
    invoices = ListSequence.fromList(invoices).sort((it) -> it.getId(), true).toList();



    Invoice reload1 = ListSequence.fromList(invoices).first();
    {
      int leftSide = ListSequence.fromList(reload1.getPositions()).getElement(0).getId();
      int rightSide = ListSequence.fromList(inv1.getPositions()).getElement(0).getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.One query - load 2 invoices, joins pos and join reference':  reload1 .positions.get.id ==  inv1 .positions.get.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(reload1.getPositions()).getElement(3).getId();
      int rightSide = ListSequence.fromList(inv1.getPositions()).getElement(3).getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.One query - load 2 invoices, joins pos and join reference':  reload1 .positions.get.id ==  inv1 .positions.get.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String operand = reload1.getMainPosRef().getPosText();
      String param0 = "ref1";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Session tests.One query - load 2 invoices, joins pos and join reference':  reload1 .mainPosRef.posText.equals(\"ref1\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }

    Invoice reload2 = ListSequence.fromList(invoices).getElement(1);
    {
      int leftSide = ListSequence.fromList(reload2.getPositions()).getElement(0).getId();
      int rightSide = ListSequence.fromList(inv2.getPositions()).getElement(0).getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.One query - load 2 invoices, joins pos and join reference':  reload2 .positions.get.id ==  inv2 .positions.get.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      int leftSide = ListSequence.fromList(reload2.getPositions()).getElement(3).getId();
      int rightSide = ListSequence.fromList(inv2.getPositions()).getElement(3).getId();
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.One query - load 2 invoices, joins pos and join reference':  reload2 .positions.get.id ==  inv2 .positions.get.id          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
    {
      String operand = reload2.getMainPosRef().getPosText();
      String param0 = "ref2";
      StringBuilder textRepresentation = new StringBuilder();
      textRepresentation.append("" + param0 + ", ");
      textRepresentation.setLength(textRepresentation.length() - 2);
      if (!(operand.equals(param0))) {
        throw new OFXTestSuitException("'Session tests.One query - load 2 invoices, joins pos and join reference':  reload2 .mainPosRef.posText.equals(\"ref2\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") " + "\n");
      }
    }




  }
  @OFXTestMethod(id = 25, name = "Remove element from list should change dirty state of session.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_25(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice created_inv = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("listdirtycheck", __manMapSession);


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    Invoice inv = __DomainRepoInvoice.checkoutInvoiceByIdWithRefs(created_inv.getId(), session);
    if (!(!(session.isDirty()))) {
      throw new OFXTestSuitException("'Session tests.Remove element from list should change dirty state of session.': !( session .isDirty())          ==>> FALSE !" + "\n");
    }

    int origPosSize = ListSequence.fromList(inv.getPositions()).count();
    {
      int leftSide = origPosSize;
      int rightSide = 0;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'Session tests.Remove element from list should change dirty state of session.':  origPosSize  > 0          ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }

    ListSequence.fromList(inv.getPositions()).removeLastElement();
    {
      int leftSide = ListSequence.fromList(inv.getPositions()).count();
      int rightSide = origPosSize - 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Remove element from list should change dirty state of session.':  inv .positions.size ==  origPosSize  - 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      IOFXSession operand = session;
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.isDirty())) {
        throw new OFXTestSuitException("'Session tests.Remove element from list should change dirty state of session.':  session .isDirty()          ==>> '" + operand + "'.isDirty(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 26, name = "Add element to list should change dirty state of session.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_26(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice created_inv = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("listdirtycheck", __manMapSession);


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    Invoice inv = __DomainRepoInvoice.checkoutInvoiceByIdWithRefs(created_inv.getId(), session);
    if (!(!(session.isDirty()))) {
      throw new OFXTestSuitException("'Session tests.Add element to list should change dirty state of session.': !( session .isDirty())          ==>> FALSE !" + "\n");
    }

    int origPosSize = ListSequence.fromList(inv.getPositions()).count();
    {
      int leftSide = origPosSize;
      int rightSide = 0;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'Session tests.Add element to list should change dirty state of session.':  origPosSize  > 0          ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }

    ListSequence.fromList(inv.getPositions()).addElement(new InvoicePosition());
    {
      int leftSide = ListSequence.fromList(inv.getPositions()).count();
      int rightSide = origPosSize + 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Add element to list should change dirty state of session.':  inv .positions.size ==  origPosSize  + 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      IOFXSession operand = session;
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.isDirty())) {
        throw new OFXTestSuitException("'Session tests.Add element to list should change dirty state of session.':  session .isDirty()          ==>> '" + operand + "'.isDirty(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 27, name = "Remove an element and add another one to list should change dirty state of session.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_27(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice created_inv = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("listdirtycheck", __manMapSession);


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    Invoice inv = __DomainRepoInvoice.checkoutInvoiceByIdWithRefs(created_inv.getId(), session);
    if (!(!(session.isDirty()))) {
      throw new OFXTestSuitException("'Session tests.Remove an element and add another one to list should change dirty state of session.': !( session .isDirty())          ==>> FALSE !" + "\n");
    }

    int origPosSize = ListSequence.fromList(inv.getPositions()).count();
    {
      int leftSide = origPosSize;
      int rightSide = 0;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'Session tests.Remove an element and add another one to list should change dirty state of session.':  origPosSize  > 0          ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }

    ListSequence.fromList(inv.getPositions()).removeLastElement();
    ListSequence.fromList(inv.getPositions()).addElement(new InvoicePosition());
    {
      int leftSide = ListSequence.fromList(inv.getPositions()).count();
      int rightSide = origPosSize;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Remove an element and add another one to list should change dirty state of session.':  inv .positions.size ==  origPosSize           ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    {
      IOFXSession operand = session;
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.isDirty())) {
        throw new OFXTestSuitException("'Session tests.Remove an element and add another one to list should change dirty state of session.':  session .isDirty()          ==>> '" + operand + "'.isDirty(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 28, name = "Setting new list with same elements should not change dirty state of session.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_28(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice created_inv = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("listdirtycheck", __manMapSession);


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    Invoice inv = __DomainRepoInvoice.checkoutInvoiceByIdWithRefs(created_inv.getId(), session);
    if (!(!(session.isDirty()))) {
      throw new OFXTestSuitException("'Session tests.Setting new list with same elements should not change dirty state of session.': !( session .isDirty())          ==>> FALSE !" + "\n");
    }

    int origPosSize = ListSequence.fromList(inv.getPositions()).count();
    {
      int leftSide = origPosSize;
      int rightSide = 0;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'Session tests.Setting new list with same elements should not change dirty state of session.':  origPosSize  > 0          ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }

    final List<InvoicePosition> newList = ListSequence.fromList(new ArrayList<InvoicePosition>());
    ListSequence.fromList(inv.getPositions()).visitAll((it) -> ListSequence.fromList(newList).addElement(it));
    inv.setPositions(newList);

    if (!(!(session.isDirty()))) {
      throw new OFXTestSuitException("'Session tests.Setting new list with same elements should not change dirty state of session.': !( session .isDirty())          ==>> FALSE !" + "\n");
    }
  }
  @OFXTestMethod(id = 29, name = "Setting new list with one element less should change dirty state of session.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_29(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice created_inv = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("listdirtycheck", __manMapSession);


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    Invoice inv = __DomainRepoInvoice.checkoutInvoiceByIdWithRefs(created_inv.getId(), session);
    if (!(!(session.isDirty()))) {
      throw new OFXTestSuitException("'Session tests.Setting new list with one element less should change dirty state of session.': !( session .isDirty())          ==>> FALSE !" + "\n");
    }

    int origPosSize = ListSequence.fromList(inv.getPositions()).count();
    {
      int leftSide = origPosSize;
      int rightSide = 0;
      if (!(leftSide > rightSide)) {
        throw new OFXTestSuitException("'Session tests.Setting new list with one element less should change dirty state of session.':  origPosSize  > 0          ==>>" + leftSide + " >" + rightSide + "\n");
      }
    }

    final List<InvoicePosition> newList = ListSequence.fromList(new ArrayList<InvoicePosition>());
    ListSequence.fromList(inv.getPositions()).visitAll((it) -> ListSequence.fromList(newList).addElement(it));
    ListSequence.fromList(newList).removeLastElement();
    inv.setPositions(newList);

    {
      IOFXSession operand = session;
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.isDirty())) {
        throw new OFXTestSuitException("'Session tests.Setting new list with one element less should change dirty state of session.':  session .isDirty()          ==>> '" + operand + "'.isDirty(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 30, name = "Adding a new entity to session sets session dirty.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_30(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    Invoice inv = new Invoice();
    session.ensureInSession(inv);
    {
      IOFXSession operand = session;
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.isDirty())) {
        throw new OFXTestSuitException("'Session tests.Adding a new entity to session sets session dirty.':  session .isDirty()          ==>> '" + operand + "'.isDirty(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 31, name = "Loading an entity from db results in a isNewInSession false", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_31(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice created_inv = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("isnew", __manMapSession);



    IOFXSession session = __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
    Invoice inv = __DomainRepoInvoice.checkoutInvoiceByIdWithRefs(created_inv.getId(), session);

    if (!(!(inv._META().isNewInSession()))) {
      throw new OFXTestSuitException("'Session tests.Loading an entity from db results in a isNewInSession false': !( inv .#Meta.isNewInSession())          ==>> FALSE !" + "\n");
    }
  }
  @OFXTestMethod(id = 32, name = "Creating Entity with new() sets isNewInSession to true", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_32(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice created_inv = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("isnew", __manMapSession);



    Invoice inv = new Invoice();
    {
      IOFXMeta4Entity operand = inv._META();
      StringBuilder textRepresentation = new StringBuilder();
      if (!(operand.isNewInSession())) {
        throw new OFXTestSuitException("'Session tests.Creating Entity with new() sets isNewInSession to true':  inv .#Meta.isNewInSession()          ==>> '" + operand + "'.isNewInSession(" + textRepresentation + ") " + "\n");
      }
    }
  }
  @OFXTestMethod(id = 33, name = "Load invoices in a read only manner with reverse ref-join.", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_33(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    IOFXSession sess = __DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
    Invoice invoice1 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("refjoin-1", sess);
    Invoice invoice2 = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("refjoin-2", sess);

    List<InvoicePosition> reloaded_inv1 = __DomainRepoInvoice.findInvoicesByIdReverseRefJoin("%refjoin%", __manMapSession);

    {
      int leftSide = ListSequence.fromList(reloaded_inv1).select((it) -> it.getInvoice()).distinct().count();
      int rightSide = 2;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Load invoices in a read only manner with reverse ref-join.':  reloaded_inv1 .select.distinct.size == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }


  }
  @OFXTestMethod(id = 34, name = "Check that entity info (tcn) is rolled back on transaction rollback", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_34(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    Invoice invoice = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("refjoin-1", __manMapSession);

    invoice.setName("changed");
    __DomainRepoInvoice.checkinInvoice(invoice, __manMapSession);

    final IOFXSession sess = __DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
    final Invoice checkedout = __DomainRepoInvoice.checkoutInvoiceJoinPositions(invoice.getId(), sess);
    {
      int leftSide = checkedout.getId();
      int rightSide = 1;
      if (!(leftSide >= rightSide)) {
        throw new OFXTestSuitException("'Session tests.Check that entity info (tcn) is rolled back on transaction rollback':  checkedout .id >= 1          ==>>" + leftSide + " >=" + rightSide + "\n");
      }
    }
    {
      int leftSide = ((IOFXEntity) (checkedout)).getTCN();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Check that entity info (tcn) is rolled back on transaction rollback': ((IOFXEntity)( checkedout )).getTCN() == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    checkedout.setName("chgd again");
    sess.addOperation(new IOFXSessionOperation() {
      public void execute() {
        __DomainRepoInvoice.checkinInvoice(checkedout, sess);
        {
          int leftSide = ((IOFXEntity) (checkedout)).getTCN();
          int rightSide = 2;
          if (leftSide != rightSide) {
            throw new OFXTestSuitException("'Session tests.Check that entity info (tcn) is rolled back on transaction rollback': ((IOFXEntity)( checkedout )).getTCN() == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
          }
        }
      }
      public String getInformation() {
        return "checkin invoice";
      }
    });

    sess.addOperation(new IOFXSessionOperation() {
      public void execute() {
        throw new RuntimeException("catch me");
      }
      public String getInformation() {
        return "catch me exception";
      }
    });

    try {
      sess.startTransactionAndFlush();
      {
        int leftSide = 1;
        int rightSide = 2;
        if (leftSide != rightSide) {
          throw new OFXTestSuitException("'Session tests.Check that entity info (tcn) is rolled back on transaction rollback': 1 == 2          ==>>" + leftSide + " ==" + rightSide + "We will never get here.");
        }
      }
    } catch (Exception ex) {
      {
        String operand = ex.getMessage();
        String param0 = "catch me";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append("" + param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!(operand.contains(param0))) {
          throw new OFXTestSuitException("'Session tests.Check that entity info (tcn) is rolled back on transaction rollback':  ex .getMessage().contains(\"catch me\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
        }
      }
    }
    {
      int leftSide = ((IOFXEntity) (checkedout)).getTCN();
      int rightSide = 1;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Check that entity info (tcn) is rolled back on transaction rollback': ((IOFXEntity)( checkedout )).getTCN() == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }
  @OFXTestMethod(id = 35, name = "Check that entity key is rolled back on transaction rollback", debug = false, enabled = true, runAt = "1/27/1980 4:30:0")
  public void __testmethod_35(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {


    final IOFXSession sess = __DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
    final Invoice invoice = __DomainCreatorsFactory.createInvoiceGraphWith4Positions_NOTonDB("refjoin-1", __manMapSession);


    {
      int leftSide = invoice.getId();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Check that entity key is rolled back on transaction rollback':  invoice .id == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }

    sess.addOperation(new IOFXSessionOperation() {
      public void execute() {
        __DomainRepoInvoice.checkinInvoice(invoice, sess);
        {
          int leftSide = invoice.getId();
          int rightSide = 1;
          if (!(leftSide >= rightSide)) {
            throw new OFXTestSuitException("'Session tests.Check that entity key is rolled back on transaction rollback':  invoice .id >= 1          ==>>" + leftSide + " >=" + rightSide + "\n");
          }
        }
      }
      public String getInformation() {
        return "checkin invoice";
      }
    });

    sess.addOperation(new IOFXSessionOperation() {
      public void execute() {
        throw new RuntimeException("catch me");
      }
      public String getInformation() {
        return "catch me exception";
      }
    });

    try {
      sess.startTransactionAndFlush();
      {
        int leftSide = 1;
        int rightSide = 2;
        if (leftSide != rightSide) {
          throw new OFXTestSuitException("'Session tests.Check that entity key is rolled back on transaction rollback': 1 == 2          ==>>" + leftSide + " ==" + rightSide + "We will never get here.");
        }
      }

    } catch (Exception ex) {

      {
        String operand = ex.getMessage();
        String param0 = "catch me";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append("" + param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!(operand.contains(param0))) {
          throw new OFXTestSuitException("'Session tests.Check that entity key is rolled back on transaction rollback':  ex .getMessage().contains(\"catch me\")          ==>> '" + operand + "'.contains(" + textRepresentation + ") " + "\n");
        }
      }
    }
    {
      int leftSide = invoice.getId();
      int rightSide = 0;
      if (leftSide != rightSide) {
        throw new OFXTestSuitException("'Session tests.Check that entity key is rolled back on transaction rollback':  invoice .id == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
      }
    }
  }


  public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
  }


  public static void main(String[] args) {
    String[] allIncludedTest = new String[]{"org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit"};
    String[] includedTestToRun = new String[]{};

    OFXTestSuit.runAsMain("org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", Session_tests.class, allIncludedTest, includedTestToRun);
  }
}
