package org.modellwerkstatt.dataux.intentions;

/*Generated by MPS */

import jetbrains.mps.intentions.AbstractIntentionAspectDescriptor;
import jetbrains.mps.openapi.intentions.IntentionFactory;
import java.util.Map;
import org.jetbrains.mps.openapi.language.SAbstractConcept;
import java.util.HashMap;
import org.jetbrains.annotations.Nullable;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import java.util.Arrays;
import jetbrains.mps.lang.smodel.ConceptSwitchIndex;
import jetbrains.mps.lang.smodel.ConceptSwitchIndexBuilder;
import jetbrains.mps.smodel.adapter.ids.MetaIdFactory;

public final class IntentionsDescriptor extends AbstractIntentionAspectDescriptor {
  private static final IntentionFactory[] EMPTY_ARRAY = new IntentionFactory[0];
  private Map<SAbstractConcept, IntentionFactory[]> myCached = new HashMap<SAbstractConcept, IntentionFactory[]>();

  public IntentionsDescriptor() {
  }

  @Nullable
  public Collection<IntentionFactory> getIntentions(@NotNull SAbstractConcept concept) {
    if (myCached.containsKey(concept)) {
      return Arrays.asList(myCached.get(concept));
    }

    IntentionFactory[] intentions = EMPTY_ARRAY;
    SAbstractConcept cncpt = concept;
    switch (conceptIndex.index(cncpt)) {
      case 0:
        if (true) {
          // concept
          intentions = new IntentionFactory[1];
          intentions[0] = new AutoCompleteDelegates_Intention();
        }
        break;
      case 1:
        if (true) {
          // concept
          intentions = new IntentionFactory[1];
          intentions[0] = new NameElement_Intention();
        }
        break;
      case 2:
        if (true) {
          // concept
          intentions = new IntentionFactory[1];
          intentions[0] = new ConvertLvdsToGlobalApiVarDecl_Intention();
        }
        break;
      case 3:
        if (true) {
          // concept
          intentions = new IntentionFactory[1];
          intentions[0] = new RemoveInnerGraphEdit_Intention();
        }
        break;
      case 4:
        if (true) {
          // concept
          intentions = new IntentionFactory[3];
          intentions[0] = new AutoCompleteEditorPagePane_Intention();
          intentions[1] = new AutoCompleteMainDocPagePane_Intention();
          intentions[2] = new AutoCompleteTablePagePane_Intention();
        }
        break;
      default:
    }
    myCached.put(concept, intentions);
    return Arrays.asList(intentions);
  }

  @NotNull
  @Override
  public Collection<IntentionFactory> getAllIntentions() {
    IntentionFactory[] rv = new IntentionFactory[7];
    rv[0] = new NameElement_Intention();
    rv[1] = new AutoCompleteDelegates_Intention();
    rv[2] = new RemoveInnerGraphEdit_Intention();
    rv[3] = new AutoCompleteEditorPagePane_Intention();
    rv[4] = new AutoCompleteMainDocPagePane_Intention();
    rv[5] = new AutoCompleteTablePagePane_Intention();
    rv[6] = new ConvertLvdsToGlobalApiVarDecl_Intention();
    return Arrays.asList(rv);
  }
  private static final ConceptSwitchIndex conceptIndex = new ConceptSwitchIndexBuilder().put(MetaIdFactory.conceptId(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x676081f33335c23L), MetaIdFactory.conceptId(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x4a11e39c393faabdL), MetaIdFactory.conceptId(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc67c7f0L), MetaIdFactory.conceptId(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x1c073f3ba551a927L), MetaIdFactory.conceptId(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x63cf441cbd8ed5c6L)).seal();
}
