package org.modellwerkstatt.dataux.ofxutil;

/*Generated by MPS */

import jetbrains.mps.scope.Scope;
import org.jetbrains.mps.openapi.model.SModel;
import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import java.util.List;
import java.util.ArrayList;
import org.modellwerkstatt.dataux.behavior.IOptionallyNamed__BehaviorDescriptor;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.internal.collections.runtime.Sequence;
import org.modellwerkstatt.dataux.behavior.IBindable__BehaviorDescriptor;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import jetbrains.mps.scope.ListScope;
import org.jetbrains.mps.openapi.language.SAbstractConcept;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SConceptOperations;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SInterfaceConcept;
import org.jetbrains.mps.openapi.language.SConcept;
import org.jetbrains.mps.openapi.language.SReferenceLink;

public class OFXGetSelectedScoper {


  public static Scope scopeForBindableObjects(SModel m, SNode currentBindable) {
    final Wrappers._T<List<SNode>> clsList = new Wrappers._T<List<SNode>>(new ArrayList<SNode>());

    // Restriction of Selection Provider is solely that selections should be available in the
    // hierarchy above us. .. not what is following us ..

    // is this a root node?
    if ((boolean) IOptionallyNamed__BehaviorDescriptor.isRootWhichNeedsName_id7Cs1IG3kH_v.invoke(currentBindable)) {
      // then all available IOFXObjects
      clsList.value = ListSequence.fromList(SModelOperations.rootsIncludingImported(m, CONCEPTS.IOFXObject$Y7)).select((it) -> SNodeOperations.cast(it, CONCEPTS.Classifier$Ix)).toList();

    } else {

      addPrviousBindableSiblingsToList(clsList.value, currentBindable);

      // try some calculations.
      // all content types from ancestors, including previous selected objects
      Iterable<SNode> ancestorsWithContent = ListSequence.fromList(SNodeOperations.getNodeAncestors(currentBindable, null, false)).where((it) -> SNodeOperations.isInstanceOf(it, CONCEPTS.IBindable$dn)).select((it) -> SNodeOperations.cast(it, CONCEPTS.IBindable$dn));

      Sequence.fromIterable(ancestorsWithContent).visitAll((it) -> {
        addPrviousBindableSiblingsToList(clsList.value, it);

        if ((boolean) IBindable__BehaviorDescriptor.hasContentType_id7vQ8h9w9WBW.invoke(it)) {
          // Itself is okay, but no one after current node, i.e. no next siblings.
          ListSequence.fromList(clsList.value).addElement(SLinkOperations.getTarget(IBindable__BehaviorDescriptor.getContentType_id7rG0OCcGK61.invoke(it), LINKS.classifier$cxMr));
        }

      });

    }

    return ListScope.forNamedElements(ListSequence.fromList(clsList.value).distinct());

  }

  private static void addPrviousBindableSiblingsToList(final List<SNode> clsList, SNode bindable) {
    // all siblings in front of current element R

    ListSequence.fromList(SNodeOperations.getPrevSiblings(bindable, false)).visitAll((it) -> {

      // and hierarchy down on all prev siblings, i.e.
      // (1) itself, if bindable with content
      // (2) childs of it, if bindable with content
      ListSequence.fromList(clsList).addSequence(ListSequence.fromList(SNodeOperations.getNodeDescendants(it, CONCEPTS.IBindable$dn, true, new SAbstractConcept[]{})).where(new _FunctionTypes._return_P1_E0<Boolean, SNode>() {
        public Boolean invoke(SNode it) {
          return (boolean) IBindable__BehaviorDescriptor.hasContentType_id7vQ8h9w9WBW.invoke(it);
        }
      }).select(new _FunctionTypes._return_P1_E0<SNode, SNode>() {
        public SNode invoke(SNode it) {
          return SLinkOperations.getTarget(IBindable__BehaviorDescriptor.getContentType_id7rG0OCcGK61.invoke(it), LINKS.classifier$cxMr);
        }
      }));


    });
  }


  public static SNode getProbableBoundTypeForBindable(SNode bindable) {
    // bindable is the enclosing node in the ux factory, not the current one!
    // thus, bindable ist abstract and does not have a contentType itself ..
    SNode lastSibling = SNodeOperations.getPrevSibling(bindable);

    if ((lastSibling != null) && SNodeOperations.isInstanceOf(lastSibling, CONCEPTS.IBindable$dn)) {
      SNode bindiWithContent = SNodeOperations.cast(lastSibling, CONCEPTS.IBindable$dn);
      if ((boolean) IBindable__BehaviorDescriptor.hasContentType_id7vQ8h9w9WBW.invoke(bindiWithContent)) {
        return IBindable__BehaviorDescriptor.getContentType_id7rG0OCcGK61.invoke(bindiWithContent);
      }
    }

    // okay, no sibling suitable in front of us. try parent
    SNode parent = SNodeOperations.getNodeAncestor(bindable, CONCEPTS.IBindable$dn, false, false);
    if ((parent != null)) {
      if ((boolean) IBindable__BehaviorDescriptor.hasContentType_id7vQ8h9w9WBW.invoke(parent)) {
        return IBindable__BehaviorDescriptor.getContentType_id7rG0OCcGK61.invoke(parent);
      }

      return getProbableBoundTypeForBindable(parent);
    }

    // no parent available... end of story
    return SConceptOperations.createNewNode(MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101de48bf9eL, "jetbrains.mps.baseLanguage.structure.ClassifierType"));
  }


  private static final class CONCEPTS {
    /*package*/ static final SInterfaceConcept IOFXObject$Y7 = MetaAdapterFactory.getInterfaceConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3bdce9a978275e87L, "org.modellwerkstatt.objectflow.structure.IOFXObject");
    /*package*/ static final SConcept Classifier$Ix = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101d9d3ca30L, "jetbrains.mps.baseLanguage.structure.Classifier");
    /*package*/ static final SInterfaceConcept IBindable$dn = MetaAdapterFactory.getInterfaceConcept(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x4a11e39c3940e086L, "org.modellwerkstatt.dataux.structure.IBindable");
  }

  private static final class LINKS {
    /*package*/ static final SReferenceLink classifier$cxMr = MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101de48bf9eL, 0x101de490babL, "classifier");
  }
}
