package org.modellwerkstatt.dataux.plugin;

/*Generated by MPS */

import com.intellij.openapi.ui.DialogBuilder;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import jetbrains.mps.project.MPSProject;
import java.awt.Color;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Label;
import javax.swing.JSeparator;
import javax.swing.SwingConstants;
import java.awt.Dimension;

public class DLGCompleterWindow extends DialogBuilder {
  private JComponent myComponent;
  public JTextArea detectedProblems;
  private boolean isOkayButton = false;
  private List<String> modelNames;
  private List<String> childsName;


  private JCheckBox mappings;
  private JCheckBox repos;
  private JCheckBox service;
  private JCheckBox searchCmd;
  private JCheckBox graphOwnerCmd;
  private JCheckBox graphEditCmd;
  private JCheckBox creatorCmd;

  private JComboBox childsBox;
  private JComboBox commandsUiBox;
  private JComboBox serviceBox;

  private String entityName;
  private boolean disableDbFeatures;


  public DLGCompleterWindow(MPSProject project, String name, boolean disDbFeat) {
    super(project.getProject());
    this.entityName = name;
    this.setTitle("Werkbank DDD Template");
    this.disableDbFeatures = disDbFeat;
    this.detectedProblems = new JTextArea();
    this.detectedProblems.setEditable(false);
    this.detectedProblems.setEnabled(false);
    this.detectedProblems.setDisabledTextColor(new Color(255, 0, 0));
  }


  public void setModels(List<String> m) {
    List<String> fullList = ListSequence.fromList(new ArrayList<String>());
    // do not add - as options, since validation is necessary then
    // use checkbox to determine selection
    ListSequence.fromList(fullList).addSequence(ListSequence.fromList(m));
    modelNames = fullList;



  }

  public void setChilds(List<String> m) {
    List<String> fullList = ListSequence.fromList(new ArrayList<String>());
    ListSequence.fromList(fullList).addElement("-");
    ListSequence.fromList(fullList).addSequence(ListSequence.fromList(m));
    childsName = fullList;
  }

  public void addProblem(String txt) {
    this.detectedProblems.setText(this.detectedProblems.getText() + txt + "\n");
  }
  public JComponent createPanel() {
    JPanel panel = new JPanel(new BorderLayout());


    JPanel featureSelector = new JPanel(new GridLayout(10, 2));

    featureSelector.add(new Label("SELECT CONCEPTS YOU WANT TO CREATE FOR '" + entityName + "':"));
    featureSelector.add(new Label(""));

    featureSelector.add(new Label("Database Mappings"));
    mappings = new JCheckBox();
    mappings.setSelected(true);
    featureSelector.add(mappings);
    if (disableDbFeatures) {
      mappings.setSelected(false);
      mappings.setEnabled(false);
    }

    featureSelector.add(new Label("Repository"));
    repos = new JCheckBox();
    repos.setSelected(true);

    featureSelector.add(repos);
    if (disableDbFeatures) {
      repos.setSelected(false);
      repos.setEnabled(false);
    }

    featureSelector.add(new Label("Aggregate Service / Factory"));
    service = new JCheckBox();
    service.setSelected(true);

    featureSelector.add(service);
    if (disableDbFeatures) {
      service.setSelected(false);
      service.setEnabled(false);
    }


    featureSelector.add(new Label("Search Command"));
    searchCmd = new JCheckBox();
    searchCmd.setSelected(true);
    featureSelector.add(searchCmd);

    featureSelector.add(new Label("Graph Owner Command"));
    graphOwnerCmd = new JCheckBox();
    graphOwnerCmd.setSelected(true);
    featureSelector.add(graphOwnerCmd);

    featureSelector.add(new Label("Graph Edit Command"));
    graphEditCmd = new JCheckBox();
    graphEditCmd.setSelected(true);
    featureSelector.add(graphEditCmd);

    featureSelector.add(new Label("Creator Command (predecessor)"));
    creatorCmd = new JCheckBox();
    creatorCmd.setSelected(true);
    featureSelector.add(creatorCmd);

    featureSelector.add(new Label("Include Child list"));
    childsBox = new JComboBox(ListSequence.fromList(childsName).toGenericArray(String.class));
    featureSelector.add(childsBox);
    if (ListSequence.fromList(childsName).count() > 1) {
      childsBox.setSelectedIndex(1);
    }


    JPanel modelSelector = new JPanel(new GridLayout(4, 2));
    commandsUiBox = new JComboBox(ListSequence.fromList(modelNames).toGenericArray(String.class));
    serviceBox = new JComboBox(ListSequence.fromList(modelNames).toGenericArray(String.class));

    // check if we can find the agg model name + unit name?
    // select models default - if possible
    String element = ListSequence.fromList(modelNames).findFirst((it) -> it.toLowerCase().endsWith(entityName.toLowerCase()));
    if (element != null) {
      serviceBox.setSelectedIndex(ListSequence.fromList(modelNames).indexOf(element));
    }

    element = ListSequence.fromList(modelNames).findFirst((it) -> it.toLowerCase().endsWith(entityName.toLowerCase() + "unit"));
    if (element != null) {
      commandsUiBox.setSelectedIndex(ListSequence.fromList(modelNames).indexOf(element));
    }

    modelSelector.add(new Label("SELECT MODELS TO PLACE CONCEPTS:"));
    modelSelector.add(new Label(""));
    modelSelector.add(new Label("Service and Repo to"));
    modelSelector.add(serviceBox);
    modelSelector.add(new Label("Commands and UI to"));
    modelSelector.add(commandsUiBox);



    JPanel lowerPart = new JPanel(new BorderLayout());
    lowerPart.add(modelSelector, BorderLayout.PAGE_START);
    lowerPart.add(new JSeparator(SwingConstants.HORIZONTAL), BorderLayout.CENTER);
    lowerPart.add(detectedProblems, BorderLayout.PAGE_END);


    panel.add(featureSelector, BorderLayout.PAGE_START);
    panel.add(new JSeparator(SwingConstants.HORIZONTAL), BorderLayout.CENTER);
    panel.add(lowerPart, BorderLayout.PAGE_END);

    return panel;
  }

  public boolean isMapping() {
    return mappings.isSelected();
  }
  public boolean isRepo() {
    return repos.isSelected();
  }
  public boolean isServiceNFactory() {
    return service.isSelected();
  }
  public boolean isSearchCmd() {
    return searchCmd.isSelected();
  }
  public boolean isGraphOwnerCmd() {
    return graphOwnerCmd.isSelected();
  }
  public boolean isGraphEditCmd() {
    return graphEditCmd.isSelected();
  }
  public boolean isCreatorCmd() {
    return creatorCmd.isSelected();
  }

  public String getCommandsModelName() {
    String selection = ((String) commandsUiBox.getSelectedItem());
    if ("-".equals(selection)) {
      return null;
    }
    return selection;
  }
  public String getMappingsModelName() {
    String selection = ((String) serviceBox.getSelectedItem());
    if ("-".equals(selection)) {
      return null;
    }
    return selection;
  }
  public String getChildListInEntity() {
    String selection = ((String) childsBox.getSelectedItem());
    if ("-".equals(selection)) {
      return null;
    }
    return selection;
  }

  public void setReadOnly() {
    this.myComponent.setEnabled(false);
  }
  public void showDialog() {
    this.myComponent = this.createPanel();
    this.myComponent.setMinimumSize(new Dimension(600, 400));

    this.setCenterPanel(this.myComponent);

    isOkayButton = super.showAndGet();
  }

  public boolean isOkay() {
    return isOkayButton;
  }
}
