package org.modellwerkstatt.dataux.plugin;

/*Generated by MPS */

import jetbrains.mps.workbench.action.BaseAction;
import javax.swing.Icon;
import jetbrains.mps.workbench.action.ActionAccess;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.Map;
import jetbrains.mps.project.MPSProject;
import jetbrains.mps.ide.actions.MPSCommonDataKeys;
import java.awt.Frame;
import org.jetbrains.annotations.NotNull;
import java.util.List;
import org.jetbrains.mps.openapi.model.SModel;
import org.modellwerkstatt.objectflow.plugin.MoMdlAccess;
import org.modellwerkstatt.objectflow.plugin.CopyPasteDialog;
import java.io.StringReader;
import org.modellwerkstatt.objectflow.runtime.CSVReader;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import javax.swing.JOptionPane;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.jetbrains.mps.openapi.model.EditableSModel;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import jetbrains.mps.extapi.persistence.FileDataSource;
import jetbrains.mps.refactoring.Renamer;
import jetbrains.mps.smodel.ModelDependencyResolver;
import jetbrains.mps.smodel.language.LanguageRegistry;
import org.jetbrains.mps.openapi.module.SModuleReference;
import jetbrains.mps.smodel.DefaultSModelDescriptor;
import org.jetbrains.mps.openapi.language.SLanguage;

public class GeneralizedAutoRefactor_Action extends BaseAction {
  private static final Icon ICON = null;

  public GeneralizedAutoRefactor_Action() {
    super("Werkbank - Generalized Auto Refactorer", "", ICON);
    this.setIsAlwaysVisible(false);
    this.setActionAccess(ActionAccess.UNDO_PROJECT);
    updateInBackground(true);
  }
  @Override
  public boolean isDumbAware() {
    return true;
  }
  @Override
  protected boolean collectActionData(AnActionEvent event, final Map<String, Object> _params) {
    if (!(super.collectActionData(event, _params))) {
      return false;
    }
    {
      MPSProject p = event.getData(MPSCommonDataKeys.MPS_PROJECT);
      if (p == null) {
        return false;
      }
    }
    {
      Frame p = event.getData(MPSCommonDataKeys.FRAME);
      if (p == null) {
        return false;
      }
    }
    return true;
  }
  @Override
  public void doExecute(@NotNull final AnActionEvent event, final Map<String, Object> _params) {

    List<SModel> allRelevantModels = MoMdlAccess.relevantModels(event.getData(MPSCommonDataKeys.MPS_PROJECT), true);

    try {
      CopyPasteDialog dialog = new CopyPasteDialog(event.getData(MPSCommonDataKeys.MPS_PROJECT), "Generalized Auto Refactorer(csv)");
      dialog.showDialog();
      String csvData = dialog.myText.getText();

      StringReader sr = new StringReader(csvData);
      CSVReader reader = new CSVReader(sr, '\t');
      List<String[]> allLines = reader.readAll();
      sr.close();

      String command = ListSequence.fromList(allLines).getElement(0)[0].toLowerCase();
      System.err.println("\n\n\n- - - - - - - Generalized Auto Refactorer Protocol - - - - - - -");
      System.err.println("Command is '" + command + "'");

      if ("modelrename".equals(command)) {
        GeneralizedAutoRefactor_Action.this.renameModels(event.getData(MPSCommonDataKeys.MPS_PROJECT), allRelevantModels, ListSequence.fromList(allLines).skip(1).toList(), event);

      } else if ("genplan".equals(command)) {
        GeneralizedAutoRefactor_Action.this.adjustToGenplan(allRelevantModels, event);

      } else {
        throw new Exception("Command " + command + " not found.");
      }


    } catch (NullPointerException npe) {
      JOptionPane.showMessageDialog(event.getData(MPSCommonDataKeys.FRAME), "NPE \n" + OFXConsoleHelper.stackTrace2String(npe), "Problem while generating report ..", JOptionPane.ERROR_MESSAGE);

    } catch (Throwable t) {
      JOptionPane.showMessageDialog(event.getData(MPSCommonDataKeys.FRAME), t.getMessage(), "Problem while generating report . ", JOptionPane.ERROR_MESSAGE);
    }
  }
  private void renameModels(final MPSProject prj, final List<SModel> relevantModels, List<String[]> oldNewPairs, final AnActionEvent event) {
    ListSequence.fromList(oldNewPairs).visitAll((it) -> {
      final String oldName = it[0];
      String newName = it[1];

      System.err.println("'" + oldName + "' '" + newName + "'");
      EditableSModel test = ((EditableSModel) ListSequence.fromList(relevantModels).findFirst(new _FunctionTypes._return_P1_E0<Boolean, SModel>() {
        public Boolean invoke(SModel it) {
          return SModelOperations.getModelName(it).equals(oldName);
        }
      }));

      if (newName.trim().equals("")) {
        // create model
        GeneralizedAutoRefactor_Action.this.createMode(ListSequence.fromList(relevantModels).first(), oldName, event);

      } else if (test == null) {
        System.err.println("ERROR: model " + oldName + " not found and thus not renamed to " + newName);

      } else {
        test.getRepository().saveAll();
        test.rename(newName, test.getSource() instanceof FileDataSource);
        Renamer.updateModelAndModuleReferences(prj);
        test.getRepository().saveAll();
        System.err.println("Renamed " + oldName + " to " + newName);
      }
    });
  }
  private void createMode(SModel proto, String name, final AnActionEvent event) {
    EditableSModel editableProto = ((EditableSModel) proto);
    editableProto.getModelRoot().createModel(name);
    System.err.println("Created model with name '" + name + "'.");
  }
  private boolean toRemoveLang(String candidate, final AnActionEvent event) {
    if (candidate.equals("org.modellwerkstatt.dataux")) {
      return true;
    }
    if (candidate.equals("org.modellwerkstatt.objectflow")) {
      return true;
    }
    if (candidate.equals("org.modellwerkstatt.manmap")) {
      return true;
    }
    if (candidate.equals("jetbrains.mps.baseLanguage")) {
      return true;
    }
    if (candidate.equals("jetbrains.mps.baseLanguage.collections")) {
      return true;
    }
    if (candidate.equals("jetbrains.mps.baseLanguage.closures")) {
      return true;
    }

    return false;
  }
  private void adjustToGenplan(List<SModel> relevantModels, final AnActionEvent event) {
    ModelDependencyResolver mdr = new ModelDependencyResolver(event.getData(MPSCommonDataKeys.MPS_PROJECT).getComponent(LanguageRegistry.class), event.getData(MPSCommonDataKeys.MPS_PROJECT).getRepository());

    SModuleReference refToDevKit = null;

    for (SModel model : relevantModels) {
      if (model instanceof DefaultSModelDescriptor) {
        DefaultSModelDescriptor m = ((DefaultSModelDescriptor) model);
        for (SModuleReference devKit : m.importedDevkits()) {
          if (devKit.getModuleName().endsWith("MoWareWerkbank")) {
            refToDevKit = devKit;
            System.err.println("Found MoWareWerkbank @ " + m.getName());
          }
        }
      }
    }

    if (refToDevKit != null) {
      for (SModel model : relevantModels) {
        if (model instanceof DefaultSModelDescriptor) {
          DefaultSModelDescriptor m = ((DefaultSModelDescriptor) model);
          if (m.importedDevkits().size() == 0) {
            m.addDevKit(refToDevKit);
            System.err.println(m.getName() + "  added " + refToDevKit.getModuleName());
          }

          for (SLanguage lang : mdr.usedLanguages(m)) {
            if (GeneralizedAutoRefactor_Action.this.toRemoveLang(lang.getQualifiedName(), event)) {
              m.deleteLanguageId(lang);
              System.err.println(m.getName() + "  removed " + lang.getQualifiedName());
            }

          }


        } else {
          System.err.println("IGNORING: " + model.getName());
        }

      }
    } else {
      System.err.println("No ref to devKit MoWareWerkbank found - add it to just one model in your solution!");
    }

  }
}
