package org.modellwerkstatt.dataux.plugin;

/*Generated by MPS */

import jetbrains.mps.workbench.action.BaseAction;
import javax.swing.Icon;
import jetbrains.mps.workbench.action.ActionAccess;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.Map;
import java.awt.Frame;
import jetbrains.mps.ide.actions.MPSCommonDataKeys;
import jetbrains.mps.project.MPSProject;
import org.jetbrains.annotations.NotNull;
import java.util.List;
import org.jetbrains.mps.openapi.model.SModel;
import org.modellwerkstatt.objectflow.plugin.MoMdlAccess;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import java.io.StringWriter;
import org.modellwerkstatt.objectflow.runtime.CSVWriter;
import org.modellwerkstatt.objectflow.plugin.CopyPasteDialog;
import javax.swing.JOptionPane;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;

public class LanguageStringsExport_Action extends BaseAction {
  private static final Icon ICON = null;

  public LanguageStringsExport_Action() {
    super("Werkbank - Language Translations export", "", ICON);
    this.setIsAlwaysVisible(false);
    this.setActionAccess(ActionAccess.UNDO_PROJECT);
    updateInBackground(true);
  }
  @Override
  public boolean isDumbAware() {
    return true;
  }
  @Override
  protected boolean collectActionData(AnActionEvent event, final Map<String, Object> _params) {
    if (!(super.collectActionData(event, _params))) {
      return false;
    }
    {
      Frame p = event.getData(MPSCommonDataKeys.FRAME);
      if (p == null) {
        return false;
      }
    }
    {
      MPSProject p = event.getData(MPSCommonDataKeys.MPS_PROJECT);
      if (p == null) {
        return false;
      }
    }
    return true;
  }
  @Override
  public void doExecute(@NotNull final AnActionEvent event, final Map<String, Object> _params) {
    try {
      List<SModel> models = MoMdlAccess.relevantModels(event.getData(MPSCommonDataKeys.MPS_PROJECT), true);

      List<TransKeyVal> translations = ListSequence.fromList(new ArrayList<TransKeyVal>());

      for (SModel m : models) {
        System.err.println("Checking model " + SModelOperations.getModelName(m));
        TransHelper.attachToList(translations, TransHelper.fromStati(m));
        TransHelper.attachToList(translations, TransHelper.fromIOFXObjects(m));
        TransHelper.attachToList(translations, TransHelper.fromUiLabels(m));
        TransHelper.attachToList(translations, TransHelper.fromMultiStrings(m));
        TransHelper.attachToList(translations, TransHelper.fromOldStringLiteralInFlagCommand(m));
        TransHelper.attachToList(translations, TransHelper.fromDataUX(m));
      }


      // sort em.
      translations = ListSequence.fromList(translations).sort((it) -> it.key.length(), true).alsoSort((it) -> it.key, true).toList();

      StringWriter sw = new StringWriter();
      final CSVWriter write = new CSVWriter(sw);

      ListSequence.fromList(translations).visitAll((it) -> write.writeNext(it.asArray()));

      CopyPasteDialog dialog = new CopyPasteDialog(event.getData(MPSCommonDataKeys.MPS_PROJECT), "Exported Strings for translation (csv)");
      dialog.myText.setText(sw.toString());
      try {
        sw.close();
      } catch (Throwable t) {
      }
      dialog.showDialog();


    } catch (NullPointerException npe) {
      JOptionPane.showMessageDialog(event.getData(MPSCommonDataKeys.FRAME), "Null Pointer Exception \n" + OFXConsoleHelper.stackTrace2String(npe), "Problem while importing langstrings... ", JOptionPane.ERROR_MESSAGE);

    } catch (Throwable t) {
      JOptionPane.showMessageDialog(event.getData(MPSCommonDataKeys.FRAME), t.getMessage(), "Problem while importing langstrings... ", JOptionPane.ERROR_MESSAGE);
    }
  }
}
