package org.modellwerkstatt.dataux.plugin;

/*Generated by MPS */

import jetbrains.mps.workbench.action.BaseAction;
import javax.swing.Icon;
import jetbrains.mps.workbench.action.ActionAccess;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.Map;
import java.awt.Frame;
import jetbrains.mps.ide.actions.MPSCommonDataKeys;
import jetbrains.mps.project.MPSProject;
import org.jetbrains.annotations.NotNull;
import java.util.List;
import org.jetbrains.mps.openapi.model.SModel;
import org.modellwerkstatt.objectflow.plugin.MoMdlAccess;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import org.modellwerkstatt.objectflow.plugin.CopyPasteDialog;
import java.io.StringReader;
import org.modellwerkstatt.objectflow.runtime.CSVReader;
import javax.swing.JOptionPane;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;

public class LanguageStringsImport_Action extends BaseAction {
  private static final Icon ICON = null;

  public LanguageStringsImport_Action() {
    super("Werkbank - Language Translations import", "", ICON);
    this.setIsAlwaysVisible(false);
    this.setActionAccess(ActionAccess.UNDO_PROJECT);
    updateInBackground(true);
  }
  @Override
  public boolean isDumbAware() {
    return true;
  }
  @Override
  protected boolean collectActionData(AnActionEvent event, final Map<String, Object> _params) {
    if (!(super.collectActionData(event, _params))) {
      return false;
    }
    {
      Frame p = event.getData(MPSCommonDataKeys.FRAME);
      if (p == null) {
        return false;
      }
    }
    {
      MPSProject p = event.getData(MPSCommonDataKeys.MPS_PROJECT);
      if (p == null) {
        return false;
      }
    }
    return true;
  }
  @Override
  public void doExecute(@NotNull final AnActionEvent event, final Map<String, Object> _params) {


    try {
      List<SModel> models = MoMdlAccess.relevantModels(event.getData(MPSCommonDataKeys.MPS_PROJECT), true);
      List<TransKeyVal> translations = ListSequence.fromList(new ArrayList<TransKeyVal>());


      CopyPasteDialog dialog = new CopyPasteDialog(event.getData(MPSCommonDataKeys.MPS_PROJECT), "Exported Strings for translation (csv)");
      dialog.showDialog();
      String csvData = dialog.myText.getText();


      StringReader sr = new StringReader(csvData);
      CSVReader reader = new CSVReader(sr);
      List<String[]> allLines = reader.readAll();
      sr.close();

      for (String[] line : allLines) {
        ListSequence.fromList(translations).addElement(TransKeyVal.fromCSV(line));
      }

      for (SModel m : models) {
        TransHelper.updateStati(m, translations);
        TransHelper.updateIOFXObjects(m, translations);
        TransHelper.updateUiLabels(m, translations);
        TransHelper.updateMultiStrings(m, translations);
        TransHelper.updateOldStringLiteralInFlagCommand(m, translations);
        TransHelper.updateDataUX(m, translations);
      }



    } catch (NullPointerException npe) {
      JOptionPane.showMessageDialog(event.getData(MPSCommonDataKeys.FRAME), "Null Pointer Exception \n" + OFXConsoleHelper.stackTrace2String(npe), "Problem while importing langstrings... ", JOptionPane.ERROR_MESSAGE);

    } catch (Throwable t) {
      JOptionPane.showMessageDialog(event.getData(MPSCommonDataKeys.FRAME), t.getMessage(), "Problem while importing langstrings... ", JOptionPane.ERROR_MESSAGE);
    }
  }
}
