package org.modellwerkstatt.dataux.plugin;

/*Generated by MPS */

import jetbrains.mps.workbench.action.BaseAction;
import javax.swing.Icon;
import jetbrains.mps.workbench.action.ActionAccess;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.Map;
import jetbrains.mps.project.MPSProject;
import jetbrains.mps.ide.actions.MPSCommonDataKeys;
import java.awt.Frame;
import org.jetbrains.annotations.NotNull;
import java.io.StringWriter;
import java.util.List;
import org.jetbrains.mps.openapi.model.SModel;
import org.modellwerkstatt.objectflow.plugin.MoMdlAccess;
import org.modellwerkstatt.objectflow.runtime.CSVWriter;
import org.joda.time.LocalDate;
import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SEnumOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import org.modellwerkstatt.objectflow.util.CommandPermissionsResolver;
import jetbrains.mps.lang.core.behavior.INamedConcept__BehaviorDescriptor;
import org.modellwerkstatt.objectflow.plugin.CopyPasteDialog;
import javax.swing.JOptionPane;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.jetbrains.mps.openapi.language.SConcept;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SProperty;

public class MoWareCommandPermissions_Action extends BaseAction {
  private static final Icon ICON = null;

  public MoWareCommandPermissions_Action() {
    super("Werkbank - Report command permissions", "Generate command permission report", ICON);
    this.setIsAlwaysVisible(true);
    this.setActionAccess(ActionAccess.UNDO_PROJECT);
    updateInBackground(true);
  }
  @Override
  public boolean isDumbAware() {
    return true;
  }
  @Override
  protected boolean collectActionData(AnActionEvent event, final Map<String, Object> _params) {
    if (!(super.collectActionData(event, _params))) {
      return false;
    }
    {
      MPSProject p = event.getData(MPSCommonDataKeys.MPS_PROJECT);
      if (p == null) {
        return false;
      }
    }
    {
      Frame p = event.getData(MPSCommonDataKeys.FRAME);
      if (p == null) {
        return false;
      }
    }
    return true;
  }
  @Override
  public void doExecute(@NotNull final AnActionEvent event, final Map<String, Object> _params) {
    StringWriter myStringWriter = new StringWriter();

    try {
      List<SModel> allRelevantModels = MoMdlAccess.relevantModels(event.getData(MPSCommonDataKeys.MPS_PROJECT), true);


      final CSVWriter csvWriter = new CSVWriter(myStringWriter);
      final char SEP = CSVWriter.DEFAULT_SEPARATOR;





      // (1) Project summary - header information 
      csvWriter.line("MoWare Werkbank - command permissions" + SEP + "run @ " + new LocalDate());
      csvWriter.line("for project " + event.getData(MPSCommonDataKeys.MPS_PROJECT).getName());
      csvWriter.newLine();


      for (SModel mod : allRelevantModels) {
        List<SNode> cmdList = SModelOperations.roots(mod, CONCEPTS.Command$nA);
        List<SNode> orderedCmds = ListSequence.fromList(new ArrayList<SNode>());

        ListSequence.fromList(orderedCmds).addSequence(ListSequence.fromList(cmdList).where((it) -> SEnumOperations.isMember(SPropertyOperations.getEnum(it, PROPS.newCommandType$SkFQ), 0x6dcd8c002475ea53L)));
        ListSequence.fromList(orderedCmds).addSequence(ListSequence.fromList(cmdList).where((it) -> SEnumOperations.isMember(SPropertyOperations.getEnum(it, PROPS.newCommandType$SkFQ), 0x6dcd8c002475ea5bL) || SEnumOperations.isMember(SPropertyOperations.getEnum(it, PROPS.newCommandType$SkFQ), 0x700193f2bf70a46aL)));
        ListSequence.fromList(orderedCmds).addSequence(ListSequence.fromList(cmdList).where((it) -> SEnumOperations.isMember(SPropertyOperations.getEnum(it, PROPS.newCommandType$SkFQ), 0x6dcd8c002475ea58L)));


        if (ListSequence.fromList(orderedCmds).count() > 0) {
          csvWriter.newLine();
          csvWriter.line("" + SEP + SModelOperations.getModelName(mod));
        }

        ListSequence.fromList(orderedCmds).visitAll((cmd) -> {
          String permissions = CommandPermissionsResolver.resolveCmdPresmission(cmd);

          csvWriter.line(INamedConcept__BehaviorDescriptor.getFqName_idhEwIO9y.invoke(cmd) + SEP + SPropertyOperations.getEnum(cmd, PROPS.newCommandType$SkFQ) + SEP + permissions);
        });

      }

      try {
        CopyPasteDialog dialog = new CopyPasteDialog(event.getData(MPSCommonDataKeys.MPS_PROJECT), "Generated CSV report");
        dialog.myText.setText(myStringWriter.toString());
        dialog.showDialog();

      } finally {
        myStringWriter.close();
      }

    } catch (NullPointerException npe) {
      JOptionPane.showMessageDialog(event.getData(MPSCommonDataKeys.FRAME), "NPE \n" + OFXConsoleHelper.stackTrace2String(npe), "Problem while generating report ..", JOptionPane.ERROR_MESSAGE);

    } catch (Throwable t) {
      JOptionPane.showMessageDialog(event.getData(MPSCommonDataKeys.FRAME), t.getMessage(), "Problem while generating report . ", JOptionPane.ERROR_MESSAGE);
    }
  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept Command$nA = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x63cf441cbd8ed5caL, "org.modellwerkstatt.objectflow.structure.Command");
  }

  private static final class PROPS {
    /*package*/ static final SProperty newCommandType$SkFQ = MetaAdapterFactory.getProperty(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x63cf441cbd8ed5caL, 0x6dcd8c002475ec83L, "newCommandType");
  }
}
