package org.modellwerkstatt.dataux.plugin;

/*Generated by MPS */

import jetbrains.mps.workbench.action.BaseAction;
import javax.swing.Icon;
import jetbrains.mps.workbench.action.ActionAccess;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.Map;
import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.ide.actions.MPSCommonDataKeys;
import java.awt.Frame;
import jetbrains.mps.project.MPSProject;
import org.jetbrains.annotations.NotNull;
import org.modellwerkstatt.dataux.autcomplete.RefResolve;
import org.modellwerkstatt.objectflow.plugin.MoMdlAccess;
import org.jetbrains.mps.openapi.model.SModel;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import javax.swing.JOptionPane;
import org.modellwerkstatt.objectflow.behavior.IOFXObject__BehaviorDescriptor;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import org.modellwerkstatt.objectflow.util.OFXLegacyHelper;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import org.modellwerkstatt.objectflow.behavior.BusinessProperty__BehaviorDescriptor;
import org.modellwerkstatt.dataux.autcomplete.MoWareDDDTemplateUtil;
import org.jetbrains.mps.openapi.language.SConcept;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SInterfaceConcept;
import org.jetbrains.mps.openapi.language.SProperty;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.language.SReferenceLink;

public class MoWareDDDTemplate_Action extends BaseAction {
  private static final Icon ICON = null;

  public MoWareDDDTemplate_Action() {
    super("Werkbank - DDD Template", "Create DDD environment for entity", ICON);
    this.setIsAlwaysVisible(true);
    this.setActionAccess(ActionAccess.UNDO_PROJECT);
    updateInBackground(true);
  }
  @Override
  public boolean isDumbAware() {
    return true;
  }
  @Override
  protected boolean collectActionData(AnActionEvent event, final Map<String, Object> _params) {
    if (!(super.collectActionData(event, _params))) {
      return false;
    }
    {
      SNode p = event.getData(MPSCommonDataKeys.NODE);
    }
    {
      Frame p = event.getData(MPSCommonDataKeys.FRAME);
      if (p == null) {
        return false;
      }
    }
    {
      MPSProject p = event.getData(MPSCommonDataKeys.MPS_PROJECT);
      if (p == null) {
        return false;
      }
    }
    return true;
  }
  @Override
  public void doExecute(@NotNull final AnActionEvent event, final Map<String, Object> _params) {
    boolean DEBUG_DAN_SIMPELSOL = false;

    RefResolve refs = new RefResolve();
    MoMdlAccess mh = new MoMdlAccess(event.getData(MPSCommonDataKeys.MPS_PROJECT));
    SNode entity;

    if (DEBUG_DAN_SIMPELSOL) {
      SModel autoTestModel = mh.getModel("simple.invoice");
      entity = ListSequence.fromList(SModelOperations.roots(autoTestModel, CONCEPTS.Entity$WP)).findFirst((it) -> "Invoice".equals(SPropertyOperations.getString(it, PROPS.name$MnvL)));
      refs.cleanUpModel(autoTestModel);

    } else {

      if (event.getData(MPSCommonDataKeys.NODE) == null || !(event.getData(MPSCommonDataKeys.NODE).isInstanceOfConcept(CONCEPTS.Entity$WP) || event.getData(MPSCommonDataKeys.NODE).isInstanceOfConcept(CONCEPTS.DTO$UE))) {
        JOptionPane.showMessageDialog(event.getData(MPSCommonDataKeys.FRAME), "Select the Entity node in the project explorer you want to run the autocomplete over.", "Selection missing", JOptionPane.ERROR_MESSAGE);
        return;
      }

      entity = ((SNode) event.getData(MPSCommonDataKeys.NODE));
    }






    DLGCompleterWindow dlg = new DLGCompleterWindow(event.getData(MPSCommonDataKeys.MPS_PROJECT), IOFXObject__BehaviorDescriptor.getName_id2vvVhmoLArJ.invoke(entity), SNodeOperations.isInstanceOf(entity, CONCEPTS.DTO$UE));


    dlg.setModels(ListSequence.fromList(mh.getAllModelNames()).sort((it) -> it, true).toList());
    dlg.setChilds(ListSequence.fromList(IOFXObject__BehaviorDescriptor.getBusinessPropertiesAndInherited_id8dakBL3erK.invoke(entity)).where((it) -> OFXLegacyHelper.isCollecitonWithViewOrEntity(SLinkOperations.getTarget(it, LINKS.type$56v0))).select((it) -> SPropertyOperations.getString(it, PROPS.name$MnvL)).toList());

    dlg.showDialog();

    try {
      if (dlg.isOkay()) {
        refs.parent = entity;
        if (dlg.getChildListInEntity() != null) {
          final String nameOfChild = dlg.getChildListInEntity();
          refs.childListInParent = ListSequence.fromList(IOFXObject__BehaviorDescriptor.getBusinessPropertiesAndInherited_id8dakBL3erK.invoke(entity)).findFirst((it) -> SPropertyOperations.getString(it, PROPS.name$MnvL).equals(nameOfChild));
          refs.child = SNodeOperations.cast(SLinkOperations.getTarget(SNodeOperations.cast(SLinkOperations.getTarget(SNodeOperations.cast(SLinkOperations.getTarget(refs.childListInParent, LINKS.type$56v0), CONCEPTS.ListType$LR), LINKS.elementType$ssn), CONCEPTS.ClassifierType$bL), LINKS.classifier$cxMr), CONCEPTS.IOFXObject$Y7);
          refs.parentRefInChild = ListSequence.fromList(SLinkOperations.getChildren(refs.child, LINKS.businessProperties$cI4J)).findFirst((it) -> (boolean) BusinessProperty__BehaviorDescriptor.isOpposite_id1jMXz13pjjo.invoke(it));
          refs.usingKeyOnlyMapping = !(OFXLegacyHelper.isEntityReference(SLinkOperations.getTarget(refs.parentRefInChild, LINKS.type$56v0)));
          MoWareDDDTemplateUtil.ld("settings", "Using child list (KeyOnlyMapping is " + refs.usingKeyOnlyMapping + ")");
        }

        MoWareDDDTemplateUtil util = new MoWareDDDTemplateUtil();

        String problems = util.checker(refs, dlg.isMapping(), dlg.isRepo(), dlg.isServiceNFactory(), dlg.isSearchCmd(), dlg.isGraphOwnerCmd(), dlg.isGraphEditCmd(), dlg.isCreatorCmd());

        int answer = 0;
        if (problems != null) {
          answer = JOptionPane.showConfirmDialog(null, problems + "\n\n\nDo you still want to continue?", "MoWare DDD Template problems detected.", JOptionPane.YES_NO_OPTION);
        }

        if (answer == 0) {
          refs.modForService = mh.getModel(dlg.getMappingsModelName());
          refs.modForCmdsUi = mh.getModel(dlg.getCommandsModelName());

          // Search for static ressources
          refs.staticRessources = mh.searchStaticRessources();

          util.createConceptsForEntity(refs, dlg.isMapping(), dlg.isRepo(), dlg.isServiceNFactory(), dlg.isSearchCmd(), dlg.isGraphOwnerCmd(), dlg.isGraphEditCmd(), dlg.isCreatorCmd());
        }
      }

    } catch (Exception e) {
      System.err.println("\n\n\n ------ SERIOUS Problem while auto completing -----------------------------------------\n");
      e.printStackTrace();

      JOptionPane.showMessageDialog(null, "A problem occured while trying to generate concepts!\n\n" + e.getMessage() + "\n\n\n", "Serious problem", JOptionPane.ERROR_MESSAGE);
    }

  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept Entity$WP = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x130a62a9d793b6e4L, "org.modellwerkstatt.objectflow.structure.Entity");
    /*package*/ static final SConcept DTO$UE = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x488302ba36b9283fL, "org.modellwerkstatt.objectflow.structure.DTO");
    /*package*/ static final SConcept ListType$LR = MetaAdapterFactory.getConcept(0x8388864671ce4f1cL, 0x9c53c54016f6ad4fL, 0x10c25fb076aL, "jetbrains.mps.baseLanguage.collections.structure.ListType");
    /*package*/ static final SConcept ClassifierType$bL = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101de48bf9eL, "jetbrains.mps.baseLanguage.structure.ClassifierType");
    /*package*/ static final SInterfaceConcept IOFXObject$Y7 = MetaAdapterFactory.getInterfaceConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3bdce9a978275e87L, "org.modellwerkstatt.objectflow.structure.IOFXObject");
  }

  private static final class PROPS {
    /*package*/ static final SProperty name$MnvL = MetaAdapterFactory.getProperty(0xceab519525ea4f22L, 0x9b92103b95ca8c0cL, 0x110396eaaa4L, 0x110396ec041L, "name");
  }

  private static final class LINKS {
    /*package*/ static final SContainmentLink type$56v0 = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x117b744dafeL, 0x117b752a0b9L, "type");
    /*package*/ static final SContainmentLink elementType$ssn = MetaAdapterFactory.getContainmentLink(0x8388864671ce4f1cL, 0x9c53c54016f6ad4fL, 0x10c25fb076aL, 0x10c25fe95c5L, "elementType");
    /*package*/ static final SReferenceLink classifier$cxMr = MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101de48bf9eL, 0x101de490babL, "classifier");
    /*package*/ static final SContainmentLink businessProperties$cI4J = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3bdce9a978275e87L, 0x2c8253fb15073741L, "businessProperties");
  }
}
