package org.modellwerkstatt.dataux.plugin;

/*Generated by MPS */

import jetbrains.mps.workbench.action.BaseAction;
import javax.swing.Icon;
import jetbrains.mps.workbench.action.ActionAccess;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.Map;
import jetbrains.mps.project.MPSProject;
import jetbrains.mps.ide.actions.MPSCommonDataKeys;
import java.awt.Frame;
import org.jetbrains.annotations.NotNull;
import java.io.StringWriter;
import java.util.List;
import org.jetbrains.mps.openapi.model.SModel;
import org.modellwerkstatt.objectflow.plugin.MoMdlAccess;
import org.modellwerkstatt.objectflow.runtime.CSVWriter;
import org.joda.time.LocalDate;
import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import org.modellwerkstatt.dataux.behavior.IOptionallyNamed__BehaviorDescriptor;
import org.modellwerkstatt.objectflow.behavior.IOFXObject__BehaviorDescriptor;
import org.modellwerkstatt.objectflow.plugin.CopyPasteDialog;
import javax.swing.JOptionPane;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.jetbrains.mps.openapi.language.SAbstractConcept;
import jetbrains.mps.internal.collections.runtime.Sequence;
import org.jetbrains.mps.openapi.language.SInterfaceConcept;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SConcept;
import org.jetbrains.mps.openapi.language.SProperty;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.language.SReferenceLink;

public class MoWareSkeletonsReport_Action extends BaseAction {
  private static final Icon ICON = null;

  public MoWareSkeletonsReport_Action() {
    super("Werkbank - Report dead skeletons", "Generate dead skeletons report", ICON);
    this.setIsAlwaysVisible(true);
    this.setActionAccess(ActionAccess.UNDO_PROJECT);
    updateInBackground(true);
  }
  @Override
  public boolean isDumbAware() {
    return true;
  }
  @Override
  protected boolean collectActionData(AnActionEvent event, final Map<String, Object> _params) {
    if (!(super.collectActionData(event, _params))) {
      return false;
    }
    {
      MPSProject p = event.getData(MPSCommonDataKeys.MPS_PROJECT);
      if (p == null) {
        return false;
      }
    }
    {
      Frame p = event.getData(MPSCommonDataKeys.FRAME);
      if (p == null) {
        return false;
      }
    }
    return true;
  }
  @Override
  public void doExecute(@NotNull final AnActionEvent event, final Map<String, Object> _params) {
    StringWriter myStringWriter = new StringWriter();

    try {
      List<SModel> allRelevantModels = MoMdlAccess.relevantModels(event.getData(MPSCommonDataKeys.MPS_PROJECT), true);
      final CSVWriter csvWriter = new CSVWriter(myStringWriter);
      char SEP = CSVWriter.DEFAULT_SEPARATOR;





      // (1) Project summary - header information 
      csvWriter.line("MoWare Werkbank - dead skeletons " + SEP + "run @ " + new LocalDate());
      csvWriter.line("for project " + event.getData(MPSCommonDataKeys.MPS_PROJECT).getName());
      csvWriter.newLine();

      final List<SNode> totalRootObjects = ListSequence.fromList(new ArrayList<SNode>());

      List<SNode> totalCommandsInProject = ListSequence.fromList(new ArrayList<SNode>());
      List<SNode> totalUxRootsInProject = ListSequence.fromList(new ArrayList<SNode>());
      List<SNode> totalMethodsInProject = ListSequence.fromList(new ArrayList<SNode>());
      final List<SNode> totalMappingsInProject = ListSequence.fromList(new ArrayList<SNode>());
      final List<SNode> totalCustomSqlStuff = ListSequence.fromList(new ArrayList<SNode>());

      final List<SNode> commandsInspected = ListSequence.fromList(new ArrayList<SNode>());
      final List<SNode> uxRootsInspected = ListSequence.fromList(new ArrayList<SNode>());
      final List<SNode> rootsProvidingIncludedElements = ListSequence.fromList(new ArrayList<SNode>());


      List<SNode> apps = ListSequence.fromList(new ArrayList<SNode>());
      List<SNode> tests = ListSequence.fromList(new ArrayList<SNode>());

      for (SModel mod : allRelevantModels) {
        ListSequence.fromList(apps).addSequence(ListSequence.fromList(SModelOperations.roots(mod, CONCEPTS.IModule$eS)));
        ListSequence.fromList(totalCommandsInProject).addSequence(ListSequence.fromList(SModelOperations.roots(mod, CONCEPTS.Command$nA)));
        ListSequence.fromList(totalUxRootsInProject).addSequence(ListSequence.fromList(SModelOperations.roots(mod, CONCEPTS.UxRoot$gH)));
        ListSequence.fromList(totalMethodsInProject).addSequence(ListSequence.fromList(SModelOperations.nodes(mod, CONCEPTS.InstanceMethodDeclaration$39)));
        ListSequence.fromList(tests).addSequence(ListSequence.fromList(SModelOperations.roots(mod, CONCEPTS.OFXTestSuit$Iy)));

        ListSequence.fromList(totalRootObjects).addSequence(ListSequence.fromList(SModelOperations.roots(mod, CONCEPTS.Repository$WM)));
        ListSequence.fromList(totalRootObjects).addSequence(ListSequence.fromList(SModelOperations.roots(mod, CONCEPTS.Service$HK)));
        ListSequence.fromList(totalRootObjects).addSequence(ListSequence.fromList(SModelOperations.roots(mod, CONCEPTS.IOFXObject$Y7)));

        ListSequence.fromList(totalMappingsInProject).addSequence(ListSequence.fromList(SModelOperations.nodes(mod, CONCEPTS.EntityMapping$ux)));

        ListSequence.fromList(totalCustomSqlStuff).addSequence(ListSequence.fromList(SModelOperations.nodes(mod, CONCEPTS.SqlStringField$nr)));
        ListSequence.fromList(totalCustomSqlStuff).addSequence(ListSequence.fromList(SModelOperations.nodes(mod, CONCEPTS.RowMapperField$XD)));
        ListSequence.fromList(totalCustomSqlStuff).addSequence(ListSequence.fromList(SModelOperations.nodes(mod, CONCEPTS.NoKeyMapperField$_P)));
      }




      // tests declared ..........................................................................................
      csvWriter.line("Tests declared in this project - remove deprecated/old ones !!");
      ListSequence.fromList(tests).visitAll((it) -> {
        csvWriter.line(SModelOperations.getModelName(SNodeOperations.getModel(it)), SPropertyOperations.getString(it, PROPS.name$MnvL), "" + ListSequence.fromList(SLinkOperations.getChildren(it, LINKS.content$_1km)).where(new _FunctionTypes._return_P1_E0<Boolean, SNode>() {
          public Boolean invoke(SNode it) {
            return SNodeOperations.isInstanceOf(it, CONCEPTS.OFXTestMethod$cv);
          }
        }).count());
      });
      csvWriter.newLine();
      csvWriter.newLine();




      // diff commands and uxRoots ................................................................................
      ListSequence.fromList(apps).visitAll((it) -> {
        List<SNode> rootCommands = MoWareSkeletonsReport_Action.this.commandsRefs(it, event);
        ListSequence.fromList(rootCommands).visitAll(new _FunctionTypes._void_P1_E0<SNode>() {
          public void invoke(SNode it) {
            MoWareSkeletonsReport_Action.this.inspectCmd(commandsInspected, uxRootsInspected, rootsProvidingIncludedElements, it, event);
          }
        });
      });
      ListSequence.fromList(rootsProvidingIncludedElements).visitAll((it) -> {
        if (!(ListSequence.fromList(uxRootsInspected).contains(it))) {
          csvWriter.line("WARNING", IOptionallyNamed__BehaviorDescriptor.getEscapedName_id7Cs1IG3kBLh.invoke(it) + " provides named elements, which are included. But  " + IOptionallyNamed__BehaviorDescriptor.getEscapedName_id7Cs1IG3kBLh.invoke(it) + " itself is never used from a command.");
        }

      });

      csvWriter.line("Commands no longer actively used in project");
      ListSequence.fromList(totalCommandsInProject).visitAll((it) -> {
        if (!(ListSequence.fromList(commandsInspected).contains(it))) {
          csvWriter.line(SModelOperations.getModelName(SNodeOperations.getModel(it)), SPropertyOperations.getString(it, PROPS.name$MnvL));
        }
      });
      csvWriter.newLine();
      csvWriter.newLine();

      csvWriter.line("UxRoots no longer actively used in project");
      ListSequence.fromList(totalUxRootsInProject).visitAll((it) -> {
        if (!(ListSequence.fromList(uxRootsInspected).contains(it))) {
          csvWriter.line(SModelOperations.getModelName(SNodeOperations.getModel(it)), SPropertyOperations.getString(it, PROPS.name$MnvL));
        }
      });
      csvWriter.newLine();
      csvWriter.newLine();




      final List<SNode> methodsInUse = ListSequence.fromList(new ArrayList<SNode>());
      final List<SNode> mappingsInUse = ListSequence.fromList(new ArrayList<SNode>());
      final List<SNode> edvcrInUsed = ListSequence.fromList(new ArrayList<SNode>());
      final List<SNode> customSqlStuffUsed = ListSequence.fromList(new ArrayList<SNode>());

      ListSequence.fromList(commandsInspected).visitAll((cmd) -> MoWareSkeletonsReport_Action.this.inspectContent(methodsInUse, customSqlStuffUsed, mappingsInUse, edvcrInUsed, cmd, event));
      ListSequence.fromList(tests).visitAll((test) -> MoWareSkeletonsReport_Action.this.inspectContent(methodsInUse, customSqlStuffUsed, mappingsInUse, edvcrInUsed, test, event));
      ListSequence.fromList(apps).visitAll((it) -> MoWareSkeletonsReport_Action.this.inspectContent(methodsInUse, customSqlStuffUsed, mappingsInUse, edvcrInUsed, it, event));






      // methods no longer used ...............................................................................
      csvWriter.line("Methods no longer actively used in project . . .");
      ListSequence.fromList(totalMethodsInProject).visitAll((it) -> {
        if (!(ListSequence.fromList(methodsInUse).contains(it)) && !("toString".equals(SPropertyOperations.getString(it, PROPS.name$MnvL)) || "equals".equals(SPropertyOperations.getString(it, PROPS.name$MnvL)))) {
          csvWriter.line(SModelOperations.getModelName(SNodeOperations.getModel(it)), "" + SNodeOperations.present(SNodeOperations.getContainingRoot(it)), SPropertyOperations.getString(it, PROPS.name$MnvL));
        }
      });
      csvWriter.newLine();
      csvWriter.newLine();
      System.err.println("Methods in project " + ListSequence.fromList(totalMethodsInProject).count() + " in use " + ListSequence.fromList(methodsInUse).count());






      // anti pattern :) ...............................................................................
      csvWriter.line("Objects that are used only as data containers of used objects [interestingly] . . .");
      List<SNode> iofxObjectsWithUsedMethods = ListSequence.fromList(methodsInUse).where((it) -> SNodeOperations.isInstanceOf(SNodeOperations.getParent(it), CONCEPTS.IOFXObject$Y7)).select((it) -> SNodeOperations.cast(SNodeOperations.getParent(it), CONCEPTS.IOFXObject$Y7)).distinct().toList();
      final List<SNode> propsIndirectlyUsedIOFXObjects = ListSequence.fromList(new ArrayList<SNode>());
      ListSequence.fromList(iofxObjectsWithUsedMethods).visitAll((it) -> ListSequence.fromList(IOFXObject__BehaviorDescriptor.getBusinessPropertiesAndInherited_id8dakBL3erK.invoke(it)).visitAll((prop) -> {

        SNode objInProperty = null;
        if (SNodeOperations.isInstanceOf(SLinkOperations.getTarget(prop, LINKS.type$56v0), CONCEPTS.ClassifierType$bL) && SNodeOperations.isInstanceOf(SLinkOperations.getTarget(SNodeOperations.cast(SLinkOperations.getTarget(prop, LINKS.type$56v0), CONCEPTS.ClassifierType$bL), LINKS.classifier$cxMr), CONCEPTS.IOFXObject$Y7)) {
          objInProperty = SNodeOperations.cast(SLinkOperations.getTarget(SNodeOperations.cast(SLinkOperations.getTarget(prop, LINKS.type$56v0), CONCEPTS.ClassifierType$bL), LINKS.classifier$cxMr), CONCEPTS.IOFXObject$Y7);
        } else if (SNodeOperations.isInstanceOf(SLinkOperations.getTarget(prop, LINKS.type$56v0), CONCEPTS.ListType$LR)) {
          objInProperty = SNodeOperations.cast(SLinkOperations.getTarget(SNodeOperations.cast(SLinkOperations.getTarget(SNodeOperations.cast(SLinkOperations.getTarget(prop, LINKS.type$56v0), CONCEPTS.ListType$LR), LINKS.elementType$ssn), CONCEPTS.ClassifierType$bL), LINKS.classifier$cxMr), CONCEPTS.IOFXObject$Y7);
        }
        if (objInProperty != null && !(ListSequence.fromList(propsIndirectlyUsedIOFXObjects).contains(objInProperty))) {
          ListSequence.fromList(propsIndirectlyUsedIOFXObjects).addElement(objInProperty);
        }
      }));

      ListSequence.fromList(iofxObjectsWithUsedMethods).visitAll((it) -> ListSequence.fromList(propsIndirectlyUsedIOFXObjects).removeElement(it));
      ListSequence.fromList(propsIndirectlyUsedIOFXObjects).visitAll((it) -> csvWriter.line(SModelOperations.getModelName(SNodeOperations.getModel(it)), IOFXObject__BehaviorDescriptor.getName_id2vvVhmoLArJ.invoke(it)));
      csvWriter.newLine();
      csvWriter.newLine();







      // roots no longer actively used in project here ....................................................
      csvWriter.line("Roots no longer actively used in project . . .");
      ListSequence.fromList(methodsInUse).visitAll((it) -> totalRootObjects.remove(SNodeOperations.getContainingRoot(it)));
      ListSequence.fromList(edvcrInUsed).visitAll((it) -> ListSequence.fromList(totalRootObjects).removeElement(it));
      ListSequence.fromList(propsIndirectlyUsedIOFXObjects).visitAll((it) -> ListSequence.fromList(totalRootObjects).removeElement(it));

      ListSequence.fromList(totalRootObjects).visitAll((it) -> csvWriter.line(SModelOperations.getModelName(SNodeOperations.getModel(it)), "" + SNodeOperations.present(it)));
      csvWriter.newLine();
      csvWriter.newLine();



      // mappings no longer used ....................................................
      csvWriter.line("Mappings/CustomSql no longer actively used in project . . .");
      ListSequence.fromList(mappingsInUse).visitAll((it) -> ListSequence.fromList(totalMappingsInProject).removeElement(it));
      ListSequence.fromList(totalMappingsInProject).visitAll((it) -> csvWriter.line(SModelOperations.getModelName(SNodeOperations.getModel(it)), "" + SNodeOperations.present(SNodeOperations.getContainingRoot(it)), "mapping", SPropertyOperations.getString(it, PROPS.name$MnvL)));
      ListSequence.fromList(customSqlStuffUsed).visitAll((it) -> ListSequence.fromList(totalCustomSqlStuff).removeElement(it));
      ListSequence.fromList(totalCustomSqlStuff).visitAll((it) -> csvWriter.line(SModelOperations.getModelName(SNodeOperations.getModel(it)), "" + SNodeOperations.present(SNodeOperations.getContainingRoot(it)), "custom sql", "" + SNodeOperations.present(it)));


      csvWriter.newLine();
      csvWriter.newLine();




      try {
        CopyPasteDialog dialog = new CopyPasteDialog(event.getData(MPSCommonDataKeys.MPS_PROJECT), "Generated CSV report");
        dialog.myText.setText(myStringWriter.toString());
        dialog.showDialog();

      } finally {
        myStringWriter.close();
      }

    } catch (NullPointerException npe) {
      npe.printStackTrace();
      JOptionPane.showMessageDialog(event.getData(MPSCommonDataKeys.FRAME), "NPE \n" + OFXConsoleHelper.stackTrace2String(npe), "Problem while generating report ..", JOptionPane.ERROR_MESSAGE);

    } catch (Throwable t) {
      t.printStackTrace();
      JOptionPane.showMessageDialog(event.getData(MPSCommonDataKeys.FRAME), t.getMessage(), "Problem while generating report . ", JOptionPane.ERROR_MESSAGE);
    }
  }
  private List<SNode> commandsRefs(SNode n, final AnActionEvent event) {
    List<SNode> ccbs = ListSequence.fromList(SNodeOperations.getNodeDescendants(n, CONCEPTS.CommandCallBasis$a4, false, new SAbstractConcept[]{})).toList();
    return ListSequence.fromList(ccbs).select((it) -> SLinkOperations.getTarget(it, LINKS.command$aEih)).toList();
  }
  private void inspectCmd(final List<SNode> alreadyBrowsed, final List<SNode> uxroots, final List<SNode> rootsProvidingIncludedElements, SNode toInspect, final AnActionEvent event) {
    if (ListSequence.fromList(alreadyBrowsed).contains(toInspect)) {
      return;
    }
    ListSequence.fromList(alreadyBrowsed).addElement(toInspect);

    // successors
    List<SNode> newCommands = MoWareSkeletonsReport_Action.this.commandsRefs(toInspect, event);
    ListSequence.fromList(newCommands).visitAll((it) -> MoWareSkeletonsReport_Action.this.inspectCmd(alreadyBrowsed, uxroots, rootsProvidingIncludedElements, it, event));

    Sequence.fromIterable(SLinkOperations.collectMany(SLinkOperations.getChildren(toInspect, LINKS.pages$CGHC), LINKS.pagePaneActionProviderLink$J8ec)).visitAll((it) -> {
      SNode pp = SNodeOperations.cast(SLinkOperations.getTarget(it, LINKS.actionProviderPagePane$_bcp), CONCEPTS.PagePane$a);
      MoWareSkeletonsReport_Action.this.inspectUxRoot(alreadyBrowsed, uxroots, rootsProvidingIncludedElements, pp, event);

    });

  }
  private void inspectUxRoot(final List<SNode> alreadyBrowsed, final List<SNode> uxroots, final List<SNode> rootsProvidingIncludedElements, SNode pane, final AnActionEvent event) {
    if (ListSequence.fromList(uxroots).contains(pane)) {
      return;
    }
    ListSequence.fromList(uxroots).addElement(pane);

    List<SNode> newCmds = MoWareSkeletonsReport_Action.this.commandsRefs(pane, event);
    ListSequence.fromList(newCmds).visitAll((it) -> MoWareSkeletonsReport_Action.this.inspectCmd(alreadyBrowsed, uxroots, rootsProvidingIncludedElements, it, event));

    ListSequence.fromList(SNodeOperations.getNodeDescendants(pane, CONCEPTS.Include$75, false, new SAbstractConcept[]{})).visitAll((inc) -> {
      SNode uxElem = SNodeOperations.cast(SLinkOperations.getTarget(inc, LINKS.uxElement$qTAg), CONCEPTS.UxRoot$gH);
      if (SNodeOperations.getContainingRoot(uxElem) != uxElem) {
        ListSequence.fromList(rootsProvidingIncludedElements).addElement(SNodeOperations.cast(SNodeOperations.getContainingRoot(uxElem), CONCEPTS.UxRoot$gH));
      }
      MoWareSkeletonsReport_Action.this.inspectUxRoot(alreadyBrowsed, uxroots, rootsProvidingIncludedElements, uxElem, event);

    });
  }
  private List<SNode> methodsFromOpCalls(SNode n, final AnActionEvent event) {
    List<SNode> calls = ListSequence.fromList(SNodeOperations.getNodeDescendants(n, CONCEPTS.OperationCall$7H, false, new SAbstractConcept[]{})).toList();
    return ListSequence.fromList(calls).select((it) -> SLinkOperations.getTarget(it, LINKS.baseMethodDeclaration$pyYw)).toList();
  }
  private List<SNode> methodsFromCallOperations(SNode n, final AnActionEvent event) {
    List<SNode> calls = ListSequence.fromList(SNodeOperations.getNodeDescendants(n, CONCEPTS.InstanceMethodCallOperation$uu, false, new SAbstractConcept[]{})).toList();
    return ListSequence.fromList(calls).select((it) -> SLinkOperations.getTarget(it, LINKS.baseMethodDeclaration$pyYw)).toList();
  }
  private List<SNode> methodsFromLocalCalls(SNode n, final AnActionEvent event) {
    List<SNode> calls = ListSequence.fromList(SNodeOperations.getNodeDescendants(n, CONCEPTS.LocalMethodCall$zT, false, new SAbstractConcept[]{})).toList();
    return ListSequence.fromList(calls).where((it) -> SNodeOperations.isInstanceOf(SLinkOperations.getTarget(it, LINKS.baseMethodDeclaration$pyYw), CONCEPTS.InstanceMethodDeclaration$39)).select((it) -> SNodeOperations.cast(SLinkOperations.getTarget(it, LINKS.baseMethodDeclaration$pyYw), CONCEPTS.InstanceMethodDeclaration$39)).toList();
  }
  private List<SNode> __edvcrCreated(SNode n, final AnActionEvent event) {

    final List<SNode> created = ListSequence.fromList(new ArrayList<SNode>());

    ListSequence.fromList(SNodeOperations.getNodeDescendants(n, CONCEPTS.GenericNewExpression$Fh, false, new SAbstractConcept[]{})).visitAll((it) -> {
      if (SNodeOperations.isInstanceOf(SLinkOperations.getTarget(it, LINKS.creator$BsHW), CONCEPTS.ClassCreator$ZG) && SNodeOperations.isInstanceOf(SNodeOperations.getContainingRoot(SLinkOperations.getTarget(SNodeOperations.cast(SLinkOperations.getTarget(it, LINKS.creator$BsHW), CONCEPTS.ClassCreator$ZG), LINKS.baseMethodDeclaration$pyYw)), CONCEPTS.IOFXObject$Y7)) {
        ListSequence.fromList(created).addElement(SNodeOperations.cast(SNodeOperations.getContainingRoot(SLinkOperations.getTarget(SNodeOperations.cast(SLinkOperations.getTarget(it, LINKS.creator$BsHW), CONCEPTS.ClassCreator$ZG), LINKS.baseMethodDeclaration$pyYw)), CONCEPTS.IOFXObject$Y7));
      }
    });

    ListSequence.fromList(SNodeOperations.getNodeDescendants(n, CONCEPTS.BuilderExpression$5Y, false, new SAbstractConcept[]{})).visitAll((it) -> {
      if (SNodeOperations.isInstanceOf(SLinkOperations.getTarget(SNodeOperations.cast(SLinkOperations.getTarget(it, LINKS.type$ovXx), CONCEPTS.ClassifierType$bL), LINKS.classifier$cxMr), CONCEPTS.IOFXObject$Y7)) {
        ListSequence.fromList(created).addElement(SNodeOperations.cast(SLinkOperations.getTarget(SNodeOperations.cast(SLinkOperations.getTarget(it, LINKS.type$ovXx), CONCEPTS.ClassifierType$bL), LINKS.classifier$cxMr), CONCEPTS.IOFXObject$Y7));
      }
    });

    return ListSequence.fromList(created).distinct().toList();
  }
  private SNode ___hasReturnIOFXObject(SNode toInspect, final AnActionEvent event) {
    SNode returned = null;
    SNode cls = null;

    if (SNodeOperations.isInstanceOf(SLinkOperations.getTarget(toInspect, LINKS.returnType$5xoi), CONCEPTS.ListType$LR) && SNodeOperations.isInstanceOf(SLinkOperations.getTarget(SNodeOperations.cast(SLinkOperations.getTarget(toInspect, LINKS.returnType$5xoi), CONCEPTS.ListType$LR), LINKS.elementType$ssn), CONCEPTS.ClassifierType$bL)) {
      cls = SLinkOperations.getTarget(SNodeOperations.cast(SLinkOperations.getTarget(SNodeOperations.cast(SLinkOperations.getTarget(toInspect, LINKS.returnType$5xoi), CONCEPTS.ListType$LR), LINKS.elementType$ssn), CONCEPTS.ClassifierType$bL), LINKS.classifier$cxMr);

    } else if (SNodeOperations.isInstanceOf(SLinkOperations.getTarget(toInspect, LINKS.returnType$5xoi), CONCEPTS.ClassifierType$bL)) {
      cls = SLinkOperations.getTarget(SNodeOperations.cast(SLinkOperations.getTarget(toInspect, LINKS.returnType$5xoi), CONCEPTS.ClassifierType$bL), LINKS.classifier$cxMr);
    }

    if (SNodeOperations.isInstanceOf(cls, CONCEPTS.IOFXObject$Y7)) {
      returned = SNodeOperations.cast(cls, CONCEPTS.IOFXObject$Y7);
    }
    return returned;
  }
  private void inspectContent(final List<SNode> browsedImd, final List<SNode> customSqlStuff, final List<SNode> browsedMappings, final List<SNode> edvCr, SNode toInspect, final AnActionEvent event) {

    if (SNodeOperations.isInstanceOf(toInspect, CONCEPTS.InstanceMethodDeclaration$39)) {
      if (ListSequence.fromList(browsedImd).contains(SNodeOperations.cast(toInspect, CONCEPTS.InstanceMethodDeclaration$39))) {
        return;
      }
      ListSequence.fromList(browsedImd).addElement(SNodeOperations.cast(toInspect, CONCEPTS.InstanceMethodDeclaration$39));

      SNode ret = MoWareSkeletonsReport_Action.this.___hasReturnIOFXObject(SNodeOperations.cast(toInspect, CONCEPTS.InstanceMethodDeclaration$39), event);
      if (ret != null && !(ListSequence.fromList(edvCr).contains(ret))) {
        ListSequence.fromList(edvCr).addElement(ret);
      }

      ListSequence.fromList(SNodeOperations.getNodeDescendants(toInspect, CONCEPTS.INeedsClassMapper$F$, false, new SAbstractConcept[]{})).visitAll((it) -> {
        if (!(ListSequence.fromList(browsedMappings).contains(SLinkOperations.getTarget(it, LINKS.entityMapping$Sxke)))) {
          ListSequence.fromList(browsedMappings).addElement(SLinkOperations.getTarget(it, LINKS.entityMapping$Sxke));
          if (!(ListSequence.fromList(edvCr).contains(SLinkOperations.getTarget(SLinkOperations.getTarget(it, LINKS.entityMapping$Sxke), LINKS.classConcept$r5Kr)))) {
            ListSequence.fromList(edvCr).addElement(SLinkOperations.getTarget(SLinkOperations.getTarget(it, LINKS.entityMapping$Sxke), LINKS.classConcept$r5Kr));
          }

        }

      });
    }

    ListSequence.fromList(MoWareSkeletonsReport_Action.this.__edvcrCreated(toInspect, event)).visitAll((it) -> {
      if (!(ListSequence.fromList(edvCr).contains(it))) {
        ListSequence.fromList(edvCr).addElement(it);
      }
    });

    ListSequence.fromList(SNodeOperations.getNodeDescendants(toInspect, CONCEPTS.SqlStringFieldRef$3I, false, new SAbstractConcept[]{})).visitAll((it) -> {
      if (!(ListSequence.fromList(customSqlStuff).contains(SLinkOperations.getTarget(it, LINKS.sqlstringField$5ZBe)))) {
        ListSequence.fromList(customSqlStuff).addElement(SLinkOperations.getTarget(it, LINKS.sqlstringField$5ZBe));
      }
    });
    ListSequence.fromList(SNodeOperations.getNodeDescendants(toInspect, CONCEPTS.RowMapperFieldRef$ZP, false, new SAbstractConcept[]{})).visitAll((it) -> {
      if (!(ListSequence.fromList(customSqlStuff).contains(SLinkOperations.getTarget(it, LINKS.rowMapperField$cyrb)))) {
        ListSequence.fromList(customSqlStuff).addElement(SLinkOperations.getTarget(it, LINKS.rowMapperField$cyrb));
      }
    });
    ListSequence.fromList(SNodeOperations.getNodeDescendants(toInspect, CONCEPTS.NoKeyMapperFieldRef$Vu, false, new SAbstractConcept[]{})).visitAll((it) -> {
      if (!(ListSequence.fromList(customSqlStuff).contains(SLinkOperations.getTarget(it, LINKS.noKeyMapperField$RKjG)))) {
        ListSequence.fromList(customSqlStuff).addElement(SLinkOperations.getTarget(it, LINKS.noKeyMapperField$RKjG));
      }
    });


    List<SNode> all = ListSequence.fromList(new ArrayList<SNode>());
    ListSequence.fromList(all).addSequence(ListSequence.fromList(MoWareSkeletonsReport_Action.this.methodsFromCallOperations(toInspect, event)));
    ListSequence.fromList(all).addSequence(ListSequence.fromList(MoWareSkeletonsReport_Action.this.methodsFromLocalCalls(toInspect, event)));
    ListSequence.fromList(all).addSequence(ListSequence.fromList(MoWareSkeletonsReport_Action.this.methodsFromOpCalls(toInspect, event)));

    ListSequence.fromList(all).visitAll((it) -> MoWareSkeletonsReport_Action.this.inspectContent(browsedImd, customSqlStuff, browsedMappings, edvCr, it, event));
  }

  private static final class CONCEPTS {
    /*package*/ static final SInterfaceConcept IModule$eS = MetaAdapterFactory.getInterfaceConcept(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x2cc73adc8a53eb8cL, "org.modellwerkstatt.dataux.structure.IModule");
    /*package*/ static final SConcept Command$nA = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x63cf441cbd8ed5caL, "org.modellwerkstatt.objectflow.structure.Command");
    /*package*/ static final SConcept UxRoot$gH = MetaAdapterFactory.getConcept(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x7a1c06eb034fe8f5L, "org.modellwerkstatt.dataux.structure.UxRoot");
    /*package*/ static final SConcept InstanceMethodDeclaration$39 = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc56b21dL, "jetbrains.mps.baseLanguage.structure.InstanceMethodDeclaration");
    /*package*/ static final SConcept OFXTestSuit$Iy = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x128a6a0cae5ec4baL, "org.modellwerkstatt.objectflow.structure.OFXTestSuit");
    /*package*/ static final SConcept Repository$WM = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x3d5d71b314aa1113L, "org.modellwerkstatt.manmap.structure.Repository");
    /*package*/ static final SConcept Service$HK = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3eafb777941be31fL, "org.modellwerkstatt.objectflow.structure.Service");
    /*package*/ static final SInterfaceConcept IOFXObject$Y7 = MetaAdapterFactory.getInterfaceConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3bdce9a978275e87L, "org.modellwerkstatt.objectflow.structure.IOFXObject");
    /*package*/ static final SConcept EntityMapping$ux = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d06aL, "org.modellwerkstatt.manmap.structure.EntityMapping");
    /*package*/ static final SConcept SqlStringField$nr = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x1de119beb864396dL, "org.modellwerkstatt.manmap.structure.SqlStringField");
    /*package*/ static final SConcept RowMapperField$XD = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x1de119beb8645f71L, "org.modellwerkstatt.manmap.structure.RowMapperField");
    /*package*/ static final SConcept NoKeyMapperField$_P = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xad9572552c31468L, "org.modellwerkstatt.manmap.structure.NoKeyMapperField");
    /*package*/ static final SConcept OFXTestMethod$cv = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x607becf482ad5e9fL, "org.modellwerkstatt.objectflow.structure.OFXTestMethod");
    /*package*/ static final SConcept ClassifierType$bL = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101de48bf9eL, "jetbrains.mps.baseLanguage.structure.ClassifierType");
    /*package*/ static final SConcept ListType$LR = MetaAdapterFactory.getConcept(0x8388864671ce4f1cL, 0x9c53c54016f6ad4fL, 0x10c25fb076aL, "jetbrains.mps.baseLanguage.collections.structure.ListType");
    /*package*/ static final SConcept CommandCallBasis$a4 = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x35c73bac90726cdaL, "org.modellwerkstatt.objectflow.structure.CommandCallBasis");
    /*package*/ static final SConcept PagePane$a = MetaAdapterFactory.getConcept(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x7d1a43a2ebd99c0cL, "org.modellwerkstatt.dataux.structure.PagePane");
    /*package*/ static final SConcept Include$75 = MetaAdapterFactory.getConcept(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x28ff5e7aa98b432aL, "org.modellwerkstatt.dataux.structure.Include");
    /*package*/ static final SConcept OperationCall$7H = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x6e0022916f60f59bL, "org.modellwerkstatt.objectflow.structure.OperationCall");
    /*package*/ static final SConcept InstanceMethodCallOperation$uu = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x118154a6332L, "jetbrains.mps.baseLanguage.structure.InstanceMethodCallOperation");
    /*package*/ static final SConcept LocalMethodCall$zT = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x6c6b6a1e379f9404L, "jetbrains.mps.baseLanguage.structure.LocalMethodCall");
    /*package*/ static final SConcept GenericNewExpression$Fh = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x10ab8473cc5L, "jetbrains.mps.baseLanguage.structure.GenericNewExpression");
    /*package*/ static final SConcept ClassCreator$ZG = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x11a59b0fbceL, "jetbrains.mps.baseLanguage.structure.ClassCreator");
    /*package*/ static final SConcept BuilderExpression$5Y = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x55266b8679f4de74L, "org.modellwerkstatt.objectflow.structure.BuilderExpression");
    /*package*/ static final SInterfaceConcept INeedsClassMapper$F$ = MetaAdapterFactory.getInterfaceConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x7169e080446daebaL, "org.modellwerkstatt.manmap.structure.INeedsClassMapper");
    /*package*/ static final SConcept SqlStringFieldRef$3I = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x6ad7cca26edc173L, "org.modellwerkstatt.manmap.structure.SqlStringFieldRef");
    /*package*/ static final SConcept RowMapperFieldRef$ZP = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x75d01b58a82b6ec0L, "org.modellwerkstatt.manmap.structure.RowMapperFieldRef");
    /*package*/ static final SConcept NoKeyMapperFieldRef$Vu = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xad95725532e1d33L, "org.modellwerkstatt.manmap.structure.NoKeyMapperFieldRef");
  }

  private static final class PROPS {
    /*package*/ static final SProperty name$MnvL = MetaAdapterFactory.getProperty(0xceab519525ea4f22L, 0x9b92103b95ca8c0cL, 0x110396eaaa4L, 0x110396ec041L, "name");
  }

  private static final class LINKS {
    /*package*/ static final SContainmentLink content$_1km = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x128a6a0cae5ec4baL, 0x607becf482b20095L, "content");
    /*package*/ static final SContainmentLink type$56v0 = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x117b744dafeL, 0x117b752a0b9L, "type");
    /*package*/ static final SReferenceLink classifier$cxMr = MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101de48bf9eL, 0x101de490babL, "classifier");
    /*package*/ static final SContainmentLink elementType$ssn = MetaAdapterFactory.getContainmentLink(0x8388864671ce4f1cL, 0x9c53c54016f6ad4fL, 0x10c25fb076aL, 0x10c25fe95c5L, "elementType");
    /*package*/ static final SReferenceLink command$aEih = MetaAdapterFactory.getReferenceLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x35c73bac90726cdaL, 0x35c73bac907283a4L, "command");
    /*package*/ static final SContainmentLink pages$CGHC = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x63cf441cbd8ed5caL, 0x63cf441cbd8fd5e7L, "pages");
    /*package*/ static final SContainmentLink pagePaneActionProviderLink$J8ec = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x63cf441cbd8ed5c6L, 0x35f1d76ff5e9ecb6L, "pagePaneActionProviderLink");
    /*package*/ static final SReferenceLink actionProviderPagePane$_bcp = MetaAdapterFactory.getReferenceLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x35f1d76ff5e9ec95L, 0x35f1d76ff5e9ec96L, "actionProviderPagePane");
    /*package*/ static final SReferenceLink uxElement$qTAg = MetaAdapterFactory.getReferenceLink(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x28ff5e7aa98b432aL, 0x76ec034a0d4c5b34L, "uxElement");
    /*package*/ static final SReferenceLink baseMethodDeclaration$pyYw = MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x11857355952L, 0xf8c78301adL, "baseMethodDeclaration");
    /*package*/ static final SContainmentLink creator$BsHW = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x10ab8473cc5L, 0x10ab847b486L, "creator");
    /*package*/ static final SContainmentLink type$ovXx = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x55266b8679f4de74L, 0x717214f13066ffe8L, "type");
    /*package*/ static final SContainmentLink returnType$5xoi = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc56b1fcL, 0xf8cc56b1fdL, "returnType");
    /*package*/ static final SReferenceLink entityMapping$Sxke = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x7169e080446daebaL, 0x7169e080446daebbL, "entityMapping");
    /*package*/ static final SReferenceLink classConcept$r5Kr = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d06aL, 0xc18788c4e4730efL, "classConcept");
    /*package*/ static final SReferenceLink sqlstringField$5ZBe = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x6ad7cca26edc173L, 0x6ad7cca26edc1c1L, "sqlstringField");
    /*package*/ static final SReferenceLink rowMapperField$cyrb = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x75d01b58a82b6ec0L, 0x75d01b58a82b894cL, "rowMapperField");
    /*package*/ static final SReferenceLink noKeyMapperField$RKjG = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xad95725532e1d33L, 0xad95725532e1d3dL, "noKeyMapperField");
  }
}
