package org.modellwerkstatt.dataux.plugin;

/*Generated by MPS */

import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.IAttributeDescriptor;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import org.jetbrains.mps.openapi.language.SProperty;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SConcept;
import org.jetbrains.mps.openapi.language.SContainmentLink;

public class TransKeyVal {
  public String key;
  public String info;
  public String nodeId;
  public List<String> trans;

  public TransKeyVal(String k, String in, String nid) {
    if (k == null) {
      throw new RuntimeException("Do not reg null keys!! (here for " + in + ")");
    }
    key = k;
    trans = ListSequence.fromList(new ArrayList<String>());
    info = in;
    nodeId = nid;
  }
  public boolean hasTransLations() {
    return ListSequence.fromList(trans).count() > 0;
  }
  public String[] asArray() {
    String[] arr = new String[ListSequence.fromList(trans).count() + 3];
    int i = 0;
    arr[i++] = key;
    arr[i++] = info;
    arr[i++] = nodeId;

    for (String s : trans) {
      arr[i++] = s;
    }
    return arr;
  }


  public static TransKeyVal fromSL(SNode sl, String in) {
    final TransKeyVal keyVal = new TransKeyVal(SPropertyOperations.getString(sl, PROPS.value$w7MM), in, "" + sl.getNodeId());
    if ((new IAttributeDescriptor.NodeAttribute(CONCEPTS.StringLiteralTransAttribut$Bh).get(sl) != null)) {
      ListSequence.fromList(SLinkOperations.getChildren(new IAttributeDescriptor.NodeAttribute(CONCEPTS.StringLiteralTransAttribut$Bh).get(sl), LINKS.translations$AQU2)).visitAll((it) -> ListSequence.fromList(keyVal.trans).addElement(SPropertyOperations.getString(it, PROPS.value$llEn)));
    }

    return keyVal;
  }

  public static TransKeyVal fromMS(SNode ms, String in) {
    final TransKeyVal keyVal = new TransKeyVal(SPropertyOperations.getString(SNodeOperations.cast(SLinkOperations.getTarget(ms, LINKS.formatString$GGXJ), CONCEPTS.StringFormatString$sD), PROPS.formatStringValue$2TVh), in, "" + ms.getNodeId());
    if (ListSequence.fromList(SLinkOperations.getChildren(ms, LINKS.translations$kKvQ)).count() > 0) {
      ListSequence.fromList(SLinkOperations.getChildren(ms, LINKS.translations$kKvQ)).visitAll((it) -> ListSequence.fromList(keyVal.trans).addElement(SPropertyOperations.getString(it, PROPS.formatString$eXrT)));
    }
    return keyVal;

  }
  public static TransKeyVal fromCSV(String[] in) {
    if (in.length < 3) {
      throw new RuntimeException("Need at least 3 columns for lang-csv: " + printArray(in));
    }
    TransKeyVal keyVal = new TransKeyVal(in[0], in[1], in[2]);
    for (int i = 3; i < in.length; i++) {
      ListSequence.fromList(keyVal.trans).addElement(in[i]);
    }
    return keyVal;
  }
  public static void updateSLifTransNotNull(TransKeyVal val, SNode sl) {
    if (val == null || !(val.hasTransLations())) {
      return;
    }

    // else. okay. update...
    if ((new IAttributeDescriptor.NodeAttribute(CONCEPTS.StringLiteralTransAttribut$Bh).get(sl) == null)) {
      new IAttributeDescriptor.NodeAttribute(CONCEPTS.StringLiteralTransAttribut$Bh).setNew(sl);
    }

    int index = 0;
    for (String singleT : val.trans) {

      if (ListSequence.fromList(SLinkOperations.getChildren(new IAttributeDescriptor.NodeAttribute(CONCEPTS.StringLiteralTransAttribut$Bh).get(sl), LINKS.translations$AQU2)).count() <= index) {
        SLinkOperations.addNewChild(new IAttributeDescriptor.NodeAttribute(CONCEPTS.StringLiteralTransAttribut$Bh).get(sl), LINKS.translations$AQU2, CONCEPTS.TranslatedStringLiteral$rI);
      }

      // update?
      if (!(singleT.equals(SPropertyOperations.getString(ListSequence.fromList(SLinkOperations.getChildren(new IAttributeDescriptor.NodeAttribute(CONCEPTS.StringLiteralTransAttribut$Bh).get(sl), LINKS.translations$AQU2)).getElement(index), PROPS.value$llEn)))) {
        SPropertyOperations.assign(ListSequence.fromList(SLinkOperations.getChildren(new IAttributeDescriptor.NodeAttribute(CONCEPTS.StringLiteralTransAttribut$Bh).get(sl), LINKS.translations$AQU2)).getElement(index), PROPS.value$llEn, singleT);
      }
      index++;
    }
  }
  public static void updateMSifTransNotNull(TransKeyVal val, SNode ms) {
    if (val == null || !(val.hasTransLations())) {
      return;
    }

    // else. okay. update...

    int index = 0;
    for (String singleT : val.trans) {
      if (ListSequence.fromList(SLinkOperations.getChildren(ms, LINKS.translations$kKvQ)).count() <= index) {
        SLinkOperations.addNewChild(ms, LINKS.translations$kKvQ, CONCEPTS.TranslatedMultiString$Cx);
      }

      if (!(singleT.equals(SPropertyOperations.getString(ListSequence.fromList(SLinkOperations.getChildren(ms, LINKS.translations$kKvQ)).getElement(index), PROPS.formatString$eXrT)))) {
        SPropertyOperations.assign(ListSequence.fromList(SLinkOperations.getChildren(ms, LINKS.translations$kKvQ)).getElement(index), PROPS.formatString$eXrT, singleT);
      }
      index++;
    }
  }

  public static String printArray(String[] ar) {
    StringBuilder sb = new StringBuilder();
    for (String s : ar) {
      sb.append(s + ", ");
    }
    return sb.toString();
  }

  private static final class PROPS {
    /*package*/ static final SProperty value$w7MM = MetaAdapterFactory.getProperty(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf93d565d10L, 0xf93d565d11L, "value");
    /*package*/ static final SProperty value$llEn = MetaAdapterFactory.getProperty(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x59515864ae34e73fL, 0x59515864ae34e7b7L, "value");
    /*package*/ static final SProperty formatStringValue$2TVh = MetaAdapterFactory.getProperty(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x45334e0957030122L, 0x45334e095703015dL, "formatStringValue");
    /*package*/ static final SProperty formatString$eXrT = MetaAdapterFactory.getProperty(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x372ee24bb023b219L, 0x372ee24bb023b288L, "formatString");
  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept StringLiteralTransAttribut$Bh = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x59515864ae34e613L, "org.modellwerkstatt.objectflow.structure.StringLiteralTransAttribut");
    /*package*/ static final SConcept StringFormatString$sD = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x45334e0957030122L, "org.modellwerkstatt.objectflow.structure.StringFormatString");
    /*package*/ static final SConcept TranslatedStringLiteral$rI = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x59515864ae34e73fL, "org.modellwerkstatt.objectflow.structure.TranslatedStringLiteral");
    /*package*/ static final SConcept TranslatedMultiString$Cx = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x372ee24bb023b219L, "org.modellwerkstatt.objectflow.structure.TranslatedMultiString");
  }

  private static final class LINKS {
    /*package*/ static final SContainmentLink translations$AQU2 = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x59515864ae34e613L, 0x59515864ae34e9c4L, "translations");
    /*package*/ static final SContainmentLink formatString$GGXJ = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x31c16699f45ad44aL, 0x45334e095702ffecL, "formatString");
    /*package*/ static final SContainmentLink translations$kKvQ = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x31c16699f45ad44aL, 0x372ee24bb023b2dcL, "translations");
  }
}
