package org.modellwerkstatt.dataux.autcomplete;

/*Generated by MPS */

import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.behavior.IOFXObject__BehaviorDescriptor;
import org.modellwerkstatt.objectflow.util.OFXLegacyHelper;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import org.modellwerkstatt.objectflow.behavior.BusinessProperty__BehaviorDescriptor;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import java.util.List;
import org.jetbrains.mps.openapi.model.SNode;
import java.util.ArrayList;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import jetbrains.mps.smodel.action.SNodeFactoryOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SConceptOperations;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.baseLanguage.behavior.ClassConcept__BehaviorDescriptor;
import org.modellwerkstatt.objectflow.util.CreateDefaultMappingForManMap;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.language.SReferenceLink;
import org.jetbrains.mps.openapi.language.SConcept;
import org.jetbrains.mps.openapi.language.SProperty;

public class MoWareDDDTemplateUtil {
  private RefResolve refs;
  private CommandAutoCompleter commandAutoCompleter;
  private UiAutoCompleter uiAutoCompleter;
  private RepoAutoCompleter repoAutoCompleter;



  public MoWareDDDTemplateUtil() {
  }

  public static void ld(String type, String msg) {
    System.err.println(String.format("%30s: %s", type, msg));
  }


  public String checker(RefResolve refInfo, boolean mapping, boolean repo, boolean serviceNFact, boolean search, boolean grapowner, boolean graphedit, boolean creatorCmd) {
    String problems = "";
    refs = refInfo;

    // Build situational awareness - - - - - - - - - - - - - - - - - - - - - - - - - - - - Ubiqutous language! - - - - -
    boolean withPositions = refs.child != null;
    boolean parentHasProcessStateField = ListSequence.fromList(IOFXObject__BehaviorDescriptor.getBusinessPropertiesAndInherited_id8dakBL3erK.invoke(refs.parent)).any((it) -> OFXLegacyHelper.isStatus(SLinkOperations.getTarget(it, LINKS.type$56v0)));



    //  then run business rules  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    // (1) when using child list, we need back-reference
    if (withPositions && !(ListSequence.fromList(IOFXObject__BehaviorDescriptor.getBusinessPropertiesAndInherited_id8dakBL3erK.invoke(refs.child)).any((it) -> (boolean) BusinessProperty__BehaviorDescriptor.isOpposite_id1jMXz13pjjo.invoke(it)))) {
      problems += "The child-list entities '" + SNodeOperations.present(refs.child) + "' do not contain a back-reference/key to it's parent entity '" + refs.parent + "' Use OPPOSITE keyword.\n";
    }

    // (2) we need a status field, last mentioned in entity for a process state
    if (serviceNFact && !(parentHasProcessStateField)) {
      problems += "Your parent '" + SNodeOperations.present(refs.parent) + "' needs a status field, if you want to create a service for this aggregate.\n";
    }

    if (creatorCmd && !(serviceNFact)) {
      problems += "When requesting a creator command, you should also enable the creation of a factory for the aggregate!";

    }

    if ("".equals(problems)) {
      return null;
    }
    return problems;
  }



  public void createConceptsForEntity(RefResolve refInfo, boolean mapping, boolean repo, boolean service, boolean search, boolean grapowner, boolean graphedit, boolean creatorCmd) {

    refs = refInfo;
    repoAutoCompleter = new RepoAutoCompleter(refInfo);
    uiAutoCompleter = new UiAutoCompleter(refInfo);
    commandAutoCompleter = new CommandAutoCompleter(refInfo, repoAutoCompleter, uiAutoCompleter);


    //  see what is to do ...
    if (mapping) {
      refs.parentMapping = createMappingFor(refs.parent, null, null);

      if (refs.childListInParent != null) {
        refs.childMappipng = createMappingFor(refs.child, SNodeOperations.cast(ListSequence.fromList(SLinkOperations.getChildren(refs.parentMapping, LINKS.atomMpig$bBsC)).findFirst((it) -> SNodeOperations.isInstanceOf(it, CONCEPTS.ListMapping$Ro) && SLinkOperations.getTarget(SNodeOperations.cast(it, CONCEPTS.ListMapping$Ro), LINKS.property$v8ai) == refs.childListInParent), CONCEPTS.ListMapping$Ro), refs.parent);
      }
    } else {
      final List<SNode> allMappingsInModel = new ArrayList<SNode>();
      ListSequence.fromList(SModelOperations.nodes(refs.modForService, CONCEPTS.PersistenceDescription$pP)).select((it) -> SLinkOperations.getChildren(it, LINKS.persistenceMapping$S18_)).visitAll((it) -> ListSequence.fromList(allMappingsInModel).addSequence(ListSequence.fromList(it)));

      refs.parentMapping = ListSequence.fromList(allMappingsInModel).findFirst((it) -> SLinkOperations.getTarget(it, LINKS.classConcept$r5Kr) == refs.parent);
      refs.childMappipng = ListSequence.fromList(allMappingsInModel).findFirst((it) -> SLinkOperations.getTarget(it, LINKS.classConcept$r5Kr) == refs.child);
    }

    if (repo) {
      repoAutoCompleter.createRepositoryFor(null);

    }

    if (service) {
      createAggService();
      createFactory();
    }


    if (graphedit) {
      commandAutoCompleter.createGraphEditForParent(false);
      if (refs.child != null) {
        commandAutoCompleter.createGraphEditForParent(true);
      }
    }

    if (grapowner) {
      commandAutoCompleter.createGraphOwner();
    }

    if (creatorCmd) {
      commandAutoCompleter.createCreatorCmd();
    }

    if (search) {
      commandAutoCompleter.createSearchCommand();
    }

  }




  private void createAggService() {
    ld("create agg srv", "creating serivce andn factory");
    SNode srv = SNodeFactoryOperations.createNewRootNode(refs.modForService, CONCEPTS.Service$HK, null);
    refs.service = srv;
    SPropertyOperations.assign(srv, PROPS.name$MnvL, IOFXObject__BehaviorDescriptor.getName_id2vvVhmoLArJ.invoke(refs.parent) + "Srv");


    SNode statusPropery = ListSequence.fromList(IOFXObject__BehaviorDescriptor.getBusinessPropertiesAndInherited_id8dakBL3erK.invoke(refs.parent)).findLast((it) -> OFXLegacyHelper.isStatus(SLinkOperations.getTarget(it, LINKS.type$56v0)));
    SNode status = SLinkOperations.getTarget(SNodeOperations.cast(SLinkOperations.getTarget(statusPropery, LINKS.type$56v0), CONCEPTS.StatusType$Mp), LINKS.status$PoDo);

    // (3) ________________ one method per state, with transition
    for (SNode elem : SLinkOperations.getChildren(status, LINKS.element$GLWK)) {

      SNode simd = GU.addStatusChangeMethod(srv, "set" + SNodeOperations.present(elem), SNodeOperations.cast(refs.parent, CONCEPTS.Entity$WP));
      SPropertyOperations.assign(ListSequence.fromList(SLinkOperations.getChildren(simd, LINKS.parameter$5xBj)).first(), PROPS.name$MnvL, IOFXObject__BehaviorDescriptor.getName_id2vvVhmoLArJ.invoke(refs.parent).toLowerCase());

      ListSequence.fromList(SLinkOperations.getChildren(SLinkOperations.getTarget(simd, LINKS.body$5xQk), LINKS.statement$53DE)).addElement(GU.createStatusChange(ListSequence.fromList(SLinkOperations.getChildren(simd, LINKS.parameter$5xBj)).first(), statusPropery, elem));
    }
  }


  public void createFactory() {
    ld("create factory", "creating factory");
    SNode factory = SNodeFactoryOperations.createNewRootNode(refs.modForService, CONCEPTS.Service$HK, null);
    refs.factory = factory;
    SPropertyOperations.assign(factory, PROPS.name$MnvL, IOFXObject__BehaviorDescriptor.getName_id2vvVhmoLArJ.invoke(refs.parent) + "Fact");


    SNode simd = SNodeFactoryOperations.addNewChild(factory, LINKS.member$L_2d, CONCEPTS.ServiceInstanceMethodDeclaration$ww);
    SPropertyOperations.assign(simd, PROPS.name$MnvL, "create" + IOFXObject__BehaviorDescriptor.getName_id2vvVhmoLArJ.invoke(refs.parent) + "WithOnePos");

    SLinkOperations.setTarget(simd, LINKS.returnType$5xoi, GU.typeForEnttiy(refs.parent));

    SNode rootLvd = SNodeFactoryOperations.setNewChild(SNodeFactoryOperations.addNewChild(SLinkOperations.getTarget(simd, LINKS.body$5xQk), LINKS.statement$53DE, CONCEPTS.LocalVariableDeclarationStatement$4w), LINKS.localVariableDeclaration$RpjM, CONCEPTS.LocalVariableDeclaration$41);
    SPropertyOperations.assign(rootLvd, PROPS.name$MnvL, IOFXObject__BehaviorDescriptor.getName_id2vvVhmoLArJ.invoke(refs.parent).toLowerCase());
    SLinkOperations.setTarget(rootLvd, LINKS.type$a1UY, GU.typeForEnttiy(refs.parent));

    SNode rootRef = SConceptOperations.createNewNode(MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8c77f1e98L, "jetbrains.mps.baseLanguage.structure.VariableReference"));
    SLinkOperations.setTarget(rootRef, LINKS.variableDeclaration$N1XG, rootLvd);


    SNode newParent = SNodeFactoryOperations.setNewChild(SNodeFactoryOperations.addNewChild(SLinkOperations.getTarget(simd, LINKS.body$5xQk), LINKS.statement$53DE, CONCEPTS.ExpressionStatement$O8), LINKS.expression$5L7M, CONCEPTS.AssignmentExpression$SE);
    SLinkOperations.setTarget(newParent, LINKS.lValue$splI, SNodeOperations.copyNode(rootRef));
    SLinkOperations.setTarget(SNodeFactoryOperations.setNewChild(SNodeFactoryOperations.setNewChild(newParent, LINKS.rValue$spNK, CONCEPTS.GenericNewExpression$Fh), LINKS.creator$BsHW, CONCEPTS.ClassCreator$ZG), LINKS.baseMethodDeclaration$pyYw, Sequence.fromIterable(ClassConcept__BehaviorDescriptor.constructors_id4_LVZ3pCvsd.invoke(SNodeOperations.cast(refs.parent, CONCEPTS.ClassConcept$bK))).first());


    if (refs.child != null) {
      SNode lvd = SNodeFactoryOperations.setNewChild(SNodeFactoryOperations.addNewChild(SLinkOperations.getTarget(simd, LINKS.body$5xQk), LINKS.statement$53DE, CONCEPTS.LocalVariableDeclarationStatement$4w), LINKS.localVariableDeclaration$RpjM, CONCEPTS.LocalVariableDeclaration$41);
      SPropertyOperations.assign(lvd, PROPS.name$MnvL, IOFXObject__BehaviorDescriptor.getName_id2vvVhmoLArJ.invoke(refs.child).toLowerCase());
      SLinkOperations.setTarget(lvd, LINKS.type$a1UY, GU.typeForEnttiy(refs.child));
      SLinkOperations.setTarget(SNodeFactoryOperations.setNewChild(SNodeFactoryOperations.setNewChild(lvd, LINKS.initializer$2twD, CONCEPTS.GenericNewExpression$Fh), LINKS.creator$BsHW, CONCEPTS.ClassCreator$ZG), LINKS.baseMethodDeclaration$pyYw, Sequence.fromIterable(ClassConcept__BehaviorDescriptor.constructors_id4_LVZ3pCvsd.invoke(SNodeOperations.cast(refs.child, CONCEPTS.ClassConcept$bK))).first());


      SNode rootDot = SNodeFactoryOperations.setNewChild(SNodeFactoryOperations.addNewChild(SLinkOperations.getTarget(simd, LINKS.body$5xQk), LINKS.statement$53DE, CONCEPTS.ExpressionStatement$O8), LINKS.expression$5L7M, CONCEPTS.DotExpression$yW);
      SLinkOperations.setTarget(SNodeFactoryOperations.setNewChild(rootDot, LINKS.operand$w6IR, CONCEPTS.DotExpression$yW), LINKS.operand$w6IR, SNodeOperations.copyNode(rootRef));
      SLinkOperations.setTarget(SNodeFactoryOperations.setNewChild(SNodeOperations.cast(SLinkOperations.getTarget(rootDot, LINKS.operand$w6IR), CONCEPTS.DotExpression$yW), LINKS.operation$gs9E, CONCEPTS.PropertyReference$hL), LINKS.property$Bjg2, refs.childListInParent);
      SLinkOperations.setTarget(SNodeFactoryOperations.setNewChild(SNodeFactoryOperations.setNewChild(rootDot, LINKS.operation$gs9E, CONCEPTS.AddElementOperation$ST), LINKS.argument$ZmGN, CONCEPTS.VariableReference$TC), LINKS.variableDeclaration$N1XG, lvd);
    }

    SLinkOperations.setTarget(SNodeFactoryOperations.addNewChild(SLinkOperations.getTarget(simd, LINKS.body$5xQk), LINKS.statement$53DE, CONCEPTS.ExpressionStatement$O8), LINKS.expression$5L7M, SNodeOperations.copyNode(rootRef));
  }



  private SNode createMappingFor(SNode entity, SNode parentListMapping, SNode parent) {
    SNode pd = ListSequence.fromList(SModelOperations.roots(refs.modForService, CONCEPTS.PersistenceDescription$pP)).first();
    // is there a persistance description
    ld("create mapping", "mapping for " + IOFXObject__BehaviorDescriptor.getName_id2vvVhmoLArJ.invoke(entity));
    if (pd == null) {
      pd = SNodeFactoryOperations.createNewRootNode(refs.modForService, CONCEPTS.PersistenceDescription$pP, null);
      SPropertyOperations.assign(pd, PROPS.name$MnvL, "AutoGenPersistanceDescription");
    }


    SNode createdMapping = SNodeFactoryOperations.addNewChild(pd, LINKS.persistenceMapping$S18_, CONCEPTS.EntityMapping$ux);
    SLinkOperations.setTarget(createdMapping, LINKS.classConcept$r5Kr, SNodeOperations.cast(entity, CONCEPTS.ClassConcept$bK));
    SPropertyOperations.assign(createdMapping, PROPS.name$MnvL, "Map" + IOFXObject__BehaviorDescriptor.getName_id2vvVhmoLArJ.invoke(entity));
    SNodeFactoryOperations.setNewChild(createdMapping, LINKS.tableName$PpjQ, null);
    SPropertyOperations.assign(SLinkOperations.getTarget(createdMapping, LINKS.tableName$PpjQ), PROPS.value$w7MM, "TABLE_" + IOFXObject__BehaviorDescriptor.getName_id2vvVhmoLArJ.invoke(entity));
    // Optimistic locking is on default ... 

    ListSequence.fromList(SLinkOperations.getChildren(createdMapping, LINKS.atomMpig$bBsC)).addSequence(ListSequence.fromList(CreateDefaultMappingForManMap.createDefaultMapping(createdMapping)));


    //  complicated back reference stuff comes here ...
    if (parentListMapping != null) {
      if (refs.usingKeyOnlyMapping) {
        SNode keyOnlyMapping = SNodeOperations.cast(ListSequence.fromList(SLinkOperations.getChildren(createdMapping, LINKS.atomMpig$bBsC)).findFirst((it) -> SNodeOperations.isInstanceOf(it, CONCEPTS.FieldMapping$r8) && SLinkOperations.getTarget(SNodeOperations.cast(it, CONCEPTS.FieldMapping$r8), LINKS.property$JxuR) == refs.parentRefInChild), CONCEPTS.FieldMapping$r8);

        SNode ref = SNodeFactoryOperations.setNewChild(parentListMapping, LINKS.mappedfieldRef$gS23, CONCEPTS.KeyOnlyReferenceMapping$u8);
        SLinkOperations.setTarget(ref, LINKS.entityMapping$1rZd, createdMapping);
        SLinkOperations.setTarget(ref, LINKS.keyOnlyRef$1stf, keyOnlyMapping);

      } else {
        SNode backRefMapping = SNodeOperations.cast(ListSequence.fromList(SLinkOperations.getChildren(createdMapping, LINKS.atomMpig$bBsC)).findFirst((it) -> SNodeOperations.isInstanceOf(it, CONCEPTS.ReferenceMapping$TY) && SLinkOperations.getTarget(SNodeOperations.cast(it, CONCEPTS.ReferenceMapping$TY), LINKS.property$GCKf) == refs.parentRefInChild), CONCEPTS.ReferenceMapping$TY);

        SNode ref = SNodeFactoryOperations.setNewChild(parentListMapping, LINKS.mappedfieldRef$gS23, CONCEPTS.MappedFieldRef$Ly);
        SLinkOperations.setTarget(ref, LINKS.entityMapping$L$je, createdMapping);
        SLinkOperations.setTarget(ref, LINKS.refMapping$L$yf, backRefMapping);
      }


    }

    return createdMapping;
  }

  private static final class LINKS {
    /*package*/ static final SContainmentLink type$56v0 = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x117b744dafeL, 0x117b752a0b9L, "type");
    /*package*/ static final SContainmentLink atomMpig$bBsC = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e476b28L, 0x3f409dc3f36bdc67L, "atomMpig");
    /*package*/ static final SReferenceLink property$v8ai = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e48afdaL, 0xc18788c4e48afdfL, "property");
    /*package*/ static final SContainmentLink persistenceMapping$S18_ = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e458697L, 0xc18788c4e46d0b0L, "persistenceMapping");
    /*package*/ static final SReferenceLink classConcept$r5Kr = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d06aL, 0xc18788c4e4730efL, "classConcept");
    /*package*/ static final SReferenceLink status$PoDo = MetaAdapterFactory.getReferenceLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3ee8b55a8397033dL, 0x5b98aafabfcedbd3L, "status");
    /*package*/ static final SContainmentLink parameter$5xBj = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc56b1fcL, 0xf8cc56b1feL, "parameter");
    /*package*/ static final SContainmentLink body$5xQk = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc56b1fcL, 0xf8cc56b1ffL, "body");
    /*package*/ static final SContainmentLink statement$53DE = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc56b200L, 0xf8cc6bf961L, "statement");
    /*package*/ static final SContainmentLink element$GLWK = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3ee8b55a8395b855L, 0x3ee8b55a8395b858L, "element");
    /*package*/ static final SContainmentLink member$L_2d = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101d9d3ca30L, 0x4a9a46de59132803L, "member");
    /*package*/ static final SContainmentLink returnType$5xoi = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc56b1fcL, 0xf8cc56b1fdL, "returnType");
    /*package*/ static final SContainmentLink localVariableDeclaration$RpjM = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc67c7f0L, 0xf8cc67c7f1L, "localVariableDeclaration");
    /*package*/ static final SContainmentLink type$a1UY = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x450368d90ce15bc3L, 0x4ed4d318133c80ceL, "type");
    /*package*/ static final SReferenceLink variableDeclaration$N1XG = MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8c77f1e98L, 0xf8cc6bf960L, "variableDeclaration");
    /*package*/ static final SContainmentLink expression$5L7M = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc56b213L, 0xf8cc56b214L, "expression");
    /*package*/ static final SContainmentLink lValue$splI = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x11b0d00332cL, 0xf8c77f1e97L, "lValue");
    /*package*/ static final SContainmentLink rValue$spNK = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x11b0d00332cL, 0xf8c77f1e99L, "rValue");
    /*package*/ static final SContainmentLink creator$BsHW = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x10ab8473cc5L, 0x10ab847b486L, "creator");
    /*package*/ static final SReferenceLink baseMethodDeclaration$pyYw = MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x11857355952L, 0xf8c78301adL, "baseMethodDeclaration");
    /*package*/ static final SContainmentLink initializer$2twD = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8c37a7f6eL, 0xf8c37f506eL, "initializer");
    /*package*/ static final SContainmentLink operand$w6IR = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x116b46a08c4L, 0x116b46a4416L, "operand");
    /*package*/ static final SContainmentLink operation$gs9E = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x116b46a08c4L, 0x116b46b36c4L, "operation");
    /*package*/ static final SReferenceLink property$Bjg2 = MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x117b821eaaeL, 0x117b823ed57L, "property");
    /*package*/ static final SContainmentLink argument$ZmGN = MetaAdapterFactory.getContainmentLink(0x8388864671ce4f1cL, 0x9c53c54016f6ad4fL, 0x7818f71827244b5L, 0x7818f71827244b6L, "argument");
    /*package*/ static final SContainmentLink tableName$PpjQ = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d06aL, 0xc18788c4e5a1501L, "tableName");
    /*package*/ static final SReferenceLink property$JxuR = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d063L, 0xc18788c4e476aafL, "property");
    /*package*/ static final SContainmentLink mappedfieldRef$gS23 = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e48afdaL, 0x6b9f295710412373L, "mappedfieldRef");
    /*package*/ static final SReferenceLink entityMapping$1rZd = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x4b6fb42d5752c97dL, 0x4b6fb42d5799ace9L, "entityMapping");
    /*package*/ static final SReferenceLink keyOnlyRef$1stf = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x4b6fb42d5752c97dL, 0x4b6fb42d5799acebL, "keyOnlyRef");
    /*package*/ static final SReferenceLink property$GCKf = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x752265f7ae8fe1eeL, 0x752265f7ae8fe1f0L, "property");
    /*package*/ static final SReferenceLink entityMapping$L$je = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x6b9f295710400f29L, 0x6b9f295710400f2aL, "entityMapping");
    /*package*/ static final SReferenceLink refMapping$L$yf = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x6b9f295710400f29L, 0x6b9f295710400f2bL, "refMapping");
  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept ListMapping$Ro = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e48afdaL, "org.modellwerkstatt.manmap.structure.ListMapping");
    /*package*/ static final SConcept PersistenceDescription$pP = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e458697L, "org.modellwerkstatt.manmap.structure.PersistenceDescription");
    /*package*/ static final SConcept Service$HK = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3eafb777941be31fL, "org.modellwerkstatt.objectflow.structure.Service");
    /*package*/ static final SConcept StatusType$Mp = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3ee8b55a8397033dL, "org.modellwerkstatt.objectflow.structure.StatusType");
    /*package*/ static final SConcept Entity$WP = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x130a62a9d793b6e4L, "org.modellwerkstatt.objectflow.structure.Entity");
    /*package*/ static final SConcept ServiceInstanceMethodDeclaration$ww = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x6de6af0ef2406677L, "org.modellwerkstatt.objectflow.structure.ServiceInstanceMethodDeclaration");
    /*package*/ static final SConcept LocalVariableDeclarationStatement$4w = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc67c7f0L, "jetbrains.mps.baseLanguage.structure.LocalVariableDeclarationStatement");
    /*package*/ static final SConcept LocalVariableDeclaration$41 = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc67c7efL, "jetbrains.mps.baseLanguage.structure.LocalVariableDeclaration");
    /*package*/ static final SConcept ExpressionStatement$O8 = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc56b213L, "jetbrains.mps.baseLanguage.structure.ExpressionStatement");
    /*package*/ static final SConcept AssignmentExpression$SE = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8c77f1e96L, "jetbrains.mps.baseLanguage.structure.AssignmentExpression");
    /*package*/ static final SConcept GenericNewExpression$Fh = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x10ab8473cc5L, "jetbrains.mps.baseLanguage.structure.GenericNewExpression");
    /*package*/ static final SConcept ClassCreator$ZG = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x11a59b0fbceL, "jetbrains.mps.baseLanguage.structure.ClassCreator");
    /*package*/ static final SConcept ClassConcept$bK = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8c108ca66L, "jetbrains.mps.baseLanguage.structure.ClassConcept");
    /*package*/ static final SConcept DotExpression$yW = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x116b46a08c4L, "jetbrains.mps.baseLanguage.structure.DotExpression");
    /*package*/ static final SConcept PropertyReference$hL = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x117b821eaaeL, "jetbrains.mps.baseLanguage.structure.PropertyReference");
    /*package*/ static final SConcept AddElementOperation$ST = MetaAdapterFactory.getConcept(0x8388864671ce4f1cL, 0x9c53c54016f6ad4fL, 0x10e39e3ff80L, "jetbrains.mps.baseLanguage.collections.structure.AddElementOperation");
    /*package*/ static final SConcept VariableReference$TC = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8c77f1e98L, "jetbrains.mps.baseLanguage.structure.VariableReference");
    /*package*/ static final SConcept EntityMapping$ux = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d06aL, "org.modellwerkstatt.manmap.structure.EntityMapping");
    /*package*/ static final SConcept FieldMapping$r8 = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d063L, "org.modellwerkstatt.manmap.structure.FieldMapping");
    /*package*/ static final SConcept KeyOnlyReferenceMapping$u8 = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x4b6fb42d5752c97dL, "org.modellwerkstatt.manmap.structure.KeyOnlyReferenceMapping");
    /*package*/ static final SConcept ReferenceMapping$TY = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x752265f7ae8fe1eeL, "org.modellwerkstatt.manmap.structure.ReferenceMapping");
    /*package*/ static final SConcept MappedFieldRef$Ly = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x6b9f295710400f29L, "org.modellwerkstatt.manmap.structure.MappedFieldRef");
  }

  private static final class PROPS {
    /*package*/ static final SProperty name$MnvL = MetaAdapterFactory.getProperty(0xceab519525ea4f22L, 0x9b92103b95ca8c0cL, 0x110396eaaa4L, 0x110396ec041L, "name");
    /*package*/ static final SProperty value$w7MM = MetaAdapterFactory.getProperty(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf93d565d10L, 0xf93d565d11L, "value");
  }
}
