package org.modellwerkstatt.dataux.ofxutil;

/*Generated by MPS */

import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import org.modellwerkstatt.objectflow.util.OFXLegacyHelper;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SConceptOperations;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import jetbrains.mps.smodel.builder.SNodeBuilder;
import org.jetbrains.mps.openapi.language.SConcept;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.language.SReferenceLink;
import org.jetbrains.mps.openapi.language.SProperty;

public class DataUxApiHelper {

  public static SNode ensureIntBoxed(SNode theType) {
    if (SNodeOperations.isInstanceOf(theType, CONCEPTS.IntegerType$7a)) {
      return _quotation_createNode_o6j90t_a0a0a1();
    }
    return theType;
  }

  public static boolean isPrimInt(SNode theType) {
    return SNodeOperations.isInstanceOf(theType, CONCEPTS.IntegerType$7a);
  }
  public static boolean isList(SNode theType) {
    return SNodeOperations.isInstanceOf(theType, CONCEPTS.ListType$LR);
  }

  public static boolean isPrimString(SNode theType) {
    return SNodeOperations.isInstanceOf(theType, CONCEPTS.StringType$uX);
  }

  public static boolean isPrimIntString(SNode theType) {
    return SNodeOperations.isInstanceOf(theType, CONCEPTS.IntegerType$7a) || SNodeOperations.isInstanceOf(theType, CONCEPTS.StringType$uX);
  }

  public static boolean isPrimIntStringList(SNode theType) {
    if (SNodeOperations.isInstanceOf(theType, CONCEPTS.ListType$LR)) {
      SNode elemType = SLinkOperations.getTarget(SNodeOperations.cast(theType, CONCEPTS.ListType$LR), LINKS.elementType$ssn);
      if (SNodeOperations.isInstanceOf(elemType, CONCEPTS.IntegerType$7a) || SNodeOperations.isInstanceOf(elemType, CONCEPTS.StringType$uX)) {
        return true;
      }
    }
    return false;
  }
  public static boolean isPrimStringList(SNode theType) {
    if (SNodeOperations.isInstanceOf(theType, CONCEPTS.ListType$LR)) {
      SNode elemType = SLinkOperations.getTarget(SNodeOperations.cast(theType, CONCEPTS.ListType$LR), LINKS.elementType$ssn);
      if (SNodeOperations.isInstanceOf(elemType, CONCEPTS.StringType$uX)) {
        return true;
      }
    }
    return false;
  }
  public static boolean isPrimIntList(SNode theType) {
    if (SNodeOperations.isInstanceOf(theType, CONCEPTS.ListType$LR)) {
      SNode elemType = SLinkOperations.getTarget(SNodeOperations.cast(theType, CONCEPTS.ListType$LR), LINKS.elementType$ssn);
      if (SNodeOperations.isInstanceOf(elemType, CONCEPTS.IntegerType$7a)) {
        return true;
      }
    }
    return false;
  }
  public static boolean isDtoEntity(SNode theType) {
    return OFXLegacyHelper.isDTO(theType) || OFXLegacyHelper.isEntity(theType);
  }
  public static boolean isDtoEntityList(SNode theType) {
    if (SNodeOperations.isInstanceOf(theType, CONCEPTS.ListType$LR)) {
      SNode elemType = SLinkOperations.getTarget(SNodeOperations.cast(theType, CONCEPTS.ListType$LR), LINKS.elementType$ssn);
      if (isDtoEntity(elemType)) {
        return true;
      }
    }
    return false;
  }

  public static boolean needPartialSerdes(SNode given) {
    SNode type = given;

    if (SNodeOperations.isInstanceOf(given, CONCEPTS.ListType$LR)) {
      type = SLinkOperations.getTarget(SNodeOperations.cast(given, CONCEPTS.ListType$LR), LINKS.elementType$ssn);
    }

    return OFXLegacyHelper.isEntity(type) || OFXLegacyHelper.isDTO(type) || OFXLegacyHelper.isValueObject(type);
  }
  public static boolean listOfMwPrim(SNode lt) {

    if (!(SNodeOperations.isInstanceOf(lt, CONCEPTS.ListType$LR))) {
      return false;
    }

    SNode type = SLinkOperations.getTarget(SNodeOperations.cast(lt, CONCEPTS.ListType$LR), LINKS.elementType$ssn);
    return OFXLegacyHelper.isMwPrimitive(type);
  }
  public static boolean listOfMwPrimStatus(SNode lt) {

    if (!(SNodeOperations.isInstanceOf(lt, CONCEPTS.ListType$LR))) {
      return false;
    }
    SNode type = SLinkOperations.getTarget(SNodeOperations.cast(lt, CONCEPTS.ListType$LR), LINKS.elementType$ssn);
    return OFXLegacyHelper.isStatus(type);
  }

  public static boolean standardMwSerializeable(SNode given) {
    SNode type = given;

    if (SNodeOperations.isInstanceOf(given, CONCEPTS.ListType$LR)) {
      type = SLinkOperations.getTarget(SNodeOperations.cast(given, CONCEPTS.ListType$LR), LINKS.elementType$ssn);
    }

    return OFXLegacyHelper.isEntity(type) || OFXLegacyHelper.isDTO(type) || OFXLegacyHelper.isValueObject(type) || OFXLegacyHelper.isMwPrimitive(type);
  }





  private static boolean same(SNode t1, SNode t2) {

    if (SNodeOperations.isInstanceOf(t1, CONCEPTS.ClassifierType$bL)) {
      if (SNodeOperations.isInstanceOf(t2, CONCEPTS.ClassifierType$bL)) {
        return SLinkOperations.getTarget(SNodeOperations.cast(t1, CONCEPTS.ClassifierType$bL), LINKS.classifier$cxMr) == SLinkOperations.getTarget(SNodeOperations.cast(t2, CONCEPTS.ClassifierType$bL), LINKS.classifier$cxMr);
      } else {
        return false;
      }

    } else if (SNodeOperations.isInstanceOf(t1, CONCEPTS.ListType$LR)) {
      if (SNodeOperations.isInstanceOf(t2, CONCEPTS.ListType$LR)) {
        return same(SLinkOperations.getTarget(SNodeOperations.cast(t1, CONCEPTS.ListType$LR), LINKS.elementType$ssn), SLinkOperations.getTarget(SNodeOperations.cast(t2, CONCEPTS.ListType$LR), LINKS.elementType$ssn));
      } else {
        return false;
      }

    } else if (SNodeOperations.isInstanceOf(t1, CONCEPTS.ArrayType$rh)) {
      if (SNodeOperations.isInstanceOf(t2, CONCEPTS.ArrayType$rh)) {
        return same(SLinkOperations.getTarget(SNodeOperations.cast(t1, CONCEPTS.ArrayType$rh), LINKS.componentType$F$Gi), SLinkOperations.getTarget(SNodeOperations.cast(t2, CONCEPTS.ArrayType$rh), LINKS.componentType$F$Gi));
      } else {
        return false;
      }

    } else {
      throw new RuntimeException("This can not happen. Unknown type " + SNodeOperations.present(t1));
    }

  }


  public static List<SNode> specialDistinct(List<SNode> orig) {
    final List<SNode> dist = ListSequence.fromList(new ArrayList<SNode>());

    ListSequence.fromList(orig).visitAll((final SNode looking) -> {
      SNode existing = ListSequence.fromList(dist).findFirst((present) -> same(looking, present));

      if ((existing == null)) {
        ListSequence.fromList(dist).addElement(looking);
      }
    });

    return dist;
  }
  public static SNode convertListToArrayTypeExceptPrimMwSerializable(SNode it) {
    if (DataUxApiHelper.listOfMwPrim(it)) {
      return SLinkOperations.getTarget(SNodeOperations.cast(it, CONCEPTS.ListType$LR), LINKS.elementType$ssn);

    } else if (SNodeOperations.isInstanceOf(it, CONCEPTS.ListType$LR)) {
      SNode at = SConceptOperations.createNewNode(MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf940d819f7L, "jetbrains.mps.baseLanguage.structure.ArrayType"));
      SLinkOperations.setTarget(at, LINKS.componentType$F$Gi, SNodeOperations.copyNode(SLinkOperations.getTarget(SNodeOperations.cast(it, CONCEPTS.ListType$LR), LINKS.elementType$ssn)));
      return at;
    }

    return it;
  }
  public static List<SNode> convertForMwSerdes(List<SNode> orig) {
    final List<SNode> converted = ListSequence.fromList(new ArrayList<SNode>());

    ListSequence.fromList(orig).visitAll((it) -> ListSequence.fromList(converted).addElement(convertListToArrayTypeExceptPrimMwSerializable(it)));

    return converted;
  }





  public static SNode convertToGlobalVarDecl(SNode lvds) {

    SNode var = SConceptOperations.createNewNode(MetaAdapterFactory.getConcept(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x69695f96cfbe995cL, "org.modellwerkstatt.dataux.structure.ApiGlobalVarDeclarationStatement"));
    SLinkOperations.setTarget(var, LINKS.apiVar$8ESW, SConceptOperations.createNewNode(MetaAdapterFactory.getConcept(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x3ac3be340dd4d730L, "org.modellwerkstatt.dataux.structure.ApiVariable")));
    SLinkOperations.setTarget(SLinkOperations.getTarget(var, LINKS.apiVar$8ESW), LINKS.type$a1UY, SLinkOperations.getTarget(SLinkOperations.getTarget(lvds, LINKS.localVariableDeclaration$RpjM), LINKS.type$a1UY));
    SPropertyOperations.assign(SLinkOperations.getTarget(var, LINKS.apiVar$8ESW), PROPS.name$MnvL, SPropertyOperations.getString(SLinkOperations.getTarget(lvds, LINKS.localVariableDeclaration$RpjM), PROPS.name$MnvL));
    if (SLinkOperations.getTarget(SLinkOperations.getTarget(lvds, LINKS.localVariableDeclaration$RpjM), LINKS.initializer$2twD) != null) {
      SLinkOperations.setTarget(SLinkOperations.getTarget(var, LINKS.apiVar$8ESW), LINKS.initializer$2twD, SLinkOperations.getTarget(SLinkOperations.getTarget(lvds, LINKS.localVariableDeclaration$RpjM), LINKS.initializer$2twD));
    }
    SNodeOperations.replaceWithAnother(lvds, var);
    return var;
  }
  public static boolean invalidLvds(SNode lvds) {
    return SNodeOperations.isInstanceOf(SNodeOperations.getParent(SNodeOperations.getParent(lvds)), CONCEPTS.ApiImplContainer$hk);
  }
  public static int posInApiContImplStatementList(SNode someNode) {
    SNode parent = SNodeOperations.getParent(someNode);
    SNode parentOfParent = SNodeOperations.getParent(parent);

    while ((parentOfParent != null) && !(SNodeOperations.isInstanceOf(parentOfParent, CONCEPTS.ApiImplContainer$hk))) {
      someNode = parent;
      parent = parentOfParent;
      parentOfParent = SNodeOperations.getParent(parent);
    }

    if (SNodeOperations.isInstanceOf(parentOfParent, CONCEPTS.ApiImplContainer$hk) && SNodeOperations.isInstanceOf(parent, CONCEPTS.StatementList$m_)) {
      return SNodeOperations.getIndexInParent(someNode);
    }

    return 0;
  }

  private static SNode _quotation_createNode_o6j90t_a0a0a1() {
    SNode quotedNode_1 = null;
    SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept(MetaAdapterFactory.getLanguage(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, "jetbrains.mps.baseLanguage"), 0x101de48bf9eL, "ClassifierType"));
    quotedNode_1 = nb.getResult();
    nb.setReference(MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101de48bf9eL, 0x101de490babL, "classifier"), "6354ebe7-c22a-4a0f-ac54-50b52ab9b065/java:java.lang(JDK/)/~Integer");
    return quotedNode_1;
  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept IntegerType$7a = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf940d22479L, "jetbrains.mps.baseLanguage.structure.IntegerType");
    /*package*/ static final SConcept ListType$LR = MetaAdapterFactory.getConcept(0x8388864671ce4f1cL, 0x9c53c54016f6ad4fL, 0x10c25fb076aL, "jetbrains.mps.baseLanguage.collections.structure.ListType");
    /*package*/ static final SConcept StringType$uX = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x11d47da71ecL, "jetbrains.mps.baseLanguage.structure.StringType");
    /*package*/ static final SConcept ClassifierType$bL = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101de48bf9eL, "jetbrains.mps.baseLanguage.structure.ClassifierType");
    /*package*/ static final SConcept ArrayType$rh = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf940d819f7L, "jetbrains.mps.baseLanguage.structure.ArrayType");
    /*package*/ static final SConcept ApiImplContainer$hk = MetaAdapterFactory.getConcept(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x3ac3be340dd4dfbfL, "org.modellwerkstatt.dataux.structure.ApiImplContainer");
    /*package*/ static final SConcept StatementList$m_ = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc56b200L, "jetbrains.mps.baseLanguage.structure.StatementList");
  }

  private static final class LINKS {
    /*package*/ static final SContainmentLink elementType$ssn = MetaAdapterFactory.getContainmentLink(0x8388864671ce4f1cL, 0x9c53c54016f6ad4fL, 0x10c25fb076aL, 0x10c25fe95c5L, "elementType");
    /*package*/ static final SReferenceLink classifier$cxMr = MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101de48bf9eL, 0x101de490babL, "classifier");
    /*package*/ static final SContainmentLink componentType$F$Gi = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf940d819f7L, 0xf940d819f8L, "componentType");
    /*package*/ static final SContainmentLink apiVar$8ESW = MetaAdapterFactory.getContainmentLink(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x69695f96cfbe995cL, 0x69695f96cfbe9a85L, "apiVar");
    /*package*/ static final SContainmentLink type$a1UY = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x450368d90ce15bc3L, 0x4ed4d318133c80ceL, "type");
    /*package*/ static final SContainmentLink localVariableDeclaration$RpjM = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc67c7f0L, 0xf8cc67c7f1L, "localVariableDeclaration");
    /*package*/ static final SContainmentLink initializer$2twD = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8c37a7f6eL, 0xf8c37f506eL, "initializer");
  }

  private static final class PROPS {
    /*package*/ static final SProperty name$MnvL = MetaAdapterFactory.getProperty(0xceab519525ea4f22L, 0x9b92103b95ca8c0cL, 0x110396eaaa4L, 0x110396ec041L, "name");
  }
}
