package org.modellwerkstatt.dataux.plugin;

/*Generated by MPS */

import jetbrains.mps.workbench.action.BaseAction;
import javax.swing.Icon;
import jetbrains.mps.workbench.action.ActionAccess;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.Map;
import java.awt.Frame;
import jetbrains.mps.ide.actions.MPSCommonDataKeys;
import jetbrains.mps.project.MPSProject;
import org.jetbrains.mps.openapi.model.SNode;
import org.jetbrains.annotations.NotNull;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import javax.swing.JOptionPane;
import java.util.List;
import org.jetbrains.mps.openapi.model.SModel;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SConceptOperations;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import org.jetbrains.mps.openapi.language.SConcept;
import org.jetbrains.mps.openapi.language.SInterfaceConcept;
import org.jetbrains.mps.openapi.language.SProperty;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.language.SReferenceLink;

public class ConvertEntityAndDTO_Action extends BaseAction {
  private static final Icon ICON = null;

  public ConvertEntityAndDTO_Action() {
    super("Werkbank - Convert Entities / DTO", "Entity2DTO and DTO2Entity", ICON);
    this.setIsAlwaysVisible(true);
    this.setActionAccess(ActionAccess.UNDO_PROJECT);
    updateInBackground(true);
  }
  @Override
  public boolean isDumbAware() {
    return true;
  }
  @Override
  protected boolean collectActionData(AnActionEvent event, final Map<String, Object> _params) {
    if (!(super.collectActionData(event, _params))) {
      return false;
    }
    {
      Frame p = event.getData(MPSCommonDataKeys.FRAME);
      if (p == null) {
        return false;
      }
    }
    {
      MPSProject p = event.getData(MPSCommonDataKeys.MPS_PROJECT);
      if (p == null) {
        return false;
      }
    }
    {
      SNode p = event.getData(MPSCommonDataKeys.NODE);
    }
    return true;
  }
  @Override
  public void doExecute(@NotNull final AnActionEvent event, final Map<String, Object> _params) {
    SNode selectedNode = event.getData(MPSCommonDataKeys.NODE);

    if (selectedNode == null || !(SNodeOperations.isInstanceOf(selectedNode, CONCEPTS.Entity$WP) || SNodeOperations.isInstanceOf(selectedNode, CONCEPTS.DTO$UE))) {
      JOptionPane.showMessageDialog(event.getData(MPSCommonDataKeys.FRAME), "Selected an Entity or a DTO which should be converted.", "Wrong selection in project explorer", JOptionPane.ERROR_MESSAGE);
      return;
    }

    List<SModel> models = ListSequence.fromList(new ArrayList<SModel>());
    for (SModel mod : event.getData(MPSCommonDataKeys.MPS_PROJECT).getProjectModels()) {
      ListSequence.fromList(models).addElement(mod);
    }


    if (SNodeOperations.isInstanceOf(selectedNode, CONCEPTS.Entity$WP)) {
      SNode bo = SNodeOperations.cast(selectedNode, CONCEPTS.Entity$WP);
      SNode newVo = SConceptOperations.createNewNode(MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x488302ba36b9283fL, "org.modellwerkstatt.objectflow.structure.DTO"));

      SPropertyOperations.assign(newVo, PROPS.name$MnvL, SPropertyOperations.getString(bo, PROPS.name$MnvL));
      ListSequence.fromList(SLinkOperations.getChildren(newVo, LINKS.member$L_2d)).addSequence(ListSequence.fromList(SLinkOperations.getChildren(bo, LINKS.member$L_2d)));
      SLinkOperations.setTarget(newVo, LINKS.documentation2$_ebi, SLinkOperations.getTarget(bo, LINKS.documentation2$V0ZS));
      ListSequence.fromList(SLinkOperations.getChildren(newVo, LINKS.businessProperties$cI4J)).addSequence(ListSequence.fromList(SLinkOperations.getChildren(bo, LINKS.businessProperties$cI4J)));
      ListSequence.fromList(SLinkOperations.getChildren(newVo, LINKS.status$agas)).addSequence(ListSequence.fromList(SLinkOperations.getChildren(bo, LINKS.status$iHEp)));

      ConvertEntityAndDTO_Action.this.replaceClassifierType(models, bo, newVo, event);
      ConvertEntityAndDTO_Action.this.replaceSelectedObjects(models, bo, newVo, event);
      ConvertEntityAndDTO_Action.this.replaceIBindable(models, bo, newVo, event);
      ConvertEntityAndDTO_Action.this.replacePageBind(models, bo, newVo, event);

      SNodeOperations.replaceWithAnother(bo, newVo);

    } else {
      SNode vo = SNodeOperations.cast(selectedNode, CONCEPTS.DTO$UE);
      SNode newBo = SConceptOperations.createNewNode(MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x130a62a9d793b6e4L, "org.modellwerkstatt.objectflow.structure.Entity"));

      SPropertyOperations.assign(newBo, PROPS.name$MnvL, SPropertyOperations.getString(vo, PROPS.name$MnvL));
      ListSequence.fromList(SLinkOperations.getChildren(newBo, LINKS.member$L_2d)).addSequence(ListSequence.fromList(SLinkOperations.getChildren(vo, LINKS.member$L_2d)));
      SLinkOperations.setTarget(newBo, LINKS.documentation2$V0ZS, SLinkOperations.getTarget(vo, LINKS.documentation2$_ebi));
      ListSequence.fromList(SLinkOperations.getChildren(newBo, LINKS.businessProperties$cI4J)).addSequence(ListSequence.fromList(SLinkOperations.getChildren(vo, LINKS.businessProperties$cI4J)));
      ListSequence.fromList(SLinkOperations.getChildren(newBo, LINKS.status$iHEp)).addSequence(ListSequence.fromList(SLinkOperations.getChildren(vo, LINKS.status$agas)));

      ConvertEntityAndDTO_Action.this.replaceClassifierType(models, vo, newBo, event);
      ConvertEntityAndDTO_Action.this.replaceSelectedObjects(models, vo, newBo, event);
      ConvertEntityAndDTO_Action.this.replaceIBindable(models, vo, newBo, event);
      ConvertEntityAndDTO_Action.this.replacePageBind(models, vo, newBo, event);

      SNodeOperations.replaceWithAnother(vo, newBo);
    }




    // search vor classifierTypes ...




  }
  private void replaceClassifierType(List<SModel> models, final SNode lookingFor, final SNode toReplace, final AnActionEvent event) {
    ListSequence.fromList(models).visitAll((mod) -> {

      ListSequence.fromList(SModelOperations.nodes(mod, CONCEPTS.ClassifierType$bL)).where((it) -> SLinkOperations.getTarget(it, LINKS.classifier$cxMr) == lookingFor).visitAll((it) -> SLinkOperations.setTarget(it, LINKS.classifier$cxMr, toReplace));

    });

  }
  private void replaceSelectedObjects(List<SModel> models, final SNode lookingFor, final SNode toReplace, final AnActionEvent event) {
    ListSequence.fromList(models).visitAll((mod) -> {

      ListSequence.fromList(SModelOperations.nodes(mod, CONCEPTS.SelectedObject$U2)).where((it) -> SLinkOperations.getTarget(it, LINKS.object$8cOt) == lookingFor).visitAll((it) -> SLinkOperations.setTarget(it, LINKS.object$8cOt, toReplace));

      ListSequence.fromList(SModelOperations.nodes(mod, CONCEPTS.SelectedList$pC)).where((it) -> SLinkOperations.getTarget(it, LINKS.object$9HfT) == lookingFor).visitAll((it) -> SLinkOperations.setTarget(it, LINKS.object$9HfT, toReplace));

    });

  }
  private void replaceIBindable(List<SModel> models, final SNode lookingFor, final SNode toReplace, final AnActionEvent event) {
    ListSequence.fromList(models).visitAll((mod) -> {

      ListSequence.fromList(SModelOperations.nodes(mod, CONCEPTS.IBindable$dn)).where((it) -> SLinkOperations.getTarget(it, LINKS.boundClassifier$bk2Q) == lookingFor).visitAll((it) -> SLinkOperations.setTarget(it, LINKS.boundClassifier$bk2Q, toReplace));

    });

  }
  private void replacePageBind(List<SModel> models, final SNode lookingFor, final SNode toReplace, final AnActionEvent event) {
    ListSequence.fromList(models).visitAll((mod) -> {

      ListSequence.fromList(SModelOperations.nodes(mod, CONCEPTS.PageCrtl$lE)).where((it) -> SLinkOperations.getTarget(it, LINKS.boundObject$7AiE) == lookingFor).visitAll((it) -> SLinkOperations.setTarget(it, LINKS.boundObject$7AiE, toReplace));

    });

  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept Entity$WP = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x130a62a9d793b6e4L, "org.modellwerkstatt.objectflow.structure.Entity");
    /*package*/ static final SConcept DTO$UE = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x488302ba36b9283fL, "org.modellwerkstatt.objectflow.structure.DTO");
    /*package*/ static final SConcept ClassifierType$bL = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101de48bf9eL, "jetbrains.mps.baseLanguage.structure.ClassifierType");
    /*package*/ static final SConcept SelectedObject$U2 = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x7037ca72de981e40L, "org.modellwerkstatt.objectflow.structure.SelectedObject");
    /*package*/ static final SConcept SelectedList$pC = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x7037ca72de9833c1L, "org.modellwerkstatt.objectflow.structure.SelectedList");
    /*package*/ static final SInterfaceConcept IBindable$dn = MetaAdapterFactory.getInterfaceConcept(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x4a11e39c3940e086L, "org.modellwerkstatt.dataux.structure.IBindable");
    /*package*/ static final SConcept PageCrtl$lE = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x63cf441cbd8ed5c6L, "org.modellwerkstatt.objectflow.structure.PageCrtl");
  }

  private static final class PROPS {
    /*package*/ static final SProperty name$MnvL = MetaAdapterFactory.getProperty(0xceab519525ea4f22L, 0x9b92103b95ca8c0cL, 0x110396eaaa4L, 0x110396ec041L, "name");
  }

  private static final class LINKS {
    /*package*/ static final SContainmentLink member$L_2d = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101d9d3ca30L, 0x4a9a46de59132803L, "member");
    /*package*/ static final SContainmentLink documentation2$_ebi = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x488302ba36b9283fL, 0x5126d09e0b766383L, "documentation2");
    /*package*/ static final SContainmentLink documentation2$V0ZS = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x130a62a9d793b6e4L, 0x5126d09e0b764323L, "documentation2");
    /*package*/ static final SContainmentLink businessProperties$cI4J = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3bdce9a978275e87L, 0x2c8253fb15073741L, "businessProperties");
    /*package*/ static final SContainmentLink status$agas = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x488302ba36b9283fL, 0x308cecec2460bae7L, "status");
    /*package*/ static final SContainmentLink status$iHEp = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x130a62a9d793b6e4L, 0x3ee8b55a83963103L, "status");
    /*package*/ static final SReferenceLink classifier$cxMr = MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101de48bf9eL, 0x101de490babL, "classifier");
    /*package*/ static final SReferenceLink object$8cOt = MetaAdapterFactory.getReferenceLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x7037ca72de981e40L, 0x7037ca72de983ba9L, "object");
    /*package*/ static final SReferenceLink object$9HfT = MetaAdapterFactory.getReferenceLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x7037ca72de9833c1L, 0x7037ca72de9833c2L, "object");
    /*package*/ static final SReferenceLink boundClassifier$bk2Q = MetaAdapterFactory.getReferenceLink(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x4a11e39c3940e086L, 0x7a1c06eb0351873eL, "boundClassifier");
    /*package*/ static final SReferenceLink boundObject$7AiE = MetaAdapterFactory.getReferenceLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x63cf441cbd8ed5c6L, 0x39a05968e991a6eeL, "boundObject");
  }
}
