package org.modellwerkstatt.dataux.plugin;

/*Generated by MPS */

import jetbrains.mps.workbench.action.BaseAction;
import javax.swing.Icon;
import jetbrains.mps.workbench.action.ActionAccess;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.Map;
import jetbrains.mps.project.MPSProject;
import jetbrains.mps.ide.actions.MPSCommonDataKeys;
import java.awt.Frame;
import org.jetbrains.annotations.NotNull;
import java.io.StringWriter;
import java.util.List;
import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import org.jetbrains.mps.openapi.model.SModel;
import org.modellwerkstatt.objectflow.plugin.MoMdlAccess;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import org.modellwerkstatt.objectflow.runtime.CSVWriter;
import org.joda.time.LocalDate;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import org.jetbrains.mps.openapi.language.SAbstractConcept;
import jetbrains.mps.internal.collections.runtime.Sequence;
import org.modellwerkstatt.objectflow.behavior.Service__BehaviorDescriptor;
import org.modellwerkstatt.manmap.behavior.Repository__BehaviorDescriptor;
import jetbrains.mps.baseLanguage.behavior.Classifier__BehaviorDescriptor;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.lang.text.behavior.TextElement__BehaviorDescriptor;
import jetbrains.mps.lang.core.behavior.BaseConcept__BehaviorDescriptor;
import org.modellwerkstatt.objectflow.plugin.CopyPasteDialog;
import javax.swing.JOptionPane;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import jetbrains.mps.smodel.SModelInternal;
import org.jetbrains.mps.openapi.model.SModelReference;
import org.jetbrains.mps.openapi.language.SConcept;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SInterfaceConcept;
import org.jetbrains.mps.openapi.language.SProperty;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.language.SReferenceLink;

public class MoWareDDDAnalyzer_Action extends BaseAction {
  private static final Icon ICON = null;

  public MoWareDDDAnalyzer_Action() {
    super("Werkbank - Report of DDD analyzer", "Generate DDD report", ICON);
    this.setIsAlwaysVisible(true);
    this.setActionAccess(ActionAccess.UNDO_PROJECT);
    updateInBackground(true);
  }
  @Override
  public boolean isDumbAware() {
    return true;
  }
  @Override
  protected boolean collectActionData(AnActionEvent event, final Map<String, Object> _params) {
    if (!(super.collectActionData(event, _params))) {
      return false;
    }
    {
      MPSProject p = event.getData(MPSCommonDataKeys.MPS_PROJECT);
      if (p == null) {
        return false;
      }
    }
    {
      Frame p = event.getData(MPSCommonDataKeys.FRAME);
      if (p == null) {
        return false;
      }
    }
    return true;
  }
  @Override
  public void doExecute(@NotNull final AnActionEvent event, final Map<String, Object> _params) {
    boolean TESTS_ALSO = true;
    StringWriter myStringWriter = new StringWriter();

    List<SNode> allCommands = ListSequence.fromList(new ArrayList<SNode>());
    List<SNode> allRepos = ListSequence.fromList(new ArrayList<SNode>());
    List<SNode> allServices = ListSequence.fromList(new ArrayList<SNode>());
    final List<SNode> allCalls = ListSequence.fromList(new ArrayList<SNode>());
    List<SNode> allObjects = ListSequence.fromList(new ArrayList<SNode>());
    final List<SNode> allObjectMethodCalls = ListSequence.fromList(new ArrayList<SNode>());

    try {
      List<SModel> allRelevantModels = MoMdlAccess.relevantModels(event.getData(MPSCommonDataKeys.MPS_PROJECT), TESTS_ALSO);
      for (SModel mod : allRelevantModels) {
        ListSequence.fromList(allCommands).addSequence(ListSequence.fromList(SModelOperations.roots(mod, CONCEPTS.Command$nA)));
        ListSequence.fromList(allRepos).addSequence(ListSequence.fromList(SModelOperations.roots(mod, CONCEPTS.Repository$WM)));
        ListSequence.fromList(allServices).addSequence(ListSequence.fromList(SModelOperations.roots(mod, CONCEPTS.Service$HK)));
        ListSequence.fromList(allCalls).addSequence(ListSequence.fromList(SModelOperations.nodes(mod, CONCEPTS.OperationCall$7H)));
        ListSequence.fromList(allObjects).addSequence(ListSequence.fromList(SModelOperations.roots(mod, CONCEPTS.IOFXObject$Y7)));
        ListSequence.fromList(allObjectMethodCalls).addSequence(ListSequence.fromList(SModelOperations.nodes(mod, CONCEPTS.InstanceMethodCallOperation$uu)));
      }
      final CSVWriter csvWriter = new CSVWriter(myStringWriter);
      char SEP = CSVWriter.DEFAULT_SEPARATOR;





      // (1) Project summary - header information 
      csvWriter.line("MoWare Werkbank - DDD Analyzer" + SEP + "run @ " + new LocalDate());
      csvWriter.line("for project " + event.getData(MPSCommonDataKeys.MPS_PROJECT).getName());
      csvWriter.newLine();

      // TODO: Complexity in % Base: 
      csvWriter.line("Models in project " + event.getData(MPSCommonDataKeys.MPS_PROJECT).getName());
      String[] headers = {"Model", "Nodes", "Entities", "ValueObjects", "DTOs", "Commands", "UxRoots", "Services", "Repos", "Tests", "Apps", "Jobs", "Imports", "ImportedBy"};
      csvWriter.writeNext(headers);
      int[] totals = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
      for (SModel mod : allRelevantModels) {
        List<String> imports = MoWareDDDAnalyzer_Action.this.imports(allRelevantModels, mod, event);
        List<SModel> importedBy = MoWareDDDAnalyzer_Action.this.importedBy(allRelevantModels, mod, event);
        int[] data = {ListSequence.fromList(SModelOperations.nodes(mod, null)).count(), ListSequence.fromList(SModelOperations.roots(mod, CONCEPTS.Entity$WP)).count(), ListSequence.fromList(SModelOperations.roots(mod, CONCEPTS.ValueObject$bz)).count(), ListSequence.fromList(SModelOperations.roots(mod, CONCEPTS.DTO$UE)).count(), ListSequence.fromList(SModelOperations.roots(mod, CONCEPTS.Command$nA)).count(), ListSequence.fromList(SModelOperations.roots(mod, CONCEPTS.UxRoot$gH)).count(), ListSequence.fromList(SModelOperations.roots(mod, CONCEPTS.Service$HK)).count(), ListSequence.fromList(SModelOperations.roots(mod, CONCEPTS.Repository$WM)).count(), ListSequence.fromList(SModelOperations.nodes(mod, CONCEPTS.OFXTestMethod$cv)).count(), ListSequence.fromList(SModelOperations.roots(mod, CONCEPTS.AppUiModule$oo)).count(), ListSequence.fromList(SModelOperations.roots(mod, CONCEPTS.BatchJobModule$QP)).count(), ListSequence.fromList(imports).count(), ListSequence.fromList(importedBy).count()};

        String importsText = IterableUtils.join(ListSequence.fromList(imports).select((it) -> MoVersion.getCapitalizedShortNameFromFQ(it)), " ");
        String importedByText = IterableUtils.join(ListSequence.fromList(importedBy).select((it) -> MoVersion.getCapitalizedShortNameFromFQ(SModelOperations.getModelName(it))), " ");
        csvWriter.writeNext(MoWareDDDAnalyzer_Action.this.updateTotals(SModelOperations.getModelName(mod), data, totals, new String[]{importsText, importedByText}, event));
      }
      csvWriter.writeNext(MoWareDDDAnalyzer_Action.this.updateTotals("TOTAL", totals, totals, new String[]{}, event));
      csvWriter.newLine();
      csvWriter.newLine();


      csvWriter.line("Service & Repo Analysis");
      csvWriter.writeNext(new String[]{"", "model", "name", "nodes", "methods", "privat", "protected", "public", "cmds", "tests"});
      ListSequence.fromList(allServices).visitAll((service) -> {

        csvWriter.writeNext(new String[]{"srv", SModelOperations.getModelName(SNodeOperations.getModel(service)), SPropertyOperations.getString(service, PROPS.name$MnvL), "" + ListSequence.fromList(SNodeOperations.getNodeDescendants(service, null, false, new SAbstractConcept[]{})).count(), "" + Sequence.fromIterable(Service__BehaviorDescriptor.servicesMethods_id6RAFKVNrPUM.invoke(service)).count(), MoWareDDDAnalyzer_Action.this.tos(MoWareDDDAnalyzer_Action.this.privatUsageCmpt(allCalls, service, event), event), MoWareDDDAnalyzer_Action.this.tos(ListSequence.fromList(MoWareDDDAnalyzer_Action.this.protectedUsageCmpt(allCalls, service, event)).count(), event), MoWareDDDAnalyzer_Action.this.tos(ListSequence.fromList(MoWareDDDAnalyzer_Action.this.publicUsageCmpt(allCalls, service, event)).count(), event), MoWareDDDAnalyzer_Action.this.tos(ListSequence.fromList(MoWareDDDAnalyzer_Action.this.inCmdUsageCmpt(allCalls, service, event)).count(), event), MoWareDDDAnalyzer_Action.this.tos(ListSequence.fromList(MoWareDDDAnalyzer_Action.this.inTestUsageCmpt(allCalls, service, event)).count(), event)});

      });
      ListSequence.fromList(allRepos).visitAll((repo) -> {

        csvWriter.writeNext(new String[]{"repo", SModelOperations.getModelName(SNodeOperations.getModel(repo)), SPropertyOperations.getString(repo, PROPS.name$MnvL), "" + ListSequence.fromList(SNodeOperations.getNodeDescendants(repo, null, false, new SAbstractConcept[]{})).count(), "" + ListSequence.fromList(Repository__BehaviorDescriptor.repoMethods_id7CiiQbKHd38.invoke(repo)).count(), MoWareDDDAnalyzer_Action.this.tos(MoWareDDDAnalyzer_Action.this.privatUsageCmpt(allCalls, repo, event), event), MoWareDDDAnalyzer_Action.this.tos(ListSequence.fromList(MoWareDDDAnalyzer_Action.this.protectedUsageCmpt(allCalls, repo, event)).count(), event), MoWareDDDAnalyzer_Action.this.tos(ListSequence.fromList(MoWareDDDAnalyzer_Action.this.publicUsageCmpt(allCalls, repo, event)).count(), event), MoWareDDDAnalyzer_Action.this.tos(ListSequence.fromList(MoWareDDDAnalyzer_Action.this.inCmdUsageCmpt(allCalls, repo, event)).count(), event), MoWareDDDAnalyzer_Action.this.tos(ListSequence.fromList(MoWareDDDAnalyzer_Action.this.inTestUsageCmpt(allCalls, repo, event)).count(), event)});


      });

      csvWriter.newLine();
      csvWriter.newLine();


      csvWriter.line("Method Analysis");
      csvWriter.writeNext(new String[]{"", "model", "component", "name", "nodes", "privat", "protected", "public", "fan-out", "cmds", "tests"});


      ListSequence.fromList(allServices).visitAll((it) -> Sequence.fromIterable(Service__BehaviorDescriptor.servicesMethods_id6RAFKVNrPUM.invoke(it)).visitAll((method) -> {

        csvWriter.writeNext(new String[]{"srv", SModelOperations.getModelName(SNodeOperations.getModel(method)), "" + SNodeOperations.present(SNodeOperations.getContainingRoot(method)), MoWareDDDAnalyzer_Action.this.methodInfo(method, event), "" + ListSequence.fromList(SNodeOperations.getNodeDescendants(method, null, false, new SAbstractConcept[]{})).count(), MoWareDDDAnalyzer_Action.this.tos(MoWareDDDAnalyzer_Action.this.privatUsageMeth(allCalls, method, event), event), MoWareDDDAnalyzer_Action.this.tos(ListSequence.fromList(MoWareDDDAnalyzer_Action.this.protectedUsageMeth(allCalls, method, event)).count(), event), MoWareDDDAnalyzer_Action.this.tos(ListSequence.fromList(MoWareDDDAnalyzer_Action.this.publicUsageMeth(allCalls, method, event)).count(), event), MoWareDDDAnalyzer_Action.this.tos(MoWareDDDAnalyzer_Action.this.methodForeignOpCalls(method, event), event), MoWareDDDAnalyzer_Action.this.tos(ListSequence.fromList(MoWareDDDAnalyzer_Action.this.inCmdUsageMeth(allCalls, method, event)).count(), event), MoWareDDDAnalyzer_Action.this.tos(ListSequence.fromList(MoWareDDDAnalyzer_Action.this.inTestUsageMeth(allCalls, method, event)).count(), event)});
      }));

      ListSequence.fromList(allRepos).visitAll((it) -> ListSequence.fromList(Repository__BehaviorDescriptor.repoMethods_id7CiiQbKHd38.invoke(it)).visitAll((method) -> {

        csvWriter.writeNext(new String[]{"repo", SModelOperations.getModelName(SNodeOperations.getModel(method)), "" + SNodeOperations.present(SNodeOperations.getContainingRoot(method)), MoWareDDDAnalyzer_Action.this.methodInfo(method, event), "" + ListSequence.fromList(SNodeOperations.getNodeDescendants(method, null, false, new SAbstractConcept[]{})).count(), MoWareDDDAnalyzer_Action.this.tos(MoWareDDDAnalyzer_Action.this.privatUsageMeth(allCalls, method, event), event), MoWareDDDAnalyzer_Action.this.tos(ListSequence.fromList(MoWareDDDAnalyzer_Action.this.protectedUsageMeth(allCalls, method, event)).count(), event), MoWareDDDAnalyzer_Action.this.tos(ListSequence.fromList(MoWareDDDAnalyzer_Action.this.publicUsageMeth(allCalls, method, event)).count(), event), MoWareDDDAnalyzer_Action.this.tos(MoWareDDDAnalyzer_Action.this.methodForeignOpCalls(method, event), event), MoWareDDDAnalyzer_Action.this.tos(ListSequence.fromList(MoWareDDDAnalyzer_Action.this.inCmdUsageMeth(allCalls, method, event)).count(), event), MoWareDDDAnalyzer_Action.this.tos(ListSequence.fromList(MoWareDDDAnalyzer_Action.this.inTestUsageMeth(allCalls, method, event)).count(), event)});

      }));

      csvWriter.newLine();
      csvWriter.newLine();


      csvWriter.line("Object Analysis");
      csvWriter.writeNext(new String[]{"", "model", "component", "name", "nodes", "privat", "protected", "public", "cmds", "tests"});


      ListSequence.fromList(allObjects).visitAll((final SNode it) -> Sequence.fromIterable(Classifier__BehaviorDescriptor.methods_id4_LVZ3pBKCn.invoke(SNodeOperations.cast(it, CONCEPTS.ClassConcept$bK))).visitAll((method) -> {
        String type = "obj";
        if (SNodeOperations.isInstanceOf(it, CONCEPTS.Entity$WP)) {
          type = "entity";
        } else if (SNodeOperations.isInstanceOf(it, CONCEPTS.DTO$UE)) {
          type = "dto";
        } else if (SNodeOperations.isInstanceOf(it, CONCEPTS.ValueObject$bz)) {
          type = "vo";
        }

        csvWriter.writeNext(new String[]{type, SModelOperations.getModelName(SNodeOperations.getModel(method)), "" + SNodeOperations.present(SNodeOperations.getContainingRoot(method)), MoWareDDDAnalyzer_Action.this.methodInfo(method, event), "" + ListSequence.fromList(SNodeOperations.getNodeDescendants(method, null, false, new SAbstractConcept[]{})).count(), MoWareDDDAnalyzer_Action.this.tos(MoWareDDDAnalyzer_Action.this.privatUsageObjMeth(allObjectMethodCalls, method, event), event), MoWareDDDAnalyzer_Action.this.tos(ListSequence.fromList(MoWareDDDAnalyzer_Action.this.protectedUsageObjMeth(allObjectMethodCalls, method, event)).count(), event), MoWareDDDAnalyzer_Action.this.tos(ListSequence.fromList(MoWareDDDAnalyzer_Action.this.publicUsageObjMeth(allObjectMethodCalls, method, event)).count(), event), MoWareDDDAnalyzer_Action.this.tos(ListSequence.fromList(MoWareDDDAnalyzer_Action.this.inCmdUsageObjMeth(allObjectMethodCalls, method, event)).count(), event), MoWareDDDAnalyzer_Action.this.tos(ListSequence.fromList(MoWareDDDAnalyzer_Action.this.inTestUsageObjMeth(allObjectMethodCalls, method, event)).count(), event)});
      }));


      csvWriter.newLine();
      csvWriter.newLine();



      // TODO: Deprecated in die service/repo analysis
      csvWriter.line("ToDo & Deprecated summary of all models:");
      final Wrappers._int toDosTotal = new Wrappers._int(0);
      final Wrappers._int deprecatedTota = new Wrappers._int(0);

      for (final SModel mod : allRelevantModels) {
        ListSequence.fromList(SModelOperations.nodes(mod, CONCEPTS.Word$Dn)).where((it) -> isNotEmptyString(SPropertyOperations.getString(it, PROPS.value$zQr_)) && SPropertyOperations.getString(it, PROPS.value$zQr_).toLowerCase().contains("todo")).visitAll((it) -> {
          String fullComment = IterableUtils.join(ListSequence.fromList(SLinkOperations.getChildren(SNodeOperations.cast(SNodeOperations.getParent(it), CONCEPTS.Line$yC), LINKS.elements$_j45)).select(new _FunctionTypes._return_P1_E0<String, SNode>() {
            public String invoke(SNode it) {
              return (String) TextElement__BehaviorDescriptor.getTextualRepresentation_idfB3l81it7u.invoke(it);
            }
          }), " ");
          csvWriter.line("Todo", MoVersion.getCapitalizedShortNameFromFQ(SModelOperations.getModelName(mod)), "" + SNodeOperations.present(SNodeOperations.getContainingRoot(it)), fullComment);
          toDosTotal.value++;
        });
        ListSequence.fromList(SModelOperations.nodes(mod, CONCEPTS.AnnotationInstance$yl)).where((it) -> SPropertyOperations.getString(SLinkOperations.getTarget(it, LINKS.annotation$12Ek), PROPS.name$MnvL).equals("Deprecated")).visitAll((it) -> {

          csvWriter.line("Deprecated", MoVersion.getCapitalizedShortNameFromFQ(SModelOperations.getModelName(mod)), "" + SNodeOperations.present(SNodeOperations.getContainingRoot(it)), "Deprecated " + BaseConcept__BehaviorDescriptor.getPresentation_idhEwIMiw.invoke(SNodeOperations.getParent(it)));
          deprecatedTota.value++;
        });

      }
      csvWriter.line("Todos total", "" + toDosTotal.value, "Deprecated total", "" + deprecatedTota.value);
      csvWriter.newLine();
      csvWriter.newLine();



      try {
        CopyPasteDialog dialog = new CopyPasteDialog(event.getData(MPSCommonDataKeys.MPS_PROJECT), "Generated CSV report");
        dialog.myText.setText(myStringWriter.toString());
        dialog.showDialog();

      } finally {
        myStringWriter.close();
      }

    } catch (NullPointerException npe) {
      JOptionPane.showMessageDialog(event.getData(MPSCommonDataKeys.FRAME), "NPE \n" + OFXConsoleHelper.stackTrace2String(npe), "Problem while generating report ..", JOptionPane.ERROR_MESSAGE);

    } catch (Throwable t) {
      JOptionPane.showMessageDialog(event.getData(MPSCommonDataKeys.FRAME), t.getMessage(), "Problem while generating report . ", JOptionPane.ERROR_MESSAGE);
    }
  }
  private String tos(int val, final AnActionEvent event) {
    return (val > 0 ? "" + val : "");
  }
  private String[] updateTotals(String modelName, int[] data, int[] totals, String[] addOnContent, final AnActionEvent event) {
    String[] conv = new String[data.length + 1 + addOnContent.length];
    conv[0] = modelName;
    for (int i = 1; i <= data.length; i++) {
      int d = data[i - 1];
      conv[i] = MoWareDDDAnalyzer_Action.this.tos(d, event);
      totals[i - 1] += data[i - 1];
    }
    for (int i = data.length + 1; i < data.length + 1 + addOnContent.length; i++) {
      conv[i] = addOnContent[i - (data.length + 1)];
    }
    return conv;
  }
  private List<SModel> importedBy(List<SModel> allModels, SModel toInspect, final AnActionEvent event) {
    List<SModel> dependentModel = ListSequence.fromList(new ArrayList<SModel>());

    String lookingForFqName = SModelOperations.getModelName(toInspect);
    for (SModel a : allModels) {
      SModelInternal aInternal = ((SModelInternal) a);

      for (SModelReference ref : aInternal.getModelImports()) {
        if (ref.getModelName().equals(lookingForFqName)) {
          ListSequence.fromList(dependentModel).addElement(a);
        }
      }
    }
    return dependentModel;
  }
  private List<String> imports(List<SModel> allModels, SModel toInspect, final AnActionEvent event) {
    List<String> imported = ListSequence.fromList(new ArrayList<String>());
    List<String> relevant = ListSequence.fromList(allModels).select((it) -> SModelOperations.getModelName(it)).toList();

    SModelInternal iInternal = ((SModelInternal) toInspect);

    for (SModelReference ref : iInternal.getModelImports()) {
      if (ListSequence.fromList(relevant).contains(ref.getModelName())) {
        ListSequence.fromList(imported).addElement(ref.getModelName());
      }
    }
    return imported;
  }
  private int privatUsageCmpt(List<SNode> allCalls, final SNode cmpt, final AnActionEvent event) {
    int opCalls = ListSequence.fromList(allCalls).where((it) -> SLinkOperations.getTarget(it, LINKS.runtimeHandledObject$2jLr) == cmpt && SNodeOperations.getContainingRoot(it) == cmpt).count();
    opCalls += ListSequence.fromList(SNodeOperations.getNodeDescendants(cmpt, CONCEPTS.LocalMethodCall$zT, false, new SAbstractConcept[]{})).count();
    return opCalls;
  }
  private List<SNode> protectedUsageCmpt(List<SNode> allCalls, final SNode cmpt, final AnActionEvent event) {
    return ListSequence.fromList(allCalls).where((it) -> SLinkOperations.getTarget(it, LINKS.runtimeHandledObject$2jLr) == cmpt && (SNodeOperations.getModel(it) == SNodeOperations.getModel(cmpt) && SNodeOperations.getContainingRoot(it) != cmpt)).toList();
  }
  private List<SNode> publicUsageCmpt(List<SNode> allCalls, final SNode cmpt, final AnActionEvent event) {
    return ListSequence.fromList(allCalls).where((it) -> SLinkOperations.getTarget(it, LINKS.runtimeHandledObject$2jLr) == cmpt && SNodeOperations.getModel(it) != SNodeOperations.getModel(cmpt) && !(SNodeOperations.isInstanceOf(SNodeOperations.getContainingRoot(it), CONCEPTS.OFXTestSuit$Iy))).toList();
  }
  private List<SNode> inTestUsageCmpt(List<SNode> allCalls, final SNode cmpt, final AnActionEvent event) {
    return ListSequence.fromList(allCalls).where((it) -> SLinkOperations.getTarget(it, LINKS.runtimeHandledObject$2jLr) == cmpt && SNodeOperations.getModel(it) != SNodeOperations.getModel(cmpt) && SNodeOperations.isInstanceOf(SNodeOperations.getContainingRoot(it), CONCEPTS.OFXTestSuit$Iy)).toList();
  }
  private List<SNode> inCmdUsageCmpt(List<SNode> allCalls, final SNode cmpt, final AnActionEvent event) {
    return ListSequence.fromList(allCalls).where((it) -> SLinkOperations.getTarget(it, LINKS.runtimeHandledObject$2jLr) == cmpt && SNodeOperations.isInstanceOf(SNodeOperations.getContainingRoot(it), CONCEPTS.Command$nA)).toList();
  }
  private int privatUsageMeth(List<SNode> allCalls, final SNode m, final AnActionEvent event) {
    int opCalls = ListSequence.fromList(allCalls).where((it) -> SLinkOperations.getTarget(it, LINKS.baseMethodDeclaration$pyYw) == m && SNodeOperations.getContainingRoot(it) == SNodeOperations.getContainingRoot(m)).count();
    opCalls += ListSequence.fromList(SNodeOperations.getNodeDescendants(SNodeOperations.getContainingRoot(m), CONCEPTS.LocalMethodCall$zT, false, new SAbstractConcept[]{})).where((it) -> SLinkOperations.getTarget(it, LINKS.baseMethodDeclaration$pyYw) == m).count();
    return opCalls;
  }
  private List<SNode> protectedUsageMeth(List<SNode> allCalls, final SNode m, final AnActionEvent event) {
    return ListSequence.fromList(allCalls).where((it) -> SLinkOperations.getTarget(it, LINKS.baseMethodDeclaration$pyYw) == m && (SNodeOperations.getModel(it) == SNodeOperations.getModel(m) && SNodeOperations.getContainingRoot(it) != SNodeOperations.getContainingRoot(m))).toList();
  }
  private List<SNode> publicUsageMeth(List<SNode> allCalls, final SNode m, final AnActionEvent event) {
    return ListSequence.fromList(allCalls).where((it) -> SLinkOperations.getTarget(it, LINKS.baseMethodDeclaration$pyYw) == m && SNodeOperations.getModel(it) != SNodeOperations.getModel(m) && !(SNodeOperations.isInstanceOf(SNodeOperations.getContainingRoot(it), CONCEPTS.OFXTestSuit$Iy))).toList();
  }
  private List<SNode> inTestUsageMeth(List<SNode> allCalls, final SNode m, final AnActionEvent event) {
    return ListSequence.fromList(allCalls).where((it) -> SLinkOperations.getTarget(it, LINKS.baseMethodDeclaration$pyYw) == m && SNodeOperations.getModel(it) != SNodeOperations.getModel(m) && SNodeOperations.isInstanceOf(SNodeOperations.getContainingRoot(it), CONCEPTS.OFXTestSuit$Iy)).toList();
  }
  private List<SNode> inCmdUsageMeth(List<SNode> allCalls, final SNode m, final AnActionEvent event) {
    return ListSequence.fromList(allCalls).where((it) -> SLinkOperations.getTarget(it, LINKS.baseMethodDeclaration$pyYw) == m && SNodeOperations.isInstanceOf(SNodeOperations.getContainingRoot(it), CONCEPTS.Command$nA)).toList();
  }
  private String methodInfo(SNode imd, final AnActionEvent event) {
    String st = "" + BaseConcept__BehaviorDescriptor.getPresentation_idhEwIMiw.invoke(SLinkOperations.getTarget(imd, LINKS.returnType$5xoi)) + " " + SPropertyOperations.getString(imd, PROPS.name$MnvL) + " (";
    st += IterableUtils.join(ListSequence.fromList(SLinkOperations.getChildren(imd, LINKS.parameter$5xBj)).select((it) -> (String) BaseConcept__BehaviorDescriptor.getPresentation_idhEwIMiw.invoke(SLinkOperations.getTarget(it, LINKS.type$a1UY))), ", ");
    return st + ")";
  }
  private int methodForeignOpCalls(final SNode imd, final AnActionEvent event) {
    return ListSequence.fromList(SNodeOperations.getNodeDescendants(imd, CONCEPTS.OperationCall$7H, false, new SAbstractConcept[]{})).where((it) -> SLinkOperations.getTarget(it, LINKS.runtimeHandledObject$2jLr) != SNodeOperations.getContainingRoot(imd)).count();
  }
  private int privatUsageObjMeth(List<SNode> allCalls, final SNode m, final AnActionEvent event) {
    int opCalls = ListSequence.fromList(allCalls).where((it) -> SLinkOperations.getTarget(it, LINKS.baseMethodDeclaration$pyYw) == m && SNodeOperations.getContainingRoot(it) == SNodeOperations.getContainingRoot(m)).count();
    opCalls += ListSequence.fromList(SNodeOperations.getNodeDescendants(SNodeOperations.getContainingRoot(m), CONCEPTS.LocalMethodCall$zT, false, new SAbstractConcept[]{})).where((it) -> SLinkOperations.getTarget(it, LINKS.baseMethodDeclaration$pyYw) == m).count();
    return opCalls;
  }
  private List<SNode> protectedUsageObjMeth(List<SNode> allCalls, final SNode m, final AnActionEvent event) {
    return ListSequence.fromList(allCalls).where((it) -> SLinkOperations.getTarget(it, LINKS.baseMethodDeclaration$pyYw) == m && (SNodeOperations.getModel(it) == SNodeOperations.getModel(m) && SNodeOperations.getContainingRoot(it) != SNodeOperations.getContainingRoot(m))).toList();
  }
  private List<SNode> publicUsageObjMeth(List<SNode> allCalls, final SNode m, final AnActionEvent event) {
    return ListSequence.fromList(allCalls).where((it) -> SLinkOperations.getTarget(it, LINKS.baseMethodDeclaration$pyYw) == m && SNodeOperations.getModel(it) != SNodeOperations.getModel(m) && !(SNodeOperations.isInstanceOf(SNodeOperations.getContainingRoot(it), CONCEPTS.OFXTestSuit$Iy))).toList();
  }
  private List<SNode> inTestUsageObjMeth(List<SNode> allCalls, final SNode m, final AnActionEvent event) {
    return ListSequence.fromList(allCalls).where((it) -> SLinkOperations.getTarget(it, LINKS.baseMethodDeclaration$pyYw) == m && SNodeOperations.getModel(it) != SNodeOperations.getModel(m) && SNodeOperations.isInstanceOf(SNodeOperations.getContainingRoot(it), CONCEPTS.OFXTestSuit$Iy)).toList();
  }
  private List<SNode> inCmdUsageObjMeth(List<SNode> allCalls, final SNode m, final AnActionEvent event) {
    return ListSequence.fromList(allCalls).where((it) -> SLinkOperations.getTarget(it, LINKS.baseMethodDeclaration$pyYw) == m && SNodeOperations.isInstanceOf(SNodeOperations.getContainingRoot(it), CONCEPTS.Command$nA)).toList();
  }
  private static boolean isNotEmptyString(String str) {
    return str != null && str.length() > 0;
  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept Command$nA = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x63cf441cbd8ed5caL, "org.modellwerkstatt.objectflow.structure.Command");
    /*package*/ static final SConcept Repository$WM = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x3d5d71b314aa1113L, "org.modellwerkstatt.manmap.structure.Repository");
    /*package*/ static final SConcept Service$HK = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3eafb777941be31fL, "org.modellwerkstatt.objectflow.structure.Service");
    /*package*/ static final SConcept OperationCall$7H = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x6e0022916f60f59bL, "org.modellwerkstatt.objectflow.structure.OperationCall");
    /*package*/ static final SInterfaceConcept IOFXObject$Y7 = MetaAdapterFactory.getInterfaceConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3bdce9a978275e87L, "org.modellwerkstatt.objectflow.structure.IOFXObject");
    /*package*/ static final SConcept InstanceMethodCallOperation$uu = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x118154a6332L, "jetbrains.mps.baseLanguage.structure.InstanceMethodCallOperation");
    /*package*/ static final SConcept Entity$WP = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x130a62a9d793b6e4L, "org.modellwerkstatt.objectflow.structure.Entity");
    /*package*/ static final SConcept ValueObject$bz = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x6f25d9824ef9bfaaL, "org.modellwerkstatt.objectflow.structure.ValueObject");
    /*package*/ static final SConcept DTO$UE = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x488302ba36b9283fL, "org.modellwerkstatt.objectflow.structure.DTO");
    /*package*/ static final SConcept UxRoot$gH = MetaAdapterFactory.getConcept(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x7a1c06eb034fe8f5L, "org.modellwerkstatt.dataux.structure.UxRoot");
    /*package*/ static final SConcept OFXTestMethod$cv = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x607becf482ad5e9fL, "org.modellwerkstatt.objectflow.structure.OFXTestMethod");
    /*package*/ static final SConcept AppUiModule$oo = MetaAdapterFactory.getConcept(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x6c070f1ddeebc0d4L, "org.modellwerkstatt.dataux.structure.AppUiModule");
    /*package*/ static final SConcept BatchJobModule$QP = MetaAdapterFactory.getConcept(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x2cc73adc8a2ca8e9L, "org.modellwerkstatt.dataux.structure.BatchJobModule");
    /*package*/ static final SConcept ClassConcept$bK = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8c108ca66L, "jetbrains.mps.baseLanguage.structure.ClassConcept");
    /*package*/ static final SConcept Word$Dn = MetaAdapterFactory.getConcept(0xc7fb639fbe784307L, 0x89b0b5959c3fa8c8L, 0x229012ddae35f04L, "jetbrains.mps.lang.text.structure.Word");
    /*package*/ static final SConcept Line$yC = MetaAdapterFactory.getConcept(0xc7fb639fbe784307L, 0x89b0b5959c3fa8c8L, 0x2331694e561af166L, "jetbrains.mps.lang.text.structure.Line");
    /*package*/ static final SConcept AnnotationInstance$yl = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x114a6b4ccabL, "jetbrains.mps.baseLanguage.structure.AnnotationInstance");
    /*package*/ static final SConcept LocalMethodCall$zT = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x6c6b6a1e379f9404L, "jetbrains.mps.baseLanguage.structure.LocalMethodCall");
    /*package*/ static final SConcept OFXTestSuit$Iy = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x128a6a0cae5ec4baL, "org.modellwerkstatt.objectflow.structure.OFXTestSuit");
  }

  private static final class PROPS {
    /*package*/ static final SProperty name$MnvL = MetaAdapterFactory.getProperty(0xceab519525ea4f22L, 0x9b92103b95ca8c0cL, 0x110396eaaa4L, 0x110396ec041L, "name");
    /*package*/ static final SProperty value$zQr_ = MetaAdapterFactory.getProperty(0xc7fb639fbe784307L, 0x89b0b5959c3fa8c8L, 0x229012ddae35f04L, 0x229012ddae35f05L, "value");
  }

  private static final class LINKS {
    /*package*/ static final SContainmentLink elements$_j45 = MetaAdapterFactory.getContainmentLink(0xc7fb639fbe784307L, 0x89b0b5959c3fa8c8L, 0x2331694e561af166L, 0x2331694e561af167L, "elements");
    /*package*/ static final SReferenceLink annotation$12Ek = MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x114a6b4ccabL, 0x114a6b85d40L, "annotation");
    /*package*/ static final SReferenceLink runtimeHandledObject$2jLr = MetaAdapterFactory.getReferenceLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x6e0022916f60f59bL, 0x6e0022916f60f5b4L, "runtimeHandledObject");
    /*package*/ static final SReferenceLink baseMethodDeclaration$pyYw = MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x11857355952L, 0xf8c78301adL, "baseMethodDeclaration");
    /*package*/ static final SContainmentLink returnType$5xoi = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc56b1fcL, 0xf8cc56b1fdL, "returnType");
    /*package*/ static final SContainmentLink parameter$5xBj = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc56b1fcL, 0xf8cc56b1feL, "parameter");
    /*package*/ static final SContainmentLink type$a1UY = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x450368d90ce15bc3L, 0x4ed4d318133c80ceL, "type");
  }
}
