package org.modellwerkstatt.dataux.plugin;

/*Generated by MPS */

import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.jetbrains.mps.openapi.model.SModel;
import java.util.ArrayList;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import org.jetbrains.mps.openapi.language.SAbstractConcept;
import org.modellwerkstatt.objectflow.behavior.IOFXObject__BehaviorDescriptor;
import org.jetbrains.mps.openapi.language.SConcept;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SInterfaceConcept;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.language.SReferenceLink;
import org.jetbrains.mps.openapi.language.SProperty;

public class TransHelper {

  public static void attachToList(List<TransKeyVal> orig, List<TransKeyVal> newList) {
    for (final TransKeyVal newKeyVal : newList) {
      TransKeyVal found = ListSequence.fromList(orig).findFirst((it) -> it.key.equals(newKeyVal.key));
      if (found == null) {
        ListSequence.fromList(orig).addElement(newKeyVal);
      } else {
        for (int i = 0; i < ListSequence.fromList(newKeyVal.trans).count(); i++) {
          if (i >= ListSequence.fromList(found.trans).count()) {
            ListSequence.fromList(found.trans).addElement(ListSequence.fromList(newKeyVal.trans).getElement(i));

          } else if (!(ListSequence.fromList(found.trans).getElement(i).equals(ListSequence.fromList(newKeyVal.trans).getElement(i)))) {
            String err = "Translations for same key do not match:\n\n";
            err += "Existing '" + found.key + "'  trans_" + i + " = " + ListSequence.fromList(found.trans).getElement(i) + " @ " + found.info + "\n";
            err += "New      '" + newKeyVal.key + "'  trans_" + i + " = " + ListSequence.fromList(newKeyVal.trans).getElement(i) + " @ " + newKeyVal.info + "\n";

            throw new RuntimeException(err);
          }
        }
        // check if we have to add translations

      }
    }
  }


  public static List<TransKeyVal> fromStati(SModel m) {
    final List<TransKeyVal> trans = ListSequence.fromList(new ArrayList<TransKeyVal>());

    ListSequence.fromList(SModelOperations.nodes(m, CONCEPTS.StatusDeclaration$of)).visitAll((final SNode it) -> {
      // single statusdecl
      ListSequence.fromList(SLinkOperations.getChildren(it, LINKS.element$GLWK)).visitAll((elem) -> {
        ListSequence.fromList(trans).addElement(TransKeyVal.fromSL(SLinkOperations.getTarget(elem, LINKS.shortDescNew$mKyp), SPropertyOperations.getString(it, PROPS.name$MnvL) + "." + SPropertyOperations.getString(elem, PROPS.name$MnvL) + " short desc"));
        ListSequence.fromList(trans).addElement(TransKeyVal.fromSL(SLinkOperations.getTarget(elem, LINKS.longDescNew$pIm2), SPropertyOperations.getString(it, PROPS.name$MnvL) + "." + SPropertyOperations.getString(elem, PROPS.name$MnvL) + " long desc"));
      });
    });

    return trans;
  }

  public static void updateStati(SModel m, final List<TransKeyVal> translations) {

    ListSequence.fromList(SModelOperations.nodes(m, CONCEPTS.StatusDeclaration$of)).visitAll((it) -> {
      // single statusdecl
      ListSequence.fromList(SLinkOperations.getChildren(it, LINKS.element$GLWK)).visitAll((elem) -> {
        TransKeyVal shotSl = findByKey(translations, SPropertyOperations.getString(SLinkOperations.getTarget(elem, LINKS.shortDescNew$mKyp), PROPS.value$w7MM));
        TransKeyVal longSl = findByKey(translations, SPropertyOperations.getString(SLinkOperations.getTarget(elem, LINKS.longDescNew$pIm2), PROPS.value$w7MM));

        TransKeyVal.updateSLifTransNotNull(shotSl, SLinkOperations.getTarget(elem, LINKS.shortDescNew$mKyp));
        TransKeyVal.updateSLifTransNotNull(longSl, SLinkOperations.getTarget(elem, LINKS.longDescNew$pIm2));
      });
    });
  }

  public static List<TransKeyVal> fromMultiStrings(SModel m) {
    final List<TransKeyVal> trans = ListSequence.fromList(new ArrayList<TransKeyVal>());

    ListSequence.fromList(SModelOperations.nodes(m, CONCEPTS.MultiString$$y)).visitAll((it) -> ListSequence.fromList(trans).addElement(TransKeyVal.fromMS(it, "MultiString in " + SNodeOperations.present(SNodeOperations.getNodeAncestorWhereConceptInList(it, new SAbstractConcept[]{CONCEPTS.Service$HK, CONCEPTS.Repository$WM, CONCEPTS.Command$nA, CONCEPTS.AppUiModule$oo, CONCEPTS.BatchJobModule$QP, CONCEPTS.UxRoot$gH}, false, false)))));

    return trans;
  }
  public static void updateMultiStrings(SModel m, final List<TransKeyVal> translations) {

    ListSequence.fromList(SModelOperations.nodes(m, CONCEPTS.MultiString$$y)).visitAll((it) -> {
      TransKeyVal trans = findByKey(translations, SPropertyOperations.getString(SNodeOperations.cast(SLinkOperations.getTarget(it, LINKS.formatString$GGXJ), CONCEPTS.StringFormatString$sD), PROPS.formatStringValue$2TVh));
      TransKeyVal.updateMSifTransNotNull(trans, it);
    });

  }

  public static List<TransKeyVal> fromOldStringLiteralInFlagCommand(SModel m) {
    List<TransKeyVal> trans = ListSequence.fromList(new ArrayList<TransKeyVal>());
    // TODO: search for conditions
    return trans;
  }

  public static void updateOldStringLiteralInFlagCommand(SModel m, List<TransKeyVal> translations) {
    // TODO: update conditions

  }

  public static List<TransKeyVal> fromIOFXObjects(SModel m) {
    final List<TransKeyVal> trans = ListSequence.fromList(new ArrayList<TransKeyVal>());

    ListSequence.fromList(SModelOperations.roots(m, CONCEPTS.IOFXObject$Y7)).visitAll((final SNode it) -> ListSequence.fromList(IOFXObject__BehaviorDescriptor.getBusinessProperties_id2M2kZGncixH.invoke(it)).visitAll((bp) -> {
      if ((SLinkOperations.getTarget(bp, LINKS.shortDesc$YWpx) != null)) {
        ListSequence.fromList(trans).addElement(TransKeyVal.fromSL(SLinkOperations.getTarget(bp, LINKS.shortDesc$YWpx), "" + IOFXObject__BehaviorDescriptor.getName_id2vvVhmoLArJ.invoke(it) + "." + SPropertyOperations.getString(bp, PROPS.name$MnvL) + " short desc"));
      }
      if ((SLinkOperations.getTarget(bp, LINKS.longDesc$YXl_) != null)) {
        ListSequence.fromList(trans).addElement(TransKeyVal.fromSL(SLinkOperations.getTarget(bp, LINKS.longDesc$YXl_), "" + IOFXObject__BehaviorDescriptor.getName_id2vvVhmoLArJ.invoke(it) + "." + SPropertyOperations.getString(bp, PROPS.name$MnvL) + " long desc"));
      }

    }));

    return trans;
  }

  public static void updateIOFXObjects(SModel m, final List<TransKeyVal> translations) {

    ListSequence.fromList(SModelOperations.roots(m, CONCEPTS.IOFXObject$Y7)).visitAll((it) -> ListSequence.fromList(IOFXObject__BehaviorDescriptor.getBusinessProperties_id2M2kZGncixH.invoke(it)).visitAll((bp) -> {
      if ((SLinkOperations.getTarget(bp, LINKS.shortDesc$YWpx) != null)) {
        TransKeyVal trans = findByKey(translations, SPropertyOperations.getString(SLinkOperations.getTarget(bp, LINKS.shortDesc$YWpx), PROPS.value$w7MM));
        TransKeyVal.updateSLifTransNotNull(trans, SLinkOperations.getTarget(bp, LINKS.shortDesc$YWpx));
      }

      if ((SLinkOperations.getTarget(bp, LINKS.longDesc$YXl_) != null)) {
        TransKeyVal trans = findByKey(translations, SPropertyOperations.getString(SLinkOperations.getTarget(bp, LINKS.longDesc$YXl_), PROPS.value$w7MM));
        TransKeyVal.updateSLifTransNotNull(trans, SLinkOperations.getTarget(bp, LINKS.longDesc$YXl_));
      }

    }));

  }

  public static List<TransKeyVal> fromUiLabels(SModel m) {
    final List<TransKeyVal> trans = ListSequence.fromList(new ArrayList<TransKeyVal>());

    ListSequence.fromList(SModelOperations.roots(m, CONCEPTS.StaticRessources$xz)).visitAll((it) -> {
      ListSequence.fromList(SLinkOperations.getChildren(it, LINKS.labels$Nqfz)).visitAll((final SNode label) -> ListSequence.fromList(SLinkOperations.getChildren(label, LINKS.specification$5uuY)).visitAll((spec) -> {
        if ((SLinkOperations.getTarget(spec, LINKS.text$wcWD) != null) && SNodeOperations.isInstanceOf(SLinkOperations.getTarget(spec, LINKS.text$wcWD), CONCEPTS.StringLiteral$xu) && isNotEmptyString(SPropertyOperations.getString(SNodeOperations.cast(SLinkOperations.getTarget(spec, LINKS.text$wcWD), CONCEPTS.StringLiteral$xu), PROPS.value$w7MM))) {
          ListSequence.fromList(trans).addElement(TransKeyVal.fromSL(SNodeOperations.cast(SLinkOperations.getTarget(spec, LINKS.text$wcWD), CONCEPTS.StringLiteral$xu), "" + SPropertyOperations.getString(label, PROPS.name$MnvL) + " / " + SPropertyOperations.getString(SLinkOperations.getTarget(spec, LINKS.platform$7aC7), PROPS.name$MnvL) + " label"));
        }

      }));

    });

    return trans;
  }
  public static void updateUiLabels(SModel m, final List<TransKeyVal> translations) {

    ListSequence.fromList(SModelOperations.roots(m, CONCEPTS.StaticRessources$xz)).visitAll((it) -> {
      ListSequence.fromList(SLinkOperations.getChildren(it, LINKS.labels$Nqfz)).visitAll((label) -> ListSequence.fromList(SLinkOperations.getChildren(label, LINKS.specification$5uuY)).visitAll((spec) -> {
        if ((SLinkOperations.getTarget(spec, LINKS.text$wcWD) != null) && SNodeOperations.isInstanceOf(SLinkOperations.getTarget(spec, LINKS.text$wcWD), CONCEPTS.StringLiteral$xu) && isNotEmptyString(SPropertyOperations.getString(SNodeOperations.cast(SLinkOperations.getTarget(spec, LINKS.text$wcWD), CONCEPTS.StringLiteral$xu), PROPS.value$w7MM))) {
          TransKeyVal trans = findByKey(translations, SPropertyOperations.getString(SNodeOperations.cast(SLinkOperations.getTarget(spec, LINKS.text$wcWD), CONCEPTS.StringLiteral$xu), PROPS.value$w7MM));
          TransKeyVal.updateSLifTransNotNull(trans, SNodeOperations.cast(SLinkOperations.getTarget(spec, LINKS.text$wcWD), CONCEPTS.StringLiteral$xu));
        }

      }));

    });

  }


  public static List<TransKeyVal> fromDataUX(SModel m) {
    final List<TransKeyVal> trans = ListSequence.fromList(new ArrayList<TransKeyVal>());


    // NOPE- use multiStrings there!!

    ListSequence.fromList(SModelOperations.nodes(m, CONCEPTS.MenuSub$vn)).visitAll((it) -> {
      if ((SLinkOperations.getTarget(it, LINKS.label$ICew) != null)) {
        ListSequence.fromList(trans).addElement(TransKeyVal.fromSL(SLinkOperations.getTarget(it, LINKS.label$ICew), "MenuSub " + SPropertyOperations.getString(SLinkOperations.getTarget(it, LINKS.label$ICew), PROPS.value$w7MM)));
      }
    });

    ListSequence.fromList(SModelOperations.nodes(m, CONCEPTS.LabelFOption$IL)).where((it) -> SNodeOperations.isInstanceOf(SLinkOperations.getTarget(it, LINKS.expression$d2yO), CONCEPTS.StringLiteral$xu)).visitAll((it) -> ListSequence.fromList(trans).addElement(TransKeyVal.fromSL(SNodeOperations.cast(SLinkOperations.getTarget(it, LINKS.expression$d2yO), CONCEPTS.StringLiteral$xu), "LabelOption in Ux-Element")));
    ListSequence.fromList(SModelOperations.nodes(m, CONCEPTS.OverwriteLabelDOption$Gb)).where((it) -> SNodeOperations.isInstanceOf(SLinkOperations.getTarget(it, LINKS.expression$lxfO), CONCEPTS.StringLiteral$xu)).visitAll((it) -> ListSequence.fromList(trans).addElement(TransKeyVal.fromSL(SNodeOperations.cast(SLinkOperations.getTarget(it, LINKS.expression$lxfO), CONCEPTS.StringLiteral$xu), "Overwritten Label in Ux-Element")));

    return trans;
  }
  public static void updateDataUX(SModel m, final List<TransKeyVal> translations) {

    ListSequence.fromList(SModelOperations.nodes(m, CONCEPTS.MenuSub$vn)).where((it) -> (SLinkOperations.getTarget(it, LINKS.label$ICew) != null) && isNotEmptyString(SPropertyOperations.getString(SLinkOperations.getTarget(it, LINKS.label$ICew), PROPS.value$w7MM))).visitAll((it) -> {
      TransKeyVal trans = findByKey(translations, SPropertyOperations.getString(SLinkOperations.getTarget(it, LINKS.label$ICew), PROPS.value$w7MM));
      TransKeyVal.updateSLifTransNotNull(trans, SLinkOperations.getTarget(it, LINKS.label$ICew));
    });

    ListSequence.fromList(SModelOperations.nodes(m, CONCEPTS.LabelFOption$IL)).where((it) -> SNodeOperations.isInstanceOf(SLinkOperations.getTarget(it, LINKS.expression$d2yO), CONCEPTS.StringLiteral$xu)).visitAll((it) -> {
      TransKeyVal trans = findByKey(translations, SPropertyOperations.getString(SNodeOperations.cast(SLinkOperations.getTarget(it, LINKS.expression$d2yO), CONCEPTS.StringLiteral$xu), PROPS.value$w7MM));
      TransKeyVal.updateSLifTransNotNull(trans, SNodeOperations.cast(SLinkOperations.getTarget(it, LINKS.expression$d2yO), CONCEPTS.StringLiteral$xu));
    });

    ListSequence.fromList(SModelOperations.nodes(m, CONCEPTS.OverwriteLabelDOption$Gb)).where((it) -> SNodeOperations.isInstanceOf(SLinkOperations.getTarget(it, LINKS.expression$lxfO), CONCEPTS.StringLiteral$xu)).visitAll((it) -> {
      TransKeyVal trans = findByKey(translations, SPropertyOperations.getString(SNodeOperations.cast(SLinkOperations.getTarget(it, LINKS.expression$lxfO), CONCEPTS.StringLiteral$xu), PROPS.value$w7MM));
      TransKeyVal.updateSLifTransNotNull(trans, SNodeOperations.cast(SLinkOperations.getTarget(it, LINKS.expression$lxfO), CONCEPTS.StringLiteral$xu));
    });

  }

  public static TransKeyVal findByKey(List<TransKeyVal> all, final String key) {
    return ListSequence.fromList(all).findFirst((it) -> it.key.equals(key));
  }
  private static boolean isNotEmptyString(String str) {
    return str != null && str.length() > 0;
  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept StatusDeclaration$of = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3ee8b55a8395b855L, "org.modellwerkstatt.objectflow.structure.StatusDeclaration");
    /*package*/ static final SConcept MultiString$$y = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x31c16699f45ad44aL, "org.modellwerkstatt.objectflow.structure.MultiString");
    /*package*/ static final SConcept Service$HK = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3eafb777941be31fL, "org.modellwerkstatt.objectflow.structure.Service");
    /*package*/ static final SConcept Repository$WM = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x3d5d71b314aa1113L, "org.modellwerkstatt.manmap.structure.Repository");
    /*package*/ static final SConcept Command$nA = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x63cf441cbd8ed5caL, "org.modellwerkstatt.objectflow.structure.Command");
    /*package*/ static final SConcept AppUiModule$oo = MetaAdapterFactory.getConcept(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x6c070f1ddeebc0d4L, "org.modellwerkstatt.dataux.structure.AppUiModule");
    /*package*/ static final SConcept BatchJobModule$QP = MetaAdapterFactory.getConcept(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x2cc73adc8a2ca8e9L, "org.modellwerkstatt.dataux.structure.BatchJobModule");
    /*package*/ static final SConcept UxRoot$gH = MetaAdapterFactory.getConcept(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x7a1c06eb034fe8f5L, "org.modellwerkstatt.dataux.structure.UxRoot");
    /*package*/ static final SConcept StringFormatString$sD = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x45334e0957030122L, "org.modellwerkstatt.objectflow.structure.StringFormatString");
    /*package*/ static final SInterfaceConcept IOFXObject$Y7 = MetaAdapterFactory.getInterfaceConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3bdce9a978275e87L, "org.modellwerkstatt.objectflow.structure.IOFXObject");
    /*package*/ static final SConcept StaticRessources$xz = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x13fe307201aa671aL, "org.modellwerkstatt.objectflow.structure.StaticRessources");
    /*package*/ static final SConcept StringLiteral$xu = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf93d565d10L, "jetbrains.mps.baseLanguage.structure.StringLiteral");
    /*package*/ static final SConcept MenuSub$vn = MetaAdapterFactory.getConcept(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x184bbc1717997159L, "org.modellwerkstatt.dataux.structure.MenuSub");
    /*package*/ static final SConcept LabelFOption$IL = MetaAdapterFactory.getConcept(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x676081f3315a610L, "org.modellwerkstatt.dataux.structure.LabelFOption");
    /*package*/ static final SConcept OverwriteLabelDOption$Gb = MetaAdapterFactory.getConcept(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x676081f33220377L, "org.modellwerkstatt.dataux.structure.OverwriteLabelDOption");
  }

  private static final class LINKS {
    /*package*/ static final SContainmentLink element$GLWK = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3ee8b55a8395b855L, 0x3ee8b55a8395b858L, "element");
    /*package*/ static final SContainmentLink shortDescNew$mKyp = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3ee8b55a8395b856L, 0x59515864ae979be1L, "shortDescNew");
    /*package*/ static final SContainmentLink longDescNew$pIm2 = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3ee8b55a8395b856L, 0x59515864ae979c16L, "longDescNew");
    /*package*/ static final SContainmentLink formatString$GGXJ = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x31c16699f45ad44aL, 0x45334e095702ffecL, "formatString");
    /*package*/ static final SContainmentLink shortDesc$YWpx = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x7485cdb73f561ff9L, 0x50143a75f8d95900L, "shortDesc");
    /*package*/ static final SContainmentLink longDesc$YXl_ = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x7485cdb73f561ff9L, 0x50143a75f8d95904L, "longDesc");
    /*package*/ static final SContainmentLink labels$Nqfz = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x13fe307201aa671aL, 0x2ba9f3a1bf24ef0eL, "labels");
    /*package*/ static final SContainmentLink specification$5uuY = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x13fe307201aa6913L, 0x2ba9f3a1bf24f0f7L, "specification");
    /*package*/ static final SContainmentLink text$wcWD = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x2ba9f3a1bf24efe5L, 0x13fe307201aa6937L, "text");
    /*package*/ static final SReferenceLink platform$7aC7 = MetaAdapterFactory.getReferenceLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x2ba9f3a1bf24efe5L, 0x76b61b5bdebc7847L, "platform");
    /*package*/ static final SContainmentLink label$ICew = MetaAdapterFactory.getContainmentLink(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x184bbc1717997159L, 0x35f1d76ff620251bL, "label");
    /*package*/ static final SContainmentLink expression$d2yO = MetaAdapterFactory.getContainmentLink(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x676081f3315a610L, 0x676081f3315a613L, "expression");
    /*package*/ static final SContainmentLink expression$lxfO = MetaAdapterFactory.getContainmentLink(0x64adc67c5fcf45f5L, 0x82db6a6771963d93L, 0x676081f33220377L, 0x676081f3322037aL, "expression");
  }

  private static final class PROPS {
    /*package*/ static final SProperty name$MnvL = MetaAdapterFactory.getProperty(0xceab519525ea4f22L, 0x9b92103b95ca8c0cL, 0x110396eaaa4L, 0x110396ec041L, "name");
    /*package*/ static final SProperty value$w7MM = MetaAdapterFactory.getProperty(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf93d565d10L, 0xf93d565d11L, "value");
    /*package*/ static final SProperty formatStringValue$2TVh = MetaAdapterFactory.getProperty(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x45334e0957030122L, 0x45334e095703015dL, "formatStringValue");
  }
}
