package org.modellwerkstatt.objectflow.batchjob;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.runtime.TelemetricsLongAbsoluter;
import org.modellwerkstatt.objectflow.runtime.CoreReporterInfo;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;

public class ConsumerReporter extends JobReporter implements ConsumerReporterMBean {

  private TelemetricsLongAbsoluter processingTimes;
  private long startMillis;
  private long faults;
  private long cancels;
  private Object currentKey;
  private String lastAction;
  private String internalState;


  public ConsumerReporter(String pcPairName, int idOrProducer, JobProperties props) {
    super(pcPairName, idOrProducer, props);
    processingTimes = new TelemetricsLongAbsoluter();
    startMillis = 0;
    faults = 0;
    cancels = 0;
  }

  public String getconsumer1_InternalState() {
    return internalState;
  }
  public String getconsumer2_LastAction() {
    return lastAction;
  }
  public String getconsumer3_LastKeyReceived() {
    return "" + currentKey;
  }
  public long getconsumer4_AvgProcessingDuration() {
    return processingTimes.getAverage();
  }
  public long getconsumer5_MaxProcessingDuration() {
    return processingTimes.getMax();
  }
  public long getconsumer6_SuccessfullyProcessedKeys() {
    return processingTimes.getCount();
  }
  public long getconsumer7_FaultedProcessings() {
    return faults;
  }
  public long getconsumer8_CanceledProcessings() {
    return cancels;
  }
  public void setInternalStatus(String s) {
    internalState = s;
  }
  public void startProcessing(Object key) {
    if (startMillis != 0) {
      faults++;
      logFrmwrkError("Processing next item/key " + key + ", but last item/key " + currentKey + " was not concluded successfully, fault count increased to " + faults, null);
    }
    startMillis = System.currentTimeMillis();
    currentKey = key;
  }
  public void setLastAction(String action) {
    lastAction = action;
    logFrmwrkTrace("Last action was: " + action);
  }

  public void stopProcessing() {
    long diff = System.currentTimeMillis() - startMillis;
    processingTimes.addSample(diff);

    CoreReporterInfo info = createInfoObject(IOFXCoreReporter.Type.APP_MESSAGE, IOFXCoreReporter.LogPriority.DEBUG, "Consumer processed item/key " + currentKey);
    info.addParameter(CoreReporterInfo.DIFF, diff);
    info.addParameter(CoreReporterInfo.PARAM, "" + currentKey);

    coreReporter.report(info);
    jmxLog(false, "" + info.getPrio(), "Processed item/key " + currentKey, null);

    startMillis = 0;
    currentKey = null;
  }

  public void canceledProcessing(boolean silentLog, String cmdFqName, List<IOFXProblem> problems) {
    long diff = System.currentTimeMillis() - startMillis;

    for (IOFXProblem prblm : problems) {
      CoreReporterInfo info = createInfoObject((prblm.isWarningOnly() ? IOFXCoreReporter.Type.APP_MESSAGE : IOFXCoreReporter.Type.APP_PROBLEM), prblm.translatedLogPrio(), "Canceled processing of " + currentKey);
      info.setCmdFqName(cmdFqName);
      info.addParameter(CoreReporterInfo.DIFF, diff);
      info.addParameter(CoreReporterInfo.PARAM, prblm.getSimpleUserText());

      if (prblm.hasForwardedEx()) {
        info.setException(prblm.getForwardedEx());
      }

      CoreReporterInfo.takeOverParamsIfNotNull(info.getParameters(), prblm.getPropMapOrNull());

      coreReporter.report(info);
      jmxLog(false, "" + info.getPrio(), "[" + currentKey + " canceled] " + prblm, null);
    }

    cancels++;
    startMillis = 0;
    currentKey = null;
  }

}
