package org.modellwerkstatt.objectflow.batchjob;

/*Generated by MPS */


public class ConsumerThread<EntityOrKey> extends Thread {
  private Status status;
  private EntityOrKey processingKey;
  private OFXConsumerRunnable consRunable;
  private int id;


  public ConsumerThread(String jobShortName, String pcPairName, OFXConsumerRunnable r, int theId) {
    // Status accessed by producer, not by consumer!
    super(r, jobShortName + pcPairName + " Consumer " + theId);
    consRunable = r;
    id = theId;
  }

  public Status getStatus() {
    return status;
  }
  public void setStatus(Status stat) {
    status = stat;
  }
  public EntityOrKey getProcessingKey() {
    return processingKey;
  }
  public void setProcessingKey(EntityOrKey key) {
    processingKey = key;
  }
  public void receive(Message msg) {
    consRunable.receive(msg);
  }
  public OFXConsumerRunnable getConsumerRunnable() {
    return consRunable;
  }
  public int getConsumerId() {
    return id;
  }

  public enum Status {
    WAITING(),
    WORKING(),
    SHUTDOWN()
  }

  public void gcClean() {
    consRunable.gcClean();
    consRunable = null;
    processingKey = null;
  }

  @Override
  public String toString() {
    return this.getName() + " [" + status + " / '" + processingKey + "']";
  }

}
