package org.modellwerkstatt.objectflow.batchjob;

/*Generated by MPS */

import java.util.TimerTask;
import org.modellwerkstatt.objectflow.runtime.OFXLogger;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;

public class MsgFromTimer extends TimerTask {
  private OFXPCPairController controller;
  private IOFXTimerMasterController timerController;
  private Message message;
  private int issuedVersion;

  public MsgFromTimer(IOFXTimerMasterController timerCrtl, OFXPCPairController crtl, Message msg, int version) {
    timerController = timerCrtl;
    controller = crtl;
    message = msg;
    issuedVersion = version;
  }

  public void run() {
    int currentVersion = timerController.getCurrentTimerVersion();
    if (currentVersion != issuedVersion) {
      OFXLogger.log(MsgFromTimer.class, IOFXCoreReporter.LogPriority.ERROR, "Fallback: TimerMsg " + message + " for " + controller.getPCPairName() + "/" + controller.getPCPairID() + " ignored since versions do not match: issued " + issuedVersion + " to current " + currentVersion, null);

    } else {
      controller.receive(message);

    }
    timerController = null;
    controller = null;
    message = null;
  }
  public OFXPCPairController getCrtl() {
    return controller;
  }
  public Message getMessage() {
    return message;
  }

}
