package org.modellwerkstatt.objectflow.batchjob;

/*Generated by MPS */

import java.util.List;
import java.util.Timer;
import java.util.ArrayList;
import org.joda.time.DateTime;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import org.modellwerkstatt.objectflow.runtime.OFXLogger;

public class OFXCronMasterController implements IOFXTimerMasterController {
  private static final boolean LOG_DBG_LEVEL = true;
  private List<MultiCronJobDesc> multiCronJobDescriptions;
  private List<OFXPCPairController> pcPairController;

  private boolean dependentMode;
  private boolean singleRunMode;
  private volatile int timerVersion;

  private Timer timer;
  private RollatingLogger rolLog = new RollatingLogger(50);
  private JobProperties properties;


  public OFXCronMasterController() {
    multiCronJobDescriptions = new ArrayList<MultiCronJobDesc>();
    pcPairController = new ArrayList<OFXPCPairController>();
    dependentMode = false;
    singleRunMode = false;
    timerVersion = 0;
  }

  @Override
  public JobProperties getJobProperties() {
    return properties;
  }
  public void switchToNextCrtl(OFXPCPairController crtl, int minWaitingTimeMs) {
    ll(crtl, "switchToNextCrtl() was crtlId: " + crtl.getPCPairID() + " (wait min " + minWaitingTimeMs + " ms.)");

    int finishedId = crtl.getPCPairID();

    if (finishedId >= (pcPairController.size() - 1)) {
      if (singleRunMode) {
        info("Last pair executed " + crtl.getPCPairName() + " / " + crtl.getPCPairID() + ". Single run of job completed.", true);
        OFXPCPairController firstCrlt = pcPairController.get(0);
        firstCrlt.receive(new ShutdownMsg());

      } else {
        // Sched run for first controller again.
        DateTime nextRun = multiCronJobDescriptions.get(0).nextEarlyiestRunMS(minWaitingTimeMs);
        OFXPCPairController firstCrlt = pcPairController.get(0);

        SCHED_OR_NOW(firstCrlt, new RunProducerMsg(firstCrlt.getPCPairID(), RunProducerMsg.Source.MASTERCRTL), nextRun);

      }

    } else {
      info("Processed " + crtl.getPCPairName() + " / " + crtl.getPCPairID() + " switching to next producer/consumer pair.", true);

      // Next controller ..
      OFXPCPairController nextCrtl = pcPairController.get(finishedId + 1);
      Message m = new RunProducerMsg(nextCrtl.getPCPairID(), RunProducerMsg.Source.MASTERCRTL);

      if (minWaitingTimeMs > 0) {
        DateTime nextRun = multiCronJobDescriptions.get(0).nextEarlyiestRunMS(minWaitingTimeMs);
        SCHED_OR_NOW(nextCrtl, m, nextRun);
      } else {
        nextCrtl.receive(m);
      }
    }


  }
  public void runCompletedResched(OFXPCPairController crtl) {
    ll(crtl, "runCompletedResched() for crtlId: " + crtl.getPCPairID());

    int finishedId = crtl.getPCPairID();
    if (dependentMode) {
      // ProdRun for next crtl
      switchToNextCrtl(crtl, 0);

    } else {
      DateTime nextRun = multiCronJobDescriptions.get(finishedId).nextEarlyiestRunMS(0);
      SCHED_OR_NOW(crtl, new RunProducerMsg(finishedId, RunProducerMsg.Source.MASTERCRTL), nextRun);
    }
  }

  public SchedInfo runNotCompletedDueEXResched(OFXPCPairController crtl, int minWaitingTimeInMS, boolean prodRun, boolean inboxEmpty) {
    ll(crtl, "runNotCompletedDueEXResched() in crtlId: " + crtl.getPCPairID() + " (min wait  " + minWaitingTimeInMS + "ms, prodRun? " + prodRun + ", inboxEmpty? " + inboxEmpty + ")");
    info("runNotCompletedDueEXResched() for " + crtl.getPCPairName() + " / " + crtl.getPCPairID() + " in " + minWaitingTimeInMS + "ms.", false);

    if (dependentMode) {
      DateTime nextRun = multiCronJobDescriptions.get(0).nextEarlyiestRunMS(minWaitingTimeInMS);
      OFXPCPairController firstCrtl = pcPairController.get(0);

      return SCHED_OR_NOW(firstCrtl, new RunProducerMsg(firstCrtl.getPCPairID(), RunProducerMsg.Source.MASTERCRTL), nextRun);

    } else {
      int exPairCrtl = crtl.getPCPairID();
      boolean cronWindowMode = multiCronJobDescriptions.get(exPairCrtl).isCronWindowMode();
      DateTime nextRun = multiCronJobDescriptions.get(exPairCrtl).nextEarlyiestRunMS(minWaitingTimeInMS);

      Message msgToSend = new WakeupPairCrtlMsg(exPairCrtl);
      boolean emptyInboxAndNextCronDraw = !(cronWindowMode) && inboxEmpty && minWaitingTimeInMS <= 0;
      // ex in last consumer, no waiting time, do a prod run next possible time

      if (prodRun || emptyInboxAndNextCronDraw) {
        msgToSend = new RunProducerMsg(exPairCrtl, RunProducerMsg.Source.MASTERCRTL);
      }

      return SCHED_OR_NOW(crtl, msgToSend, nextRun);
    }
  }

  public SchedInfo runNotCompletedOutOfCronWindowResched(OFXPCPairController crtl, boolean prodRun) {
    ll(crtl, "runNotCompletedOutOfCronWindowResched() from crtlId: " + crtl.getPCPairID() + " prodRun? " + prodRun);

    if (dependentMode) {
      DateTime nextRun = multiCronJobDescriptions.get(0).nextEarlyiestRunMS(0);
      OFXPCPairController firstCrtl = pcPairController.get(0);
      return SCHED_OR_NOW(firstCrtl, new RunProducerMsg(firstCrtl.getPCPairID(), RunProducerMsg.Source.MASTERCRTL), nextRun);

    } else {
      int toRunCrtl = crtl.getPCPairID();
      DateTime nextRun = multiCronJobDescriptions.get(toRunCrtl).nextEarlyiestRunMS(0);
      Message msgToSend = new WakeupPairCrtlMsg(toRunCrtl);

      if (prodRun) {
        msgToSend = new RunProducerMsg(toRunCrtl, RunProducerMsg.Source.MASTERCRTL);
      }

      return SCHED_OR_NOW(crtl, msgToSend, nextRun);
    }
  }

  public boolean outOfCronWindow(OFXPCPairController crtl) {
    int qId = crtl.getPCPairID();

    if (dependentMode) {
      qId = 0;
    }
    return !(multiCronJobDescriptions.get(qId).canRunAccoordingToCronWindowInDelayMode(new DateTime()));
  }

  public boolean enableTimer(boolean enabled) {
    if (timer == null) {
      System.err.println("gcClean() on OFXCronMasterController already called. ");
      return false;
    }


    ll(null, "enableTimer( " + enabled + " ) called.");
    if (enabled == false) {
      timer.cancel();
      return enabled;

    } else {
      timer = new Timer(MoVersion.getShortNameFromFQ(properties.swJobFqName) + "_Tmr");
      //  but draw new cron leases!
      initialProducerRuns();
      return enabled;
    }
  }

  public void shuttingDown(OFXPCPairController crtl) {
    try {
      ll(crtl, "shuttingDown( " + crtl + ")");
      enableTimer(false);
      // intended or unintended. crtl might be null !!
      // producers can receive ShutdownMsg multiple times ..
      for (OFXPCPairController aCrtl : pcPairController) {
        if (aCrtl != crtl && aCrtl.needsShutdownMsg()) {
          aCrtl.receive(new ShutdownMsg());
        }

      }
    } catch (Throwable t) {
      // gracefully exec shutdown cmd ..
      t.printStackTrace();
    }
  }
  public int getCurrentTimerVersion() {
    return timerVersion;
  }
  public int clearJobTimerState() {
    timerVersion++;
    ll(null, "clear job timer state, version increased to " + timerVersion + ". exec initialProducerRuns().");
    initialProducerRuns();
    return timerVersion;
  }

  public void initialProducerRuns() {
    int cronJobsDescriptionsToHandle = pcPairController.size();

    if (dependentMode) {
      cronJobsDescriptionsToHandle = 1;
    }

    for (int i = 0; i < cronJobsDescriptionsToHandle; i++) {
      OFXPCPairController crtl = pcPairController.get(i);
      Message msg = new RunProducerMsg(crtl.getPCPairID(), RunProducerMsg.Source.MASTERCRTL);

      if (multiCronJobDescriptions.get(i).isCronWindowMode() && multiCronJobDescriptions.get(i).canRunAccoordingToCronWindowInDelayMode(new DateTime())) {
        SCHED_OR_NOW(crtl, msg, new DateTime());

      } else {
        DateTime nextRun = multiCronJobDescriptions.get(i).nextEarlyiestRunMS(0);
        SCHED_OR_NOW(crtl, msg, nextRun);
      }

    }

  }

  public void init(JobProperties props) {
    this.properties = props;
    timer = new Timer(MoVersion.getShortNameFromFQ(props.swJobFqName) + "_Tmr");
  }

  public void setDependentMode() {
    for (int i = 0; i < multiCronJobDescriptions.size(); i++) {
      multiCronJobDescriptions.get(i).checkForCronInDependentMode(i == 0);
    }
    dependentMode = true;
  }
  public void add(OFXPCPairController pcrtl) {
    int nextIndex = multiCronJobDescriptions.size();
    if (nextIndex != pcPairController.size()) {
      throw new IllegalStateException("Internal Error, descriptions and controller instances out of sync. desc: " + multiCronJobDescriptions.size() + " pcPairCrtl: " + pcPairController.size());
    }
    if (nextIndex != pcrtl.getPCPairID()) {
      throw new IllegalArgumentException("You can not add Crtl with ID " + pcrtl.getPCPairID() + " as nextIndex " + nextIndex);
    }

    multiCronJobDescriptions.add(new MultiCronJobDesc(pcrtl.getPCPairID(), pcrtl.getPCPairName()));
    pcPairController.add(pcrtl);
  }
  public void addCron(int id, String cr) {
    if (dependentMode) {
      throw new IllegalStateException("After setting dependent mode, no cron expressions can be added");
    }
    if (!(id < multiCronJobDescriptions.size())) {
      throw new IllegalArgumentException("Id is larger than curren registered pairControllers");
    }

    multiCronJobDescriptions.get(id).addCron(cr);
  }
  public void setDelayInMS(int id, int delayInMs) {
    if (dependentMode) {
      throw new IllegalStateException("After setting dependent mode, no delays can be set");
    }

    if (!(id < multiCronJobDescriptions.size())) {
      throw new IllegalArgumentException("Id is larger than curren registered pairControllers");
    }
    multiCronJobDescriptions.get(id).setDelayInMS(delayInMs);
  }

  public OFXPCPairController getPair(int id) {
    return pcPairController.get(id);
  }
  public SchedInfo SCHED_OR_NOW(OFXPCPairController crtl, Message msgToCrtl, DateTime dt) {
    SchedInfo info;
    MsgFromTimer msg = new MsgFromTimer(this, crtl, msgToCrtl, timerVersion);
    msg.getCrtl().addSchedEntry(dt);

    String target = msg.getCrtl().getPCPairID() + "_" + msg.getCrtl().getPCPairName();
    String msgDesc = msg.getMessage().getClass().getSimpleName();

    String logEntry = "sched entry for " + target + " => " + msg.getMessage() + "      @ " + OFXPCPairController.DATENTIME_FORMAT_EXACT.print(dt) + "  -  ";

    // before now?
    if (dt.isBefore(new DateTime().plusMillis(900))) {
      ll(crtl, logEntry + " running immediatelly.");
      msg.run();
      info = new SchedInfo(msgDesc + " for " + target + " (done imdtly)", new DateTime());

    } else {
      ll(crtl, logEntry + " added to timer.");
      try {
        timer.schedule(msg, dt.toDate());
        info = new SchedInfo(msgDesc + " for " + target, dt);

      } catch (IllegalStateException ise) {
        crtl.logJobProblem(false, "Job timer ex, but job not crashed. Check next timer for next run!", ise, ise.getMessage());
        info = new SchedInfo("Timer " + ise.getClass().getSimpleName() + " @ " + new DateTime() + " while sched for " + dt, dt);
      }
    }

    return info;
  }

  public void buildHtmlDashboardInfo(OFXBatchJobHtmlDashboard dashinfo) {

    dashinfo.addSection(properties.swJobFqName);
    dashinfo.addMonitoringInfo("information generated at ", "" + new DateTime());
    dashinfo.addMonitoringInfo("job fq name", properties.swJobFqName);
    dashinfo.addMonitoringInfo("job version", properties.swJobVersion);
    dashinfo.addMonitoringInfo("moware plugin version", properties.mowareVersion);
    dashinfo.addMonitoringInfo("username and id", properties.userName + "_" + properties.userId);
    dashinfo.addMonitoringInfo("datasource connection url ", properties.connectionInfo);
    dashinfo.addMonitoringInfo("&nbsp;", "&nbsp;");


    for (int i = 0; i < pcPairController.size(); i++) {
      OFXPCPairController crtl = pcPairController.get(i);
      dashinfo.addSection("Consumer/Producer Pair " + crtl.getPCPairID() + ": " + crtl.getPCPairName());
      dashinfo.addMonitoringInfo("Number of Consumers", "" + crtl.getNumberOfConsumers());
      dashinfo.addMonitoringInfo("Startuptime", crtl.getbatchjob_StartupTime());
      dashinfo.addMonitoringInfo("Cron sched settings", crtl.getbatchjob_PairSchedExpressions());

      dashinfo.addMonitoringInfo("Consumer processings ok", "" + crtl.getoverall1_ConsumerItemsOk());
      dashinfo.addMonitoringInfo("Consumer processings canceled", "" + crtl.getoverall2_ConsumerItemsCanceled());
      dashinfo.addMonitoringInfo("Consumer processings ex", "" + crtl.getoverall3_ConsumerItemsEx());

      dashinfo.addMonitoringInfo("Protocolled EX", "" + crtl.getxExceptions_protocolled());
      dashinfo.addMonitoringInfo("Unprotocolled EX", "" + crtl.getxExceptions_unprotocolled());
      dashinfo.addMonitoringInfo("Producer enabled", "" + crtl.getproducer6_ProducerEnabled());
      dashinfo.addMonitoringInfo("Next Sched", "" + crtl.getproducer7_NextScheduledRuns());
      dashinfo.addMonitoringInfo("Internal State", "" + crtl.getproducer1_InternalState());
      dashinfo.addMonitoringInfo("Last Fillup", "" + crtl.getinbox_LastFillup());

      dashinfo.addMonitoringInfo("Log", "<code>" + crtl.fullStatusReport().replace("\n", "<br/>") + " </code>");
    }

    dashinfo.addMonitoringInfo("&nbsp;", "&nbsp;");
    dashinfo.addSection(properties.swJobFqName);
    dashinfo.addMonitoringInfo("Timer Log (Tracing)", "<code> " + this.getFullStatusReport(null).replace("\n", "<br/>") + " </code>");
  }
  public void ensureJMXUnregistered() {
    for (int i = 0; i < pcPairController.size(); i++) {
      pcPairController.get(i).jmxUnregister();
    }
  }
  public String getSchedSetting(OFXPCPairController pair) {
    if (dependentMode && pair.getPCPairID() != 0) {
      return "(dependent)";
    }

    return multiCronJobDescriptions.get(pair.getPCPairID()).toString();
  }
  public String getFullStatusReport(OFXPCPairController crtl) {
    return rolLog.toString();
  }

  public void setSingleRunMode() {
    singleRunMode = true;
  }
  private void ll(OFXPCPairController crtl, String msg) {

    String logEntry = JobReporter.EXACT_TIME_ONLY_FORMATTER.print(new DateTime()) + ": " + msg;
    if (crtl != null) {
      crtl.logFrmwrkTrace("OFXCronMasterContoller() " + msg);
    }
    rolLog.add(logEntry);
  }

  private void info(String msg, boolean newSection) {
    String logEntry = JobReporter.EXACT_TIME_ONLY_FORMATTER.print(new DateTime()) + ": " + msg;

    if (newSection) {
      logEntry = "\n\n - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -\n" + logEntry;
    }

    if (singleRunMode) {
      OFXLogger.logConsole(logEntry);
    }
  }

  public void gcClean() {
    timer.cancel();
    timer = null;

    pcPairController.clear();
    pcPairController = null;
    multiCronJobDescriptions.clear();
    multiCronJobDescriptions = null;

  }

}
