package org.modellwerkstatt.objectflow.batchjob;

/*Generated by MPS */


public abstract class OFXExceptionStrategy {

  public enum StrategyProp {
    VM_SHUTDOWN(),
    VM_RESTART(),
    JOB_SHUTDOWN(),
    JOB_RESTART(),
    CONSUMER_RESTART(),
    READD_TO_INBOX(),
    DELAY_EXECUTION(),
    SILENT_NO_LOG(),
    CLEAR_INBOX()
  }

  public static class Strategy {
    private Integer waitDelayTimeInMs;
    private OFXExceptionStrategy.StrategyProp[] properties;

    public Strategy(Integer inMillis, OFXExceptionStrategy.StrategyProp... p) {
      waitDelayTimeInMs = inMillis;
      properties = p;
    }
    public int getDelayTimeInMsOrZero() {
      if (isDelayExecution()) {
        return waitDelayTimeInMs;
      }
      return 0;
    }
    public OFXExceptionStrategy.StrategyProp[] getPropertiesOfStrategy() {
      return properties;
    }
    public boolean isReaddToInbox() {
      for (OFXExceptionStrategy.StrategyProp prop : properties) {
        if (prop == OFXExceptionStrategy.StrategyProp.READD_TO_INBOX) {
          return true;
        }
      }
      return false;
    }
    public boolean isSilentNoLog() {
      for (OFXExceptionStrategy.StrategyProp prop : properties) {
        if (prop == OFXExceptionStrategy.StrategyProp.SILENT_NO_LOG) {
          return true;
        }
      }
      return false;
    }
    public boolean isConsumerRestart() {
      for (OFXExceptionStrategy.StrategyProp prop : properties) {
        if (prop == OFXExceptionStrategy.StrategyProp.CONSUMER_RESTART) {
          return true;
        }
      }
      return false;
    }
    public boolean isVMShutdown() {
      for (OFXExceptionStrategy.StrategyProp prop : properties) {
        if (prop == OFXExceptionStrategy.StrategyProp.VM_SHUTDOWN) {
          return true;
        }
      }
      return false;
    }
    public boolean isVMRestart() {
      for (OFXExceptionStrategy.StrategyProp prop : properties) {
        if (prop == OFXExceptionStrategy.StrategyProp.VM_RESTART) {
          return true;
        }
      }
      return false;
    }
    public boolean isJobShutdown() {
      for (OFXExceptionStrategy.StrategyProp prop : properties) {
        if (prop == OFXExceptionStrategy.StrategyProp.JOB_SHUTDOWN) {
          return true;
        }
      }
      return false;
    }
    public boolean isJobRestart() {
      for (OFXExceptionStrategy.StrategyProp prop : properties) {
        if (prop == OFXExceptionStrategy.StrategyProp.JOB_RESTART) {
          return true;
        }
      }
      return false;
    }
    public boolean isClearInbox() {
      for (OFXExceptionStrategy.StrategyProp prop : properties) {
        if (prop == OFXExceptionStrategy.StrategyProp.CLEAR_INBOX) {
          return true;
        }
      }
      return false;
    }
    public boolean isDelayExecution() {
      for (OFXExceptionStrategy.StrategyProp prop : properties) {
        if (prop == OFXExceptionStrategy.StrategyProp.DELAY_EXECUTION) {
          return true;
        }
      }
      return false;
    }

    @Override
    public String toString() {
      String s = "ExStrat: ";
      for (OFXExceptionStrategy.StrategyProp p : properties) {
        s += p + " ";
      }
      s += "wait=" + waitDelayTimeInMs;
      return s;
    }
  }

  public abstract Strategy strategyFor(Throwable t);
}
