package org.modellwerkstatt.objectflow.batchjob;

/*Generated by MPS */

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.Queue;
import org.modellwerkstatt.objectflow.runtime.IOFXUserServices;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.ArrayList;
import java.util.LinkedList;
import org.modellwerkstatt.objectflow.runtime.IPrintingServiceImpl;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.joda.time.DateTime;
import org.modellwerkstatt.objectflow.runtime.StaticJmxAccess;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import org.modellwerkstatt.manmap.runtime.MMShutdownRequestException;
import org.modellwerkstatt.objectflow.runtime.OFXJobWorkCanceledException;

public abstract class OFXPCPairController<Entity> extends PCPairReporter implements Runnable {
  public static final int PRODUCER_QUEUE_CAPACITY = 50;
  public static final int PRODUCER_EX_MIN_RERUNTIME_INMS = 300000;
  public static final int GRACEFULL_WAITING_TIME_SEC = 5;
  public static final boolean START_NEW_CONSUMER_ON_UNEXPECTED_SHTUDOWN = false;
  public static final String VERSION = "MoWare 11 PairCrtl 2021";

  private int thisPCPairID;
  private String thisPCPairName;

  private IOFXTimerMasterController timerContoller;
  private IOFXCommandImplProducer<Entity> producerCommandImplStatefull;

  private List<ConsumerThread<Entity>> allConsumers;
  private BlockingQueue<Message> messageQueue;
  private Queue<Entity> inbox;
  private List<Message> dbg_processedMsg;

  private volatile boolean shutdownWhenInboxEmptyAndConsumersParked;
  private volatile boolean shuttingDown;
  private volatile boolean jmxUnregisterDone;

  private boolean checkInboxForRescheduling;
  private boolean manuallyInboxFilled;
  private volatile boolean producerRunsEnabled;
  private int consumerWaitTimeDueToEXinMS;

  public IOFXUserServices __userServices;


  public boolean inboxEmtpy() {
    return inbox.size() == 0;
  }
  public boolean consumerExWaitReqeusted() {
    // 0 is resched, due to inbox clear...
    return consumerWaitTimeDueToEXinMS >= 0;
  }


  private OFXExceptionStrategy exceptionStrategy;
  private OFXExceptionStrategy.Strategy stratRespForShutdown;

  private OFXPCPairController(int id, String name, IOFXTimerMasterController masterController, OFXExceptionStrategy strat) {
    super(name, masterController.getJobProperties());

    timerContoller = masterController;
    messageQueue = new LinkedBlockingQueue<Message>(PRODUCER_QUEUE_CAPACITY);
    allConsumers = new ArrayList<ConsumerThread<Entity>>();

    // Changed implementation with Fanny 160000 issues to LinkedList, saving some time with
    // the many size operations. 
    inbox = new LinkedList<Entity>();

    shuttingDown = false;
    jmxUnregisterDone = false;
    shutdownWhenInboxEmptyAndConsumersParked = false;
    stratRespForShutdown = null;

    thisPCPairID = id;
    thisPCPairName = name;

    if (timerContoller.getJobProperties().envMode != MODE.TOMMY_MODE) {
      dbg_processedMsg = new ArrayList<Message>();
    }

    // created externally, in order to allow emergency clean-up
    exceptionStrategy = strat;
    __userServices = this;
  }

  public OFXPCPairController(int id, String name, IOFXTimerMasterController masterController, OFXExceptionStrategy strat, IPrintingServiceImpl print, IOFXCoreReporter reporter) {
    this(id, name, masterController, strat);
    initUserServices(print, reporter);
  }


  public void receive(Message message) {
    // can be called by consumers
    // can be called by external players
    messageQueue.add(message);
  }


  public String runProducerNow() {
    receive(new RunProducerMsg(thisPCPairID, RunProducerMsg.Source.MANUAL));
    return "Sent RunProducerMsg:Manual - clear inbox, reload @ " + asExactDateTimeFormatOrEmpty(new DateTime());
  }

  public String startJobTimer() {
    boolean currentState = timerContoller.enableTimer(true);
    return "Started timer for job, timer enabled now " + currentState;
  }

  public String stopJobTimer() {
    boolean currentState = timerContoller.enableTimer(false);
    return "Stopped timer for job, timer enabled now " + currentState;
  }

  public String clearJobTimerState() {
    int newversion = timerContoller.clearJobTimerState();
    return "Cleared timer state for whole job (timer version now " + newversion + ")";
  }

  public int getinbox_CurrentInboxSize() {
    return inbox.size();
  }

  public String getbatchjob_PairSchedExpressions() {
    if (timerContoller == null) {
      return "timerControlelr=null (gcClean() ?)";
    }
    return timerContoller.getSchedSetting(this);
  }
  public String fullStatusReportTimerController() {
    if (timerContoller == null) {
      return "timerControlelr=null (gcClean() ?)";
    }
    return timerContoller.getFullStatusReport(this);
  }

  public String toggleProducerEnabled() {
    receive(new ToggleEnbldProdMsg(thisPCPairID));
    return "Enabled was " + producerRunsEnabled + " but sent ToggleProducerEnabled message now.";
  }
  public String getbatchjob_PCPairNameAndID() {
    return "" + thisPCPairID + "_" + thisPCPairName;
  }

  public OFXExceptionStrategy.Strategy exStratFor(Throwable t) {
    // requested by consumers.
    return exceptionStrategy.strategyFor(t);
  }

  public abstract IOFXCommandImplConsumer<Entity>[] createNewConsumerImplementations();
  public abstract IOFXCommandImplProducer<Entity> createNewProducerImplementation();


  public void setupPairController(int numConsumers) {
    setupPairController(numConsumers, true);
  }

  public synchronized void setupPairController(int numConsumers, boolean consoleMode) {
    if (producerCommandImplStatefull != null) {
      throw new IllegalStateException("OFXPCPairController already initialized. setup already called.");
    }
    producerCommandImplStatefull = createNewProducerImplementation();

    if (!(consoleMode)) {
      consoleModeOff();
      StaticJmxAccess.register(this, assembleJMXPrefix(getbatchjob_PCPairNameAndID(), true, 0));
    }
    for (int i = 0; i < numConsumers; i++) {
      addAndStartConsumer();
    }

  }

  private int addAndStartConsumer() {
    // sender 0, no sender is -1
    int newId = allConsumers.size();

    OFXConsumerRunnable runnable = new OFXConsumerRunnable(thisPCPairName, newId, timerContoller.getJobProperties(), createNewConsumerImplementations());
    runnable.init(this, userPrintService, coreReporter);


    String shorJobName = MoVersion.getShortNameFromFQ(getbatchjob_Name());
    ConsumerThread<Entity> t = new ConsumerThread<Entity>(shorJobName, getbatchjob_PCPairNameAndID(), runnable, newId);
    t.setStatus(ConsumerThread.Status.WAITING);
    allConsumers.add(t);

    if (!(isConsoleMode())) {
      runnable.consoleModeOff();
      StaticJmxAccess.register(runnable, assembleJMXPrefix(getbatchjob_PCPairNameAndID(), false, newId));
    }

    t.start();
    logFrmwrkTrace("Started consumer with id " + newId);
    return newId;
  }


  public void run() {
    Message currentMessageProcessing;

    // main loop of consumer
    ConsumerThread<Entity> consumerSenderThread = null;
    logFrmwrkTrace("Starting into event loop (mode=" + timerContoller.getJobProperties().envMode + ")");

    Thread.currentThread().setName(MoVersion.getShortNameFromFQ(timerContoller.getJobProperties().swJobFqName) + "_" + thisPCPairName + " Producer");

    checkInboxForRescheduling = false;
    consumerWaitTimeDueToEXinMS = -1;
    manuallyInboxFilled = false;
    producerRunsEnabled = true;

    try {
      // ex strategy
      // process all messages when shutting down
      // really clever? yes, since msgs will check the shutdown flag
      while (!(shuttingDown && messageQueue.size() == 0)) {
        consumerSenderThread = null;

        setInternalState("Waiting for messages");
        long before = System.currentTimeMillis();
        currentMessageProcessing = messageQueue.take();
        if (dbg_processedMsg != null) {
          dbg_processedMsg.add(currentMessageProcessing);
        }
        addIdleSample(System.currentTimeMillis() - before);

        // some state checks
        // (1) is there any consumer available or are all on SHUTDOWN?
        // (2) timeout, pos msg on Timeout with EntityOrKey and ConsumerID to see, if that consumer is changing UoW
        // 
        if (currentMessageProcessing.getConsumerSenderId() >= 0) {
          consumerSenderThread = allConsumers.get(currentMessageProcessing.getConsumerSenderId());
        }
        if (currentMessageProcessing.getPCReceiverId() >= 0 && currentMessageProcessing.getPCReceiverId() != thisPCPairID) {
          throw new IllegalArgumentException("Received Message '" + currentMessageProcessing + "' at pcPare with ID " + thisPCPairID + "  - what is not correct ...");
        }


        logFrmwrkTrace("Processing Message " + currentMessageProcessing + " from " + consumerSenderThread);
        setInternalState("Processing Message " + currentMessageProcessing);

        if (currentMessageProcessing instanceof ShutdownMsg) {
          shuttingDown = true;
          // process the remaining messages now

        } else if (currentMessageProcessing instanceof ToggleEnbldProdMsg) {
          producerRunsEnabled = !(producerRunsEnabled);
          logFrmwrkTrace("ToggleEnbldProducer Message processed: Producer enabled now " + producerRunsEnabled);

        } else if (currentMessageProcessing instanceof ShutdownWhenInboxEmptyMsg) {
          shutdownWhenInboxEmptyAndConsumersParked = true;

        } else if (currentMessageProcessing instanceof RunProducerMsg) {
          if (shutdownWhenInboxEmptyAndConsumersParked || shuttingDown) {
            logFrmwrkError("Reqeust to run producer, but waiting for a shutdown. (IGNORING !!, shutdown=" + shuttingDown + " shtWhenInboxEmpty=" + shutdownWhenInboxEmptyAndConsumersParked, null);

          } else {
            // check inbox size, check window
            singleProducerRun(((RunProducerMsg) currentMessageProcessing).fromMan());

          }

        } else if (currentMessageProcessing instanceof WakeupPairCrtlMsg) {
          // since manuallyRun does not lead to Wakeups, we check inbox here ..
          if (manuallyInboxFilled) {
            logFrmwrkError("Received a WakeupPairCrtlMsg but inbox (" + inbox.size() + ") was filled by a manual run....", null);

          } else if (inboxEmtpy()) {
            logFrmwrkTrace("Received a WakeupPairCrtlMsg but inbox has size " + inbox.size() + ". Presumably ex on last consumer item.");

          }

          checkInboxForRescheduling = true;
          if (!(shuttingDown)) {
            wakeUpWaitingAndSendWork();
          }

        } else if (currentMessageProcessing instanceof ConsWorkDoneMsg || currentMessageProcessing instanceof ConsWorkCanceledMsg) {
          // consumer requests work, send over some work. last entity was commited
          consumerSenderThread.setStatus(ConsumerThread.Status.WAITING);
          consumerSenderThread.setProcessingKey(null);

          if (currentMessageProcessing instanceof ConsWorkCanceledMsg) {
            incConsumerCanceledProcessing();
            logFrmwrkTrace("Got ConsWorkCanceledMsg - " + ((ConsWorkCanceledMsg) currentMessageProcessing).getMessage());

          } else {
            incConsumerOkProcessings();
          }

          if (!(shuttingDown)) {
            checkInboxAndSendWork(consumerSenderThread);
          }

        } else if (currentMessageProcessing instanceof ConsumerFinallyDownMsg) {
          boolean wakeup = false;
          // finally, this consumer is down
          consumerSenderThread.setStatus(ConsumerThread.Status.SHUTDOWN);

          // was taken item acknowledged?
          if (consumerSenderThread.getProcessingKey() != null) {
            // okay, can be processed.
            inbox.add(consumerSenderThread.getProcessingKey());
            consumerSenderThread.setProcessingKey(null);
            wakeup = true;
          }

          if (!(shuttingDown) && START_NEW_CONSUMER_ON_UNEXPECTED_SHTUDOWN) {
            addAndStartConsumer();
            wakeup = true;
          }

          if (wakeup) {
            wakeUpWaitingAndSendWork();
          }


        } else if (currentMessageProcessing instanceof ConsWorkExMsg) {
          boolean wakeup = false;

          ConsWorkExMsg msg = ((ConsWorkExMsg) currentMessageProcessing);
          OFXExceptionStrategy.Strategy toFollow = exStratFor(msg.getThrowable());

          // ex is reported by consumer. 
          if (toFollow.isSilentNoLog()) {
            skipReportingEx();

          } else {
            logJobProblem(true, msg.getThrowable().getClass().getSimpleName() + " in consumer " + consumerSenderThread.toString() + " while processing '" + consumerSenderThread.getProcessingKey() + "': handling with " + toFollow, msg.getThrowable(), convertGuardMsg(msg.getThrowable()));
          }

          incConsumerEx();

          // okay, error is protocoled
          if (!(shuttingDown)) {
            // check entity key, do we have to add it to inbox
            if (toFollow.isReaddToInbox()) {
              inbox.add(consumerSenderThread.getProcessingKey());
              wakeup = true;
            }
            consumerSenderThread.setProcessingKey(null);

            // is consumer damaged?
            if (msg.wasEvtLoopStopped()) {
              // then the thread won t be alive any longer
              consumerSenderThread.setStatus(ConsumerThread.Status.SHUTDOWN);

            } else {
              consumerSenderThread.setStatus(ConsumerThread.Status.WAITING);
              // also awakes our consumer
              wakeup = true;
            }

            if (!(manuallyInboxFilled) && (toFollow.isJobRestart() || toFollow.isJobShutdown() || toFollow.isVMRestart() || toFollow.isVMShutdown())) {
              stratRespForShutdown = toFollow;
              wakeup = false;
              shuttingDown = true;

            } else if (toFollow.isConsumerRestart()) {
              consumerSenderThread.setStatus(ConsumerThread.Status.SHUTDOWN);
              if (!(ensureConsumerShutdown(currentMessageProcessing.getConsumerSenderId(), GRACEFULL_WAITING_TIME_SEC))) {
                // can not stop consumer with thread id
                logFrmwrkError("Can not stop " + consumerSenderThread + " (status set to SHUTDOWN now)", null);
              }

              // start another one
              int newId = addAndStartConsumer();
              wakeup = true;
            }


            // Clear inbox and request a resched due to problems
            if (toFollow.isClearInbox()) {
              inbox.clear();
              wakeup = false;

              // resched requested .. 0 is resched!
              if (!(consumerExWaitReqeusted())) {
                // resched due to inbox clear = 0! DANGEROUS :/ CODE
                consumerWaitTimeDueToEXinMS = 0;
              }
            }

            // do we have a delay time specified?
            if (toFollow.getDelayTimeInMsOrZero() > 0) {
              wakeup = false;
              if (toFollow.getDelayTimeInMsOrZero() > consumerWaitTimeDueToEXinMS) {
                consumerWaitTimeDueToEXinMS = toFollow.getDelayTimeInMsOrZero();
              }


            } else if (!(manuallyInboxFilled) && wakeup == true) {
              // manual runs do not proceed on problems
              wakeUpWaitingAndSendWork();

            }

          }
        }

        // last consumer triggers wait time. --------- --------- ---------
        if (manuallyInboxFilled && consumerExWaitReqeusted() && isNoConsumerWorking()) {
          // Ui ... exception while processing a manually filled inbox.
          inboxLoadProblem("Inbox manually filled but exception occured. Inbox with " + inbox.size() + " items cleared!");
          inbox.clear();
          // if already sched, weakup will set manuallyInboxFilled, check against 0 inbox and order resched ...
          consumerWaitTimeDueToEXinMS = -1;
          manuallyInboxFilled = false;
          checkInboxForRescheduling = false;


        } else if (consumerExWaitReqeusted() && isNoConsumerWorking()) {
          SchedInfo info = timerContoller.runNotCompletedDueEXResched(this, consumerWaitTimeDueToEXinMS, false, inboxEmtpy());
          logJobProblem(false, "In MainLoop scheduled: " + info.msg + " @ " + JobReporter.EXACT_TIME_ONLY_FORMATTER.print(info.when), null, null);
          consumerWaitTimeDueToEXinMS = -1;

          // if inbox Empty, do not report a resched
          if (inboxEmtpy()) {
            checkInboxForRescheduling = false;
          }

        }

        // check state --------- --------- --------- --------- --------- ---------
        if (checkInboxForRescheduling && !(manuallyInboxFilled) && !(shutdownWhenInboxEmptyAndConsumersParked) && !(shuttingDown) && inboxEmtpy() && isNoConsumerWorking()) {
          // Last message led to all work done now.
          logFrmwrkTrace("Successfully completed all work, inbox now 0 and no consumer working.");
          reportConsumerWorkTotal();

          timerContoller.runCompletedResched(this);
          checkInboxForRescheduling = false;

        } else if (manuallyInboxFilled && inboxEmtpy() && isNoConsumerWorking()) {
          // inbox empty no, so manuallyInboxFilled is also over
          manuallyInboxFilled = false;

        }

        // --------- --------- ---------




        //  only for testing and debug purpose
        if (shutdownWhenInboxEmptyAndConsumersParked && inboxEmtpy() && isNoConsumerWorking()) {
          // do not exec this block again when receiving msgs.
          shutdownWhenInboxEmptyAndConsumersParked = false;
          shuttingDown = true;
          // Only for Test purpose... wait for the consumers to send over termination msgs.
          shutdownConsumersGraceFullyAndWait();
          // process the remaining messages now
        }

        //  ENDO OF WHILE LOOP
      }


    } catch (InterruptedException ex) {
      logFrmwrkError("Interrupted in main loop - shutting down", ex);
      Thread.currentThread().interrupt();

    } catch (Throwable t) {
      logFrmwrkError("Exception in main loop - shutting down", t);
    }

    if (!(inboxEmtpy())) {
      inboxLoadProblem("Shutting down producer, but inbox is not empty right now :\n" + dumpInbox());
    }

    setInternalState("Exited eventloop, informing timerController");

    logFrmwrkTrace("Eventloop exited, sending shuttingDown(this) to timerCrtl " + timerContoller);
    timerContoller.shuttingDown(this);

    setInternalState("Existed eventloop, shutting down consumers");
    // intentionally or unintentionally, try to shutdown consumers.

    logFrmwrkTrace("next call shutdownConsumersGraceFullyAndWait()");
    shutdownConsumersGraceFullyAndWait();


    if (!(isNoConsumerAlive())) {
      logFrmwrkTrace("Consumers still alive.. :(  waitForAllThreadsStopped() next");
      waitForAllThreadsStopped(GRACEFULL_WAITING_TIME_SEC, true);
    }

    if (!(isNoConsumerAlive())) {
      logFrmwrkError("Producer exiting, but not all consumer threads are !isAlive(), undeploy might lead to mem leaks.", null);
    }

    // JMX HANDLING HERE .... ------------------- ------------------- ------------------- ------------------- -------------------
    setInternalState("Existed eventloop, unregistring JMX");
    logFrmwrkTrace("next call ensureJMXUnregistered()");
    jmxUnregister();

    // unreg from jmx, etc.
    logFrmwrkTrace("next call gcClean(), good by");
    this.gcClean();
    setInternalState("No longer running, gcClean() done.");

    // Evaluate Job / Vm restart here.
    if (stratRespForShutdown == null) {

    }

  }


  private void singleProducerRun(boolean manualRun) {

    // can not run producer while we have working consumers
    if (!(producerRunsEnabled) && !(manualRun)) {
      // can not run this one ... this counts as successfull run.
      logFrmwrkTrace("Producer run issued, but producerRuns are disabled, resched as successful run.. ");
      timerContoller.runCompletedResched(this);

    } else if (!(isNoConsumerWorking())) {
      // consumers are working, therefore we will not allow a producer run now!
      logFrmwrkTrace("Requested a producer-run while still processing isNoConsumerWorking()=false, inbox size=" + inbox.size() + " => rescheduling? " + !(manualRun));

      if (!(manualRun)) {
        SchedInfo info = timerContoller.runNotCompletedOutOfCronWindowResched(this, true);
        logFrmwrkTrace("ProducerRun req. but consumers working, scheduled " + info.msg + " @ " + info.when);
      }

    } else {
      manuallyInboxFilled = false;

      try {
        logFrmwrkTrace("singleProducerRun() requested @ " + asExactDateTimeFormatOrEmpty(new DateTime()) + " manually=" + manualRun);

        if (!(manualRun) && timerContoller.outOfCronWindow(this)) {
          // if triggered manually, we will not work in maintainance window, since consumers will not work anyway.
          SchedInfo info = timerContoller.runNotCompletedOutOfCronWindowResched(this, true);
          logFrmwrkTrace("ProducerRun req. but out of cron window, scheduled " + info.msg + " @ " + info.when);

          checkInboxForRescheduling = false;


        } else {
          // clear inbox first, in case of exceptions.
          inboxLoadStart(inbox.size());
          inbox.clear();

          ArrayList<Entity> listForInbox = producerCommandImplStatefull.process(this);
          // since we do ensure that no consumers are running while adding up inbox, we do not have
          // to substruct consumer workon items here...
          Entity lastElem = null;
          for (Entity elem : listForInbox) {
            if (elem == null) {
              inboxLoadProblem("Trying to add a <null> element to inbox after " + lastElem + " - what was prevented.");

            } else {
              lastElem = elem;
              inbox.add(elem);

            }

          }

          String lastAction = producerCommandImplStatefull.getLastAction();
          inboxLoadStop(inbox.size(), lastAction, allConsumers.size() == 0);
          if (manualRun) {
            manuallyInboxFilled = true;

          } else {
            checkInboxForRescheduling = true;

          }

          if (waitingConsumersAvailable() == 0 && inbox.size() > 0) {
            inboxLoadProblem("Inbox size was loaded with " + inbox.size() + " items, but there are no consumers around! CLEARING INBOX !!");
            inbox.clear();
          }

          wakeUpWaitingAndSendWork();
        }

      } catch (MMShutdownRequestException ex) {
        // shutting down, but wait for message ...
        logFrmwrkTrace("M3ShutdownRequestException received while in a singleProducerRun, waiting for shutdown message. ");

      } catch (InterruptedException ex) {
        // shutting down, but wait for messge ...
        logFrmwrkTrace("InterruptedException received while in a singleProducerRun, waiting for shutdown message.");

      } catch (Throwable t) {
        OFXExceptionStrategy.Strategy toFollow = exStratFor(t);
        if (toFollow.isSilentNoLog()) {
          skipReportingEx();

        } else if (t instanceof OFXJobWorkCanceledException) {
          OFXJobWorkCanceledException cancel = ((OFXJobWorkCanceledException) t);
          inboxLoadProblem("Inbox loading canceled - " + cancel.getFirstProblem());
          skipReportingEx();

        } else {
          logJobProblem(false, t.getClass().getSimpleName() + " during producer-run: handling with " + toFollow, t, convertGuardMsg(t));

        }

        if (!(manualRun) && (toFollow.isJobRestart() || toFollow.isJobShutdown() || toFollow.isVMRestart() || toFollow.isVMShutdown())) {
          // no rereg of producer
          stratRespForShutdown = toFollow;
          shuttingDown = true;

        } else if (!(manualRun)) {
          // manually re-run this job after delay. but wait now
          int waitMS = toFollow.getDelayTimeInMsOrZero();
          if (waitMS > 0 && waitMS < PRODUCER_EX_MIN_RERUNTIME_INMS) {
            waitMS = PRODUCER_EX_MIN_RERUNTIME_INMS;
          }

          // just assuming inbox is empty
          inbox.clear();
          SchedInfo info = timerContoller.runNotCompletedDueEXResched(this, waitMS, true, true);
          logJobProblem(false, "In ProducerRun scheduled: " + info.msg + " @ " + EXACT_TIME_ONLY_FORMATTER.print(info.when), null, null);
          checkInboxForRescheduling = false;

        }

      }


    }
  }




  private void checkInboxAndSendWork(ConsumerThread t) {
    // not shuttingDown is already checked ..
    if (shuttingDown) {
      // do not set work ..

    } else if (consumerExWaitReqeusted()) {
      // waiting for consumers to complete, but not handing out new work.

    } else if (inbox.size() > 0) {

      if (!(manuallyInboxFilled) && timerContoller.outOfCronWindow(this)) {
        String logMessage = "Work for consumer req. but out of cron window";

        // work items in inbox, but out of cron window now. resched requested by last consumer
        if (isNoConsumerWorking()) {
          SchedInfo info = timerContoller.runNotCompletedOutOfCronWindowResched(this, false);
          // inbox.size > 0, so we do not clear the checkForInboxAfterWorkDone flag here.
          logMessage = ", scheduled " + info.msg + " @ " + info.when;
        }
        logFrmwrkTrace(logMessage);


      } else {
        Entity ent = inbox.poll();
        if (ent == null) {
          throw new IllegalStateException("Programming error, no head elem to remove from inbox. (size " + inbox.size() + ")");
        }
        t.setStatus(ConsumerThread.Status.WORKING);
        t.setProcessingKey(ent);
        t.receive(new ProcessWorkMsg<Entity>(ent));

        String entityDescription;
        try {
          entityDescription = "'" + ent.toString() + "'";
        } catch (Exception e) {
          entityDescription = "'" + ent.getClass().getSimpleName() + " ????'";
          logJobProblem(false, "Exception in toString() of " + ent.getClass().getSimpleName() + " while logging", e, null);
        }
        logFrmwrkTrace(entityDescription + " to consumer " + t.getConsumerId() + " for processing");
      }

    }

  }

  private void wakeUpWaitingAndSendWork() {
    // any consumers who need fresh work, since they are waiting, but not in any shutdown mode
    for (ConsumerThread<Entity> curCon : allConsumers) {
      if (curCon.getStatus() == ConsumerThread.Status.WAITING) {
        checkInboxAndSendWork(curCon);
      }
    }
  }

  private void shutdownConsumersGraceFullyAndWait() {
    logFrmwrkTrace("Trying to shut down consumers gracefully");
    for (ConsumerThread<Entity> curCon : allConsumers) {
      if (curCon.getStatus() != ConsumerThread.Status.SHUTDOWN) {
        curCon.receive(new ShutdownMsg());
      }
    }
    // return messages from consumers "ConsumerDown" are not evaluated.
    // using isAlive() instead.
    // send, wait for them to join, 10 sec timeout
    boolean stopped = waitForAllThreadsStopped(GRACEFULL_WAITING_TIME_SEC, false);
    if (!(stopped)) {
      logFrmwrkError("Not able to stop all consumer gracefully via ShutdownMsg within " + GRACEFULL_WAITING_TIME_SEC + " secs.", null);
    }

    // kill em?
    stopped = waitForAllThreadsStopped(GRACEFULL_WAITING_TIME_SEC * 2, true);
    if (!(stopped)) {
      logFrmwrkError("Not able to stop all consumers with interrupted within " + GRACEFULL_WAITING_TIME_SEC * 2 + " secs.", null);

    }
  }

  private boolean isNoConsumerWorking() {
    int shutdownCons = 0;
    int workingCons = 0;
    for (ConsumerThread<Entity> cons : allConsumers) {
      if (cons.getStatus().equals(ConsumerThread.Status.WORKING)) {
        workingCons++;

      } else if (cons.getStatus().equals(ConsumerThread.Status.SHUTDOWN)) {
        shutdownCons++;

      }
    }

    // check, do we have consuemrs at all?
    if (shutdownCons == allConsumers.size() && allConsumers.size() != 0) {
      throw new IllegalStateException("All consumer are in SHUTDOWN status, no more consumers available");
    }
    return workingCons == 0;
  }

  private int waitingConsumersAvailable() {
    int waitingCons = 0;

    for (ConsumerThread<Entity> cons : allConsumers) {
      if (cons.getStatus().equals(ConsumerThread.Status.WAITING)) {
        waitingCons++;
      }
    }
    return waitingCons;
  }


  private boolean isNoConsumerAlive() {
    boolean noneAlive = true;
    for (ConsumerThread t : allConsumers) {
      if (t.isAlive()) {
        noneAlive = false;
      }
    }
    return noneAlive;
  }


  public boolean ensureConsumerShutdown(int id, int sec) {
    ConsumerThread t = allConsumers.get(id);
    t.receive(new ShutdownMsg());

    try {
      for (int cntDown = sec; cntDown > 0; cntDown--) {
        if (!(t.isAlive())) {
          return true;
        }
        t.interrupt();
        Thread.sleep(1000);
      }

    } catch (InterruptedException ex) {
      Thread.currentThread().interrupt();
    }

    return !(t.isAlive());
  }

  private boolean waitForAllThreadsStopped(int sec, boolean interruptFirst) {
    boolean noneAlive = false;

    if (interruptFirst) {
      for (ConsumerThread t : allConsumers) {
        if (t.isAlive()) {
          t.interrupt();
        }
      }
    }

    try {
      for (int cntDown = sec; cntDown > 0; cntDown--) {
        noneAlive = isNoConsumerAlive();
        if (noneAlive) {
          return true;
        }
        Thread.sleep(1000);
      }

    } catch (InterruptedException ex) {
      Thread.currentThread().interrupt();
    }

    return isNoConsumerAlive();
  }

  public List<Message> dbg_getProcessedMessages() {
    return dbg_processedMsg;
  }
  public List<Message> dbg_getRemainingMessages() {
    List<Message> msgs = new ArrayList<Message>();
    for (Object msg : messageQueue.toArray()) {
      msgs.add(((Message) msg));
    }
    return msgs;
  }
  public List<ConsumerThread<Entity>> dbg_getConsumerThreads() {
    return allConsumers;
  }
  public int dbg_inboxSize() {
    return inbox.size();
  }

  public String dbg_dumpState() {
    String s = "OFXProducerCrtl shutdown=" + shuttingDown + " shutdonInboxEmpty=" + shutdownWhenInboxEmptyAndConsumersParked;
    s += " msgQSize=" + messageQueue.size() + " inbox=" + inbox.size() + "\nOFXConsumerRunnable ";
    for (ConsumerThread t : allConsumers) {
      s += t.getStatus() + ", ";
    }
    return s;
  }

  private String dumpInbox() {
    String s = "";
    Object[] inboxState = inbox.toArray();

    for (int i = 0; i < inboxState.length; i++) {
      if (i < 5 || i >= (inboxState.length - 5)) {
        s += inboxState[i] + " ";

      } else if (i == 5) {
        s += " ... ";
      }
    }
    return s;
  }


  public boolean getproducer6_ProducerEnabled() {
    return producerRunsEnabled;
  }

  public int getPCPairID() {
    return thisPCPairID;
  }
  public String getPCPairName() {
    return thisPCPairName;
  }
  public int getNumberOfConsumers() {
    return allConsumers.size();
  }

  public boolean needsShutdownMsg() {
    return !(shuttingDown) || !(shutdownWhenInboxEmptyAndConsumersParked);
  }

  public void jmxUnregister() {
    if (!(isConsoleMode()) && !(jmxUnregisterDone)) {
      for (int i = 0; i < allConsumers.size(); i++) {
        StaticJmxAccess.unregister(assembleJMXPrefix(getbatchjob_PCPairNameAndID(), false, allConsumers.get(i).getConsumerId()));
      }
      StaticJmxAccess.unregister(assembleJMXPrefix(getbatchjob_PCPairNameAndID(), true, 0));
    }
    jmxUnregisterDone = true;
  }
  public void gcClean() {
    producerCommandImplStatefull = null;
    exceptionStrategy = null;

    for (int i = 0; i < allConsumers.size(); i++) {
      allConsumers.get(i).gcClean();
    }

    if (timerContoller.getJobProperties().envMode == MODE.TOMMY_MODE) {
      messageQueue.clear();
      inbox.clear();
      allConsumers.clear();
    }
    timerContoller = null;
  }


  public enum MODE {
    TOMMY_MODE(),
    CONSOLE_MODE(),
    TEST_MODE_WITH_CRON()
  }
}
