package org.modellwerkstatt.objectflow.batchjob;

/*Generated by MPS */

import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.DateTime;
import org.modellwerkstatt.objectflow.runtime.TelemetricsLongAbsoluter;
import org.modellwerkstatt.objectflow.runtime.CoreReporterInfo;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;

public abstract class PCPairReporter extends JobReporter implements PCPairReporterMBean {
  public static final int SCHEDINFO_QUEUE_SIZE = 5;
  public static DateTimeFormatter DATENTIME_FORMAT_EXACT = DateTimeFormat.forPattern("EEE dd.MM.yyyy HH:mm:ss.SSS");

  private DateTime startup;
  private DateTime inboxLastLoad;
  private TelemetricsLongAbsoluter processingInboxtime;
  private TelemetricsLongAbsoluter idleTime;

  private int inboxSizeBeforeFillup;
  private String lastAction;
  private String internalStatus;
  private String keySentToConsumer;
  private String lastInboxFillup;
  private long inboxloadStartTime;
  private long faults;


  private long consumerOverAllCancels;
  private long consumerThisRunCancels;

  private long consumerOverallSuccessful;
  private long consumerThisRunSuccessful;

  private long consumerOverallFaults;
  private long consumerThisRunFaults;
  private long consumerProcessingStartMillis;



  private String[] lastScheds;
  private int nextSchedEntry;



  public PCPairReporter(String pcPairName, JobProperties props) {
    super(pcPairName, PRODUCER_ID, props);

    startup = new DateTime();
    processingInboxtime = new TelemetricsLongAbsoluter();
    idleTime = new TelemetricsLongAbsoluter();
    inboxSizeBeforeFillup = 0;
    keySentToConsumer = "";
    lastInboxFillup = "";
    inboxloadStartTime = 0;
    faults = 0;
    lastScheds = new String[SCHEDINFO_QUEUE_SIZE];
    nextSchedEntry = 0;

    consumerOverallSuccessful = 0;
    consumerOverallFaults = 0;
    consumerOverAllCancels = 0;

    consumerThisRunSuccessful = 0;
    consumerThisRunCancels = 0;
    consumerThisRunFaults = 0;

    consumerProcessingStartMillis = 0;
  }

  @Override
  public long getoverall3_ConsumerItemsEx() {
    return consumerOverallFaults;
  }
  @Override
  public long getoverall2_ConsumerItemsCanceled() {
    return consumerOverAllCancels;
  }
  @Override
  public long getoverall1_ConsumerItemsOk() {
    return consumerOverallSuccessful;
  }
  public String getbatchjob_ConnectionUrl() {
    return props.connectionInfo;
  }
  public String getbatchjob_StartupTime() {
    return asExactDateTimeFormatOrEmpty(startup);
  }
  public String getbatchjob_Version() {
    return props.swJobVersion;
  }
  public String getbatchjob_Name() {
    return props.swJobFqName;
  }
  public String getbatchjob_FrameworkVersion() {
    return props.mowareVersion;
  }
  public String getinbox_LastLoad() {
    return asExactDateTimeFormatOrEmpty(inboxLastLoad);
  }
  public long getinbox_AvgLoadDuration() {
    return processingInboxtime.getAverage();
  }
  public long getinbox_MaxLoadDuration() {
    return processingInboxtime.getMax();
  }
  public long getinbox_Fillups() {
    return processingInboxtime.getCount();
  }
  public int getinbox_SizeBeforeFillup() {
    return inboxSizeBeforeFillup;
  }
  public String getproducer1_InternalState() {
    return internalStatus;
  }
  public long getproducer2_AvgIdleTime() {
    return idleTime.getAverage();
  }
  public long getproducer3_MaxIdleTime() {
    return idleTime.getMax();
  }
  public String getproducer4_LastAction() {
    return lastAction;
  }
  public String getproducer5_LastKeySentToConsumer() {
    return keySentToConsumer;
  }
  public String getproducer7_NextScheduledRuns() {
    String st = "";
    int start = nextSchedEntry - 1;

    int i = 0;
    while (i < SCHEDINFO_QUEUE_SIZE) {
      if (start < 0) {
        start = SCHEDINFO_QUEUE_SIZE - 1;
      }
      if ("".equals(st)) {
        // first
        st += lastScheds[start] + " . . . . . . . . ";
      } else {
        st += lastScheds[start] + ", ";
      }

      start--;
      i++;
    }

    return st;
  }
  public long getproducer8_AbortedInboxLoads() {
    return faults;
  }
  public void inboxLoadStart(int startInboxSize) {
    lastAction = "";

    // was it already reported??
    if (consumerProcessingStartMillis != 0) {
      reportConsumerWorkTotal();
    }

    consumerThisRunSuccessful = 0;
    consumerThisRunCancels = 0;
    consumerThisRunFaults = 0;
    consumerProcessingStartMillis = System.currentTimeMillis();

    if (inboxloadStartTime != 0) {
      faults++;
    }

    inboxSizeBeforeFillup = startInboxSize;
    inboxloadStartTime = System.currentTimeMillis();

    logFrmwrkTrace("Inbox with " + startInboxSize + " items cleared, producer run started.");
  }

  public String getinbox_LastFillup() {
    return lastInboxFillup;
  }
  public void inboxLoadStop(int curInboxSize, String action, boolean onlyProducerMode) {
    inboxLastLoad = new DateTime();
    long diff = System.currentTimeMillis() - inboxloadStartTime;
    processingInboxtime.addSample(diff);
    lastAction = action;
    inboxloadStartTime = 0;

    if (curInboxSize > 0) {
      lastInboxFillup = "Producer run ended @ " + asExactDateTimeFormatOrEmpty(new DateTime()) + " with " + curInboxSize + " items.";
    }

    String msg = "";
    if (action != null) {
      msg += action + " - ";
    }

    msg += "loaded " + curInboxSize + " items to inboxes in " + diff + "ms";
    if (onlyProducerMode) {
      msg = action + " - inbox " + curInboxSize + ", producer run " + diff + "ms (only producer present).";
    }

    CoreReporterInfo info = createInfoObject(IOFXCoreReporter.Type.APP_MESSAGE, IOFXCoreReporter.LogPriority.INFO, msg);
    info.addParameter(CoreReporterInfo.DIFF, diff);
    info.addParameter(CoreReporterInfo.COUNT, curInboxSize);

    coreReporter.report(info);
    jmxLog(false, "INFO", msg, null);
  }

  public void inboxLoadProblem(String msg) {
    CoreReporterInfo info = createInfoObject(IOFXCoreReporter.Type.APP_MESSAGE, IOFXCoreReporter.LogPriority.ERROR, msg);

    coreReporter.report(info);
    jmxLog(false, "ERROR", msg, null);
  }

  public void reportConsumerWorkTotal() {
    long diffTime = System.currentTimeMillis() - consumerProcessingStartMillis;

    String msg = String.format("Loaded & Processed %d items ok, %d canceled and %d with ex in %dms", consumerThisRunSuccessful, consumerThisRunCancels, consumerThisRunFaults, diffTime);
    CoreReporterInfo info = createInfoObject(IOFXCoreReporter.Type.APP_MESSAGE, IOFXCoreReporter.LogPriority.INFO, msg);
    info.addParameter(CoreReporterInfo.DIFF, diffTime);
    info.addParameter(CoreReporterInfo.COUNT + " ok", consumerThisRunSuccessful);
    info.addParameter(CoreReporterInfo.COUNT + " canceled", consumerThisRunCancels);
    info.addParameter(CoreReporterInfo.COUNT + " ex", consumerThisRunFaults);

    coreReporter.report(info);
    jmxLog(false, "INFO", msg, null);

    consumerThisRunSuccessful = 0;
    consumerThisRunCancels = 0;
    consumerThisRunFaults = 0;
    consumerProcessingStartMillis = 0;
  }

  public void addIdleSample(long diff) {
    idleTime.addSample(diff);
  }
  public void sentKeyToConsumer(Object o) {
    keySentToConsumer = "" + o;
  }
  public void setInternalState(String state) {
    internalStatus = state;
  }
  public void addSchedEntry(DateTime entry) {
    lastScheds[nextSchedEntry] = DATENTIME_FORMAT_EXACT.print(entry);
    nextSchedEntry++;
    if (nextSchedEntry >= SCHEDINFO_QUEUE_SIZE) {
      nextSchedEntry = 0;
    }
  }
  public String asExactDateTimeFormatOrEmpty(DateTime dt) {
    if (dt == null) {
      return "";
    }
    return DATENTIME_FORMAT_EXACT.print(dt);
  }

  public void incConsumerCanceledProcessing() {
    consumerOverAllCancels++;
    consumerThisRunCancels++;
  }
  public void incConsumerOkProcessings() {
    consumerOverallSuccessful++;
    consumerThisRunSuccessful++;
  }
  public void incConsumerEx() {
    consumerOverallFaults++;
    consumerThisRunFaults++;
  }


}
