package org.modellwerkstatt.objectflow.batchjob;

/*Generated by MPS */


public class RollatingLogger {
  private int size;
  private boolean timestamps = true;

  private String[] logStatements;
  private int i;

  public RollatingLogger(int size) {
    this.size = size;
    this.i = 0;
    logStatements = new String[size];
  }

  public RollatingLogger(int size, boolean timeStamps) {
    this(size);
    this.timestamps = timeStamps;
  }


  public void add(String text) {
    synchronized (this) {
      logStatements[i] = text;
      i++;
      if (i >= size) {
        i = 0;
      }
    }
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();

    synchronized (this) {
      int current = i;

      for (int line = 0; line < size; line++) {
        if (current >= size) {
          current = 0;
        }

        if (logStatements[current] == null) {
          sb.append("");
        } else {
          sb.append(logStatements[current] + "\n");
        }
        current++;
      }
    }
    return sb.toString();
  }

  public static void main(String[] args) {
    RollatingLogger l = new RollatingLogger(4, false);

    l.add("Hello World");
    l.add("My Hello World");
    l.add("One Two Three");
    l.add("A B C D E");
    l.add("Hello World");
    System.out.println("" + l);

  }

}
