package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */


/**
 * IOFXModule provides command information/behaviour when command is not instantiated.
 * 
 * 
 */
public interface IOFXCmdModule {
  /**
   * the following commands will work on commandFqName basis. Enabled check will be done
   * without creating a command, startCommand will create a new command instance which is returned 
   * to uses. However, user should not directly operate on command instance! 
   * 
   * @param commandFqName command, which should be started
   * @param args arguments to the command (command internal isEnabled checks)
   * @return can the command be executed
   */
  CommandPermission getCommandPermission(CmdExecStrategy stragey, String commandFqName, Object[] args, IOFXSession session);
  IOFXCommand startCommand(CmdExecStrategy stragey, String commandFqName, Object[] args, IOFXSession parentSession, IOFXUserEnvironment userEnvironment, IOFXUserServices usrService);

  boolean isCommandType(String commandFqName, IOFXCommand.OFXCmdTyp... commandType);
  String getCommandToolTip(String commandFqName);
  String getCommandDefaultColor(String commandFqName);
  String getCommandDefaultLabel(String commandFqName);
  String getCommandDefaultIcon(String commandFqName);
  String getCommandDefaultHotkey(String commandFqName);
  Object[] getCommandDefaultParams(String commandFqName, IOFXSelcrtlBasics crtl, Object singleSelToReplaceWhenMulti);
  Object[] getCommandUrlDefaultParams(String commandFqName, OFXUrlParams params);
  boolean supportUrlDefaultParams(String commandFqName);
  CmdUrlDefaults[] getCmdUrlDefaults();



  enum CommandPermission {
    ENABLED_RO(),
    ENABLED_RW(),
    DISABLED()
  }
  enum CmdExecStrategy {
    SINGLE(),
    MULTI(),
    AUTO_CON_MULTI(),
    INNER_NO_NEW_SESSION()
  }
  class CmdDefaults {
    public Class theClass;
    public String cmdFqName;
    public IOFXCommand.OFXCmdTyp type;
    public String label;
    public String icon;
    public String hotkey;
    public String color;
    public String tooltip;
    public IOFXDynCmdParams params;


    public CmdDefaults(Class cls, String fqN, IOFXCommand.OFXCmdTyp tp, String lab, String icn, String hk, String col, String tool, IOFXDynCmdParams prms) {
      theClass = cls;
      cmdFqName = fqN;
      type = tp;
      label = lab;
      icon = icn;
      hotkey = hk;
      color = col;
      tooltip = tool;
      params = prms;
    }
  }

  class CmdUrlDefaults {
    public String cmdFqName;
    public String desc;
    public String urlAndParamDescription;
    public String url;
    public int minNumParams;
    public int maxNumParams;
    public OFXUrlParams.OFXUrlCmdParams params;

    public CmdUrlDefaults(String fqN, String aDesc, String urlDesc, String aUrl, int min, int max, OFXUrlParams.OFXUrlCmdParams prms) {
      cmdFqName = fqN;
      desc = aDesc;
      urlAndParamDescription = urlDesc;
      url = aUrl;
      minNumParams = min;
      maxNumParams = max;
      params = prms;
    }
  }



}
