package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import java.util.List;

public interface IOFXCommand {
  String getCommandTitleShort();
  String getWindowTitle();
  OFXWindowTitleType getWindowTitleType();
  String getCommandHelp();
  String getCommandFqName();
  String getCommandName();
  String getCommandIcon();
  String getAdjustedCmdUrl();

  void setCommandParams(IOFXSession session, Object[] args);
  void initCommand() throws Exception;
  List<?> initCurrentPage(IOFXSelProvider view) throws Exception;
  IOFXPage.IOFXPageConclusion[] getCurrentPageConclusions(IOFXSelProvider view);
  String calcCurrentPageDynamicTitleAndScopes();

  void execConclusion(IOFXPage.IOFXPageConclusion conclusion) throws Exception;
  int getCurrentPageIndex();
  String calcCurrentPagePaneFqName(int pageNum);

  void handleCmdTermAndClearGeFqName(boolean wasChild, boolean terminatedInFinalOk, List<Object> cmdSelections, IOFXSelProvider selectionRecorder) throws Exception;
  OFXTermHandlerType getCmdTermHandlerType();


  void doFinalCancelConclusion(List<IOFXProblem> problems, Exception unexpectedEx) throws Exception;
  void doFinalUserCancelConclusion();

  /**
   * Improvements Command: 
   * - instead of exceptions, use return values to control cmd behaviour
   * - just on single cmd state after execution (use enum)
   */
  boolean isUserCancelTerminated();
  boolean isTerminatedOk();
  List<Object> getTerminateOkSelections();
  String getTerminateOkInformation();
  Object getTerminateOkObjectForId(String name);

  boolean isTerminatedCancel();
  List<Object> getTerminateCancelSelections();

  IOFXSession getCommandSession();
  boolean isCurrentlyReadOnlySession();
  boolean isCommandType(OFXCmdTyp... commandTypsOred);
  boolean wizzardWithFullSizeUis();
  boolean hasOption(OFXCmdOptions option);
  List<String> getLockNecessaryLockNames();

  boolean hasSuccessorCommand();
  OFXSuccessorCommandConfig getSuccessorCommandConfig();
  void manageAlsoPredecessor(IOFXCommand pre);
  boolean isReadyForSuccessor();
  void doPredecessorFinalOk() throws Exception;


  enum OFXCmdTyp {
    GRAPH_EDIT_CMD(),
    GRAPH_OWNER_CMD(),
    SEARCH_CMD(),
    GRAPH_OWNER_CMD_MODAL()
  }
  enum OFXCmdOptions {
    NO_ESC(),
    BACKGROUND(),
    NEW_STYLE_TERM_HANDLING()
  }
  enum OFXTermHandlerType {
    NO_HANDLER_PRESENT(),
    CHILD_CMD_TERM_ONLY(),
    ALSO_ANY_CMD_TERM();

    public static boolean NoOrChildHandler(OFXTermHandlerType t) {
      return OFXTermHandlerType.NO_HANDLER_PRESENT.equals(t) || OFXTermHandlerType.CHILD_CMD_TERM_ONLY.equals(t);
    }
  }
  enum OFXWindowTitleType {
    ADD_ON(),
    OVERWRITE(),
    FORCE_OVERWRITE()
  }

}
