package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import org.apache.logging.log4j.Level;

public class Log4JLogLevel {
  private String loggerToConfigureName;

  public Log4JLogLevel() {
  }
  public Log4JLogLevel(String loggerName) {
    loggerToConfigureName = loggerName;
  }
  public Log4JLogLevel(String loggerName, String level) {
    loggerToConfigureName = loggerName;
    setLevelOnLogger(loggerToConfigureName, level);
  }
  public void setLevel(String level) {
    setLevelOnLogger(loggerToConfigureName, level);
  }
  public static Level getLevelFromString(String level) {
    String compareToLevel = level.trim();

    // 0 to 7
    // change from int to string logic
    if ("OFF".equals(compareToLevel) || "FATAL".equals(compareToLevel)) {
      return Level.OFF;
    } else if ("ERROR".equals(compareToLevel)) {
      return Level.ERROR;
    } else if ("WARN".equals(compareToLevel)) {
      return Level.WARN;
    } else if ("INFO".equals(compareToLevel)) {
      return Level.INFO;
    } else if ("DEBUG".equals(compareToLevel)) {
      return Level.DEBUG;
    } else if ("TRACE".equals(compareToLevel)) {
      return Level.TRACE;
    } else if ("ALL".equals(compareToLevel)) {
      return Level.ALL;
    }

    throw new IllegalStateException("Can not set level >>" + compareToLevel + "<< - level not known!");
  }
  public static void setLevelOnLogger(String loggerName, String levelName) {
    Level level = getLevelFromString(levelName);
    Log4JProperties.setLogLevel(loggerName, level);
  }
}
