package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import java.math.BigDecimal;
import java.util.HashMap;
import jetbrains.mps.internal.collections.runtime.Sequence;
import org.joda.time.DateTime;

/**
 * Moware Utility class, particularly for working with sequences due to lack of MPS baselang support 
 * 
 * Wolfgang Messner 2011
 * 
 */
public class MU {
  private static BigDecimal standardEps = new BigDecimal("0.5");
  public static final int INT_MAXVALUE = 999999999;
  public MU() {
  }

  public static void s(HashMap<String, String> map, String key, String value) {
    map.put(key, value);
  }
  public static BigDecimal sum(Iterable<BigDecimal> bigSeq) {
    BigDecimal result = BigDecimal.ZERO;
    for (BigDecimal elem : Sequence.fromIterable(bigSeq)) {
      result = result.add(elem);
    }
    return result;
  }
  public static boolean testEqual(BigDecimal v1, BigDecimal v2, BigDecimal absEps, BigDecimal relEps) {
    if (v1.compareTo(v2) == 0) {
      return true;
    } else {
      BigDecimal r = v1.subtract(v2).abs();
      BigDecimal eps2 = v1.multiply(relEps).abs();
      // Der groessere Werte der beiden Toleranen Absolut und Relativ zaehlt
      return (r.compareTo(absEps) < 0 || r.compareTo(eps2) < 0);
    }
  }
  public static boolean testEqual(BigDecimal v1, BigDecimal v2, BigDecimal eps) {
    if (v1.compareTo(v2) == 0) {
      return true;
    } else {
      BigDecimal r = v1.subtract(v2).abs();
      return r.compareTo(eps) <= 0;
    }

  }
  public static boolean testEqual(BigDecimal v1, BigDecimal v2) {
    return testEqual(v1, v2, MU.standardEps);
  }
  public static boolean testZero(BigDecimal v1, BigDecimal eps) {
    return testEqual(v1, BigDecimal.ZERO, eps.abs());
  }
  public static boolean testZero(BigDecimal v1) {
    return testEqual(v1, BigDecimal.ZERO, MU.standardEps);
  }
  public static DateTime minDateTime(Iterable<DateTime> dateTimes) {
    if (dateTimes == null || Sequence.fromIterable(dateTimes).count() == 0) {
      return null;
    }
    DateTime minimum = Sequence.fromIterable(dateTimes).first();
    for (DateTime dateTime : Sequence.fromIterable(dateTimes)) {
      if (dateTime.isBefore(minimum)) {
        minimum = dateTime;
      }
    }
    return minimum;
  }
  public static DateTime maxDateTime(Iterable<DateTime> dateTimes) {
    if (dateTimes == null || Sequence.fromIterable(dateTimes).count() == 0) {
      return null;
    }
    DateTime maximum = Sequence.fromIterable(dateTimes).first();
    for (DateTime dateTime : Sequence.fromIterable(dateTimes)) {
      if (dateTime.isAfter(maximum)) {
        maximum = dateTime;
      }
    }
    return maximum;
  }
}
