package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import org.modellwerkstatt.manmap.runtime.MMStaticAccessHelper;
import org.modellwerkstatt.manmap.runtime.MMObjectKeyStore;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;

public class MoRevertibleMerger {

  public static <Key, Entity extends IOFXEntity<Key>> Entity mergeEntityIntoEntity(Class<Entity> classOfT, Entity source, Entity destination, IOFXSession __manMapSession, boolean readOnly) {

    if (source == null) {
      throw new IllegalStateException("Requested a merge with source entity of merge is null! A source entity has to be present.");
    }

    Key keyOfSource = source.getIM3Key();
    // TODO: Only necessary, in case a session is given
    if (__manMapSession != null && MMStaticAccessHelper.isNullKeyStaticHelper(keyOfSource)) {
      throw new IllegalStateException("The key of the source entity " + source + " is a null key, which can not be merged into a session");
    }


    Entity existingInSession = null;
    if (__manMapSession != null) {
      MMObjectKeyStore<Key, Entity> keyStore = __manMapSession.getOrCreateKeyStore(classOfT.hashCode());
      existingInSession = keyStore.get(keyOfSource);

    }

    if (existingInSession != null && destination != null && existingInSession != destination) {
      throw new IllegalStateException("The destination entity to merge into '" + destination + "' is not the one in the session with key '" + keyOfSource + "' and can therefore not be merged. [legacy mode enbld?]");
    }

    if (destination != null && !(MMStaticAccessHelper.isNullKeyStaticHelper(destination.getIM3Key())) && (!(keyOfSource.equals(destination.getIM3Key())))) {
      throw new IllegalStateException("The source entity with key '" + keyOfSource + "' can not be merged into given destination entity with key '" + destination.getIM3Key() + "'.");
    }

    if (destination == null) {
      destination = existingInSession;
    }

    if (destination == null) {
      try {
        destination = classOfT.getDeclaredConstructor().newInstance();
      } catch (NoSuchMethodException e) {
        throw new RuntimeException(e);
      } catch (InvocationTargetException e) {
        throw new RuntimeException(e);
      } catch (IllegalAccessException e) {
        throw new RuntimeException(e);
      } catch (InstantiationException e) {
        throw new RuntimeException(e);
      }

      destination.setReadOnly(readOnly);
    }

    if (__manMapSession != null) {
      if (destination.getReadOnly() && !(readOnly)) {
        throw new IllegalStateException("Destination entity is readonly, but a checkout integration into session is requested.");
      }
      if (!(destination.getReadOnly()) && readOnly) {
        throw new IllegalStateException("Destination entity is checkedout, but a readonly integration into session is requested.");
      }
    }

    destination.load(source, false);

    // TODO: After key is taken over! we can always call ensureInSession :) right? 
    if (__manMapSession != null) {
      __manMapSession.ensureInSession(destination);
    }


    return destination;
  }

  public static <Key, Entity extends IOFXEntity<Key>> Entity mergeEntityIntoList(Class<Entity> classOfT, Entity source, List<Entity> destList, IOFXSession __manMapSession, boolean readOnly) {
    Entity toReturn = null;

    Key keyOfSource = source.getIM3Key();
    // TODO: Only necessary, in case a session is given
    if (__manMapSession != null && MMStaticAccessHelper.isNullKeyStaticHelper(keyOfSource)) {
      throw new IllegalStateException("The key of the source entity " + source + " is a null key, which can not be merged into a session");
    }

    for (int i = 0; i < destList.size(); i++) {
      Entity dest = destList.get(i);
      if (keyOfSource.equals(dest.getIM3Key())) {
        toReturn = MoRevertibleMerger.<Key,Entity>mergeEntityIntoEntity(classOfT, source, dest, __manMapSession, readOnly);
        break;
      }
    }

    if (toReturn == null) {
      try {
        toReturn = classOfT.getDeclaredConstructor().newInstance();
      } catch (NoSuchMethodException e) {
        throw new RuntimeException(e);
      } catch (InvocationTargetException e) {
        throw new RuntimeException(e);
      } catch (IllegalAccessException e) {
        throw new RuntimeException(e);
      } catch (InstantiationException e) {
        throw new RuntimeException(e);
      }
      toReturn.setReadOnly(readOnly);
      toReturn.load(source, false);

      if (__manMapSession != null) {
        __manMapSession.ensureInSession(toReturn);
      }
      destList.add(toReturn);
    }

    return toReturn;
  }
  public static <Key, Entity extends IOFXEntity<Key>> List<Entity> mergeListIntoList(Class<Entity> classOfT, List<Entity> source, List<Entity> destList, IOFXSession __manMapSession, boolean readOnly) {
    List<Entity> toReturn = ListSequence.fromList(new ArrayList<Entity>());

    // okay, we have to replace the object in current list viewed with the object given.
    for (Entity objToMerge : source) {
      ListSequence.fromList(toReturn).addElement(MoRevertibleMerger.<Key,Entity>mergeEntityIntoList(classOfT, objToMerge, destList, __manMapSession, readOnly));
    }

    return toReturn;
  }
  public static <Key, Entity extends IOFXEntity<Key>> Entity mergeRefOnRef(Class<Entity> classOfT, Entity sourceRef, IOFXSession __manMapSession, boolean readOnly, RefChange change, IOFXEntity destEntity) {

    if (sourceRef == null) {

      // Dan, changed behaviour Winter 22
      change.doChange(destEntity, null);
      return null;

    } else {
      // complex scenario, always get rid of current ref obj / get it from session and overwrite .. or create new one. 
      Entity newRef = MoRevertibleMerger.<Key,Entity>mergeEntityIntoEntity(classOfT, sourceRef, null, __manMapSession, readOnly);
      // ro is checked in mergeObjIntoObj

      change.doChange(destEntity, newRef);
      return newRef;
    }
  }


  public interface RefChange<E, R> {
    void doChange(E entity, R ref);
  }

}
