package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import java.math.BigDecimal;
import java.math.RoundingMode;

public class OFXBigDecimal implements IOFXMetaRangeScale<BigDecimal>, IOFXRevertableAttribute<OFXBigDecimal> {
  private boolean enabled = true;
  private boolean optional = false;
  private String label;

  private BigDecimal value = new BigDecimal("0.0");
  private BigDecimal min;
  private BigDecimal max;
  private Integer scale;
  private String format;

  public OFXBigDecimal() {
    // for optimization puropos, all Datatypes do not inherit from each other
  }
  public OFXBigDecimal(BigDecimal start, BigDecimal stop, int scale) {
    // for optimization puropos, all Datatypes do not inherit from each other
    this.min = start;
    this.max = stop;
    this.scale = scale;
  }

  public void setEnabled(boolean enbl) {
    this.enabled = enbl;
  }
  public boolean getEnabled() {
    return this.enabled;
  }
  public void setOptional(boolean opt) {
    this.optional = opt;
  }
  public boolean getOptional() {
    return this.optional;
  }
  public void setLabel(String lbl) {
    this.label = lbl;
  }
  public String getLabel() {
    return this.label;
  }
  public boolean setValue(BigDecimal val) {
    if (val != null && this.scale != null) {
      val = val.setScale(this.scale, RoundingMode.HALF_UP);
    }
    if (this.value == null) {
      if (val == null) {
        // okay, nothing to do ..
      } else {
        this.value = val;
        return true;
      }
    } else if (val == null || this.value.compareTo(val) != 0) {
      this.value = val;
      return true;
    }

    return false;
  }
  public BigDecimal getValue() {
    return this.value;
  }
  public void setMin(BigDecimal m) {
    this.min = m;
  }
  public BigDecimal getMin() {
    return this.min;
  }
  public void setMax(BigDecimal m) {
    this.max = m;
  }
  public BigDecimal getMax() {
    return this.max;
  }

  public void setMinMax(BigDecimal min, BigDecimal max, int scale) {
    this.min = min;
    this.max = max;
    this.scale = scale;
  }
  public void setMinMax(BigDecimal min, BigDecimal max) {
    this.min = min;
    this.max = max;
  }
  public void setScale(Integer val) {
    this.scale = val;
  }
  public Integer getScale() {
    return this.scale;
  }

  @Override
  public void setFormat(String format) {
    this.format = format;
  }
  @Override
  public String getFormat() {
    return this.format;
  }
  public OFXBigDecimal copy() {
    OFXBigDecimal i = new OFXBigDecimal();
    i.enabled = this.enabled;
    i.optional = this.optional;
    i.label = this.label;
    i.value = this.value;
    i.min = this.min;
    i.max = this.max;
    i.scale = this.scale;
    i.format = this.format;
    return i;
  }
  public void load(OFXBigDecimal cp, boolean fullRevertNotMerge) {
    if (fullRevertNotMerge) {
      this.enabled = cp.enabled;
      this.optional = cp.optional;
      this.label = cp.label;
      this.min = cp.min;
      this.max = cp.max;
      this.scale = cp.scale;
      this.format = cp.format;
    }
    this.value = cp.value;
  }

  /**
   * Generator convenience method only. 
   * 
   * @return value is null or not?
   */
  public boolean isNull() {
    return this.value == null;
  }


  private Boolean requestFocus;
  public void requestFocus() {
    requestFocus = new Boolean(true);
  }
  public boolean getFocusAndClearIt() {
    if (requestFocus != null && requestFocus.equals(true)) {
      requestFocus = null;
      return true;
    }
    requestFocus = null;
    return false;
  }
  @Override
  public String toString() {
    return "" + this.value;
  }

  private String validationErrorText;
  @Override
  public void setValidationError(String val) {
    validationErrorText = val;
  }
  @Override
  public String getValidationError() {
    return validationErrorText;
  }

}
