package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.manmap.runtime.MMAdditionalInfoException;

public abstract class OFXCommand implements IOFXCommand {
  protected boolean finalCancelStarted = false;
  protected boolean finalOKStarted = false;
  protected boolean userCancelStarted = false;

  protected boolean lockFinalOkDueSuccessor = false;
  protected boolean readyForFinalOkConclusion = true;

  protected IOFXSession __manMapSession;

  protected IOFXPage<?> currentPage;
  protected int currentPageIndex;
  protected OFXCommandPage<?>[] allPages;
  protected int pagesAdded = 0;
  protected boolean wizzarddWithFullSizeUis = false;

  protected StringBuilder lockHolders = new StringBuilder();

  protected IOFXCommand predecessorCommand = null;
  protected boolean hasSuccessorCommand = false;

  protected String cmdDefaultTitle;
  protected String cmdDefaultIcon;
  protected String cmdFqName;

  protected String cmdTitleAddOn = "";
  protected IOFXCommand.OFXWindowTitleType cmdTitleOverwrite;

  protected IOFXCommand.OFXCmdTyp cmdType = IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD;
  protected IOFXCommand.OFXTermHandlerType cmdTermHandlerType = IOFXCommand.OFXTermHandlerType.NO_HANDLER_PRESENT;
  protected IOFXCommand.OFXCmdOptions[] cmdOptions;

  protected String cmdHelpMessage = "";
  protected String cmdTerminateOkInfo = "";


  public OFXCommand(String fqName, String defaultCmdTitle, String defaultIcon, IOFXCommand.OFXWindowTitleType titleOverwrite, boolean hasSucc, boolean fullSizeUi, int pageSize) {
    cmdFqName = fqName;
    cmdDefaultTitle = defaultCmdTitle;
    cmdDefaultIcon = defaultIcon;

    cmdTitleOverwrite = titleOverwrite;
    hasSuccessorCommand = hasSucc;
    wizzarddWithFullSizeUis = fullSizeUi;
    allPages = new OFXCommandPage<?>[pageSize];
  }

  public void page(OFXCommandPage page) {
    allPages[pagesAdded] = page;
    pagesAdded++;
  }

  @Override
  public String getCommandFqName() {
    return cmdFqName;
  }
  @Override
  public String getCommandName() {
    return cmdDefaultTitle;
  }
  @Override
  public String getCommandTitleShort() {
    return cmdDefaultTitle + " ";
  }
  @Override
  public IOFXCommand.OFXWindowTitleType getWindowTitleType() {
    return cmdTitleOverwrite;
  }
  @Override
  public String getWindowTitle() {
    return cmdTitleAddOn;
  }
  @Override
  public String toString() {
    return cmdFqName;
  }
  @Override
  public String getCommandIcon() {
    return cmdDefaultIcon;
  }

  @Override
  public String getAdjustedCmdUrl() {
    return null;
  }
  @Override
  public String getCommandHelp() {
    return cmdHelpMessage;
  }

  @Override
  public IOFXSession getCommandSession() {
    return __manMapSession;
  }
  public void setCommandParams(IOFXSession session, boolean hasCmdSucessor) {
    __manMapSession = session;
    if (hasCmdSucessor) {
      lockFinalOkDueSuccessor = true;
      readyForFinalOkConclusion = false;
    }

    for (OFXCommandPage page : allPages) {
      page.initGenPageConclusion();
    }

    if (allPages.length > 0) {
      currentPage = allPages[0];
    }
    currentPageIndex = -1;
  }
  public void manageAlsoPredecessor(IOFXCommand pre) {
    predecessorCommand = pre;
    if (!(predecessorCommand.hasSuccessorCommand())) {
      throw new RuntimeException("This can not be true. Framework error.");
    }
  }
  @Override
  public int getCurrentPageIndex() {
    return currentPageIndex;
  }
  public void setCurrentPage(OFXChangePageException cpe) {
    String lookingForPage = cpe.getMessage();

    int i = 0;
    boolean found = false;
    for (IOFXPage<?> page : allPages) {
      if (page.getPageName().equals(lookingForPage)) {
        currentPage = page;
        currentPageIndex = i;
        found = true;
        break;
      }
      i++;
    }
    if (!(found)) {
      throw new IllegalStateException("setCurrentPage() did not found page '" + lookingForPage + "'.");
    }
  }

  public abstract void initCommandStatements() throws Exception;

  @Override
  public void initCommand() throws Exception {
    // check locks before running initCommand in CommandContainer
    if (finalCancelStarted || finalOKStarted || userCancelStarted) {
      throw new IllegalStateException(dumpCommandState("initCommand() no longer available."));
    }

    // initShadow() of arguments given ...
    startShadowing();
    boolean controllingExReceived = false;

    try {
      initCommandStatements();

    } catch (OFXChangePageException changePage) {
      controllingExReceived = true;
      setCurrentPage(changePage);
      // do not rethrow page Ex here.

    } catch (OFXCommandDoneException done) {
      controllingExReceived = true;
      this.doFinalOkConclusion();

    } catch (OFXAbortedException aborted) {
      throw aborted;

    } catch (Exception ex) {
      controllingExReceived = true;
      this.doFinalCancelConclusion(null, ex);
      throw ex;

    }

    if (allPages.length == 0 && !(controllingExReceived)) {
      // no pages present in cmd
      if (__manMapSession.isReadOnly() && !(this.hasSuccessorCommand())) {
        // no ex handling here.
        this.doFinalUserCancelConclusion();
      } else {
        this.doFinalOkConclusion();
      }

    }

    // else set default page and proceed.....
    if (currentPageIndex < 0 && !(finalCancelStarted) && !(finalOKStarted) && !(userCancelStarted)) {
      currentPageIndex = 0;
    }
  }

  public List<?> initCurrentPage(IOFXSelProvider selRecorder) throws Exception {
    List<?> returnValue = null;
    if (finalCancelStarted || finalOKStarted || userCancelStarted) {
      throw new IllegalStateException(dumpCommandState("initCurrentPage no longer available."));
    }

    try {
      returnValue = this.currentPage.initPage(selRecorder);

    } catch (OFXAbortedException aborted) {
      throw aborted;

    } catch (Exception ex) {
      this.doFinalCancelConclusion(null, ex);
      throw ex;

    }

    return returnValue;
  }

  public void execConclusion(IOFXPage.IOFXPageConclusion conclusion) throws Exception {
    if (finalCancelStarted || finalOKStarted || userCancelStarted) {
      throw new IllegalStateException(dumpCommandState("doConclusion() no longer available."));
    }

    try {
      currentPage.execPageConclusion(conclusion);

    } catch (OFXCommandDoneException doneEx) {
      this.doFinalOkConclusion();

    } catch (OFXChangePageException pageEx) {
      //  command not finished .. no process engine check, just proceed ..
      setCurrentPage(pageEx);
      throw pageEx;

    } catch (OFXAbortedException aborted) {
      throw aborted;

    } catch (Exception ex) {
      this.doFinalCancelConclusion(null, ex);
      throw ex;
    }

    // can throw, cancelException, pageException, exception
  }

  public void doPredecessorFinalOk() throws Exception {
    if (!(isReadyForSuccessor())) {
      throw new IllegalStateException(dumpCommandState("extForceOKConclusion() can only be applied on commands which are waiting for the final ok conclusion."));
    }
    lockFinalOkDueSuccessor = false;

    doFinalOkConclusion();
  }

  public abstract void finalOkStatements();
  public void doFinalOkConclusion() throws Exception {
    // do not execute final ok right now
    readyForFinalOkConclusion = true;
    if (lockFinalOkDueSuccessor) {
      return;
    }

    try {
      if (finalOKStarted || userCancelStarted || finalCancelStarted) {
        throw new IllegalStateException(dumpCommandState("FINAL_OK no longer available. Already executed (maybe precond in final_ok?)"));
      }

      // set for process to change state. ..
      finalOKStarted = true;
      finalOkStatements();

      if (predecessorCommand != null) {
        predecessorCommand.doPredecessorFinalOk();
      }

      if (isCommitSession() && predecessorCommand == null) {
        __manMapSession.startTransactionAndFlush();
      }

    } catch (OFXAbortedException ex) {
      // not realy supported, this will prevent conclusion and crash cmd.
      List<IOFXProblem> prblms = __manMapSession.getCopyOfProblemState();
      this.doFinalCancelConclusion(null, ex);

      throw new IllegalStateException("Preconditions in FINAL_OK of commands are not supported yet!\n\n" + OFXConsoleHelper.asSimpleString(prblms) + "\n\n");

    } catch (Exception ex) {
      // no... not terminated ok ...
      // matters of session (appFactory) are handled in final exception
      this.doFinalCancelConclusion(null, ex);
      throw ex;

    }

    clearShadowing();
    // not in finally, since cancel will check gc
    if (isSessionOwner() && predecessorCommand == null) {
      __manMapSession.closeSessionAndfreeGC();
    }
  }

  @Override
  public void doFinalUserCancelConclusion() {
    if (userCancelStarted || finalCancelStarted || finalOKStarted) {
      throw new IllegalStateException(dumpCommandState("USER_CANCELED no longer available."));
    }

    userCancelStarted = true;
    revertToShadow();

    try {
      if (predecessorCommand != null) {
        predecessorCommand.doFinalUserCancelConclusion();
      }
    } finally {
      clearShadowing();
      if (isSessionOwner() && predecessorCommand == null) {
        // no other outer predecessor
        __manMapSession.closeSessionAndfreeGC();
      }
    }
  }


  public abstract void finalCancelStatementsAndMarker(List<IOFXProblem> listOfProblems) throws Exception;
  @Override
  public void doFinalCancelConclusion(List<IOFXProblem> listOfProblems, Exception unexpecteEX) throws Exception {
    // exception is null or given ... (but not contained in session messages)
    // exception: OFXShutDownException or tec Exception (also from final_cancel)
    if (listOfProblems == null) {
      listOfProblems = __manMapSession.getAndclearProblemState();
    }
    if (unexpecteEX != null) {
      if (unexpecteEX instanceof OFXShutDownSessionException) {
        ListSequence.fromList(listOfProblems).addElement(((OFXShutDownSessionException) unexpecteEX).getProblem());
      } else {
        ListSequence.fromList(listOfProblems).addElement(new OFXProblem(false, "FINAL_CANCEL forwarded " + unexpecteEX.getClass().getName(), null, unexpecteEX));
      }
    }

    // report double calls for cancel !!
    if (userCancelStarted || finalCancelStarted) {
      String state = dumpCommandState("FINAL_CANCEL or USER_CANCEL already processed.") + "\n\n";
      state += OFXConsoleHelper._____organizeCurrentStacktrace_____();
      OFXLogger.log(this.getClass(), IOFXCoreReporter.LogPriority.ERROR, state, null);
      return;
    }

    try {
      // It is okay to use final cancel when finalOk already started -> but not completed
      finalCancelStarted = true;

      // Important: Revert first, then do the final cancel!
      revertToShadow();

      finalCancelStatementsAndMarker(listOfProblems);

      if (predecessorCommand != null && !(predecessorCommand.isTerminatedCancel())) {
        // not coming from predecessor cancel ... [unexpected ex not passed forward, already added]
        predecessorCommand.doFinalCancelConclusion(listOfProblems, null);
      }


    } catch (OFXAbortedException ex) {
      String stateToReport = "OFXAbortedException while processing FINAL_CANCEL for '" + listOfProblems + "'";
      // not realy supported, this will prevent conclusion and crash cmd.
      this.doFinalCancelConclusion(null, ex);
      IllegalStateException toThrow = new IllegalStateException("Preconditions in FINAL_CANCEL of commands are not supported yet!");
      toThrow.addSuppressed(new MMAdditionalInfoException(stateToReport));
      throw toThrow;

    } catch (Exception exWhileCancel) {
      // matters of session (appFactory) are handled in final exception
      String stateToReport = "Exception while processing FINAL_CANCEL for '" + listOfProblems + "'";
      if (unexpecteEX != null) {
        stateToReport = "Exception while processing Exception '" + unexpecteEX.getClass().getName() + "', unexpected ex trace \n" + OFXConsoleHelper.stackTrace2String(unexpecteEX) + "\n\n";
      }
      exWhileCancel.addSuppressed(new MMAdditionalInfoException(stateToReport));
      throw exWhileCancel;

    } finally {
      clearShadowing();

      // clean up session if cmd has it s own..
      if (isSessionOwner() && predecessorCommand == null) {
        __manMapSession.closeSessionAndfreeGC();
      }
    }

  }


  public abstract void startShadowing();
  public abstract void clearShadowing();
  public abstract void revertToShadow();



  @Override
  public IOFXCommand.OFXTermHandlerType getCmdTermHandlerType() {
    return cmdTermHandlerType;
  }

  public void handleCmdTermAndClearGeFqName(boolean wasChild, boolean terminatedInFinalOk, List<Object> cmdSelections, IOFXSelProvider selectionRecorder) throws Exception {

    try {
      if (wasChild) {
        __manMapSession.clearGraphEditFqName();
      }

      this.currentPage.cmdTerminated(wasChild, terminatedInFinalOk, selectionRecorder);

      for (Object selection : cmdSelections) {
        if (selection instanceof List) {
          List selectionList = ((List) selection);
          for (Object obj : selectionList) {
            this.currentPage.cmdTerminatedWithPushed(wasChild, terminatedInFinalOk, obj, selectionRecorder);
          }

        } else {
          this.currentPage.cmdTerminatedWithPushed(wasChild, terminatedInFinalOk, selection, selectionRecorder);
        }
      }

    } catch (OFXAbortedException aborted) {
      throw aborted;

    } catch (Exception ex) {
      this.doFinalCancelConclusion(null, ex);
      throw ex;

    }
  }
  public boolean isCurrentlyReadOnlySession() {
    return __manMapSession.isReadOnly();
  }
  public boolean isTerminatedOk() {
    return finalOKStarted && !(finalCancelStarted) && !(userCancelStarted);
  }
  public boolean isReadyForSuccessor() {
    return readyForFinalOkConclusion && lockFinalOkDueSuccessor && !(finalOKStarted || finalCancelStarted || userCancelStarted);
  }
  public boolean isTerminatedCancel() {
    return finalCancelStarted && !(userCancelStarted);
  }
  public boolean isUserCancelTerminated() {
    return userCancelStarted && !(finalCancelStarted) && !(finalOKStarted);
  }
  public void setProcess(IOFXCmdModule process) {
  }
  public IOFXPage.IOFXPageConclusion[] getCurrentPageConclusions(IOFXSelProvider finalView) {
    return this.currentPage.getPageConclusions(finalView);
  }
  public String calcCurrentPageDynamicTitleAndScopes() {
    // only used by ui cmds
    return this.currentPage.calcDynamicPageTitleAndScopes();
  }

  @Override
  public String getTerminateOkInformation() {
    String trimmed = cmdTerminateOkInfo.trim();
    if (trimmed.equals("")) {
      return null;
    } else {
      return trimmed;
    }
  }
  @Override
  public boolean hasOption(IOFXCommand.OFXCmdOptions lookingFor) {
    for (IOFXCommand.OFXCmdOptions opt : cmdOptions) {
      if (opt.equals(lookingFor)) {
        return true;
      }
    }
    return false;
  }
  @Override
  public boolean isCommandType(IOFXCommand.OFXCmdTyp... commandTypsOred) {
    for (IOFXCommand.OFXCmdTyp t : commandTypsOred) {
      if (t.equals(cmdType)) {
        return true;
      }
    }
    return false;
  }

  @Override
  public boolean hasSuccessorCommand() {
    return hasSuccessorCommand;
  }

  @Override
  public boolean wizzardWithFullSizeUis() {
    return wizzarddWithFullSizeUis;
  }

  @Override
  public String calcCurrentPagePaneFqName(int pageNum) {
    return allPages[pageNum].calcPagePaneFqName();
  }


  public boolean isSessionOwner() {
    return isSessionOwner(cmdType);
  }
  public static boolean isSessionOwner(IOFXCommand.OFXCmdTyp cmdType) {
    return cmdType == IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD || cmdType == IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD_MODAL || cmdType == IOFXCommand.OFXCmdTyp.SEARCH_CMD;
  }
  public boolean isCommitSession() {
    return cmdType == IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD || cmdType == IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD_MODAL;
  }
  public String dumpCommandState(String helpMsg) {
    String userInfo = "(no user info)";
    if (__manMapSession.getUserEnvironment() != null) {
      userInfo = __manMapSession.getUserEnvironment().getUserId() + "/" + __manMapSession.getUserEnvironment().getUserName();
    }
    return helpMsg + "[" + cmdDefaultTitle + userInfo + " , finalOKStarted=" + finalOKStarted + ", finalCancelStarted=" + finalCancelStarted + ", userCancelStarted=" + userCancelStarted + ", readyForFinalOk=" + readyForFinalOkConclusion + ", predecessor=" + predecessorCommand + "]";
  }

}
